/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.xml.TableItemProperty;
import jp.mosp.platform.bean.human.HumanBinaryArrayRegistBeanInterface;
import jp.mosp.platform.bean.human.HumanGeneralBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.base.PlatformHumanBean;
import jp.mosp.platform.dao.human.HumanBinaryArrayDaoInterface;
import jp.mosp.platform.dto.human.HumanBinaryArrayDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.impl.PfaHumanBinaryArrayDto;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class HumanBinaryArrayRegistBean
extends PlatformHumanBean
implements HumanBinaryArrayRegistBeanInterface {
    protected HumanBinaryArrayDaoInterface dao;
    protected HumanGeneralBeanInterface humanGeneral;
    protected HumanReferenceBeanInterface humanReference;

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (HumanBinaryArrayDaoInterface)this.createDaoInstance(HumanBinaryArrayDaoInterface.class);
        this.humanGeneral = (HumanGeneralBeanInterface)this.createBeanInstance(HumanGeneralBeanInterface.class);
        this.humanReference = (HumanReferenceBeanInterface)this.createBeanInstance(HumanReferenceBeanInterface.class);
    }

    public HumanBinaryArrayDtoInterface getInitDto() {
        return new PfaHumanBinaryArrayDto();
    }

    public void insert(HumanBinaryArrayDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        HumanDtoInterface humanDto = this.humanReference.getHumanInfo(dto.getPersonalId(), dto.getActivateDate());
        if (humanDto == null) {
            PfMessageUtility.addErrorPersonalBasisInfoNotExist((MospParams)this.mospParams);
            return;
        }
        dto.setPfaHumanBinaryArrayId(this.dao.nextRecordId());
        dto.setHumanRowId(this.getRowId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(HumanBinaryArrayDtoInterface dto) throws MospException {
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanBinaryArrayId());
    }

    public void deleteDeadInputItem(Set<String> divisions, String viewKey) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (String division : divisions) {
            List tableItemList = this.humanGeneral.getTableItemList(division, viewKey);
            for (TableItemProperty tableItem : tableItemList) {
                String[] itemNames;
                for (String itemName : itemNames = tableItem.getItemNames()) {
                    list.add(itemName);
                }
            }
        }
        if (list.isEmpty()) {
            return;
        }
        List listDeleteItem = this.dao.findForInfoNotIn(list);
        for (HumanBinaryArrayDtoInterface dto : listDeleteItem) {
            this.delete(dto);
        }
    }

    private void checkDelete(HumanBinaryArrayDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaHumanBinaryArrayId());
    }

    public int getRowId() throws MospException {
        int rowId = this.dao.findForMaxRowId();
        return ++rowId;
    }

    public void update(HumanBinaryArrayDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        HumanBinaryArrayDtoInterface arrayDto = (HumanBinaryArrayDtoInterface)this.findForKey((BaseDaoInterface)this.dao, dto.getPfaHumanBinaryArrayId(), true);
        this.checkExclusive((BaseDtoInterface)arrayDto);
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaHumanBinaryArrayId());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanBinaryArrayId());
        dto.setPfaHumanBinaryArrayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void validate(HumanBinaryArrayDtoInterface dto) throws MospException {
        this.checkLength(dto.getFileName(), 50, PfNameUtility.fileName((MospParams)this.mospParams));
    }
}

