/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.property.ConventionProperty;
import jp.mosp.framework.xml.ItemProperty;
import jp.mosp.framework.xml.TableItemProperty;
import jp.mosp.platform.bean.human.HumanArrayRegistBeanInterface;
import jp.mosp.platform.bean.human.HumanGeneralBeanInterface;
import jp.mosp.platform.bean.human.HumanGeneralCheckBeanInterface;
import jp.mosp.platform.bean.human.base.PlatformHumanBean;
import jp.mosp.platform.dao.human.HumanArrayDaoInterface;
import jp.mosp.platform.dto.human.HumanArrayDtoInterface;
import jp.mosp.platform.dto.human.impl.PfaHumanArrayDto;

public class HumanArrayRegistBean
extends PlatformHumanBean
implements HumanArrayRegistBeanInterface {
    protected HumanArrayDaoInterface dao;
    protected HumanGeneralBeanInterface humanGeneral;
    protected HumanGeneralCheckBeanInterface humanGeneralCheckBean;

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (HumanArrayDaoInterface)this.createDaoInstance(HumanArrayDaoInterface.class);
        this.humanGeneral = (HumanGeneralBeanInterface)this.createBeanInstance(HumanGeneralBeanInterface.class);
        this.humanGeneralCheckBean = (HumanGeneralCheckBeanInterface)this.createBeanInstance(HumanGeneralCheckBeanInterface.class);
    }

    public HumanArrayDtoInterface getInitDto() {
        return new PfaHumanArrayDto();
    }

    public void regist(String division, String viewKey, String personalId, Date activeDate, int rowId, LinkedHashMap<String, Long> recordsMap) throws MospException {
        this.humanGeneralCheckBean.validate(division, viewKey);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        int newRowId = this.getRowId();
        List tableItemList = this.humanGeneral.getTableItemList(division, viewKey);
        for (TableItemProperty tableItem : tableItemList) {
            String[] itemNames = tableItem.getItemNames();
            String[] itemKeys = tableItem.getItemKeys();
            for (int i = 0; i < itemNames.length; ++i) {
                HumanArrayDtoInterface dto;
                ConventionProperty conventionProperty;
                ItemProperty itemProperty;
                String itemName = itemNames[i];
                if (itemName.isEmpty()) continue;
                Long recordId = recordsMap.get(itemName);
                String value = this.mospParams.getRequestParam(itemName);
                if (value == null) {
                    value = "";
                }
                if ((itemProperty = (conventionProperty = (ConventionProperty)this.mospParams.getProperties().getConventionProperties().get("Default")).getItem(itemKeys[i])).getType().equals("checkbox") && value.isEmpty()) {
                    value = "0";
                }
                if (recordId == null) {
                    int rowRegistId = rowId;
                    if (rowRegistId == 0) {
                        rowRegistId = newRowId;
                    }
                    dto = this.getInitDto();
                    dto.setPersonalId(personalId);
                    dto.setHumanItemType(itemName);
                    dto.setHumanRowId(rowRegistId);
                    dto.setActivateDate(activeDate);
                    dto.setHumanItemValue(value);
                    this.insert(dto);
                    this.mospParams.addGeneralParam("ArrayRowId", (Object)String.valueOf(newRowId));
                    if (!this.mospParams.hasErrorMessage()) continue;
                    return;
                }
                dto = (HumanArrayDtoInterface)this.dao.findForKey(recordId.longValue(), false);
                dto.setHumanItemValue(value);
                this.update(dto);
                if (!this.mospParams.hasErrorMessage()) continue;
                return;
            }
        }
    }

    public void delete(String division, String viewKey, int rowId, LinkedHashMap<String, Long> recordsMap) throws MospException {
        List tableItemList = this.humanGeneral.getTableItemList(division, viewKey);
        for (TableItemProperty tableItem : tableItemList) {
            String[] itemNames;
            for (String itemName : itemNames = tableItem.getItemNames()) {
                Long recordId;
                HumanArrayDtoInterface dto;
                if (itemName.isEmpty() || (dto = (HumanArrayDtoInterface)this.dao.findForKey((recordId = recordsMap.get(itemName)).longValue(), false)) == null) continue;
                this.delete(dto);
                if (!this.mospParams.hasErrorMessage()) continue;
                return;
            }
        }
    }

    public void delete(String division, String viewKey, String personalId, Date activeDate, int rowId) throws MospException {
        List tableItemList = this.humanGeneral.getTableItemList(division, viewKey);
        for (TableItemProperty tableItem : tableItemList) {
            String[] itemNames;
            for (String itemName : itemNames = tableItem.getItemNames()) {
                HumanArrayDtoInterface dto;
                if (itemName.isEmpty() || (dto = this.dao.findForKey(personalId, itemName, rowId)) == null) continue;
                this.delete(dto);
                if (!this.mospParams.hasErrorMessage()) continue;
                return;
            }
        }
    }

    public void deleteDeadInputItem(Set<String> divisions, String viewKey) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (String division : divisions) {
            List tableItemList = this.humanGeneral.getTableItemList(division, viewKey);
            for (TableItemProperty tableItem : tableItemList) {
                String[] itemNames;
                for (String itemName : itemNames = tableItem.getItemNames()) {
                    list.add(itemName);
                }
            }
        }
        if (list.isEmpty()) {
            return;
        }
        List listDeleteItem = this.dao.findForInfoNotIn(list);
        for (HumanArrayDtoInterface dto : listDeleteItem) {
            this.delete(dto);
        }
    }

    public void delete(HumanArrayDtoInterface dto) throws MospException {
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanArrayId());
    }

    public int getRowId() throws MospException {
        int rowId = this.dao.findForMaxRowId();
        return ++rowId;
    }

    private void checkDelete(HumanArrayDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaHumanArrayId());
    }

    public void insert(HumanArrayDtoInterface dto) throws MospException {
        dto.setPfaHumanArrayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void update(HumanArrayDtoInterface dto) throws MospException {
        HumanArrayDtoInterface arrayDto = (HumanArrayDtoInterface)this.findForKey((BaseDaoInterface)this.dao, dto.getPfaHumanArrayId(), true);
        this.checkExclusive((BaseDtoInterface)arrayDto);
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaHumanArrayId());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanArrayId());
        dto.setPfaHumanArrayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }
}

