/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.property.ConventionProperty;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.xml.ItemProperty;
import jp.mosp.framework.xml.TableItemProperty;
import jp.mosp.platform.bean.human.HumanArrayReferenceBeanInterface;
import jp.mosp.platform.bean.human.impl.HumanGeneralBean;
import jp.mosp.platform.dao.human.HumanArrayDaoInterface;
import jp.mosp.platform.dto.human.HumanArrayDtoInterface;

public class HumanArrayReferenceBean
extends HumanGeneralBean
implements HumanArrayReferenceBeanInterface {
    private HumanArrayDaoInterface dao;
    protected List<TableItemProperty> tableItemList;
    LinkedHashMap<String, Map<String, String>> arrayHumanInfoMap;
    Map<String, String> arrayMap;
    protected LinkedHashMap<String, Long> recordsMap;

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (HumanArrayDaoInterface)this.createDaoInstance(HumanArrayDaoInterface.class);
    }

    public List<HumanArrayDtoInterface> findForItemType(String personalId, String humanItemType) throws MospException {
        return this.dao.findForItemType(personalId, humanItemType);
    }

    public HumanArrayDtoInterface findForKey(String personalId, String humanItemType, int rowId) throws MospException {
        return this.dao.findForKey(personalId, humanItemType, rowId);
    }

    private HumanArrayDtoInterface findForKeyItems(String personalId, String humanItemType, int rowId) throws MospException {
        String[] arySplitItemName;
        HumanArrayDtoInterface dto = this.dao.findForKey(personalId, humanItemType, rowId);
        if (dto == null) {
            dto = this.findForKey(personalId, humanItemType + "Year", rowId);
        }
        if (dto == null) {
            dto = this.findForKey(personalId, humanItemType + "Area", rowId);
        }
        if (dto == null && (arySplitItemName = MospUtility.split((String)humanItemType, (String)",")).length != 0) {
            dto = this.findForKey(personalId, arySplitItemName[0], rowId);
        }
        return dto;
    }

    public void setCommounInfo(String division, String viewKey) {
        this.conventionProperty = (ConventionProperty)this.mospParams.getProperties().getConventionProperties().get("Default");
        this.tableItemList = this.getTableItemList(division, viewKey);
        this.arrayHumanInfoMap = new LinkedHashMap();
        this.arrayMap = new HashMap();
        this.recordsMap = new LinkedHashMap();
    }

    public LinkedHashMap<String, Map<String, String>> getHumanArrayMapInfo(String division, String viewKey, String personalId, int rowID) throws MospException {
        this.setCommounInfo(division, viewKey);
        for (TableItemProperty tableItem : this.tableItemList) {
            String[] itemNames = tableItem.getItemNames();
            String[] itemKeys = tableItem.getItemKeys();
            for (int i = 0; i < itemNames.length; ++i) {
                String itemName = itemNames[i];
                if (itemName.isEmpty()) continue;
                HumanArrayDtoInterface dto = this.findForKey(personalId, itemName, rowID);
                if (dto == null) {
                    this.arrayMap.put(itemName, "");
                    continue;
                }
                String itemKey = itemKeys[i];
                ItemProperty itemProperty = this.conventionProperty.getItem(itemKey);
                String pulldownValue = this.getPulldownValue(itemProperty, dto.getActivateDate(), dto.getHumanItemValue(), itemName, false);
                if (!pulldownValue.isEmpty()) {
                    this.arrayMap.put(itemName, pulldownValue);
                }
                this.arrayMap.put(itemName, dto.getHumanItemValue());
                this.arrayMap.put("activeDate", DateUtility.getStringDate((Date)dto.getActivateDate()));
                this.arrayHumanInfoMap.put(String.valueOf(rowID), this.arrayMap);
            }
        }
        return this.arrayHumanInfoMap;
    }

    public void getHumanArrayDtoMapInfo(String division, String viewKey, String personalId, int rowID) throws MospException {
        this.setCommounInfo(division, viewKey);
        LinkedHashMap<String, Long> keyMap = new LinkedHashMap<String, Long>();
        for (TableItemProperty tableItem : this.tableItemList) {
            String[] itemNames = tableItem.getItemNames();
            String[] itemKeys = tableItem.getItemKeys();
            for (int i = 0; i < itemNames.length; ++i) {
                HumanArrayDtoInterface dto;
                String itemName = itemNames[i];
                if (itemName.isEmpty() || (dto = this.findForKey(personalId, itemName, rowID)) == null) continue;
                String itemKey = itemKeys[i];
                ItemProperty itemProperty = this.conventionProperty.getItem(itemKey);
                String pulldownValue = this.getPulldownValue(itemProperty, dto.getActivateDate(), dto.getHumanItemValue(), itemName, false);
                if (!pulldownValue.isEmpty()) {
                    dto.setHumanItemValue(pulldownValue);
                }
                keyMap.put(itemName, dto.getPfaHumanArrayId());
                this.arrayMap.put(itemName, dto.getHumanItemValue());
                this.arrayMap.put("activeDate", DateUtility.getStringDate((Date)dto.getActivateDate()));
                this.arrayHumanInfoMap.put(String.valueOf(rowID), this.arrayMap);
                this.recordsMap.put(itemName, dto.getPfaHumanArrayId());
            }
        }
    }

    public LinkedHashMap<String, Map<String, String>> getRowIdArrayMapInfo(String division, String viewKey, String personalId, Date targetDate) throws MospException {
        this.setCommounInfo(division, viewKey);
        this.arrayHumanInfoMap = this.getArrayHumanInfoMapForKey(this.tableItemList, personalId);
        for (TableItemProperty tableItem : this.tableItemList) {
            String[] itemNames = tableItem.getItemNames();
            String[] itemKeys = tableItem.getItemKeys();
            String[] labelKeys = tableItem.getLabelKeys();
            for (String rowId : this.arrayHumanInfoMap.keySet()) {
                for (int i = 0; i < itemNames.length; ++i) {
                    String mapRowId = String.valueOf(rowId);
                    HashMap<String, String> arrayMap = (HashMap<String, String>)this.arrayHumanInfoMap.get(mapRowId);
                    if (arrayMap == null) {
                        arrayMap = new HashMap<String, String>();
                    }
                    HumanArrayDtoInterface dto = this.findForKeyItems(personalId, itemNames[i], Integer.parseInt(rowId));
                    ItemProperty itemProperty = this.conventionProperty.getItem(itemKeys[i]);
                    String humanItemValue = "";
                    if (dto == null) continue;
                    String labelKey = labelKeys[i];
                    String dateTypeValue = this.getSeparateTxtItemArrayValue(personalId, itemNames[i], itemProperty, mapRowId, targetDate, labelKey);
                    arrayMap.put(itemNames[i], dateTypeValue);
                    humanItemValue = dateTypeValue;
                    String pulldownValue = this.getPulldownValue(itemProperty, dto.getActivateDate(), dto.getHumanItemValue(), itemNames[i], true);
                    if (!pulldownValue.isEmpty()) {
                        humanItemValue = pulldownValue;
                        arrayMap.put(itemNames[i], pulldownValue);
                    }
                    if (humanItemValue.isEmpty()) {
                        arrayMap.put(dto.getHumanItemType(), dto.getHumanItemValue());
                    }
                    arrayMap.put("activeDate", DateUtility.getStringDate((Date)dto.getActivateDate()));
                    this.arrayHumanInfoMap.put(mapRowId, arrayMap);
                }
            }
        }
        return this.arrayHumanInfoMap;
    }

    public String getArrayItemValue(String division, String viewKey, String personalId, Date targetDate, String tableItemKey, boolean isPulldownName) throws MospException {
        this.setCommounInfo(division, viewKey);
        this.arrayHumanInfoMap = this.getArrayHumanInfoMapForKey(this.tableItemList, personalId);
        for (TableItemProperty tableItem : this.tableItemList) {
            if (!tableItem.getKey().equals(tableItemKey)) continue;
            String[] itemNames = tableItem.getItemNames();
            String[] itemKeys = tableItem.getItemKeys();
            String[] labelKeys = tableItem.getLabelKeys();
            for (String rowId : this.arrayHumanInfoMap.keySet()) {
                for (int i = 0; i < itemNames.length; ++i) {
                    String mapRowId = rowId;
                    ItemProperty itemProperty = this.conventionProperty.getItem(itemKeys[i]);
                    String labelKey = labelKeys[i];
                    if (labelKey.equals("ActivateDate")) {
                        HumanArrayDtoInterface dto = this.findForKeyItems(personalId, itemNames[i], Integer.parseInt(rowId));
                        if (dto == null) {
                            return "";
                        }
                        return this.getStringDate(dto.getActivateDate());
                    }
                    String dateTypeValue = this.getSeparateTxtItemArrayValue(personalId, itemNames[i], itemProperty, mapRowId, targetDate, labelKey);
                    if (!dateTypeValue.isEmpty()) {
                        return dateTypeValue;
                    }
                    HumanArrayDtoInterface dto = this.findForKey(personalId, itemNames[i], Integer.parseInt(rowId));
                    if (dto == null) continue;
                    String pulldownValue = this.getPulldownValue(itemProperty, dto.getActivateDate(), dto.getHumanItemValue(), itemNames[i], true);
                    if (!pulldownValue.isEmpty()) {
                        return pulldownValue;
                    }
                    return dto.getHumanItemType();
                }
            }
        }
        return "";
    }

    public LinkedHashMap<String, Map<String, String>> getArrayHumanInfoMapForKey(List<TableItemProperty> tableItemList, String personalId) throws MospException {
        LinkedHashMap<String, Map<String, String>> arrayRowHumanInfoMap = new LinkedHashMap<String, Map<String, String>>();
        ArrayList<HumanArrayDtoInterface> valueList = new ArrayList<HumanArrayDtoInterface>();
        for (TableItemProperty tableItem : tableItemList) {
            String[] itemNames;
            for (String itemName : itemNames = tableItem.getItemNames()) {
                String[] aryItemName;
                List dataList = this.dao.findForItemType(personalId, itemName);
                if (dataList.isEmpty()) {
                    dataList = this.findForItemType(personalId, itemName + "Year");
                }
                if (dataList.isEmpty()) {
                    dataList = this.findForItemType(personalId, itemName + "Area");
                }
                if (dataList.isEmpty() && (aryItemName = MospUtility.split((String)itemName, (String)",")).length != 0) {
                    dataList = this.findForItemType(personalId, aryItemName[0]);
                }
                for (int i = 0; i < dataList.size() - 1; ++i) {
                    int j = i + 1;
                    while (j < dataList.size()) {
                        if (((HumanArrayDtoInterface)dataList.get(i)).getHumanRowId() == ((HumanArrayDtoInterface)dataList.get(j)).getHumanRowId()) {
                            dataList.remove(j);
                            continue;
                        }
                        ++j;
                    }
                }
                for (HumanArrayDtoInterface dto : dataList) {
                    valueList.add(dto);
                }
            }
        }
        for (HumanArrayDtoInterface dto : valueList) {
            HashMap<String, String> arrayRowMap = new HashMap<String, String>();
            arrayRowMap.put("activeDate", DateUtility.getStringDate((Date)dto.getActivateDate()));
            arrayRowHumanInfoMap.put(String.valueOf(dto.getHumanRowId()), arrayRowMap);
        }
        return arrayRowHumanInfoMap;
    }

    public String[] getArrayActiveDate(LinkedHashMap<String, Map<String, String>> rowIdArrayMapInfo) {
        ArrayList<String> rowIdList = new ArrayList<String>(rowIdArrayMapInfo.keySet());
        String[] arrayRowId = new String[rowIdList.size()];
        if (rowIdList.isEmpty()) {
            return arrayRowId;
        }
        Collections.sort(rowIdList);
        for (int i = 0; i < rowIdList.size(); ++i) {
            arrayRowId[i] = (String)rowIdList.get(i);
        }
        return arrayRowId;
    }

    public LinkedHashMap<String, Long> getRecordsMap() {
        return this.recordsMap;
    }

    public LinkedHashMap<String, Map<String, String>> getArrayHumanInfoMap() {
        return this.arrayHumanInfoMap;
    }
}

