/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.human.EntranceRegistBeanInterface;
import jp.mosp.platform.bean.human.base.PlatformHumanBean;
import jp.mosp.platform.dao.human.EntranceDaoInterface;
import jp.mosp.platform.dao.human.RetirementDaoInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;
import jp.mosp.platform.dto.human.impl.PfaHumanEntranceDto;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class EntranceRegistBean
extends PlatformHumanBean
implements EntranceRegistBeanInterface {
    EntranceDaoInterface dao;

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (EntranceDaoInterface)this.createDaoInstance(EntranceDaoInterface.class);
    }

    public EntranceDtoInterface getInitDto() {
        return new PfaHumanEntranceDto();
    }

    public void insert(EntranceDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfaHumanEntranceId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void regist(EntranceDtoInterface dto) throws MospException {
        if (dto.getPfaHumanEntranceId() == 0L) {
            this.insert(dto);
        } else {
            this.update(dto);
        }
    }

    public void delete(EntranceDtoInterface dto) throws MospException {
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanEntranceId());
    }

    public void validate(EntranceDtoInterface dto, Integer row) {
        this.checkRequired((Object)dto.getEntranceDate(), PfNameUtility.entranceDate((MospParams)this.mospParams), row);
    }

    public void update(EntranceDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanEntranceId());
        dto.setPfaHumanEntranceId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void checkInsert(EntranceDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForInfo(dto.getPersonalId()));
    }

    protected void checkUpdate(EntranceDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaHumanEntranceId());
        this.checkEmployeeForUpdate(dto);
    }

    protected void checkDelete(EntranceDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaHumanEntranceId());
        this.checkEmployeeForDelete(dto);
    }

    protected void checkEmployeeForUpdate(EntranceDtoInterface dto) throws MospException {
        RetirementDaoInterface retirementDao = (RetirementDaoInterface)this.createDaoInstance(RetirementDaoInterface.class);
        RetirementDtoInterface retirementDto = retirementDao.findForInfo(dto.getPersonalId());
        if (retirementDto != null && retirementDto.getRetirementDate().before(dto.getEntranceDate())) {
            PfMessageUtility.addErrorOrderInvalid((MospParams)this.mospParams, (String)PfNameUtility.retirementDate((MospParams)this.mospParams), (String)PfNameUtility.entranceDate((MospParams)this.mospParams));
        }
    }

    protected void checkEmployeeForDelete(EntranceDtoInterface dto) throws MospException {
        RetirementDaoInterface retirementDao = (RetirementDaoInterface)this.createDaoInstance(RetirementDaoInterface.class);
        RetirementDtoInterface retirementDto = retirementDao.findForInfo(dto.getPersonalId());
        if (retirementDto != null) {
            PfMessageUtility.addErrorDeleteEntrance((MospParams)this.mospParams);
        }
    }
}

