/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.base;

import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.file.PlatformFileBean;
import jp.mosp.platform.bean.system.PlatformMasterCheckBeanInterface;
import jp.mosp.platform.dao.human.EntranceDaoInterface;
import jp.mosp.platform.dao.human.RetirementDaoInterface;
import jp.mosp.platform.dao.system.EmploymentContractDaoInterface;
import jp.mosp.platform.dao.system.NamingDaoInterface;
import jp.mosp.platform.dao.system.PositionDaoInterface;
import jp.mosp.platform.dao.system.SectionDaoInterface;
import jp.mosp.platform.dao.system.WorkPlaceDaoInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;
import jp.mosp.platform.dto.system.EmploymentContractDtoInterface;
import jp.mosp.platform.dto.system.NamingDtoInterface;
import jp.mosp.platform.dto.system.PositionDtoInterface;
import jp.mosp.platform.dto.system.SectionDtoInterface;
import jp.mosp.platform.dto.system.WorkPlaceDtoInterface;
import jp.mosp.platform.human.utils.HumanUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public abstract class PlatformHumanBean
extends PlatformFileBean {
    protected PlatformMasterCheckBeanInterface masterCheck;

    public void initBean() throws MospException {
        this.masterCheck = (PlatformMasterCheckBeanInterface)this.createBeanInstance(PlatformMasterCheckBeanInterface.class);
    }

    protected String getHumanName(HumanDtoInterface dto) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return "";
        }
        return MospUtility.getHumansName((String)dto.getFirstName(), (String)dto.getLastName());
    }

    protected Date getEntranceDate(String personalId) throws MospException {
        EntranceDaoInterface entranceDao = (EntranceDaoInterface)this.createDaoInstance(EntranceDaoInterface.class);
        EntranceDtoInterface dto = entranceDao.findForInfo(personalId);
        if (dto != null) {
            return dto.getEntranceDate();
        }
        return null;
    }

    protected Date getRetirementDate(String personalId) throws MospException {
        RetirementDaoInterface retirementDao = (RetirementDaoInterface)this.createDaoInstance(RetirementDaoInterface.class);
        RetirementDtoInterface dto = retirementDao.findForInfo(personalId);
        return HumanUtility.getRetireDate((RetirementDtoInterface)dto);
    }

    protected void checkWorkPlace(String workPlaceCode, Date startDate, Date endDate, Integer row) throws MospException {
        if (MospUtility.isEmpty((String[])new String[]{workPlaceCode})) {
            return;
        }
        WorkPlaceDaoInterface workPlaceDao = (WorkPlaceDaoInterface)this.createDaoInstance(WorkPlaceDaoInterface.class);
        WorkPlaceDtoInterface dto = workPlaceDao.findForInfo(workPlaceCode, startDate);
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            String fieldName = PfNameUtility.workPlace((MospParams)this.mospParams);
            PfMessageUtility.addErrorNotExist((MospParams)this.mospParams, (String)fieldName, (String)workPlaceCode, (Integer)row);
            return;
        }
        this.masterCheck.isCheckWorkPlace(workPlaceCode, startDate, endDate, row);
    }

    protected void checkEmploymentContract(String employmentContractCode, Date startDate, Date endDate, Integer row) throws MospException {
        if (MospUtility.isEmpty((String[])new String[]{employmentContractCode})) {
            return;
        }
        EmploymentContractDaoInterface employmentContractDao = (EmploymentContractDaoInterface)this.createDaoInstance(EmploymentContractDaoInterface.class);
        EmploymentContractDtoInterface dto = employmentContractDao.findForInfo(employmentContractCode, startDate);
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            String fieldName = PfNameUtility.employmentContract((MospParams)this.mospParams);
            PfMessageUtility.addErrorNotExist((MospParams)this.mospParams, (String)fieldName, (String)employmentContractCode, (Integer)row);
            return;
        }
        this.masterCheck.isCheckEmploymentContract(employmentContractCode, startDate, endDate, row);
    }

    protected void checkSection(String sectionCode, Date startDate, Date endDate, Integer row) throws MospException {
        if (MospUtility.isEmpty((String[])new String[]{sectionCode})) {
            return;
        }
        SectionDaoInterface sectionDao = (SectionDaoInterface)this.createDaoInstance(SectionDaoInterface.class);
        SectionDtoInterface dto = sectionDao.findForInfo(sectionCode, startDate);
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            String fieldName = PfNameUtility.section((MospParams)this.mospParams);
            PfMessageUtility.addErrorNotExist((MospParams)this.mospParams, (String)fieldName, (String)sectionCode, (Integer)row);
            return;
        }
        this.masterCheck.isCheckSection(sectionCode, startDate, endDate, row);
    }

    protected void checkPosition(String positionCode, Date startDate, Date endDate, Integer row) throws MospException {
        if (MospUtility.isEmpty((String[])new String[]{positionCode})) {
            return;
        }
        PositionDaoInterface positionDao = (PositionDaoInterface)this.createDaoInstance(PositionDaoInterface.class);
        PositionDtoInterface dto = positionDao.findForInfo(positionCode, startDate);
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            String fieldName = PfNameUtility.position((MospParams)this.mospParams);
            PfMessageUtility.addErrorNotExist((MospParams)this.mospParams, (String)fieldName, (String)positionCode, (Integer)row);
            return;
        }
        this.masterCheck.isCheckPosition(positionCode, startDate, endDate, row);
    }

    protected void checkNaming(String namingType, String namingItemCode, Date startDate, Date endDate, Integer row) throws MospException {
        if (MospUtility.isEmpty((String[])new String[]{namingItemCode})) {
            return;
        }
        NamingDaoInterface namingDao = (NamingDaoInterface)this.createDaoInstance(NamingDaoInterface.class);
        NamingDtoInterface dto = namingDao.findForInfo(namingType, namingItemCode, startDate);
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            String fieldName = MospUtility.getCodeName((MospParams)this.mospParams, (String)namingType, (String)"NamingType");
            PfMessageUtility.addErrorNotExist((MospParams)this.mospParams, (String)fieldName, (String)namingItemCode, (Integer)row);
            return;
        }
        this.masterCheck.isCheckNaming(namingType, namingItemCode, startDate, endDate, row);
    }
}

