/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.file.PlatformFileBean;
import jp.mosp.platform.bean.file.UserPasswordImportBeanInterface;
import jp.mosp.platform.bean.portal.PasswordCheckBeanInterface;
import jp.mosp.platform.bean.system.UserPasswordRegistBeanInterface;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.dto.file.ImportFieldDtoInterface;
import jp.mosp.platform.dto.system.UserPasswordDtoInterface;

public class UserPasswordImportBean
extends PlatformFileBean
implements UserPasswordImportBeanInterface {
    protected UserPasswordRegistBeanInterface passwordRegist;
    protected PasswordCheckBeanInterface passwordCheck;

    public void initBean() throws MospException {
        this.passwordRegist = (UserPasswordRegistBeanInterface)this.createBeanInstance(UserPasswordRegistBeanInterface.class);
        this.passwordCheck = (PasswordCheckBeanInterface)this.createBeanInstance(PasswordCheckBeanInterface.class);
    }

    public int importFile(ImportDtoInterface importDto, InputStream requestedFile) throws MospException {
        List dataList = this.getDataList(importDto, requestedFile);
        List fieldList = this.getImportFieldList(importDto.getImportCode());
        return this.importFile(fieldList, dataList);
    }

    public int importFile(List<ImportFieldDtoInterface> fieldList, List<String[]> dataList) throws MospException {
        List targetList = this.getTargetList(fieldList, dataList);
        int row = 0;
        for (UserPasswordDtoInterface dto : targetList) {
            this.passwordRegist.validate(dto, Integer.valueOf(row++));
            if (this.mospParams.hasErrorMessage()) continue;
            this.passwordRegist.regist(dto);
        }
        return targetList.size();
    }

    protected List<UserPasswordDtoInterface> getTargetList(List<ImportFieldDtoInterface> fieldList, List<String[]> dataList) throws MospException {
        ArrayList<UserPasswordDtoInterface> targetList = new ArrayList<UserPasswordDtoInterface>();
        this.checkCsvLength(fieldList, dataList);
        if (this.mospParams.hasErrorMessage()) {
            return targetList;
        }
        for (int i = 0; i < dataList.size(); ++i) {
            String[] data = dataList.get(i);
            UserPasswordDtoInterface dto = this.getUserPasswordDto(fieldList, data);
            targetList.add(dto);
        }
        return targetList;
    }

    protected UserPasswordDtoInterface getUserPasswordDto(List<ImportFieldDtoInterface> fieldList, String[] data) throws MospException {
        UserPasswordDtoInterface dto = this.getInitDto();
        String userId = this.getFieldValue("user_id", fieldList, data);
        Date changeDate = this.getDateFieldValue("change_date", fieldList, data);
        String password = this.getFieldValue("password", fieldList, data);
        userId = userId == null ? "" : userId;
        password = MospUtility.isEmpty((String[])new String[]{password}) ? "" : this.passwordCheck.encryptPlain(password);
        dto.setUserId(userId);
        dto.setChangeDate(changeDate);
        dto.setPassword(password);
        return dto;
    }

    protected UserPasswordDtoInterface getInitDto() {
        return this.passwordRegist.getInitDto();
    }
}

