/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.file.PlatformFileBean;
import jp.mosp.platform.bean.file.UserExtraRoleImportBeanInterface;
import jp.mosp.platform.bean.system.UserAccountRegistBeanInterface;
import jp.mosp.platform.bean.system.UserExtraRoleRegistBeanInterface;
import jp.mosp.platform.bean.system.UserMasterReferenceBeanInterface;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.dto.file.ImportFieldDtoInterface;
import jp.mosp.platform.dto.system.UserExtraRoleDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;
import jp.mosp.platform.utils.PlatformUtility;

public class UserExtraRoleImportBean
extends PlatformFileBean
implements UserExtraRoleImportBeanInterface {
    protected UserExtraRoleRegistBeanInterface regist;
    protected UserMasterReferenceBeanInterface userRefer;
    protected UserAccountRegistBeanInterface accountRegist;

    public void initBean() throws MospException {
        this.regist = (UserExtraRoleRegistBeanInterface)this.createBeanInstance(UserExtraRoleRegistBeanInterface.class);
        this.userRefer = (UserMasterReferenceBeanInterface)this.createBeanInstance(UserMasterReferenceBeanInterface.class);
        this.accountRegist = (UserAccountRegistBeanInterface)this.createBeanInstance(UserAccountRegistBeanInterface.class);
    }

    public int importFile(ImportDtoInterface importDto, InputStream requestedFile) throws MospException {
        List dataList = this.getDataList(importDto, requestedFile);
        Map map = this.getTargetDtos(importDto, dataList);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        for (Map activateDateMap : map.values()) {
            for (Set dtos : activateDateMap.values()) {
                this.regist.regist((Collection)dtos);
            }
        }
        this.accountRegist.checkAfterRegist();
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        return dataList.size();
    }

    protected Map<String, Map<Date, Set<UserExtraRoleDtoInterface>>> getTargetDtos(ImportDtoInterface importDto, List<String[]> dataList) throws MospException {
        LinkedHashMap<String, Map<Date, Set<UserExtraRoleDtoInterface>>> map = new LinkedHashMap<String, Map<Date, Set<UserExtraRoleDtoInterface>>>();
        List fieldList = this.getImportFieldList(importDto.getImportCode());
        this.checkCsvLength(fieldList, dataList);
        if (this.mospParams.hasErrorMessage()) {
            return map;
        }
        for (int i = 0; i < dataList.size(); ++i) {
            LinkedHashSet<UserExtraRoleDtoInterface> dtos;
            String[] data = dataList.get(i);
            UserExtraRoleDtoInterface dto = this.getDto(fieldList, data, i);
            if (dto == null) continue;
            String userId = dto.getUserId();
            Date activateDate = dto.getActivateDate();
            LinkedHashMap<Date, LinkedHashSet<UserExtraRoleDtoInterface>> activateDateMap = (LinkedHashMap<Date, LinkedHashSet<UserExtraRoleDtoInterface>>)map.get(userId);
            if (activateDateMap == null) {
                activateDateMap = new LinkedHashMap<Date, LinkedHashSet<UserExtraRoleDtoInterface>>();
                map.put(userId, activateDateMap);
            }
            if ((dtos = (LinkedHashSet<UserExtraRoleDtoInterface>)activateDateMap.get(activateDate)) == null) {
                dtos = new LinkedHashSet<UserExtraRoleDtoInterface>();
                activateDateMap.put(activateDate, dtos);
            }
            dtos.add(dto);
        }
        return map;
    }

    protected UserExtraRoleDtoInterface getDto(List<ImportFieldDtoInterface> fieldList, String[] data, int row) throws MospException {
        String userId = this.getFieldValue("user_id", fieldList, data);
        Date activateDate = this.getDateFieldValue("activate_date", fieldList, data);
        String roleType = this.getFieldValue("role_type", fieldList, data);
        String roleCode = this.getFieldValue("role_code", fieldList, data);
        UserExtraRoleDtoInterface dto = this.regist.getInitDto();
        dto.setUserId(userId);
        dto.setActivateDate(activateDate);
        dto.setRoleType(roleType);
        dto.setRoleCode(roleCode);
        this.createUser(userId, activateDate);
        this.regist.validate(dto, Integer.valueOf(row));
        return dto;
    }

    protected void createUser(String userId, Date activateDate) throws MospException {
        List users = this.userRefer.getUserHistory(userId);
        if (!MospUtility.isEmpty((Object[])new Object[]{PlatformUtility.getDto((List)users, (Date)activateDate)})) {
            return;
        }
        UserMasterDtoInterface dto = (UserMasterDtoInterface)PlatformUtility.getLatestActiveDto((List)users, (Date)activateDate);
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return;
        }
        Date latestActivateDate = dto.getActivateDate();
        dto.setActivateDate(activateDate);
        this.accountRegist.add(dto, Collections.emptySet());
        this.regist.copy(userId, latestActivateDate, activateDate);
    }
}

