/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.file.UserExtraRoleExportBeanInterface;
import jp.mosp.platform.bean.file.impl.BaseExportBean;
import jp.mosp.platform.bean.system.UserExtraRoleReferenceBeanInterface;
import jp.mosp.platform.dao.system.UserMasterDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;

public class UserExtraRoleExportBean
extends BaseExportBean
implements UserExtraRoleExportBeanInterface {
    protected UserMasterDaoInterface userMasterDao;
    protected UserExtraRoleReferenceBeanInterface userExtraRoleRefer;

    public void initBean() throws MospException {
        super.initBean();
        this.userMasterDao = (UserMasterDaoInterface)this.createDaoInstance(UserMasterDaoInterface.class);
        this.userExtraRoleRefer = (UserExtraRoleReferenceBeanInterface)this.createBeanInstance(UserExtraRoleReferenceBeanInterface.class);
    }

    protected List<String[]> makeCsvDataList(List<String> fieldList, Date targetDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        ArrayList<String[]> csvDataList = new ArrayList<String[]>();
        List humans = this.searchHumanList(targetDate, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        for (HumanDtoInterface human : humans) {
            List userList = this.userMasterDao.findForPersonalId(human.getPersonalId(), targetDate);
            for (UserMasterDtoInterface user : userList) {
                csvDataList.addAll(this.getCsvDataList(user, fieldList));
            }
        }
        return csvDataList;
    }

    protected List<String[]> getCsvDataList(UserMasterDtoInterface user, List<String> fieldList) throws MospException {
        ArrayList<String[]> csvDataList = new ArrayList<String[]>();
        String userId = user.getUserId();
        Date activateDate = user.getActivateDate();
        Map extraRoles = this.userExtraRoleRefer.getUserExtraRoleMap(userId, activateDate);
        for (Map.Entry extraRole : extraRoles.entrySet()) {
            csvDataList.add(this.getCsvData(userId, activateDate, (String)extraRole.getKey(), (String)extraRole.getValue(), fieldList));
        }
        return csvDataList;
    }

    protected String[] getCsvData(String userId, Date activateDate, String roleType, String roleCode, List<String> fieldList) {
        ArrayList<String> csvData = new ArrayList<String>();
        for (String field : fieldList) {
            if (MospUtility.isEqual((Object)field, (Object)"user_id")) {
                csvData.add(userId);
                continue;
            }
            if (MospUtility.isEqual((Object)field, (Object)"activate_date")) {
                csvData.add(this.getStringDate(activateDate));
                continue;
            }
            if (MospUtility.isEqual((Object)field, (Object)"role_type")) {
                csvData.add(roleType);
                continue;
            }
            if (!MospUtility.isEqual((Object)field, (Object)"role_code")) continue;
            csvData.add(roleCode);
        }
        return MospUtility.toArray(csvData);
    }
}

