/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.file.UserExportBeanInterface;
import jp.mosp.platform.bean.file.impl.BaseExportBean;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.dao.system.UserMasterDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;

public class UserExportBean
extends BaseExportBean
implements UserExportBeanInterface {
    protected UserMasterDaoInterface userMasterDao;
    protected SectionReferenceBeanInterface sectionReference;

    public void initBean() throws MospException {
        super.initBean();
        this.userMasterDao = (UserMasterDaoInterface)this.createDaoInstance(UserMasterDaoInterface.class);
        this.sectionReference = (SectionReferenceBeanInterface)this.createBeanInstance(SectionReferenceBeanInterface.class);
    }

    protected List<String[]> makeCsvDataList(List<String> fieldList, Date targetDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        ArrayList<String[]> csvDataList = new ArrayList<String[]>();
        List humans = this.searchHumanList(targetDate, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        this.addUserMasterData(csvDataList, fieldList, targetDate, humans);
        return csvDataList;
    }

    protected void addUserMasterData(List<String[]> csvDataList, List<String> fieldList, Date targetDate, List<HumanDtoInterface> humans) throws MospException {
        int i;
        Integer userIdIndex = null;
        Integer activateDateIndex = null;
        Integer employeeCodeIndex = null;
        Integer employeeNameIndex = null;
        Integer sectionNameIndex = null;
        Integer sectionDisplayIndex = null;
        Integer roleCodeIndex = null;
        for (i = 0; i < fieldList.size(); ++i) {
            String field = fieldList.get(i);
            if (MospUtility.isEqual((Object)field, (Object)"user_id")) {
                userIdIndex = i;
            }
            if (MospUtility.isEqual((Object)field, (Object)"activate_date")) {
                activateDateIndex = i;
            }
            if (MospUtility.isEqual((Object)field, (Object)"employee_code")) {
                employeeCodeIndex = i;
            }
            if (MospUtility.isEqual((Object)field, (Object)"full_name")) {
                employeeNameIndex = i;
            }
            if (MospUtility.isEqual((Object)field, (Object)"role_code")) {
                roleCodeIndex = i;
            }
            if (MospUtility.isEqual((Object)field, (Object)"section_name")) {
                sectionNameIndex = i;
            }
            if (!MospUtility.isEqual((Object)field, (Object)"section_display")) continue;
            sectionDisplayIndex = i;
        }
        for (i = 0; i < humans.size(); ++i) {
            HumanDtoInterface human = humans.get(i);
            List userMasterList = this.userMasterDao.findForPersonalId(human.getPersonalId(), targetDate);
            for (UserMasterDtoInterface userMaster : userMasterList) {
                String[] csvData = new String[fieldList.size()];
                if (userIdIndex != null) {
                    csvData[userIdIndex.intValue()] = userMaster.getUserId();
                }
                if (activateDateIndex != null) {
                    csvData[activateDateIndex.intValue()] = this.getStringDate(userMaster.getActivateDate());
                }
                if (employeeCodeIndex != null) {
                    csvData[employeeCodeIndex.intValue()] = human.getEmployeeCode();
                }
                if (employeeNameIndex != null) {
                    csvData[employeeNameIndex.intValue()] = MospUtility.getHumansName((String)human.getFirstName(), (String)human.getLastName());
                }
                if (roleCodeIndex != null) {
                    csvData[roleCodeIndex.intValue()] = userMaster.getRoleCode();
                }
                if (sectionNameIndex != null) {
                    csvData[sectionNameIndex.intValue()] = this.sectionReference.getSectionName(human.getSectionCode(), targetDate);
                }
                if (sectionDisplayIndex != null) {
                    csvData[sectionDisplayIndex.intValue()] = this.sectionReference.getSectionDisplay(human.getSectionCode(), targetDate);
                }
                csvDataList.add(csvData);
            }
        }
    }
}

