/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.util.ArrayList;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.NameUtility;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.file.ImportFieldReferenceBeanInterface;
import jp.mosp.platform.bean.file.ImportReferenceBeanInterface;
import jp.mosp.platform.bean.file.TemplateOutputBeanInterface;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.dto.file.ImportFieldDtoInterface;
import jp.mosp.platform.utils.PfNameUtility;

public class TemplateOutputBean
extends PlatformBean
implements TemplateOutputBeanInterface {
    public static final String FILENAME_EXTENSION_CSV = ".csv";
    protected ImportReferenceBeanInterface importReference;
    protected ImportFieldReferenceBeanInterface importFieldReference;

    public void initBean() throws MospException {
        this.importReference = (ImportReferenceBeanInterface)this.createBeanInstance(ImportReferenceBeanInterface.class);
        this.importFieldReference = (ImportFieldReferenceBeanInterface)this.createBeanInstance(ImportFieldReferenceBeanInterface.class);
    }

    public void output(String importCode) throws MospException {
        ImportDtoInterface dto = this.importReference.findForKey(importCode);
        this.mospParams.setFile((Object)OrangeSignalUtility.getOrangeSignalParams((List)this.getTemplate(dto)));
        this.mospParams.setFileName(this.getFileName(dto));
    }

    protected List<String[]> getTemplate(ImportDtoInterface dto) throws MospException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        list.add(this.getHeader(dto));
        return list;
    }

    protected String[] getHeader(ImportDtoInterface dto) throws MospException {
        return this.getHeader(dto.getImportTable(), this.importFieldReference.getImportFieldList(dto.getImportCode()));
    }

    protected String[] getHeader(String importTable, List<ImportFieldDtoInterface> list) throws MospException {
        String[] array = new String[list.size()];
        for (int i = 0; i < array.length; ++i) {
            ImportFieldDtoInterface dto = list.get(i);
            String[] fieldNames = MospUtility.split((String)dto.getFieldName(), (String)",");
            if (fieldNames.length > 1) {
                StringBuilder sb = new StringBuilder(NameUtility.getName((MospParams)this.mospParams, (String)fieldNames[1])).append(PfNameUtility.parentheses((MospParams)this.mospParams, (String)NameUtility.getName((MospParams)this.mospParams, (String)fieldNames[0])));
                array[i] = sb.toString();
                continue;
            }
            array[i] = this.mospParams.getProperties().getCodeItemName(importTable, dto.getFieldName());
        }
        return array;
    }

    protected String getFileName(ImportDtoInterface dto) {
        StringBuffer sb = new StringBuffer();
        sb.append(dto.getImportCode());
        if ("1".equals(dto.getType())) {
            sb.append(FILENAME_EXTENSION_CSV);
        }
        return sb.toString();
    }
}

