/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.file.SectionExportBeanInterface;
import jp.mosp.platform.bean.file.impl.BaseExportBean;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionSearchBeanInterface;
import jp.mosp.platform.dto.system.SectionDtoInterface;

public class SectionExportBean
extends BaseExportBean
implements SectionExportBeanInterface {
    protected SectionReferenceBeanInterface sectionReference;
    protected SectionSearchBeanInterface sectionSearch;

    public void initBean() throws MospException {
        super.initBean();
        this.sectionReference = (SectionReferenceBeanInterface)this.createBeanInstance(SectionReferenceBeanInterface.class);
        this.sectionSearch = (SectionSearchBeanInterface)this.createBeanInstance(SectionSearchBeanInterface.class);
    }

    protected List<String[]> makeCsvDataList(List<String> fieldList, Date targetDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        ArrayList<String[]> csvDataList = new ArrayList<String[]>();
        List sections = this.search(targetDate, sectionCode);
        this.addData(csvDataList, fieldList, sections);
        return csvDataList;
    }

    protected List<SectionDtoInterface> search(Date targetDate, String sectionCode) throws MospException {
        this.sectionSearch.setActivateDate(targetDate);
        this.sectionSearch.setSectionCode(sectionCode);
        this.sectionSearch.setSectionName("");
        this.sectionSearch.setSectionAbbr("");
        this.sectionSearch.setSectionType("route");
        this.sectionSearch.setCloseFlag(Integer.toString(0));
        return this.sectionSearch.getExportList();
    }

    protected void addData(List<String[]> csvDataList, List<String> fieldList, List<SectionDtoInterface> sections) {
        Integer sectionCodeIndex = null;
        Integer activateDateIndex = null;
        Integer sectionNameIndex = null;
        Integer sectionAbbrIndex = null;
        Integer sectionDisplayIndex = null;
        Integer upperSectionCodeIndex = null;
        Integer closeFlagIndex = null;
        for (int i = 0; i < fieldList.size(); ++i) {
            String field = fieldList.get(i);
            if (MospUtility.isEqual((Object)field, (Object)"section_code")) {
                sectionCodeIndex = i;
            }
            if (MospUtility.isEqual((Object)field, (Object)"activate_date")) {
                activateDateIndex = i;
            }
            if (MospUtility.isEqual((Object)field, (Object)"section_name")) {
                sectionNameIndex = i;
            }
            if (MospUtility.isEqual((Object)field, (Object)"section_abbr")) {
                sectionAbbrIndex = i;
            }
            if (MospUtility.isEqual((Object)field, (Object)"section_display")) {
                sectionDisplayIndex = i;
            }
            if (MospUtility.isEqual((Object)field, (Object)"upper_section_code")) {
                upperSectionCodeIndex = i;
            }
            if (!MospUtility.isEqual((Object)field, (Object)"close_flag")) continue;
            closeFlagIndex = i;
        }
        for (SectionDtoInterface dto : sections) {
            String[] csvData = new String[fieldList.size()];
            if (sectionCodeIndex != null) {
                csvData[sectionCodeIndex.intValue()] = dto.getSectionCode();
            }
            if (activateDateIndex != null) {
                csvData[activateDateIndex.intValue()] = this.getStringDate(dto.getActivateDate());
            }
            if (sectionNameIndex != null) {
                csvData[sectionNameIndex.intValue()] = dto.getSectionName();
            }
            if (sectionAbbrIndex != null) {
                csvData[sectionAbbrIndex.intValue()] = dto.getSectionAbbr();
            }
            if (sectionDisplayIndex != null) {
                csvData[sectionDisplayIndex.intValue()] = dto.getSectionDisplay();
            }
            if (upperSectionCodeIndex != null) {
                csvData[upperSectionCodeIndex.intValue()] = this.getUpperSectionCode(dto);
            }
            if (closeFlagIndex != null) {
                csvData[closeFlagIndex.intValue()] = Integer.toString(dto.getCloseFlag());
            }
            csvDataList.add(csvData);
        }
    }

    protected String getUpperSectionCode(SectionDtoInterface dto) {
        String[] sectionArray = this.sectionReference.getClassRouteArray(dto);
        int length = sectionArray.length;
        if (length == 0) {
            return "";
        }
        return sectionArray[--length];
    }
}

