/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.file.PositionImportBeanInterface;
import jp.mosp.platform.bean.system.impl.PositionRegistBean;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.dto.file.ImportFieldDtoInterface;
import jp.mosp.platform.dto.system.PositionDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class PositionImportBean
extends PositionRegistBean
implements PositionImportBeanInterface {
    protected List<PositionDtoInterface> positionList;

    public int importFile(ImportDtoInterface importDto, InputStream requestedFile) throws MospException {
        List dataList = this.getDataList(importDto, requestedFile);
        this.getTargetLists(importDto, dataList);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        for (int i = 0; i < this.positionList.size(); ++i) {
            this.registPositionDto((PositionDtoInterface)this.positionList.get(i));
        }
        return this.positionList.size();
    }

    protected void getTargetLists(ImportDtoInterface importDto, List<String[]> dataList) throws MospException {
        this.positionList = new ArrayList();
        List fieldList = this.getImportFieldList(importDto.getImportCode());
        this.checkCsvLength(fieldList, dataList);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (int i = 0; i < dataList.size(); ++i) {
            String[] data = dataList.get(i);
            PositionDtoInterface positionDto = this.getPositionDto(fieldList, data, i);
            if (positionDto == null) continue;
            this.positionList.add(positionDto);
        }
    }

    protected PositionDtoInterface getPositionDto(List<ImportFieldDtoInterface> fieldList, String[] data, int row) throws MospException {
        String positionCode = this.getFieldValue("position_code", fieldList, data);
        Date activateDate = this.getDateFieldValue("activate_date", fieldList, data);
        String positionName = this.getFieldValue("position_name", fieldList, data);
        String positionAbbr = this.getFieldValue("position_abbr", fieldList, data);
        int positionGrade = this.getIntegerFieldValue("position_grade", fieldList, data);
        String closeFlag = this.getFieldValue("close_flag", fieldList, data);
        if (MospUtility.isEmpty((String[])new String[]{positionCode})) {
            PfMessageUtility.addErrorRequired((MospParams)this.mospParams, (String)PfNameUtility.positionCode((MospParams)this.mospParams), (Integer)row);
            return null;
        }
        if (MospUtility.isEmpty((Object[])new Object[]{activateDate})) {
            PfMessageUtility.addErrorActivateDateRequired((MospParams)this.mospParams, (Integer)row);
            return null;
        }
        PositionDtoInterface position = this.dao.findForInfo(positionCode, activateDate);
        if (position == null) {
            position = this.getInitDto();
        }
        position.setPositionCode(positionCode);
        position.setActivateDate(activateDate);
        if (positionName != null) {
            position.setPositionName(positionName);
        } else if (position.getPositionName() == null) {
            PfMessageUtility.addErrorRequired((MospParams)this.mospParams, (String)PfNameUtility.positionName((MospParams)this.mospParams), (Integer)row);
            return null;
        }
        if (positionAbbr != null) {
            position.setPositionAbbr(positionAbbr);
        } else if (position.getPositionAbbr() == null) {
            PfMessageUtility.addErrorRequired((MospParams)this.mospParams, (String)PfNameUtility.positionAbbreviation((MospParams)this.mospParams), (Integer)row);
            return null;
        }
        position.setPositionGrade(positionGrade);
        position.setInactivateFlag(0);
        if (closeFlag != null && !closeFlag.isEmpty()) {
            try {
                position.setInactivateFlag(Integer.parseInt(closeFlag));
            }
            catch (NumberFormatException e) {
                PfMessageUtility.addErrorActivateOrInactivateInvalid((MospParams)this.mospParams, (Integer)row);
                return null;
            }
        }
        this.validate(position, Integer.valueOf(row));
        return position;
    }

    protected void registPositionDto(PositionDtoInterface position) throws MospException {
        if (position == null) {
            return;
        }
        List list = this.dao.findForHistory(position.getPositionCode());
        if (list.isEmpty()) {
            this.insert(position);
            return;
        }
        PositionDtoInterface dto = this.dao.findForKey(position.getPositionCode(), position.getActivateDate());
        if (dto == null) {
            this.add(position);
            return;
        }
        this.update(position);
    }
}

