/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.ViewConfigProperty;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.NameUtility;
import jp.mosp.platform.bean.file.HumanExportBeanInterface;
import jp.mosp.platform.bean.file.impl.BaseExportBean;
import jp.mosp.platform.bean.human.HumanArrayReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanHistoryReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanNormalReferenceBeanInterface;
import jp.mosp.platform.dao.human.EntranceDaoInterface;
import jp.mosp.platform.dao.human.RetirementDaoInterface;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;
import jp.mosp.platform.utils.PfNameUtility;

public class HumanExportBean
extends BaseExportBean
implements HumanExportBeanInterface {
    protected EntranceDaoInterface entranceDao;
    protected RetirementDaoInterface retirementDao;
    protected HumanNormalReferenceBeanInterface humanNoraml;
    protected HumanHistoryReferenceBeanInterface humanHistory;
    protected HumanArrayReferenceBeanInterface humanArray;
    protected List<HumanDtoInterface> humanList;

    public void initBean() throws MospException {
        super.initBean();
        this.entranceDao = (EntranceDaoInterface)this.createDaoInstance(EntranceDaoInterface.class);
        this.retirementDao = (RetirementDaoInterface)this.createDaoInstance(RetirementDaoInterface.class);
        this.humanNoraml = (HumanNormalReferenceBeanInterface)this.createBeanInstance(HumanNormalReferenceBeanInterface.class);
        this.humanHistory = (HumanHistoryReferenceBeanInterface)this.createBeanInstance(HumanHistoryReferenceBeanInterface.class);
        this.humanArray = (HumanArrayReferenceBeanInterface)this.createBeanInstance(HumanArrayReferenceBeanInterface.class);
    }

    protected List<String[]> makeCsvDataList(List<String> fieldList, Date targetDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        ArrayList<String[]> csvDataList = new ArrayList<String[]>();
        this.addHumanData(csvDataList, fieldList, targetDate, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        this.addEntranceData(csvDataList, fieldList);
        this.addRetirementData(csvDataList, fieldList);
        this.addHumanGeneralData(csvDataList, fieldList, targetDate);
        return csvDataList;
    }

    protected String[] getHeader(ExportDtoInterface exportDto, List<String> fieldList, Date targetDate) throws MospException {
        String codeKey = exportDto.getExportTable();
        String[] header = new String[fieldList.size()];
        int i = 0;
        for (String field : fieldList) {
            String headerName = NameUtility.getName((MospParams)this.mospParams, (String)field);
            if (!MospUtility.isEmpty((String[])new String[]{headerName})) {
                header[i++] = headerName;
                continue;
            }
            String[] fieldNames = MospUtility.split((String)field, (String)",");
            if (fieldNames.length > 1) {
                StringBuilder sb = new StringBuilder(NameUtility.getName((MospParams)this.mospParams, (String)fieldNames[1])).append(PfNameUtility.parentheses((MospParams)this.mospParams, (String)NameUtility.getName((MospParams)this.mospParams, (String)fieldNames[0])));
                header[i++] = sb.toString();
                continue;
            }
            header[i++] = this.getCodeName(field, codeKey);
        }
        return header;
    }

    protected void addHumanData(List<String[]> csvDataList, List<String> fieldList, Date targetDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        this.humanSearch.setTargetDate(targetDate);
        this.humanSearch.setWorkPlaceCode(workPlaceCode);
        this.humanSearch.setEmploymentContractCode(employmentContractCode);
        this.humanSearch.setSectionCode(sectionCode);
        this.humanSearch.setPositionCode(positionCode);
        this.humanSearch.setStateType("presence");
        this.humanSearch.setNeedLowerSection(true);
        this.humanSearch.setNeedConcurrent(true);
        this.humanSearch.setOperationType("1");
        this.humanList = this.humanSearch.search();
        for (HumanDtoInterface human : this.humanList) {
            String[] csvData = new String[fieldList.size()];
            int i = 0;
            for (String field : fieldList) {
                csvData[i++] = this.getHumanData(human, field, targetDate);
            }
            csvDataList.add(csvData);
        }
    }

    protected void addEntranceData(List<String[]> csvDataList, List<String> fieldList) throws MospException {
        int i;
        Integer entranceDateIndex = null;
        for (i = 0; i < fieldList.size(); ++i) {
            if (!MospUtility.isEqual((Object)fieldList.get(i), (Object)"entrance_date")) continue;
            entranceDateIndex = i;
            break;
        }
        if (entranceDateIndex == null) {
            return;
        }
        for (i = 0; i < this.humanList.size(); ++i) {
            HumanDtoInterface human = (HumanDtoInterface)this.humanList.get(i);
            EntranceDtoInterface entrance = this.entranceDao.findForInfo(human.getPersonalId());
            if (entrance == null) continue;
            String[] csvData = csvDataList.get(i);
            csvData[entranceDateIndex.intValue()] = this.getStringDate(entrance.getEntranceDate());
        }
    }

    protected void addRetirementData(List<String[]> csvDataList, List<String> fieldList) throws MospException {
        int i;
        Integer retirementDateIndex = null;
        Integer retirementReasonIndex = null;
        Integer retirementDetailIndex = null;
        for (i = 0; i < fieldList.size(); ++i) {
            String field = fieldList.get(i);
            if (MospUtility.isEqual((Object)field, (Object)"retirement_date")) {
                retirementDateIndex = i;
            }
            if (MospUtility.isEqual((Object)field, (Object)"retirement_reason")) {
                retirementReasonIndex = i;
            }
            if (!MospUtility.isEqual((Object)field, (Object)"retirement_detail")) continue;
            retirementDetailIndex = i;
        }
        if (retirementDateIndex == null && retirementReasonIndex == null && retirementDetailIndex == null) {
            return;
        }
        for (i = 0; i < this.humanList.size(); ++i) {
            HumanDtoInterface human = (HumanDtoInterface)this.humanList.get(i);
            RetirementDtoInterface retirement = this.retirementDao.findForInfo(human.getPersonalId());
            if (retirement == null) continue;
            String[] csvData = csvDataList.get(i);
            if (retirementDateIndex != null) {
                csvData[retirementDateIndex.intValue()] = this.getStringDate(retirement.getRetirementDate());
            }
            if (retirementReasonIndex != null) {
                csvData[retirementReasonIndex.intValue()] = retirement.getRetirementReason();
            }
            if (retirementDetailIndex == null) continue;
            csvData[retirementDetailIndex.intValue()] = retirement.getRetirementDetail();
        }
    }

    protected void addHumanGeneralData(List<String[]> csvDataList, List<String> fieldList, Date targetDate) throws MospException {
        for (int i = 0; i < fieldList.size(); ++i) {
            String field = fieldList.get(i);
            String[] fieldName = MospUtility.split((String)field, (String)",");
            ViewConfigProperty viewConfig = (ViewConfigProperty)this.mospParams.getProperties().getViewConfigProperties().get(fieldName[0]);
            if (viewConfig == null) continue;
            int index = i;
            for (int j = 0; j < this.humanList.size(); ++j) {
                HumanDtoInterface human = (HumanDtoInterface)this.humanList.get(j);
                String value = "";
                if (viewConfig.getType().equals("Normal")) {
                    value = this.humanNoraml.getNormalItemValue(fieldName[0], "HumanExport", human.getPersonalId(), targetDate, targetDate, fieldName[1], true);
                }
                if (viewConfig.getType().equals("History")) {
                    value = this.humanHistory.getHistoryItemValue(fieldName[0], "HumanExport", human.getPersonalId(), targetDate, fieldName[1], true);
                }
                if (viewConfig.getType().equals("Array")) {
                    value = this.humanArray.getArrayItemValue(fieldName[0], "HumanExport", human.getPersonalId(), targetDate, fieldName[1], true);
                }
                String[] csvData = csvDataList.get(j);
                csvData[index] = value;
            }
        }
    }

    public boolean isExistLikeFieldName(String exportCode, String[] aryFieldName) throws MospException {
        List list = this.exportFieldRefer.getLikeStartNameList(exportCode, aryFieldName);
        list = list == null ? new ArrayList() : list;
        return !list.isEmpty();
    }
}

