/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.file.ExportBeanInterface;
import jp.mosp.platform.bean.file.ExportFieldReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.bean.system.PlatformMasterBeanInterface;
import jp.mosp.platform.dao.file.ExportDaoInterface;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.PlatformUtility;

public abstract class BaseExportBean
extends PlatformBean
implements ExportBeanInterface {
    protected ExportDaoInterface exportDao;
    protected ExportFieldReferenceBeanInterface exportFieldRefer;
    protected HumanSearchBeanInterface humanSearch;
    protected PlatformMasterBeanInterface platformMaster;

    public void initBean() throws MospException {
        this.exportDao = (ExportDaoInterface)this.createDaoInstance(ExportDaoInterface.class);
        this.exportFieldRefer = (ExportFieldReferenceBeanInterface)this.createBeanInstance(ExportFieldReferenceBeanInterface.class);
        this.humanSearch = (HumanSearchBeanInterface)this.createBeanInstance(HumanSearchBeanInterface.class);
        this.platformMaster = (PlatformMasterBeanInterface)this.createBeanInstance(PlatformMasterBeanInterface.class);
    }

    public void export(String exportCode, Date targetDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        ExportDtoInterface exportDto = this.exportDao.findForKey(exportCode);
        if (exportDto == null) {
            PfMessageUtility.addErrorNoExportInfo((MospParams)this.mospParams);
            return;
        }
        List fieldList = this.exportFieldRefer.getExportFieldNameList(exportCode);
        List csvDataList = this.makeCsvDataList(fieldList, targetDate, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        if (csvDataList.isEmpty()) {
            PfMessageUtility.addErrorNoExportInfo((MospParams)this.mospParams);
            return;
        }
        this.addHeader(csvDataList, exportDto, fieldList, targetDate);
        this.mospParams.setFile((Object)OrangeSignalUtility.getOrangeSignalParams((List)csvDataList));
        this.setFileName(exportDto, targetDate);
    }

    protected List<String[]> makeCsvDataList(List<String> fieldList, Date targetDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        return Collections.emptyList();
    }

    protected void addHeader(List<String[]> csvDataList, ExportDtoInterface exportDto, List<String> fieldList, Date targetDate) throws MospException {
        if (MospUtility.isEqual((Object)exportDto.getHeader(), (Object)0)) {
            return;
        }
        csvDataList.add(0, this.getHeader(exportDto, fieldList, targetDate));
    }

    protected String[] getHeader(ExportDtoInterface exportDto, List<String> fieldList, Date targetDate) throws MospException {
        String codeKey = exportDto.getExportTable();
        String[] header = new String[fieldList.size()];
        int i = 0;
        for (String field : fieldList) {
            header[i++] = this.getCodeName(field, codeKey);
        }
        return header;
    }

    protected void setFileName(ExportDtoInterface dto, Date targetDate) {
        StringBuilder sb = new StringBuilder(dto.getExportCode());
        sb.append(PfNameUtility.hyphen((MospParams)this.mospParams));
        sb.append(DateUtility.getStringDateNoSeparator((Date)targetDate));
        sb.append(PlatformUtility.getFileExtension((ExportDtoInterface)dto));
        this.mospParams.setFileName(sb.toString());
    }

    protected List<HumanDtoInterface> searchHumanList(Date targetDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        this.humanSearch.setTargetDate(targetDate);
        this.humanSearch.setWorkPlaceCode(workPlaceCode);
        this.humanSearch.setEmploymentContractCode(employmentContractCode);
        this.humanSearch.setSectionCode(sectionCode);
        this.humanSearch.setPositionCode(positionCode);
        this.humanSearch.setStateType("presence");
        this.humanSearch.setNeedLowerSection(true);
        this.humanSearch.setNeedConcurrent(true);
        this.humanSearch.setOperationType("1");
        return this.humanSearch.search();
    }

    protected Map<String, HumanDtoInterface> searchHumanData(Date targetDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        return PlatformUtility.getPersonalIdDtoMap((Collection)this.searchHumanList(targetDate, workPlaceCode, employmentContractCode, sectionCode, positionCode));
    }

    protected void addHumanData(List<String[]> csvDataList, List<String> fieldList, List<HumanDtoInterface> humanList, Date targetDate) throws MospException {
        for (HumanDtoInterface human : humanList) {
            csvDataList.add(this.getHumanCsvData(fieldList, human, targetDate));
        }
    }

    protected String[] getHumanCsvData(List<String> fieldList, HumanDtoInterface human, Date targetDate) throws MospException {
        String[] csvData = new String[fieldList.size()];
        int i = 0;
        for (String field : fieldList) {
            csvData[i++] = this.getHumanData(human, field, targetDate);
        }
        return csvData;
    }

    protected String getHumanData(HumanDtoInterface human, String fieldName, Date targetDate) throws MospException {
        if (MospUtility.isEqual((Object)fieldName, (Object)"employee_code")) {
            return human.getEmployeeCode();
        }
        if (MospUtility.isEqual((Object)fieldName, (Object)"activate_date")) {
            return DateUtility.getStringDate((Date)human.getActivateDate());
        }
        if (MospUtility.isEqual((Object)fieldName, (Object)"last_name")) {
            return human.getLastName();
        }
        if (MospUtility.isEqual((Object)fieldName, (Object)"first_name")) {
            return human.getFirstName();
        }
        if (MospUtility.isEqual((Object)fieldName, (Object)"full_name")) {
            return MospUtility.getHumansName((String)human.getFirstName(), (String)human.getLastName());
        }
        if (MospUtility.isEqual((Object)fieldName, (Object)"last_kana")) {
            return human.getLastKana();
        }
        if (MospUtility.isEqual((Object)fieldName, (Object)"first_kana")) {
            return human.getFirstKana();
        }
        if (MospUtility.isEqual((Object)fieldName, (Object)"work_place_code")) {
            return human.getWorkPlaceCode();
        }
        if (MospUtility.isEqual((Object)fieldName, (Object)"employment_contract_code")) {
            return human.getEmploymentContractCode();
        }
        if (MospUtility.isEqual((Object)fieldName, (Object)"section_code")) {
            return human.getSectionCode();
        }
        if (MospUtility.isEqual((Object)fieldName, (Object)"position_code")) {
            return human.getPositionCode();
        }
        if (MospUtility.isEqual((Object)fieldName, (Object)"section_name")) {
            return this.platformMaster.getSectionName(human.getSectionCode(), targetDate);
        }
        if (MospUtility.isEqual((Object)fieldName, (Object)"section_display")) {
            return this.platformMaster.getSectionNameOrDisplay(human.getSectionCode(), targetDate, this.mospParams);
        }
        return "";
    }

    protected void setCsvValue(String[] csvData, List<String> fieldList, String fieldName, Object value) {
        PlatformUtility.setCsvValue((String[])csvData, fieldList, (String)fieldName, (Object)value);
    }
}

