/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.orangesignal.OrangeSignalParams;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.file.ImportFieldReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.dto.file.ImportFieldDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public abstract class PlatformFileBean
extends PlatformBean {
    protected List<String[]> getDataList(ImportDtoInterface importDto, InputStream requestedFile) throws MospException {
        ArrayList<String[]> dataList = new ArrayList();
        if (!importDto.getType().equals("1")) {
            PfMessageUtility.addErrorNoItem((MospParams)this.mospParams, (String)PfNameUtility.fileType((MospParams)this.mospParams));
            return dataList;
        }
        dataList = this.parse(requestedFile);
        if (importDto.getHeader() != 0 && dataList.size() > 0) {
            dataList.remove(0);
        }
        if (dataList.size() == 0) {
            PfMessageUtility.addErrorNoItem((MospParams)this.mospParams, (String)PfNameUtility.insertData((MospParams)this.mospParams));
        }
        return dataList;
    }

    protected void convertEmployeeCodeIntoPersonalId(List<ImportFieldDtoInterface> fieldList, List<String[]> dataList, String activateDateField, String activateDateName) throws MospException {
        Integer personalIdIndex = this.getFieldIndex("personal_id", fieldList);
        Integer activateDateIndex = this.getFieldIndex(activateDateField, fieldList);
        if (personalIdIndex == null || activateDateIndex == null) {
            return;
        }
        HumanReferenceBeanInterface refer = (HumanReferenceBeanInterface)this.createBeanInstance(HumanReferenceBeanInterface.class);
        for (int i = 0; i < dataList.size(); ++i) {
            String personalId;
            String[] data = dataList.get(i);
            String employeeCode = this.getFieldValue("personal_id", fieldList, data);
            Date activateDate = this.getDateFieldValue(activateDateField, fieldList, data);
            int row = i + 1;
            this.checkRequired((Object)employeeCode, PfNameUtility.employeeCode((MospParams)this.mospParams), Integer.valueOf(row));
            this.checkRequired((Object)activateDate, activateDateName, Integer.valueOf(row));
            if (employeeCode == null || employeeCode.isEmpty() || activateDate == null) continue;
            data[personalIdIndex.intValue()] = personalId = refer.getPersonalId(employeeCode, activateDate);
        }
    }

    protected void convertEmployeeCodeIntoPersonalId(List<ImportFieldDtoInterface> fieldList, List<String[]> dataList) throws MospException {
        this.convertEmployeeCodeIntoPersonalId(fieldList, dataList, "activate_date", PfNameUtility.activateDate((MospParams)this.mospParams));
    }

    protected List<String[]> parse(InputStream stream) throws MospException {
        return this.parse(stream, this.createOrangeSignalParams());
    }

    protected List<String[]> parse(InputStream stream, OrangeSignalParams orangeParams) throws MospException {
        List list = OrangeSignalUtility.parse((InputStream)stream, (OrangeSignalParams)orangeParams);
        return list;
    }

    protected OrangeSignalParams createOrangeSignalParams() {
        return new OrangeSignalParams();
    }

    protected List<ImportFieldDtoInterface> getImportFieldList(String importCode) throws MospException {
        ImportFieldReferenceBeanInterface refer = (ImportFieldReferenceBeanInterface)this.createBeanInstance(ImportFieldReferenceBeanInterface.class);
        return refer.getImportFieldList(importCode);
    }

    protected Integer getFieldIndex(String fieldName, List<ImportFieldDtoInterface> fieldList) {
        for (ImportFieldDtoInterface field : fieldList) {
            if (!field.getFieldName().equals(fieldName)) continue;
            return field.getFieldOrder() - 1;
        }
        return null;
    }

    protected boolean isFieldImported(String fieldName, List<ImportFieldDtoInterface> fieldList) {
        return this.getFieldIndex(fieldName, fieldList) != null;
    }

    protected String getFieldValue(String fieldName, List<ImportFieldDtoInterface> fieldList, String[] data) {
        Integer fieldIndex = this.getFieldIndex(fieldName, fieldList);
        if (fieldIndex == null) {
            return "";
        }
        return data[fieldIndex];
    }

    protected Date getDateFieldValue(String fieldName, List<ImportFieldDtoInterface> fieldList, String[] data) {
        String date = this.getFieldValue(fieldName, fieldList, data);
        return DateUtility.getVariousDate((String)date);
    }

    protected int getIntegerFieldValue(String fieldName, List<ImportFieldDtoInterface> fieldList, String[] data) {
        String strInteger = this.getFieldValue(fieldName, fieldList, data);
        return MospUtility.getInt((Object)strInteger);
    }

    protected void checkCsvLength(List<ImportFieldDtoInterface> fieldList, List<String[]> dataList) {
        for (int i = 0; i < dataList.size(); ++i) {
            if (dataList.get(i).length == fieldList.size()) continue;
            PfMessageUtility.addErrorCheckForm((MospParams)this.mospParams, (String)PfNameUtility.insertData((MospParams)this.mospParams), (Integer)i);
            break;
        }
    }

    protected void checkIntegerField(String fieldName, List<ImportFieldDtoInterface> fieldList, String[] data, String codeKey, Integer row) {
        String value = this.getFieldValue(fieldName, fieldList, data);
        String name = this.getCodeName(fieldName, codeKey);
        this.checkRequired((Object)value, name, row);
        this.checkTypeNumber(value, name, row);
    }
}

