/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.base;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseBean;
import jp.mosp.framework.base.BaseBeanInterface;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.instance.InstanceFactory;
import jp.mosp.framework.property.RangeProperty;
import jp.mosp.framework.utils.CapsuleUtility;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MessageUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.ValidateUtility;
import jp.mosp.platform.base.AdditionalLogicBeanInterface;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.dao.human.ConcurrentDaoInterface;
import jp.mosp.platform.dao.human.EntranceDaoInterface;
import jp.mosp.platform.dao.human.HumanDaoInterface;
import jp.mosp.platform.dto.human.ConcurrentDtoInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.InputCheckUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.PlatformUtility;

public abstract class PlatformBean
extends BaseBean {
    protected static final String SEPARATOR_DATA = ",";
    protected Map<String, List<AdditionalLogicBeanInterface>> additionalLogics;

    protected void checkExclusive(BaseDaoInterface dao, long id) throws MospException {
        this.checkExclusive((BaseDtoInterface)this.findForKey(dao, id, false));
    }

    protected void checkExclusive(BaseDtoInterface dto) throws MospException {
        if (dto == null || dto.getDeleteFlag() == 1) {
            PfMessageUtility.addErrorExclusive((MospParams)this.mospParams);
        }
    }

    protected void checkDuplicateInsert(List<?> list) {
        if (!list.isEmpty()) {
            PfMessageUtility.addErrorDuplicate((MospParams)this.mospParams);
        }
    }

    protected void checkDuplicateInsert(BaseDtoInterface dto) {
        if (dto != null) {
            PfMessageUtility.addErrorDuplicate((MospParams)this.mospParams);
        }
    }

    protected void checkDuplicateAdd(BaseDtoInterface dto) {
        if (dto != null) {
            PfMessageUtility.addErrorHistoryDuplicate((MospParams)this.mospParams);
        }
    }

    protected String[][] getNoObjectDataPulldown() {
        String[][] aryPulldown = new String[][]{{"", PfNameUtility.noTargetData((MospParams)this.mospParams)}};
        return aryPulldown;
    }

    protected Date getDateClone(Date date) {
        return CapsuleUtility.getDateClone((Date)date);
    }

    protected String[] getStringArrayClone(String[] array) {
        return CapsuleUtility.getStringArrayClone((String[])array);
    }

    protected String[][] getStringArrayClone(String[][] array) {
        return CapsuleUtility.getStringArrayClone((String[][])array);
    }

    protected void validateAryId(long[] aryId) {
        if (aryId == null || aryId.length == 0) {
            PfMessageUtility.addErrorRequireCheck((MospParams)this.mospParams);
        }
    }

    protected List<HumanDtoInterface> getHumanListForCheck(PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) throws MospException {
        HumanDaoInterface humanDao = (HumanDaoInterface)this.createDaoInstance(HumanDaoInterface.class);
        List humanList = humanDao.findForActivateDate(dto.getActivateDate());
        humanList.addAll(humanDao.findForTerm(dto.getActivateDate(), this.getNextActivateDate(dto.getActivateDate(), list)));
        return humanList;
    }

    protected List<ConcurrentDtoInterface> getConcurrentListForCheck(PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) throws MospException {
        ConcurrentDaoInterface concurrentDao = (ConcurrentDaoInterface)this.createDaoInstance(ConcurrentDaoInterface.class);
        List concurrentList = concurrentDao.findForTerm(dto.getActivateDate(), this.getNextActivateDate(dto.getActivateDate(), list));
        return concurrentList;
    }

    protected boolean needCheckTermForAdd(PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) {
        int idx;
        for (idx = 0; idx < list.size(); ++idx) {
            PlatformDtoInterface historyDto = list.get(idx);
            if (dto.getActivateDate().compareTo(historyDto.getActivateDate()) <= 0) break;
        }
        if (idx == 0) {
            return true;
        }
        return this.isDtoActivate((BaseDtoInterface)list.get(idx - 1));
    }

    protected boolean needCheckTermForDelete(PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) {
        for (int idx = 0; idx < list.size(); ++idx) {
            PlatformDtoInterface historyDto = list.get(idx);
            if (dto.getActivateDate().compareTo(historyDto.getActivateDate()) != 0) continue;
            if (idx == 0 || !this.isDtoActivate((BaseDtoInterface)list.get(idx - 1))) break;
            return false;
        }
        return true;
    }

    protected Date getEffectiveLastDate(Date targetDate, List<? extends PlatformDtoInterface> list) throws MospException {
        Date effectiveLastDate = this.getNextActivateDate(targetDate, list);
        if (effectiveLastDate != null) {
            effectiveLastDate = DateUtility.addDay((Date)effectiveLastDate, (int)-1);
        }
        return effectiveLastDate;
    }

    protected Date getNextActivateDate(Date targetDate, List<? extends PlatformDtoInterface> list) {
        Date lastDate = null;
        for (PlatformDtoInterface platformDtoInterface : list) {
            if (targetDate.compareTo(platformDtoInterface.getActivateDate()) >= 0) continue;
            lastDate = platformDtoInterface.getActivateDate();
            break;
        }
        return lastDate;
    }

    protected boolean isEntered(String personalId, Date targetDate) throws MospException {
        EntranceDaoInterface entranceDao = (EntranceDaoInterface)this.createDaoInstance(EntranceDaoInterface.class);
        EntranceDtoInterface dto = entranceDao.findForInfo(personalId);
        if (dto == null || dto.getEntranceDate() == null) {
            return false;
        }
        return targetDate.compareTo(dto.getEntranceDate()) >= 0;
    }

    protected HumanDtoInterface getHumanInfo(String personalId, Date targetDate) throws MospException {
        HumanDaoInterface dao = (HumanDaoInterface)this.createDaoInstance(HumanDaoInterface.class);
        return dao.findForInfo(personalId, targetDate);
    }

    protected HumanDtoInterface getUserHumanInfo(Date targetDate) throws MospException {
        if (targetDate == null) {
            targetDate = this.getSystemDate();
        }
        if (this.mospParams.getUser() == null) {
            return null;
        }
        String personalId = this.mospParams.getUser().getPersonalId();
        return this.getHumanInfo(personalId, targetDate);
    }

    protected String[] getRangeWorkPlace(String operationType, Date targetDate) throws MospException {
        if (operationType == null) {
            return new String[0];
        }
        RangeProperty range = (RangeProperty)this.mospParams.getStoredInfo().getRangeMap().get(operationType);
        if (range == null) {
            return new String[0];
        }
        String rangeWorkPlace = range.getWorkPlace();
        if (rangeWorkPlace == null || rangeWorkPlace.isEmpty()) {
            return new String[0];
        }
        String[] array = this.split(rangeWorkPlace, SEPARATOR_DATA);
        for (int i = 0; i < array.length; ++i) {
            HumanDtoInterface dto;
            if (!array[i].equals("RangeMyself") || (dto = this.getUserHumanInfo(targetDate)) == null || dto.getWorkPlaceCode().isEmpty()) continue;
            array[i] = dto.getWorkPlaceCode();
        }
        return array;
    }

    protected String[] getRangeEmploymentContract(String operationType, Date targetDate) throws MospException {
        if (operationType == null) {
            return new String[0];
        }
        RangeProperty range = (RangeProperty)this.mospParams.getStoredInfo().getRangeMap().get(operationType);
        if (range == null) {
            return new String[0];
        }
        String rangeEmployment = range.getEmploymentContract();
        if (rangeEmployment == null || rangeEmployment.isEmpty()) {
            return new String[0];
        }
        String[] array = this.split(rangeEmployment, SEPARATOR_DATA);
        for (int i = 0; i < array.length; ++i) {
            HumanDtoInterface dto;
            if (!array[i].equals("RangeMyself") || (dto = this.getUserHumanInfo(targetDate)) == null || dto.getEmploymentContractCode().isEmpty()) continue;
            array[i] = dto.getEmploymentContractCode();
        }
        return array;
    }

    protected String[] getRangeSection(String operationType, Date targetDate) throws MospException {
        if (operationType == null) {
            return new String[0];
        }
        RangeProperty range = (RangeProperty)this.mospParams.getStoredInfo().getRangeMap().get(operationType);
        if (range == null) {
            return new String[0];
        }
        String rangeSection = range.getSection();
        if (rangeSection == null || rangeSection.isEmpty()) {
            return new String[0];
        }
        String[] array = this.split(rangeSection, SEPARATOR_DATA);
        for (int i = 0; i < array.length; ++i) {
            HumanDtoInterface dto;
            if (!array[i].equals("RangeMyself") || (dto = this.getUserHumanInfo(targetDate)) == null || dto.getSectionCode().isEmpty()) continue;
            array[i] = dto.getSectionCode();
        }
        return array;
    }

    protected String[] getRangePosition(String operationType, Date targetDate) throws MospException {
        if (operationType == null) {
            return new String[0];
        }
        RangeProperty range = (RangeProperty)this.mospParams.getStoredInfo().getRangeMap().get(operationType);
        if (range == null) {
            return new String[0];
        }
        String rangePosition = range.getPosition();
        if (rangePosition == null || rangePosition.isEmpty()) {
            return new String[0];
        }
        String[] array = this.split(rangePosition, SEPARATOR_DATA);
        for (int i = 0; i < array.length; ++i) {
            HumanDtoInterface dto;
            if (!array[i].equals("RangeMyself") || (dto = this.getUserHumanInfo(targetDate)) == null || dto.getPositionCode().isEmpty()) continue;
            array[i] = dto.getPositionCode();
        }
        return array;
    }

    protected String[] getRangeEmployee(String operationType, Date targetDate) throws MospException {
        if (operationType == null) {
            return new String[0];
        }
        RangeProperty range = (RangeProperty)this.mospParams.getStoredInfo().getRangeMap().get(operationType);
        if (range == null) {
            return new String[0];
        }
        String rangeEmployee = range.getEmployee();
        if (rangeEmployee == null || rangeEmployee.isEmpty()) {
            return new String[0];
        }
        String[] array = this.split(rangeEmployee, SEPARATOR_DATA);
        for (int i = 0; i < array.length; ++i) {
            HumanDtoInterface dto;
            if (!array[i].equals("RangeMyself") || (dto = this.getUserHumanInfo(targetDate)) == null || dto.getPersonalId().isEmpty()) continue;
            array[i] = dto.getPersonalId();
        }
        return array;
    }

    protected boolean isDtoActivate(BaseDtoInterface dto) {
        return PlatformUtility.isDtoActivate((PlatformDtoInterface)((PlatformDtoInterface)dto));
    }

    protected boolean isDtoDeleted(BaseDtoInterface dto) {
        return dto.getDeleteFlag() == 1;
    }

    protected String getCodeName(String code, String[][] array) {
        return MospUtility.getCodeName((String)code, (String[][])array);
    }

    protected String getCodeName(String code, String codeKey) {
        String[][] array = this.mospParams.getProperties().getCodeArray(codeKey, false);
        return MospUtility.getCodeName((String)code, (String[][])array);
    }

    protected String getCodeName(int code, String codeKey) {
        return this.getCodeName(String.valueOf(code), codeKey);
    }

    protected boolean isSameDate(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date1 == null) {
            return false;
        }
        return date1.equals(date2);
    }

    protected Date getSystemDate() {
        return DateUtility.getSystemDate();
    }

    protected Date getSystemTime() {
        return DateUtility.getSystemTime();
    }

    protected Date getSystemTimeAndSecond() {
        return DateUtility.getSystemTimeAndSecond();
    }

    protected Date addDay(Date date, int amount) {
        return DateUtility.addDay((Date)date, (int)amount);
    }

    protected String getStringDate(Date date) {
        return DateUtility.getStringDate((Date)date);
    }

    protected boolean checkDateOrder(Date before, Date after, boolean acceptSameDate) {
        if (before == null || after == null) {
            return true;
        }
        if (acceptSameDate && before.equals(after)) {
            return true;
        }
        return before.before(after);
    }

    protected boolean checkTermDuplicate(Date start1, Date end1, Date start2, Date end2) {
        if (end1 == null && end2 == null) {
            return !start1.equals(start2);
        }
        if (end1 == null) {
            return start1.before(start2) || start1.after(end2);
        }
        if (end2 == null) {
            return start2.before(start1) || start2.after(end1);
        }
        return start1.before(end2) || end1.after(start2);
    }

    protected boolean isForwardMatch(String condition, String value) {
        return PlatformUtility.isForwardMatch((String)condition, (String)value);
    }

    protected boolean isBroadMatch(String condition, String value) {
        return PlatformUtility.isBroadMatch((String)condition, (String)value);
    }

    protected boolean isExactMatch(String condition, String value) {
        return PlatformUtility.isExactMatch((String)condition, (String)value);
    }

    protected boolean isHumanNameMatch(String condition, String firstName, String lastName) throws MospException {
        if (this.isBroadMatch(condition, firstName)) {
            return true;
        }
        if (this.isBroadMatch(condition, lastName)) {
            return true;
        }
        if (this.isBroadMatch(condition, lastName + firstName)) {
            return true;
        }
        return this.isBroadMatch(condition, MospUtility.getHumansName((String)firstName, (String)lastName));
    }

    public void sortList(List<?> list, Class<?> cls, boolean isReverse) throws MospException {
        this.sortList(list, cls.getName(), isReverse);
    }

    public void sortList(List<?> list, String className, boolean isReverse) throws MospException {
        Comparator comp = InstanceFactory.loadComparator((String)className);
        if (isReverse) {
            comp = Collections.reverseOrder(comp);
        }
        Collections.sort(list, comp);
    }

    protected String[][] prepareSelectArray(int length, boolean needBlank) {
        if (!needBlank) {
            return new String[length][2];
        }
        String[][] array = new String[length + 1][2];
        array[0][0] = "";
        array[0][1] = "";
        return array;
    }

    protected String getCodedName(String code, String name, int length) {
        int i;
        StringBuffer sb = new StringBuffer();
        int doubleBytes = (length - code.length() + 1) / 2;
        int singleBytes = (length - code.length() + 1) % 2;
        sb.append(code);
        for (i = 0; i < doubleBytes; ++i) {
            sb.append("\u3000");
        }
        for (i = 0; i < singleBytes; ++i) {
            sb.append(" ");
        }
        sb.append(name);
        return sb.toString();
    }

    protected List<String> asList(String target, String regex) {
        return MospUtility.asList((String[])this.split(target, regex));
    }

    protected String[] split(String target, String regex) {
        return MospUtility.split((String)target, (String)regex);
    }

    protected String toSeparatedString(List<String> list, String separator) {
        StringBuffer sb = new StringBuffer();
        for (String str : list) {
            sb.append(str);
            sb.append(separator);
        }
        if (sb.length() > 0) {
            sb.delete(sb.lastIndexOf(separator), sb.length());
        }
        return sb.toString();
    }

    protected String overlapValue(String values, String separator) {
        ArrayList<String> idList = new ArrayList<String>();
        for (String value : this.asList(values, separator)) {
            if (idList.contains(value)) continue;
            idList.add(value);
        }
        return this.toSeparatedString(idList, separator);
    }

    protected String issueSequenceNo(long sequenceNo, String format) {
        DecimalFormat decimalFormat = new DecimalFormat(format);
        return decimalFormat.format(sequenceNo);
    }

    protected Integer getInteger(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected Double getDouble(String value) {
        try {
            return new Double(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected void checkRequired(Object value, String fieldName, Integer row) {
        if (!ValidateUtility.chkRequired((Object)value)) {
            PfMessageUtility.addErrorRequired((MospParams)this.mospParams, (String)fieldName, (Integer)row);
        }
    }

    protected void checkInputLength(String value, int digit, String fieldName, Integer row) {
        if (!ValidateUtility.chkInputLength((String)value, (int)digit)) {
            PfMessageUtility.addErrorCheckDigit((MospParams)this.mospParams, (String)fieldName, (int)digit, (Integer)row);
        }
    }

    protected void checkInputLength(String value, int digit, String fieldName) {
        this.checkInputLength(value, digit, fieldName, null);
    }

    protected void checkLength(String value, int maxLength, String fieldName, Integer row) {
        if (!ValidateUtility.chkLength((String)value, (int)maxLength)) {
            PfMessageUtility.addErrorCheckMaxLength((MospParams)this.mospParams, (String)fieldName, (int)maxLength, (Integer)row);
        }
    }

    protected void checkLength(String value, int maxLength, String fieldName) {
        this.checkLength(value, maxLength, fieldName, null);
    }

    protected void checkLength(int value, int maxLength, String fieldName, Integer row) {
        this.checkLength(String.valueOf(value), maxLength, fieldName, row);
    }

    protected void checkLengthWithoutCarriageReturn(String value, int maxLength, String fieldName, Integer row) {
        this.checkLength(MospUtility.replaceAll((String)value, (String)"\r", (String)""), maxLength, fieldName, row);
    }

    protected void checkByteLength(String value, int maxLength, String fieldName, Integer row) {
        if (!ValidateUtility.chkByteLength((String)value, (int)maxLength)) {
            PfMessageUtility.addErrorCheckByteLength((MospParams)this.mospParams, (String)fieldName, (int)maxLength, (Integer)row);
        }
    }

    protected void checkMailAddress(String value, String fieldName, Integer row) {
        if (!ValidateUtility.chkRegex((String)"[!#-9A-~]+@+[A-Za-z0-9]+.+[^.]$", (String)value)) {
            PfMessageUtility.addErrorCheckAlpNumSign((MospParams)this.mospParams, (String)fieldName, (Integer)row);
        }
    }

    protected void checkUserId(String value, String fieldName, Integer row) {
        if (!ValidateUtility.chkRegex((String)"[._@A-Za-z0-9-]*", (String)value)) {
            PfMessageUtility.addErrorCheckAlpNumSign((MospParams)this.mospParams, (String)fieldName, (Integer)row);
        }
    }

    protected void checkTypeCode(String value, String fieldName, Integer row) {
        InputCheckUtility.checkTypeCodeGeneral((MospParams)this.mospParams, (String)value, (String)fieldName, (Integer)row);
    }

    protected void checkTypeNumber(String value, String fieldName, Integer row) {
        if (!ValidateUtility.chkRegex((String)"[0-9]*", (String)value)) {
            PfMessageUtility.addErrorCheckNumeric((MospParams)this.mospParams, (String)fieldName, (Integer)row);
        }
    }

    protected void checkTypeKana(String value, String fieldName, Integer row) {
        InputCheckUtility.checkTypeKanaGeneral((MospParams)this.mospParams, (String)value, (String)fieldName, (Integer)row);
    }

    protected void checkAvailableChars(String value, List<String> availables, String fieldName, Integer row) {
        if (!availables.contains(value)) {
            PfMessageUtility.addErrorAvailableChars((MospParams)this.mospParams, (String)fieldName, availables, (Integer)row);
        }
    }

    protected void checkAvailableInt(int value, int[] availables, String fieldName, Integer row) {
        if (!MospUtility.isContain((int)value, (int[])availables)) {
            PfMessageUtility.addErrorAvailableIntegers((MospParams)this.mospParams, (String)fieldName, (int[])availables, (Integer)row);
        }
    }

    protected void checkInactivateFlag(int value, Integer row) {
        if (value != 0 && value != 1) {
            PfMessageUtility.addErrorActivateOrInactivateInvalid((MospParams)this.mospParams, (Integer)row);
        }
    }

    protected void checkDeleteFlag(int value, Integer row) {
        if (value != 0 && value != 1) {
            PfMessageUtility.addErrorDeleteFlagInvalid((MospParams)this.mospParams, (Integer)row);
        }
    }

    protected void checkFlag(int value, String fieldName, Integer row) {
        if (!PlatformUtility.isFlagOff((int)value) && !PlatformUtility.isFlagOn((int)value)) {
            PfMessageUtility.addErrorFlagInvalid((MospParams)this.mospParams, (String)fieldName, (Integer)row);
        }
    }

    protected void checkUnderLimit(double value, String fieldName, int limit, Integer row) {
        if (value < (double)limit) {
            PfMessageUtility.addErrorUnderLimit((MospParams)this.mospParams, (String)fieldName, (int)limit, (Integer)row);
        }
    }

    protected void checkOverLimit(double value, String fieldName, int limit, Integer row) {
        if (value > (double)limit) {
            PfMessageUtility.addErrorOverLimit((MospParams)this.mospParams, (String)fieldName, (int)limit, (Integer)row);
        }
    }

    protected String getRowedFieldName(String fieldName, Integer row) {
        return MessageUtility.getRowedFieldName((MospParams)this.mospParams, (String)fieldName, (Integer)row);
    }

    protected int getPersonalIdsMaxIndex() {
        return this.mospParams.getApplicationProperty("PersonalIdsMaxIndex", 5000);
    }

    protected boolean doAdditionalLogic(Object ... objects) throws MospException {
        boolean isAdditionalLogicExecution = false;
        String codeKey = (String)PlatformUtility.castObject((Object)objects[0]);
        for (AdditionalLogicBeanInterface addonBean : this.getBeans(AdditionalLogicBeanInterface.class, codeKey)) {
            isAdditionalLogicExecution = addonBean.doAdditionalLogic(objects) || isAdditionalLogicExecution;
        }
        return isAdditionalLogicExecution;
    }

    protected boolean doStoredLogic(Object ... objects) throws MospException {
        boolean isAdditionalLogicExecution = false;
        String codeKey = (String)objects[0];
        for (AdditionalLogicBeanInterface addonBean : this.getStoredBeans(codeKey)) {
            isAdditionalLogicExecution = addonBean.doAdditionalLogic(objects) || isAdditionalLogicExecution;
        }
        return isAdditionalLogicExecution;
    }

    protected <T extends BaseBeanInterface> List<T> getBeans(Class<T> cls, String codeKey) throws MospException {
        ArrayList<BaseBeanInterface> addonBeans = new ArrayList<BaseBeanInterface>();
        for (String[] addon : this.mospParams.getProperties().getCodeArray(codeKey, false)) {
            String addonBean = addon[0];
            if (MospUtility.isEmpty((String[])new String[]{addonBean})) continue;
            BaseBeanInterface bean = this.createBean(cls, addonBean);
            addonBeans.add(bean);
        }
        return addonBeans;
    }

    protected List<AdditionalLogicBeanInterface> getStoredBeans(String codeKey) throws MospException {
        List list;
        if (this.additionalLogics == null) {
            this.additionalLogics = new HashMap();
        }
        if ((list = (List)this.additionalLogics.get(codeKey)) != null) {
            return list;
        }
        list = this.getBeans(AdditionalLogicBeanInterface.class, codeKey);
        this.additionalLogics.put(codeKey, list);
        return list;
    }
}

