/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.xml;

import java.util.Map;
import jp.mosp.framework.property.BaseProperty;
import jp.mosp.framework.property.CommandProperty;
import jp.mosp.framework.xml.NodeWrapper;
import jp.mosp.framework.xml.TagConverterInterface;
import jp.mosp.framework.xml.TagUtility;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ControllerTagConverter
implements TagConverterInterface {
    static final String ACTION_CLASS = "ActionClass";
    static final String TAG_NEED_SESSION = "NeedSession";
    static final String TAG_NEED_PROC_SEQ = "NeedProcSeq";
    static final String TAG_ACCEPT_METHOD = "AcceptMethod";

    public void put(Map<String, BaseProperty> properties, NodeWrapper wrapper) {
        Node node = wrapper.getNode();
        int index = wrapper.index;
        String path = wrapper.path;
        String key = TagUtility.getKey((Node)node);
        if (key.isEmpty()) {
            TagUtility.noElementKeyMessage((String)path, (Node)node, (int)index);
            return;
        }
        String actionClass = null;
        String needSession = null;
        String needProcSeq = null;
        String acceptMethod = null;
        NodeList list = node.getChildNodes();
        int length = list.getLength();
        for (int itemIndex = 0; itemIndex < length; ++itemIndex) {
            Node item = list.item(itemIndex);
            if (TagUtility.isTag((Node)item, (String)ACTION_CLASS)) {
                actionClass = TagUtility.trimText((Node)item);
            }
            if (TagUtility.isTag((Node)item, (String)TAG_NEED_SESSION)) {
                needSession = TagUtility.trimText((Node)item);
            }
            if (TagUtility.isTag((Node)item, (String)TAG_NEED_PROC_SEQ)) {
                needProcSeq = TagUtility.trimText((Node)item);
            }
            if (!TagUtility.isTag((Node)item, (String)TAG_ACCEPT_METHOD)) continue;
            acceptMethod = TagUtility.trimText((Node)item);
        }
        if (actionClass == null || actionClass.isEmpty()) {
            TagUtility.invalidMassage((String)path, (Node)node);
            return;
        }
        CommandProperty value = new CommandProperty(key, actionClass, needSession, needProcSeq, acceptMethod);
        properties.put(key, (BaseProperty)value);
    }
}

