/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.xml;

import java.util.Map;
import jp.mosp.framework.property.AddonProperty;
import jp.mosp.framework.property.BaseProperty;
import jp.mosp.framework.xml.NodeWrapper;
import jp.mosp.framework.xml.TagConverterInterface;
import jp.mosp.framework.xml.TagUtility;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AddonTagConverter
implements TagConverterInterface {
    private static final String TAG_ADDON_NAME = "AddonName";
    private static final String TAG_ADDON_VALID = "AddonValid";

    public void put(Map<String, BaseProperty> properties, NodeWrapper wrapper) {
        Node node = wrapper.getNode();
        int index = wrapper.index;
        String path = wrapper.path;
        String key = TagUtility.getKey((Node)node);
        if (key.isEmpty()) {
            TagUtility.noElementKeyMessage((String)path, (Node)node, (int)index);
            return;
        }
        String addonName = null;
        boolean addonValid = false;
        NodeList list = node.getChildNodes();
        int length = list.getLength();
        for (int itemIndex = 0; itemIndex < length; ++itemIndex) {
            Node item = list.item(itemIndex);
            if (TagUtility.isTag((Node)item, (String)TAG_ADDON_NAME)) {
                addonName = TagUtility.trimText((Node)item);
            }
            if (!TagUtility.isTag((Node)item, (String)TAG_ADDON_VALID)) continue;
            addonValid = Boolean.parseBoolean(TagUtility.trimText((Node)item));
        }
        properties.put(key, (BaseProperty)new AddonProperty(key, addonName, addonValid));
    }
}

