/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.utils;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.base.TopicPath;
import jp.mosp.framework.constant.MospConst;
import jp.mosp.framework.instance.InstanceFactory;
import jp.mosp.framework.property.AddonProperty;
import jp.mosp.framework.property.MessageProperty;
import jp.mosp.framework.property.ModelProperty;
import jp.mosp.framework.property.MospProperties;

/*
 * Exception performing whole class analysis ignored.
 */
public final class MospUtility {
    private static final String[] SUFFIX_ARRAY = new String[]{"BeanInterface", "Bean", "Interface"};
    public static final char CHR_SEPARATOR_SPACE = ' ';
    public static final String WILD_CARD_COMMAND = "*";
    public static final String CHARACTER_ENCODING = "UTF-8";

    private MospUtility() {
    }

    public static String getModelClass(String modelKey, MospProperties mospProperties, Date targetDate) throws MospException {
        Map modelProperties = mospProperties.getModelProperties();
        ModelProperty modelProperty = (ModelProperty)modelProperties.get(modelKey);
        if (modelProperty == null) {
            throw new MospException((Throwable)new Exception(), "FWE9104", modelKey);
        }
        if (targetDate == null) {
            return modelProperty.getModelClass();
        }
        Map modelClassMap = modelProperty.getModelClassMap();
        ArrayList keyList = new ArrayList(modelClassMap.keySet());
        Collections.sort(keyList);
        Collections.reverse(keyList);
        for (Date key : keyList) {
            if (key.after(targetDate)) continue;
            return (String)modelClassMap.get(key);
        }
        return modelProperty.getModelClass();
    }

    public static String getModelClass(Class<?> cls, MospProperties mospProperties, Date targetDate) throws MospException {
        String modelKey = MospUtility.getModelKey(cls);
        return MospUtility.getModelClass((String)modelKey, (MospProperties)mospProperties, (Date)targetDate);
    }

    public static String getModelKey(Class<?> cls) {
        String key = cls.getSimpleName();
        for (String suffix : SUFFIX_ARRAY) {
            if (key.indexOf(suffix) != key.length() - suffix.length()) continue;
            key = key.replace(suffix, "");
            break;
        }
        return key;
    }

    public static <T> T createObject(Class<?> cls, MospParams mospParams) throws MospException {
        return (T)InstanceFactory.loadGeneralInstance(cls, (MospParams)mospParams);
    }

    public static void outputMessageJs(MospProperties mospProperties) throws MospException {
        String path = mospProperties.getApplicationProperty("Docbase") + "/pub/common/js/message.js";
        String name = "messages";
        Map messageProperties = mospProperties.getMessageProperties();
        StringBuffer sb = new StringBuffer();
        sb.append("var ");
        sb.append("messages");
        sb.append(" = new Object();");
        sb.append(MospConst.LINE_SEPARATOR);
        for (Map.Entry entry : messageProperties.entrySet()) {
            MessageProperty messageProperty = (MessageProperty)entry.getValue();
            if (!messageProperty.getClientAvailable()) continue;
            sb.append("messages");
            sb.append("[\"");
            sb.append(messageProperty.getKey());
            sb.append("\"] = \"");
            sb.append(messageProperty.getMessageBody());
            sb.append("\";");
            sb.append(MospConst.LINE_SEPARATOR);
        }
        MospUtility.outputFile((MospProperties)mospProperties, (String)path, (String)sb.toString());
    }

    public static String getCodeItemCode(String code, String[][] array) {
        if (code == null) {
            return "";
        }
        for (String[] element : array) {
            if (!element[0].equals(code)) continue;
            return element[0];
        }
        return code;
    }

    public static String getCodeName(String code, String[][] array) {
        if (code == null) {
            return "";
        }
        for (String[] element : array) {
            if (!element[0].equals(code)) continue;
            return element[1];
        }
        return code;
    }

    public static String[][] getCodeArray(MospParams mospParams, String codeKey, boolean needBlank) {
        return mospParams.getProperties().getCodeArray(codeKey, needBlank);
    }

    public static String getCodeName(MospParams mospParams, String code, String codeKey) {
        return MospUtility.getCodeName((String)code, (String[][])MospUtility.getCodeArray((MospParams)mospParams, (String)codeKey, (boolean)false));
    }

    public static String getCodeName(MospParams mospParams, int code, String codeKey) {
        return MospUtility.getCodeName((MospParams)mospParams, (String)String.valueOf(code), (String)codeKey);
    }

    public static boolean isCodeExist(String code, String[][] array) {
        if (code == null) {
            return false;
        }
        for (String[] element : array) {
            if (!element[0].equals(code)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getCodeList(MospParams mospParams, String codeKey, boolean needBlank) {
        String[][] codeArray;
        ArrayList<String> list = new ArrayList<String>();
        for (String[] array : codeArray = MospUtility.getCodeArray((MospParams)mospParams, (String)codeKey, (boolean)needBlank)) {
            list.add(array[0]);
        }
        return list;
    }

    public static Map<String, String> getCodeMap(MospParams mospParams, String codeKey) {
        return MospUtility.asMap((String[][])MospUtility.getCodeArray((MospParams)mospParams, (String)codeKey, (boolean)false));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void outputFile(MospProperties mospProperties, String path, String body) throws MospException {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        try {
            fos = new FileOutputStream(path, false);
            osw = new OutputStreamWriter((OutputStream)fos, mospProperties.getApplicationProperty("CharacterEncoding"));
            osw.write(body);
            return;
        }
        catch (FileNotFoundException e) {
            throw new MospException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new MospException((Throwable)e);
        }
        catch (IOException e) {
            throw new MospException((Throwable)e);
        }
        finally {
            try {
                if (osw != null) {
                    osw.close();
                }
            }
            catch (IOException e) {
                throw new MospException((Throwable)e);
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    throw new MospException((Throwable)e);
                }
            }
        }
    }

    public static String getLoginPersonalId(MospParams mospParams) {
        if (mospParams.getUser() == null) {
            return "";
        }
        String personalId = mospParams.getUser().getPersonalId();
        if (MospUtility.isEmpty((String[])new String[]{personalId})) {
            return "";
        }
        return personalId;
    }

    public static String getTopicPathName(MospParams mospParams) {
        TopicPath topicPath = (TopicPath)MospUtility.getLastValue((Collection)mospParams.getTopicPathList());
        if (topicPath == null) {
            return "";
        }
        String name = topicPath.getName();
        if (MospUtility.isEmpty((String[])new String[]{name})) {
            return "";
        }
        return name;
    }

    public static <T> boolean isTheVo(MospParams mospParams, Class<T> cls) {
        if (cls == null) {
            return false;
        }
        return cls.isInstance(mospParams.getVo());
    }

    public static String getHumansName(String firstName, String lastName) {
        return MospUtility.concat((String[])new String[]{lastName, firstName});
    }

    public static String getWildCardCommand(String command) {
        String wildCardCommand = command.replaceAll("\\*", "");
        if (wildCardCommand.isEmpty()) {
            return wildCardCommand;
        }
        return wildCardCommand.substring(0, wildCardCommand.length() - 1) + "*";
    }

    public static boolean isAddonValid(MospParams mospParams, String addonKey) {
        AddonProperty addon = (AddonProperty)mospParams.getProperties().getAddonProperties().get(addonKey);
        if (addon == null) {
            return false;
        }
        return addon.isAddonValid();
    }

    public static boolean isContentTypeContain(MospParams mospParams, String contentType) {
        String requestType = (String)mospParams.getGeneralParam("CONTENT-TYPE");
        return MospUtility.isContain((String)requestType, (String)contentType);
    }

    public static String concat(String ... strs) {
        return MospUtility.concat((Object)Character.valueOf(' '), (String[])strs);
    }

    public static String concat(Object separator, String ... strs) {
        StringBuilder concatted = new StringBuilder();
        MospUtility.concat((Object)separator, (StringBuilder)concatted, (String[])strs);
        return concatted.toString();
    }

    public static void concat(StringBuilder concatted, String ... strs) {
        MospUtility.concat((Object)Character.valueOf(' '), (StringBuilder)concatted, (String[])strs);
    }

    public static void concat(Object separator, StringBuilder concatted, String ... strs) {
        if (MospUtility.isEmpty((Object[])new Object[]{concatted, strs})) {
            return;
        }
        for (String str : strs) {
            if (str == null || str.isEmpty()) continue;
            if (concatted.length() != 0) {
                concatted.append(separator);
            }
            concatted.append(str);
        }
    }

    public static String[] split(String target, String regex) {
        if (target == null || target.trim().isEmpty()) {
            return new String[0];
        }
        String[] array = target.split(regex);
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i].trim();
        }
        return array;
    }

    public static String replaceAll(String value, String regex, String replacement) {
        if (MospUtility.isEmpty((String[])new String[]{regex}) || replacement == null) {
            return MospUtility.getString((Object)value);
        }
        return MospUtility.getString((Object)value).replaceAll(regex, replacement);
    }

    public static List<String> asList(String target, String regex) {
        return MospUtility.asList((String[])MospUtility.split((String)target, (String)regex));
    }

    public static List<String> asList(String[] array) {
        return new ArrayList<String>(Arrays.asList(array));
    }

    public static List<Long> asList(long[] array) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (long value : array) {
            list.add(value);
        }
        return list;
    }

    public static List<String[]> asList(String[][] array) {
        return Arrays.asList(array);
    }

    public static String[] toArray(Collection<String> collection) {
        return collection.toArray(new String[collection.size()]);
    }

    public static String[] toArray(String ... strs) {
        return strs;
    }

    public static String[][] toArrayArray(List<String[]> list) {
        return (String[][])list.toArray((T[])new String[list.size()][]);
    }

    public static int[] toArrayInt(List<Integer> values) {
        int[] array = new int[values.size()];
        if (MospUtility.isEmpty(values)) {
            return array;
        }
        for (int i = 0; i < values.size(); ++i) {
            array[i] = MospUtility.getInt((Object)values.get(i));
        }
        return array;
    }

    public static long[] toArrayLong(List<Long> list) {
        long[] array = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public static Map<String, String> asMap(String[][] arrays) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String[] array : arrays) {
            map.put(array[0], array[1]);
        }
        return map;
    }

    public static String[][] toArray(Map<String, String> map) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String[] array = new String[]{entry.getKey(), entry.getValue()};
            list.add(array);
        }
        return MospUtility.toArrayArray(list);
    }

    public static String toSeparatedString(String[] array, String separator) {
        StringBuilder sb = new StringBuilder();
        for (String str : array) {
            sb.append(str);
            sb.append(separator);
        }
        if (sb.length() > 0) {
            sb.delete(sb.lastIndexOf(separator), sb.length());
        }
        return sb.toString();
    }

    public static String toSeparatedString(int[] array, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int value : array) {
            sb.append(value);
            sb.append(separator);
        }
        if (sb.length() > 0) {
            sb.delete(sb.lastIndexOf(separator), sb.length());
        }
        return sb.toString();
    }

    public static String toSeparatedString(Collection<String> collection, String separator) {
        String[] array = MospUtility.toArray(new ArrayList<String>(collection));
        return MospUtility.toSeparatedString((String[])array, (String)separator);
    }

    public static String substring(String value, int length) {
        if (value == null || value.isEmpty() || length < 0) {
            return "";
        }
        if (value.length() < length) {
            return value;
        }
        return value.substring(0, length);
    }

    public static void deleteLastChar(StringBuilder sb) {
        if (MospUtility.isEmpty((Object[])new Object[]{sb}) || sb.length() == 0) {
            return;
        }
        sb.deleteCharAt(sb.length() - 1);
    }

    public static void removeEmpty(Collection<String> collection) {
        if (MospUtility.isEmpty(collection)) {
            return;
        }
        HashSet<String> set = new HashSet<String>();
        set.add(null);
        set.add("");
        collection.removeAll(set);
    }

    public static boolean isEmpty(String ... strs) {
        for (String str : strs) {
            if (str != null && !str.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(String ... strs) {
        for (String str : strs) {
            if (MospUtility.isEmpty((String[])new String[]{str})) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(Object ... objects) {
        for (Object obj : objects) {
            if (obj != null) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(long[] longs) {
        return longs == null || longs.length == 0;
    }

    public static boolean isContain(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.contains(str2);
    }

    public static boolean isContain(int target, int ... values) {
        for (int value : values) {
            if (target != value) continue;
            return true;
        }
        return false;
    }

    public static boolean isEqual(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static int compare(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return 0;
        }
        if (date1 == null) {
            return -1;
        }
        if (date2 == null) {
            return 1;
        }
        return date1.compareTo(date2);
    }

    public static int compare(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return 0;
        }
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        return str1.compareTo(str2);
    }

    public static int compare(double num1, double num2) {
        return new BigDecimal(num1).compareTo(new BigDecimal(num2));
    }

    public static String getString(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public static <C, T extends C> List<T> getSortList(Collection<T> collection, Class<? extends Comparator<C>> cls, boolean isDesc) throws MospException {
        ArrayList<T> list = new ArrayList<T>();
        if (MospUtility.isEmpty(collection)) {
            return list;
        }
        list.addAll(collection);
        Comparator comp = (Comparator)InstanceFactory.getNewInstance(cls);
        if (isDesc) {
            comp = comp.reversed();
        }
        Collections.sort(list, comp);
        return list;
    }

    public static <T> T getFirstValue(Collection<T> collection) {
        if (MospUtility.isEmpty(collection)) {
            return null;
        }
        return collection.iterator().next();
    }

    public static <C, T extends C> T getFirstValue(Collection<T> collection, Class<? extends Comparator<C>> cls, boolean isDesc) throws MospException {
        return (T)MospUtility.getFirstValue((Collection)MospUtility.getSortList(collection, cls, (boolean)isDesc));
    }

    public static <T> T getLastValue(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        T value2 = null;
        for (T value2 : collection) {
        }
        return value2;
    }

    public static String getFirstString(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        return collection.iterator().next();
    }

    public static String getListValue(List<String> list, int idx) {
        if (list == null || list.size() <= idx) {
            return "";
        }
        return list.get(idx);
    }

    public static boolean isIndexValid(int idx, String[] array) {
        if (array == null) {
            return false;
        }
        if (!MospUtility.isIndexValid((int)idx)) {
            return false;
        }
        return idx < array.length;
    }

    public static boolean isIndexValid(int idx) {
        return idx >= 0;
    }

    public static <T> T castObject(Object obj) {
        Object castObject = obj;
        return (T)castObject;
    }

    public static <K, V, C extends Collection<V>> C getValue(Map<K, C> map, K key, Class<?> cls) throws MospException {
        Collection value = (Collection)map.get(key);
        if (value == null) {
            value = (Collection)MospUtility.castObject((Object)InstanceFactory.getNewInstance(cls));
            map.put(key, value);
        }
        return (C)value;
    }

    public static <K, V, C> Map<V, C> getMapValue(Map<K, Map<V, C>> map, K key, Class<?> cls) throws MospException {
        Map value = map.get(key);
        if (value == null) {
            value = (Map)MospUtility.castObject((Object)InstanceFactory.getNewInstance(cls));
            map.put(key, value);
        }
        return value;
    }

    public static <K, V> List<V> getListValue(Map<K, List<V>> map, K key) throws MospException {
        return (List)MospUtility.castObject((Object)MospUtility.getValue(map, key, ArrayList.class));
    }

    public static <T> T getValue(Map<String, Object> map, String key) {
        if (MospUtility.isEmpty(map)) {
            return null;
        }
        return (T)map.get(key);
    }

    public static int getIntValue(Map<String, Object> map, String key) {
        return MospUtility.getInt((Object)MospUtility.getValue(map, (String)key));
    }

    public static <K> void addIntValue(Map<K, Integer> map, K key, int value) {
        int current = MospUtility.getInt((Object)map.get(key));
        map.put(key, current + value);
    }

    public static void addValue(Map<String, Object> params, String key, int value) {
        int current = MospUtility.getInt((Object)MospUtility.getValue(params, (String)key));
        params.put(key, current + value);
    }

    public static <T> void addValue(Collection<T> collection, T value) {
        if (MospUtility.isEmpty((Object[])new Object[]{collection, value})) {
            return;
        }
        collection.add(value);
    }

    public static int getInt(Object value) {
        try {
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Float) {
                return ((Float)value).intValue();
            }
            if (value instanceof Double) {
                return ((Double)value).intValue();
            }
            return 0;
        }
        catch (Throwable e) {
            return 0;
        }
    }

    public static float getFloat(Object value) {
        try {
            if (value instanceof String) {
                return Float.parseFloat((String)value);
            }
            if (value instanceof Integer) {
                return ((Integer)value).floatValue();
            }
            if (value instanceof Float) {
                return ((Float)value).floatValue();
            }
            if (value instanceof Double) {
                return ((Double)value).floatValue();
            }
            return 0.0f;
        }
        catch (Throwable e) {
            return 0.0f;
        }
    }

    public static double getDouble(Object value) {
        try {
            if (value instanceof String) {
                return Double.parseDouble((String)value);
            }
            if (value instanceof Integer) {
                return ((Integer)value).doubleValue();
            }
            if (value instanceof Float) {
                return ((Float)value).doubleValue();
            }
            if (value instanceof Double) {
                return (Double)value;
            }
            return 0.0;
        }
        catch (Throwable e) {
            return 0.0;
        }
    }

    public static boolean isChecked(int value) {
        return value == Integer.parseInt("1");
    }

    public static boolean isChecked(String value) {
        return MospUtility.isEqual((Object)value, (Object)"1");
    }

    public static String getStackTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        String msg = sw.toString();
        msg = msg.replaceAll(MospConst.LINE_SEPARATOR, "");
        return msg;
    }

    public static byte[] getBytes(String value) {
        if (value == null || value.isEmpty()) {
            return new byte[0];
        }
        try {
            return value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    public static String newString(byte[] value) {
        if (value == null || value.length == 0) {
            return "";
        }
        try {
            return new String(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static int getIntOrZero(int value) {
        return value < 0 ? 0 : value;
    }

    public static double divide(double value, double divisor, int scale, int roundingMode) {
        BigDecimal bd = BigDecimal.valueOf(value);
        return bd.divide(BigDecimal.valueOf(divisor), scale, roundingMode).doubleValue();
    }

    public static int divide(int value, int divisor) {
        if (divisor == 0) {
            return value;
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        return bd.divideToIntegralValue(BigDecimal.valueOf(divisor)).intValue();
    }

    public static int remainder(int value, int divisor) {
        if (divisor == 0) {
            return value;
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        return bd.remainder(BigDecimal.valueOf(divisor)).intValue();
    }

    public static int getMaxValue(int ... values) {
        int maxValue = Integer.MIN_VALUE;
        for (int value : values) {
            maxValue = Math.max(maxValue, value);
        }
        return maxValue;
    }

    public static int getMinValue(int ... values) {
        int minValue = Integer.MAX_VALUE;
        for (int value : values) {
            minValue = Math.min(minValue, value);
        }
        return minValue;
    }

    public static int getMaxValue(Collection<Integer> values) {
        if (MospUtility.isEmpty(values)) {
            return Integer.MIN_VALUE;
        }
        return MospUtility.getMaxValue((int[])MospUtility.toArrayInt(new ArrayList<Integer>(values)));
    }

    public static int getMinValue(Collection<Integer> values) {
        if (MospUtility.isEmpty(values)) {
            return Integer.MAX_VALUE;
        }
        return MospUtility.getMinValue((int[])MospUtility.toArrayInt(new ArrayList<Integer>(values)));
    }

    public static <K> Set<K> getKeysHaveMaxValue(Map<K, Integer> map) {
        TreeSet<K> keys = new TreeSet<K>();
        if (MospUtility.isEmpty(map)) {
            return keys;
        }
        int maxValue = MospUtility.getMaxValue(map.values());
        for (Map.Entry<K, Integer> entry : map.entrySet()) {
            if (maxValue != MospUtility.getInt((Object)entry.getValue())) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    public static String addString(String appended, String value, boolean isHead) {
        if (MospUtility.isContain((String)appended, (String)value)) {
            return appended;
        }
        StringBuilder sb = new StringBuilder();
        if (!MospUtility.isEmpty((String[])new String[]{appended})) {
            sb.append(appended);
        }
        MospUtility.addString((StringBuilder)sb, (String)value, (boolean)isHead);
        return sb.toString();
    }

    public static void addString(StringBuilder sb, String value, boolean isHead) {
        if (MospUtility.isEmpty((Object[])new Object[]{sb, value})) {
            return;
        }
        if (isHead) {
            sb.insert(0, value);
            return;
        }
        sb.append(value);
    }
}

