/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.utils;

import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.base.TopicPath;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.NameUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class HtmlUtility {
    public static final int COUNT_PAGE_BUTTON = 10;
    public static final int COUNT_ERROR_MESSAGE = 10;
    public static final String JS_ARY_MENU = "ARY_MENU";
    public static final String TAG_BR = "<br />";

    private HtmlUtility() {
    }

    public static String getSelectOption(String[][] array, String value) {
        return HtmlUtility.getSelectOption((String[][])array, (String)value, (boolean)false);
    }

    public static String getSelectOption(String[][] array, String value, boolean isAppend) {
        StringBuilder sb = new StringBuilder();
        for (String[] element : array) {
            String selected = "";
            if (MospUtility.isEqual((Object)element[0], (Object)value)) {
                selected = " selected=\"selected\"";
            }
            sb.append("<option value=\"");
            sb.append(HtmlUtility.escapeHTML((String)element[0]));
            sb.append("\"");
            sb.append(selected);
            sb.append(">");
            sb.append(HtmlUtility.escapeHTML((String)element[1]));
            sb.append("</option>");
        }
        if (isAppend && !MospUtility.isCodeExist((String)value, (String[][])array)) {
            sb.append("<option value=\"");
            sb.append(HtmlUtility.escapeHTML((String)value));
            sb.append("\" selected=\"selected\">");
            sb.append(HtmlUtility.escapeHTML((String)value));
            sb.append("</option>");
        }
        return sb.toString();
    }

    public static String getSelectOption(MospParams mospParams, String codeKey, String value, boolean needBlank) {
        String[][] array = mospParams.getProperties().getCodeArray(codeKey, needBlank);
        return HtmlUtility.getSelectOption((String[][])array, (String)value);
    }

    public static String getRadioButonInput(MospParams mospParams, String cls, String name, String codeKey, String value) {
        String[][] array = mospParams.getProperties().getCodeArray(codeKey, false);
        return HtmlUtility.getRadioButonInput((String)cls, (String)name, (String[][])array, (String)value);
    }

    public static String getRadioButonInput(String cls, String name, String[][] array, String value) {
        StringBuffer sb = new StringBuffer();
        if (array == null) {
            return sb.toString();
        }
        for (String[] element : array) {
            String checked = "";
            if (element[0].equals(value)) {
                checked = "checked=\"checked\"";
            }
            sb.append("<label>");
            sb.append("<input type=\"radio\" ");
            if (cls != null && !cls.isEmpty()) {
                sb.append("class=\"" + cls + "\" ");
            }
            if (name != null && !name.isEmpty()) {
                sb.append("name=\"" + name + "\" ");
            }
            sb.append("value=\"" + HtmlUtility.escapeHTML((String)element[0]) + "\"" + HtmlUtility.escapeHTML((String)checked) + "\" />");
            sb.append(HtmlUtility.escapeHTML((String)element[1]));
            sb.append("</label>");
        }
        return sb.toString();
    }

    public static String getRadioTag(MospParams mospParams, String cls, String name, String value, String selected, boolean isLabel) {
        StringBuilder sb = new StringBuilder();
        boolean isChecked = HtmlUtility.isChecked((String)value, (String[])new String[]{selected});
        if (isLabel) {
            sb.append("<span>");
            sb.append(HtmlUtility.escapeHTML((String)(isChecked ? NameUtility.selected((MospParams)mospParams) : "")));
            sb.append("</span>");
            return sb.toString();
        }
        sb.append("<input type=\"radio\" ");
        if (!MospUtility.isEmpty((String[])new String[]{cls})) {
            sb.append("class=\"" + cls + "\" ");
        }
        if (!MospUtility.isEmpty((String[])new String[]{name})) {
            sb.append("name=\"" + name + "\" ");
        }
        sb.append("value=\"" + HtmlUtility.escapeHTML((String)value) + "\" ");
        sb.append(HtmlUtility.getChecked((boolean)isChecked));
        sb.append(" />");
        return sb.toString();
    }

    public static String getRequiredMark() {
        return "<span class=\"RequiredLabel\">*&nbsp;</span>";
    }

    public static String escapeHTML(String aStr) {
        String strTarget = aStr != null ? aStr : "";
        StringBuffer returnStr = new StringBuffer();
        int length = strTarget.length();
        for (int i = 0; i < length; ++i) {
            char c = strTarget.charAt(i);
            returnStr = c == '<' ? returnStr.append("&lt;") : (c == '>' ? returnStr.append("&gt;") : (c == '&' ? returnStr.append("&amp;") : (c == '\"' ? returnStr.append("&quot;") : (c == '\'' ? returnStr.append("&#39;") : returnStr.append(c)))));
        }
        return new String(returnStr);
    }

    public static String lineFeedToBrTag(String value) {
        return MospUtility.replaceAll((String)value, (String)"\n", (String)"<br />");
    }

    public static String getButtonTag(String cls, String id, String onClick, String name, boolean isDisabled) {
        StringBuffer sb = new StringBuffer();
        sb.append("<button type=\"button\" ");
        if (!MospUtility.isEmpty((String[])new String[]{cls})) {
            sb.append("class=\"");
            sb.append(cls);
            sb.append("\"");
        }
        if (!MospUtility.isEmpty((String[])new String[]{id})) {
            sb.append("id=\"");
            sb.append(id);
            sb.append("\"");
        }
        sb.append(" onclick=\"");
        sb.append(onClick);
        sb.append("\"");
        if (isDisabled) {
            sb.append(" disabled");
        }
        sb.append(">");
        sb.append(HtmlUtility.escapeHTML((String)name));
        sb.append("</button>");
        return sb.toString();
    }

    public static String getButtonTag(String id, String cmd, String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("<button type=\"button\" ");
        if (id.length() != 0) {
            sb.append("id=\"");
            sb.append(id);
            sb.append("\"");
        }
        sb.append(" onclick=\"doSubmit(document.form, '");
        sb.append(cmd);
        sb.append("')\">");
        sb.append(HtmlUtility.escapeHTML((String)name));
        sb.append("</button>");
        return sb.toString();
    }

    public static String getBackButtonTag(MospParams mospParams, String checkTarget, String extraFunc) {
        List topicPathList = mospParams.getTopicPathList();
        if (topicPathList.size() <= 2) {
            return "";
        }
        TopicPath topicPath = (TopicPath)topicPathList.get(topicPathList.size() - 2);
        String cmd = topicPath.getCommand();
        String name = topicPath.getName();
        StringBuffer sb = new StringBuffer();
        sb.append("<button type=\"button\" style=\"width: auto;\"");
        sb.append(" onclick=\"submitTransfer(event, ");
        if (checkTarget == null) {
            sb.append("null");
        } else {
            sb.append("'").append(checkTarget).append("'");
        }
        sb.append(", ");
        if (extraFunc == null) {
            sb.append("null");
        } else {
            sb.append(extraFunc);
        }
        sb.append(", null, '");
        sb.append(cmd);
        sb.append("')\">");
        sb.append(HtmlUtility.escapeHTML((String)name)).append(NameUtility.to((MospParams)mospParams));
        sb.append("</button>");
        return sb.toString();
    }

    public static String getTextboxTag(String cls, String id, String name, String value, boolean isLabel) {
        StringBuffer sb = new StringBuffer();
        if (isLabel) {
            sb.append("<span ");
            if (id != null && !id.isEmpty()) {
                sb.append("id=\"" + id + "\"");
            }
            sb.append(">");
            sb.append(HtmlUtility.escapeHTML((String)value));
            sb.append("</span>");
            return sb.toString();
        }
        sb.append("<input type=\"text\" ");
        if (cls != null && !cls.isEmpty()) {
            sb.append("class=\"" + cls + "\" ");
        }
        if (id != null && !id.isEmpty()) {
            sb.append("id=\"" + id + "\" ");
        }
        if (name != null && !name.isEmpty()) {
            sb.append("name=\"" + name + "\" ");
        }
        sb.append("value=\"" + HtmlUtility.escapeHTML((String)value) + "\" />");
        return sb.toString();
    }

    public static String getTextboxTag(String cls, String id, String value, boolean isLabel) {
        return HtmlUtility.getTextboxTag((String)cls, (String)id, (String)id, (String)value, (boolean)isLabel);
    }

    public static String getTextboxTag(String cls, String name, int idx, String value) {
        return HtmlUtility.getTextboxTag((String)cls, (String)(name + idx), (String)name, (String)value, (boolean)false);
    }

    public static String getTextAreaTag(String cls, String id, String name, String value, boolean isLabel) {
        StringBuffer sb = new StringBuffer();
        if (isLabel) {
            sb.append("<span ");
            if (id != null && !id.isEmpty()) {
                sb.append("id=\"" + id + "\"");
            }
            sb.append(">");
            sb.append(HtmlUtility.escapeHTML((String)value));
            sb.append("</span>");
            return sb.toString();
        }
        sb.append("<textarea ");
        if (cls != null && !cls.isEmpty()) {
            sb.append("class=\"" + cls + "\" ");
        }
        if (id != null && !id.isEmpty()) {
            sb.append("id=\"" + id + "\" ");
        }
        if (name != null && !name.isEmpty()) {
            sb.append("name=\"" + name + "\" ");
        }
        sb.append(">" + HtmlUtility.escapeHTML((String)value) + "</textarea>");
        return sb.toString();
    }

    public static String getTextAreaTag(String cls, String name, int idx, String value) {
        return HtmlUtility.getTextAreaTag((String)cls, (String)(name + idx), (String)name, (String)value, (boolean)false);
    }

    public static String getSelectTag(String cls, String id, String name, String value, String[][] array, boolean isLabel) {
        return HtmlUtility.getSelectTag((String)cls, (String)id, (String)name, (String)value, (String[][])array, (boolean)false, (boolean)isLabel);
    }

    public static String getSelectTag(String cls, String id, String value, String[][] array) {
        return HtmlUtility.getSelectTag((String)cls, (String)id, (String)id, (String)value, (String[][])array, (boolean)false, (boolean)false);
    }

    public static String getSelectTag(String cls, String id, String name, String value, String option, boolean needBlank, boolean isLabel, String label) {
        StringBuffer sb = new StringBuffer();
        if (isLabel) {
            sb.append("<span ");
            if (id != null && !id.isEmpty()) {
                sb.append("id=\"" + id + "\"");
            }
            sb.append(">");
            sb.append(HtmlUtility.escapeHTML((String)label));
            sb.append("</span>");
            return sb.toString();
        }
        sb.append("<select ");
        if (cls != null && !cls.isEmpty()) {
            sb.append("class=\"" + cls + "\" ");
        }
        if (id != null && !id.isEmpty()) {
            sb.append("id=\"" + id + "\" ");
        }
        if (name != null && !name.isEmpty()) {
            sb.append("name=\"" + name + "\" ");
        }
        sb.append(">");
        if (needBlank) {
            sb.append("<option value=\"\"></option>");
        }
        sb.append(option);
        sb.append("</select>");
        return sb.toString();
    }

    public static String getSelectTag(String cls, String id, String name, String value, String[][] array, boolean needBlank, boolean isLabel) {
        String label = MospUtility.getCodeName((String)value, (String[][])array);
        String option = HtmlUtility.getSelectOption((String[][])array, (String)value);
        return HtmlUtility.getSelectTag((String)cls, (String)id, (String)name, (String)value, (String)option, (boolean)needBlank, (boolean)isLabel, (String)label);
    }

    public static String getSelectTag(String cls, String name, int idx, String value, String[][] array, boolean needBlank) {
        return HtmlUtility.getSelectTag((String)cls, (String)(name + idx), (String)name, (String)value, (String[][])array, (boolean)needBlank, (boolean)false);
    }

    public static String getSelectTag(MospParams mospParams, String cls, String id, String name, String value, String codeKey, boolean needBlank, boolean isLabel) {
        String label = MospUtility.getCodeName((MospParams)mospParams, (String)value, (String)codeKey);
        String option = HtmlUtility.getSelectOption((MospParams)mospParams, (String)codeKey, (String)value, (boolean)false);
        return HtmlUtility.getSelectTag((String)cls, (String)id, (String)name, (String)value, (String)option, (boolean)needBlank, (boolean)isLabel, (String)label);
    }

    public static String getTagLogoImage(String logoPath, String namLogo) {
        StringBuffer sb = new StringBuffer();
        if (logoPath != null) {
            sb.append("<img class=\"Logo\" id=\"logo\" src=\"");
            sb.append("../pub/" + logoPath);
            sb.append("\" alt=\"" + namLogo + "\">");
        }
        return sb.toString();
    }

    public static String getCheckTag(MospParams mospParams, String cls, String id, String name, String value, boolean isLabel, String ... selectedArray) {
        boolean isChecked = HtmlUtility.isChecked((String)value, (String[])selectedArray);
        StringBuffer sb = new StringBuffer();
        if (isLabel) {
            sb.append("<span ");
            if (!MospUtility.isEmpty((String[])new String[]{id})) {
                sb.append("id=\"" + id + "\"");
            }
            sb.append(">");
            sb.append(HtmlUtility.escapeHTML((String)(isChecked ? NameUtility.checked((MospParams)mospParams) : "")));
            sb.append("</span>");
            return sb.toString();
        }
        sb.append("<input type=\"checkbox\" ");
        if (!MospUtility.isEmpty((String[])new String[]{cls})) {
            sb.append("class=\"" + cls + "\" ");
        }
        if (!MospUtility.isEmpty((String[])new String[]{id})) {
            sb.append("id=\"" + id + "\" ");
        }
        if (!MospUtility.isEmpty((String[])new String[]{name})) {
            sb.append("name=\"" + name + "\" ");
        }
        sb.append("value=\"" + HtmlUtility.escapeHTML((String)value) + "\" ");
        sb.append(HtmlUtility.getChecked((boolean)isChecked));
        sb.append("/>");
        return sb.toString();
    }

    public static String getCheckTag(MospParams mospParams, String cls, String id, String name, long value, boolean isLabel, String ... selectedArray) {
        return HtmlUtility.getCheckTag((MospParams)mospParams, (String)cls, (String)id, (String)name, (String)String.valueOf(value), (boolean)isLabel, (String[])selectedArray);
    }

    public static String getCheckTags(MospParams mospParams, String cls, String name, String codeKey, boolean isLabel, String ... selectedArray) {
        String[][] array = mospParams.getProperties().getCodeArray(codeKey, false);
        return HtmlUtility.getCheckTags((MospParams)mospParams, (String)cls, (String)name, (String[][])array, (boolean)isLabel, (String[])selectedArray);
    }

    public static String getCheckTags(MospParams mospParams, String cls, String name, String[][] array, boolean isLabel, String ... selectedArray) {
        StringBuffer sb = new StringBuffer();
        if (array == null) {
            return sb.toString();
        }
        for (String[] element : array) {
            sb.append("<label>");
            sb.append(HtmlUtility.getCheckTag((MospParams)mospParams, (String)cls, (String)"", (String)name, (String)element[0], (boolean)isLabel, (String[])selectedArray));
            sb.append(element[1]);
            sb.append("</label>");
        }
        return sb.toString();
    }

    public static String getCheckTag(MospParams mospParams, String cls, String name, int idx, String ... selectedArray) {
        return HtmlUtility.getCheckTag((MospParams)mospParams, (String)cls, (String)(name + idx), (String)name, (long)idx, (boolean)false, (String[])selectedArray);
    }

    public static boolean isChecked(String value, String ... selectedArray) {
        if (value == null || selectedArray == null) {
            return false;
        }
        for (String selected : selectedArray) {
            if (!value.equals(selected)) continue;
            return true;
        }
        return false;
    }

    public static String getChecked(long value, String[] selectedArray) {
        return HtmlUtility.getChecked((String)String.valueOf(value), (String[])selectedArray);
    }

    public static String getChecked(String value, String ... selectedArray) {
        return HtmlUtility.getChecked((boolean)HtmlUtility.isChecked((String)value, (String[])selectedArray));
    }

    public static String getChecked(String value) {
        if (value != null && value.equals("1")) {
            return HtmlUtility.getChecked((boolean)true);
        }
        return HtmlUtility.getChecked((boolean)false);
    }

    public static String getChecked(boolean isChecked) {
        if (isChecked) {
            return "checked=\"checked\"";
        }
        return "";
    }

    public static String getSpanTag(String cls, String value, boolean isSpan) {
        StringBuilder sb = new StringBuilder(HtmlUtility.escapeHTML((String)value));
        if (isSpan) {
            sb.insert(0, "<span class=\"" + cls + "\">");
            sb.append("</span>");
        }
        return sb.toString();
    }

    public static String getMessageDiv(MospParams params) {
        StringBuffer sb = new StringBuffer();
        List messageList = params.getMessageList();
        List errorMessageList = params.getErrorMessageList();
        if (messageList.size() == 0 && errorMessageList.size() == 0) {
            return sb.toString();
        }
        sb.append("<div class=\"Message\">");
        for (String message : messageList) {
            sb.append("<span class=\"MessageSpan\">");
            sb.append(HtmlUtility.escapeHTML((String)message));
            sb.append("</span><br />");
        }
        int count = 0;
        for (String errorMessage : errorMessageList) {
            if (count >= 10) {
                sb.append("<span class=\"ErrorMessageSpan\">");
                sb.append(NameUtility.other((MospParams)params));
                sb.append(NameUtility.count((MospParams)params, (int)(errorMessageList.size() - count)));
                sb.append("</span><br />");
                break;
            }
            sb.append("<span class=\"ErrorMessageSpan\">");
            sb.append(HtmlUtility.escapeHTML((String)errorMessage));
            sb.append("</span><br />");
            ++count;
        }
        sb.append("</div>");
        return sb.toString();
    }

    public static String getListInfoFlex(MospParams mospParams, List<? extends BaseDtoInterface> list, String command, int dataPerPage, String selectIndex) {
        StringBuffer sb = new StringBuffer();
        int countAllData = list == null ? 0 : list.size();
        int select = Integer.parseInt(selectIndex);
        int offset = (select - 1) * dataPerPage;
        int full = MospUtility.divide((int)countAllData, (int)dataPerPage);
        int end = offset + dataPerPage;
        if (MospUtility.remainder((int)countAllData, (int)dataPerPage) != 0) {
            ++full;
        }
        end = end > countAllData ? countAllData : end;
        sb.append("<div class=\"ListInfo\">");
        sb.append("<table class=\"ListInfoTopTable\">");
        sb.append("<tr>");
        sb.append("<td class=\"RollLinkTd\">");
        if (select - 1 > 0) {
            sb.append("<a ");
            sb.append("onclick=\"submitTransfer(event, null, null, new Array('");
            sb.append("selectIndex");
            sb.append("', '");
            sb.append(select - 1);
            sb.append("'), '");
            sb.append(command);
            sb.append("')\">");
            sb.append("&lt;&lt;");
            sb.append("</a>");
        }
        sb.append("</td>");
        sb.append("<td>");
        sb.append(countAllData == 0 ? 0 : offset + 1);
        sb.append("&nbsp;");
        sb.append(NameUtility.wave((MospParams)mospParams));
        sb.append("&nbsp;");
        sb.append(end);
        sb.append("&nbsp;/&nbsp;");
        sb.append(countAllData);
        sb.append("&nbsp;");
        sb.append(NameUtility.count((MospParams)mospParams));
        sb.append("</td>");
        sb.append("<td class=\"RollLinkTd\">");
        if (select + 1 <= full) {
            sb.append("<a ");
            sb.append("onclick=\"submitTransfer(event, null, null, new Array('");
            sb.append("selectIndex");
            sb.append("', '");
            sb.append(select + 1);
            sb.append("'), '");
            sb.append(command);
            sb.append("')\">");
            sb.append("&gt;&gt;");
            sb.append("</a>");
        }
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("</table>");
        if (countAllData <= dataPerPage) {
            sb.append("</div>");
            return sb.toString();
        }
        sb.append("<table class=\"ListInfoBottomTable\">");
        sb.append("<tr>");
        sb.append("<td class=\"ListInfoButton\">");
        if (full != 0) {
            int pageNum = MospUtility.divide((int)select, (int)100);
            for (int i = -1; i < 11; ++i) {
                if (pageNum + i <= 0 || pageNum + i > full) continue;
                if (select != pageNum + i) {
                    sb.append("<a onclick=\"submitTransfer(event, null, null, new Array('");
                    sb.append("selectIndex");
                    sb.append("', '");
                    sb.append(pageNum + i);
                    sb.append("'), '");
                    sb.append(command);
                    sb.append("')\">");
                    sb.append(NameUtility.cornerParentheses((MospParams)mospParams, (String)String.valueOf(pageNum + i)));
                    sb.append("</a>");
                    continue;
                }
                if (select != pageNum + i) continue;
                sb.append(NameUtility.cornerParentheses((MospParams)mospParams, (String)String.valueOf(pageNum + i)));
            }
        }
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("</div>");
        return sb.toString();
    }

    public static String getJsArray(String variableName, String[] array) {
        StringBuffer sb = new StringBuffer();
        sb.append(HtmlUtility.getJsArrayDeclaration((String)variableName));
        for (String value : array) {
            sb.append(HtmlUtility.getJsArrayPush((String)variableName, (String)("\"" + value + "\"")));
        }
        return sb.toString();
    }

    public static String getJsArray(String variableName, String[][] array) {
        StringBuffer sb = new StringBuffer();
        sb.append(HtmlUtility.getJsArrayDeclaration((String)variableName));
        for (int i = 0; i < array.length; ++i) {
            String name = variableName + i;
            sb.append(HtmlUtility.getJsArray((String)name, (String[])array[i]));
            sb.append(HtmlUtility.getJsArrayPush((String)variableName, (String)name));
        }
        return sb.toString();
    }

    private static String getJsArrayDeclaration(String variableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("var ");
        sb.append(variableName);
        sb.append(" = ");
        sb.append(HtmlUtility.getJsNewArray((String)""));
        sb.append(";");
        return sb.toString();
    }

    private static String getJsNewArray(String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("new Array(");
        sb.append(value);
        sb.append(")");
        return sb.toString();
    }

    private static String getJsArrayPush(String array, String value) {
        StringBuffer sb = new StringBuffer();
        sb.append(array);
        sb.append(".push(");
        sb.append(value);
        sb.append(");");
        return sb.toString();
    }

    public static String getDisabled(boolean disabled) {
        if (disabled) {
            return " disabled=\"disabled\" ";
        }
        return "";
    }

    public static String getReadOnly(boolean isReadOnly) {
        if (isReadOnly) {
            return " readonly=\"readonly\" ";
        }
        return "";
    }
}

