/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.utils;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public final class DateUtility {
    public static final int TIME_HOUR_MILLI_SEC = 3600000;
    public static final int TIME_DAY_MILLI_SEC = 86400000;
    private static final String[] FORMAT_VARIOUS_DATE = new String[]{"yyyyMMddHHmmss", "yyyy/MM/dd HH:mm", "yyyy/MM/dd", "yyyyMMdd", "yyyy-MM-dd"};

    private DateUtility() {
    }

    public static Date getSystemDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getSystemTime() {
        Calendar cal = Calendar.getInstance();
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getSystemTimeAndSecond() {
        Calendar cal = Calendar.getInstance();
        return cal.getTime();
    }

    public static Date getDefaultTime() throws MospException {
        return DateUtility.getTime((int)0, (int)0);
    }

    public static int getCalendarValue(Date date, int field) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(field);
    }

    public static int getYear(Date date) {
        return DateUtility.getCalendarValue((Date)date, (int)1);
    }

    public static int getMonth(Date date) {
        return DateUtility.getCalendarValue((Date)date, (int)2) + 1;
    }

    public static int getDay(Date date) {
        return DateUtility.getCalendarValue((Date)date, (int)5);
    }

    public static int getHour(Date date) {
        return DateUtility.getCalendarValue((Date)date, (int)11);
    }

    public static int getHour(Date date, Date standardDate) {
        if (standardDate == null) {
            return DateUtility.getHour((Date)date);
        }
        return (int)((date.getTime() - standardDate.getTime()) / 3600000L);
    }

    public static int getMinute(Date date) {
        return DateUtility.getCalendarValue((Date)date, (int)12);
    }

    public static int getDayOfWeek(Date date) {
        return DateUtility.getCalendarValue((Date)date, (int)7);
    }

    public static String getStringYear(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"yyyy");
    }

    public static String getStringMonth(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"MM");
    }

    public static String getStringMonthM(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"M");
    }

    public static String getStringDay(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"dd");
    }

    public static String getStringDayD(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"d");
    }

    public static String getStringHour(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"HH");
    }

    public static String getStringHourH(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"H");
    }

    public static String getStringHour(Date date, Date standardDate) {
        return DateUtility.getStringHour((Date)date, (Date)standardDate, (String)"#00");
    }

    public static String getStringHourH(Date date, Date standardDate) {
        return DateUtility.getStringHour((Date)date, (Date)standardDate, (String)"#0");
    }

    private static String getStringHour(Date date, Date standardDate, String pattern) {
        if (date == null || standardDate == null) {
            return DateUtility.getStringHour((Date)date);
        }
        DecimalFormat format = new DecimalFormat(pattern);
        return format.format((Object)((date.getTime() - standardDate.getTime()) / 3600000L));
    }

    public static String getStringMinute(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"mm");
    }

    public static String getStringMinuteM(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"m");
    }

    public static String getStringDayOfWeek(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"E");
    }

    public static Date getDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getDate(int year, int month, int day) throws MospException {
        return DateUtility.getDateTime((int)year, (int)month, (int)day, (int)0, (int)0);
    }

    public static Date getDate(String year, String month, String day) throws MospException {
        try {
            if (year.isEmpty() || month.isEmpty() || day.isEmpty()) {
                return null;
            }
            return DateUtility.getDate((int)Integer.parseInt(year), (int)Integer.parseInt(month), (int)Integer.parseInt(day));
        }
        catch (NullPointerException e) {
            throw new MospException((Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new MospException((Throwable)e);
        }
    }

    public static Date getTime(int minute) throws MospException {
        return DateUtility.addMinute((Date)DateUtility.getDefaultTime(), (int)minute);
    }

    public static Date getTime(int hourOfDay, int minute) throws MospException {
        return DateUtility.getDateTime((int)1970, (int)1, (int)1, (int)hourOfDay, (int)minute);
    }

    public static Date getTime(String hour, String minute) throws MospException {
        try {
            if (hour.isEmpty() && minute.isEmpty()) {
                return null;
            }
            return DateUtility.getTime((int)Integer.parseInt(hour), (int)Integer.parseInt(minute));
        }
        catch (NullPointerException e) {
            throw new MospException((Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new MospException((Throwable)e);
        }
    }

    public static Date getTime(String date) {
        return DateUtility.getDate((String)date, (String)"yyyyMMddHHmmss");
    }

    public static Date getTime(String time, Date standardDate) {
        StringBuilder sb = new StringBuilder();
        sb.append(DateUtility.getStringDateNoSeparator((Date)standardDate));
        sb.append(time);
        return DateUtility.getDate((String)sb.toString(), (String)"yyyyMMddHH:mm");
    }

    public static Date getTime(Date time, Date standardDate) throws MospException {
        long deference = time.getTime() - DateUtility.getDefaultTime().getTime();
        return new Date(standardDate.getTime() + deference);
    }

    public static Date getDate(String date) {
        return DateUtility.getDate((String)date, (String)"yyyy/MM/dd");
    }

    public static Date getVariousDate(String date) {
        for (String format : FORMAT_VARIOUS_DATE) {
            Date objDate = DateUtility.getDate((String)date, (String)format);
            if (MospUtility.isEmpty((Object[])new Object[]{objDate})) continue;
            return objDate;
        }
        return null;
    }

    public static Date getDate(String date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setLenient(false);
        try {
            return df.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getStringDate(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"yyyy/MM/dd");
    }

    public static String getStringDateNoSeparator(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"yyyyMMdd");
    }

    public static String getStringDateAndDay(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"yyyy/MM/dd(E)");
    }

    public static String getStringMonthAndDate(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"MM/dd");
    }

    public static String getStringMonthAndDay(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"MM/dd(E)");
    }

    public static String getStringDateAndTime(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"yyyy/MM/dd HH:mm");
    }

    public static String getStringDateAndDayAndTime(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"yyyy/MM/dd(E) HH:mm");
    }

    public static String getStringYearMonth(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"yyyy/MM");
    }

    public static String getStringDateMilli(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"yyyy/MM/dd HH:mm:ss.SSS");
    }

    public static String getStringTime(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"HH:mm");
    }

    public static String getStringTimeAndSecond(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"HH:mm:ss");
    }

    public static String getStringJapaneseDate(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"yyyy\u5e74MM\u6708dd\u65e5");
    }

    public static String getStringJapaneseMonth(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"yyyy\u5e74MM\u6708");
    }

    public static String getStringTime(Date date, Date standardDate) {
        if (date == null || standardDate == null) {
            return DateUtility.getStringTime((Date)date);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(DateUtility.getStringHour((Date)date, (Date)standardDate));
        sb.append(":");
        sb.append(DateUtility.getStringMinute((Date)date));
        return sb.toString();
    }

    public static String getStringTimeAndSecond(Date date, Date standardDate) {
        if (date == null || standardDate == null) {
            return DateUtility.getStringTimeAndSecond((Date)date);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(DateUtility.getStringHour((Date)date, (Date)standardDate));
        sb.append(DateUtility.getStringDate((Date)date, (String)":mm:ss"));
        return sb.toString();
    }

    public static String getStringDate(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static Date addYear(Date date, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(1, amount);
        return cal.getTime();
    }

    public static Date addMonth(Date date, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(2, amount);
        return cal.getTime();
    }

    public static Date addDay(Date date, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, amount);
        return cal.getTime();
    }

    public static Date addHour(Date date, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(11, amount);
        return cal.getTime();
    }

    public static Date addMinute(Date date, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(12, amount);
        return cal.getTime();
    }

    public static Date addYearAndDay(Date date, int year, int day) {
        return DateUtility.addDay((Date)DateUtility.addYear((Date)date, (int)year), (int)day);
    }

    public static Date addMonthAndDay(Date date, int month, int day) {
        return DateUtility.addDay((Date)DateUtility.addMonth((Date)date, (int)month), (int)day);
    }

    public static Date getDateTime(int year, int month, int day, int hour, int minute) throws MospException {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setLenient(false);
            cal.set(year, month - 1, day, hour, minute, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        catch (IllegalArgumentException e) {
            throw new MospException((Throwable)e);
        }
    }

    public static boolean isDayOfWeek(Date date, int dayOfWeek) {
        return DateUtility.getDayOfWeek((Date)date) == dayOfWeek;
    }

    public static boolean isSunday(Date date) {
        return DateUtility.isDayOfWeek((Date)date, (int)1);
    }

    public static boolean isMonday(Date date) {
        return DateUtility.isDayOfWeek((Date)date, (int)2);
    }

    public static boolean isTuesday(Date date) {
        return DateUtility.isDayOfWeek((Date)date, (int)3);
    }

    public static boolean isWednesday(Date date) {
        return DateUtility.isDayOfWeek((Date)date, (int)4);
    }

    public static boolean isThursday(Date date) {
        return DateUtility.isDayOfWeek((Date)date, (int)5);
    }

    public static boolean isFriday(Date date) {
        return DateUtility.isDayOfWeek((Date)date, (int)6);
    }

    public static boolean isSaturday(Date date) {
        return DateUtility.isDayOfWeek((Date)date, (int)7);
    }

    public static Date getFirstDateOfWeek(int startDayOfWeek, Date targetDate) {
        Date firstDate = targetDate;
        while (!DateUtility.isDayOfWeek((Date)firstDate, (int)startDayOfWeek)) {
            firstDate = DateUtility.addDay((Date)firstDate, (int)-1);
        }
        return firstDate;
    }

    public static Date getLastDateOfWeek(int startDayOfWeek, Date targetDate) {
        Date lastDate = DateUtility.addDay((Date)targetDate, (int)1);
        while (!DateUtility.isDayOfWeek((Date)lastDate, (int)startDayOfWeek)) {
            lastDate = DateUtility.addDay((Date)lastDate, (int)1);
        }
        return DateUtility.addDay((Date)lastDate, (int)-1);
    }

    public static int getDayDifference(Date startDate, Date targetDate) {
        if (startDate == null || targetDate == null) {
            return 0;
        }
        long diff = targetDate.getTime() - startDate.getTime();
        return (int)(diff / 86400000L);
    }

    public static int getMonthDifference(Date startDate, Date targetDate) {
        int startYear = DateUtility.getYear((Date)startDate);
        int startMonth = DateUtility.getMonth((Date)startDate);
        int targetYear = DateUtility.getYear((Date)targetDate);
        int targetMonth = DateUtility.getMonth((Date)targetDate);
        int startMonthMin = startYear * 12 + startMonth;
        int targetMonthMin = targetYear * 12 + targetMonth;
        return targetMonthMin - startMonthMin;
    }

    public static boolean isTermContain(Date targetDate, Date startDate, Date endDate) {
        if (startDate == null) {
            return targetDate.compareTo(endDate) <= 0;
        }
        if (endDate == null) {
            return targetDate.compareTo(startDate) >= 0;
        }
        return targetDate.compareTo(startDate) >= 0 && targetDate.compareTo(endDate) <= 0;
    }

    public static boolean isOnTheTerm(Date termStart, Date termEnd, Date startDate, Date endDate) {
        if (MospUtility.isEmpty((Object[])new Object[]{termStart, termEnd, startDate, endDate})) {
            return false;
        }
        if (termStart.after(termEnd) || startDate.after(endDate)) {
            return false;
        }
        if (termStart.after(endDate)) {
            return false;
        }
        return !termEnd.before(startDate);
    }

    public static boolean isSame(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        return date1.compareTo(date2) == 0;
    }

    public static Date getDateAfter(Date targetDate, int year, int month, int day) {
        if (targetDate == null) {
            return null;
        }
        Date after = DateUtility.addYear((Date)targetDate, (int)year);
        after = DateUtility.addMonth((Date)after, (int)month);
        return DateUtility.addDay((Date)after, (int)day);
    }

    public static boolean isInDateAfter(Date targetDate, Date startDate, int year, int month, int day, boolean isContainLastDay) {
        if (targetDate == null) {
            return false;
        }
        Date endDate = DateUtility.getDateAfter((Date)startDate, (int)year, (int)month, (int)day);
        if (!isContainLastDay) {
            endDate = DateUtility.addDay((Date)endDate, (int)-1);
        }
        return DateUtility.isTermContain((Date)targetDate, (Date)startDate, (Date)endDate);
    }

    public static boolean isExpireMinute(Date targetDate, Date referenceDate, int expiration) {
        return targetDate.after(DateUtility.addMinute((Date)referenceDate, (int)expiration));
    }

    public static boolean isExpireDay(Date targetDate, Date referenceDate, int expiration) {
        return targetDate.after(DateUtility.addDay((Date)referenceDate, (int)expiration));
    }

    public static Date getEndTargetDate(Date startDate, Date endDate) {
        Date systemDate = DateUtility.getSystemDate();
        if (DateUtility.isTermContain((Date)systemDate, (Date)startDate, (Date)endDate)) {
            return systemDate;
        }
        if (systemDate.compareTo(startDate) < 0) {
            return startDate;
        }
        if (systemDate.compareTo(endDate) > 0) {
            return endDate;
        }
        return systemDate;
    }

    public static Date getDefaultTimeOrNull(boolean isNullAvailable) throws MospException {
        return isNullAvailable ? null : DateUtility.getDefaultTime();
    }
}

