/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import jp.mosp.framework.constant.MospConst;

public final class LogFormatClass
extends Formatter {
    public static final String DATE_FORMAT = "yyyy/MM/dd";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final String DAY_FORMAT = "E";
    private String separator;

    public LogFormatClass(String separator) {
        this.separator = separator != null ? separator : "|";
    }

    @Override
    public String format(LogRecord rec) {
        SimpleDateFormat sdf = new SimpleDateFormat(TIME_FORMAT + this.separator + DATE_FORMAT + this.separator + DAY_FORMAT);
        StringBuffer sb = new StringBuffer();
        sb.append(sdf.format(new Date()));
        sb.append(this.separator);
        sb.append(rec.getLevel());
        sb.append(this.separator);
        sb.append(this.formatMessage(rec));
        sb.append(MospConst.LINE_SEPARATOR);
        return sb.toString();
    }

    @Override
    public String getHead(Handler h) {
        return "";
    }

    @Override
    public String getTail(Handler h) {
        return "";
    }
}

