/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.base;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.mosp.framework.base.ActionInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospExporterInterface;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.base.MospPropertiesParser;
import jp.mosp.framework.base.MospRequestParser;
import jp.mosp.framework.base.MospStoredInfo;
import jp.mosp.framework.base.TopicPath;
import jp.mosp.framework.instance.InstanceFactory;
import jp.mosp.framework.log.LoggerInterface;
import jp.mosp.framework.property.CommandProperty;
import jp.mosp.framework.property.MospProperties;
import jp.mosp.framework.utils.LogUtility;
import jp.mosp.framework.utils.MessageUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.RoleUtility;
import net.arnx.jsonic.JSON;

public class Controller
extends HttpServlet {
    private static final long serialVersionUID = 5986464246296477656L;
    protected transient MospProperties ppt;
    protected Map<String, LoggerInterface> loggers = new ConcurrentHashMap();
    protected static final String ATT_STORED_INFO = "storedInfo";
    protected static final String ATT_PROC_SEQ = "procSeq";
    protected static final String APP_URL_INDEX = "UrlIndex";
    protected static final String APP_COMMAND_INDEX = "CommandIndex";
    protected static final String APP_COMMAND_LOGOUT = "CommandLogout";
    protected static final String APP_SESSION_INTERVAL = "SessionInterval";
    protected static final String APP_RESPONSE_EXPIRES = "Expires";
    protected static final String APP_RESPONSE_PRAGMA = "Pragma";
    protected static final String APP_RESPONSE_CACHE_CTRL = "Cache-Control";
    protected static final String APP_RESPONSE_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    protected static final String APP_CONTENT_TYPE_HTML = "ContentType-Html";
    protected static final String APP_EXPORTER_PREFIX = "Exporter-";
    protected static final String SESSION_NECESSARY = "necessary";
    protected static final String SESSION_UNNECESSARY = "unnecessary";
    protected static final String PRM_PROC_SEQ = "procSeq";
    protected static final String PROC_SEQ_UNNECESSARY = "unnecessary";
    protected static final String PROC_SEQ_ZERO_ACCEPT = "zeroAcceptable";
    protected static final String PROC_SEQ_IGNORE = "ignore";
    protected static final String CMD_API = "api";
    protected static final String API_SEPARATOR = "/";

    public void init(ServletConfig config) {
        try {
            super.init(config);
            String docBase = this.getServletContext().getRealPath("");
            this.ppt = this.parseMospProperties(docBase);
            MospUtility.outputMessageJs((MospProperties)this.ppt);
            LogUtility.controllerInit((MospParams)new MospParams(this.ppt, this.loggers), (String)this.toString());
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        catch (MospException e) {
            e.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.doProcess(request, response);
        }
        catch (Exception e) {
            this.handleException((Throwable)e, request, response);
        }
        catch (Error e) {
            this.handleException((Throwable)e, request, response);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.doProcess(request, response);
        }
        catch (Exception e) {
            this.handleException((Throwable)e, request, response);
        }
        catch (Error e) {
            this.handleException((Throwable)e, request, response);
        }
    }

    protected void doProcess(HttpServletRequest request, HttpServletResponse response) throws MospException {
        this.doCommonPreProcess(request);
        MospParams mospParams = this.getMospParams(request);
        LogUtility.access((MospParams)mospParams);
        LogUtility.parameter((MospParams)mospParams);
        if (mospParams.getCommand() == null || mospParams.getCommand().isEmpty()) {
            this.forward(request, response, this.ppt.getApplicationProperty(APP_URL_INDEX));
            return;
        }
        String actionClassName = mospParams.getCommandProperty().getActionClass();
        ActionInterface action = (ActionInterface)InstanceFactory.loadInstance((String)actionClassName);
        action.init(mospParams);
        action.doAction();
        this.issueProcSeq(request);
        this.forward(request, response);
    }

    protected void forward(HttpServletRequest request, HttpServletResponse response) throws MospException {
        MospParams mospParams = this.getMospParams(request);
        if (mospParams.isUrlErrorView()) {
            this.setResponseHeader(request, response);
            this.forward(request, response, mospParams.getUrl());
            return;
        }
        if (mospParams.getNextCommand() != null) {
            this.forward(request, response, "/srv/");
            return;
        }
        if (mospParams.getFile() != null) {
            this.output(request, response);
            return;
        }
        if (mospParams.getRedirect() != null) {
            this.redirect(request, response);
            return;
        }
        this.setResponseHeader(request, response);
        this.forward(request, response, mospParams.getUrl());
    }

    protected void forward(HttpServletRequest request, HttpServletResponse response, String url) throws MospException {
        try {
            this.getServletContext().getRequestDispatcher(url).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            throw new MospException((Throwable)e, "FWE9125", url);
        }
        catch (IOException e) {
            throw new MospException((Throwable)e, "FWE9125", url);
        }
    }

    protected void output(HttpServletRequest request, HttpServletResponse response) throws MospException {
        MospParams mospParams = this.getMospParams(request);
        String key = mospParams.getApplicationProperty(APP_EXPORTER_PREFIX + mospParams.getFile().getClass().getName());
        MospExporterInterface exporter = (MospExporterInterface)InstanceFactory.loadInstance((String)key);
        exporter.export(mospParams, response);
    }

    protected void redirect(HttpServletRequest request, HttpServletResponse response) throws MospException {
        String redirect = this.getMospParams(request).getRedirect();
        try {
            response.sendRedirect(redirect);
        }
        catch (IOException e) {
            throw new MospException((Throwable)e, "FWE9125", redirect);
        }
    }

    protected void setResponseHeader(HttpServletRequest request, HttpServletResponse response) {
        MospParams mospParams = this.getMospParams(request);
        for (String property : mospParams.getApplicationProperties(APP_RESPONSE_PRAGMA)) {
            response.addHeader(APP_RESPONSE_PRAGMA, property);
        }
        for (String property : mospParams.getApplicationProperties(APP_RESPONSE_CACHE_CTRL)) {
            response.addHeader(APP_RESPONSE_CACHE_CTRL, property);
        }
        for (String property : mospParams.getApplicationProperties(APP_RESPONSE_ALLOW_ORIGIN)) {
            response.addHeader(APP_RESPONSE_ALLOW_ORIGIN, property);
        }
        response.addDateHeader(APP_RESPONSE_EXPIRES, (long)mospParams.getApplicationProperty(APP_RESPONSE_EXPIRES, 0));
        response.setContentType(mospParams.getApplicationProperty(APP_CONTENT_TYPE_HTML));
    }

    protected void doCommonPreProcess(HttpServletRequest request) throws MospException {
        MospParams mospParams = new MospParams(this.ppt, this.loggers);
        MospStoredInfo storedInfo = this.getMospStoredInfo(request);
        if (storedInfo != null) {
            mospParams.setStoredInfo(storedInfo);
        }
        if (this.getMospParams(request) != null) {
            mospParams.inheritParams(this.getMospParams(request));
        }
        request.setAttribute("mospParams", (Object)mospParams);
        this.setRequestCharEncoding(request);
        MospRequestParser.parseRequestParams((HttpServletRequest)request, (MospParams)this.getMospParams(request));
        if (mospParams.getCommand() == null) {
            mospParams.setCommand(mospParams.getRequestParam("cmd"));
        }
        mospParams.addGeneralParam("USER-AGENT", (Object)request.getHeader("USER-AGENT"));
        mospParams.addGeneralParam("Referer", (Object)request.getHeader("Referer"));
        mospParams.addGeneralParam("REMOTE-ADDR", (Object)request.getRemoteAddr());
        mospParams.addGeneralParam("HTTP-METHOD", (Object)request.getMethod());
        mospParams.addGeneralParam("REQUEST-URL", (Object)request.getRequestURL());
        mospParams.addGeneralParam("REQUEST-QUERY", (Object)request.getQueryString());
        mospParams.addGeneralParam("Authorization", (Object)request.getHeader("Authorization"));
        mospParams.addGeneralParam("CONTENT-TYPE", (Object)request.getHeader("CONTENT-TYPE"));
        this.setApiParams(request);
        if (mospParams.getCommand() == null || mospParams.getCommand().isEmpty()) {
            return;
        }
        this.checkHttpMethod(request);
        this.checkHttpSession(request);
        this.checkProcSeq(request);
    }

    protected void setRequestCharEncoding(HttpServletRequest request) throws MospException {
        String encoding = this.ppt.getApplicationProperty("CharacterEncoding");
        try {
            request.setCharacterEncoding(encoding);
        }
        catch (UnsupportedEncodingException e) {
            this.getMospParams(request).setErrorViewUrl();
            throw new MospException((Throwable)e, "FWE9124", encoding);
        }
    }

    protected void handleException(Throwable throwable, HttpServletRequest request, HttpServletResponse response) {
        try {
            MospParams mospParams = this.getMospParams(request);
            if (mospParams == null) {
                this.invalidateSession(request);
                throwable.printStackTrace();
                mospParams = new MospParams(this.ppt, this.loggers);
                request.setAttribute("mospParams", (Object)mospParams);
                mospParams.setErrorViewUrl();
                this.forward(request, response);
                return;
            }
            if (!(throwable instanceof MospException)) {
                this.invalidateSession(request);
                LogUtility.error((MospParams)mospParams, (Throwable)throwable);
                mospParams.setErrorViewUrl();
                this.forward(request, response);
                return;
            }
            MospException mospException = (MospException)throwable;
            if (mospException.getCause() != null || mospParams.isUrlErrorView()) {
                this.invalidateSession(request);
                LogUtility.error((MospParams)mospParams, (Throwable)mospException);
                mospParams.addErrorMessage(mospException.getExceptionId(), mospException.getReplaceStrings());
                mospParams.setErrorViewUrl();
                this.forward(request, response);
                return;
            }
            LogUtility.debug((MospParams)mospParams, (String)mospParams.getCodedMessage(mospException.getExceptionId(), mospException.getReplaceStrings()));
            this.issueProcSeq(request);
            this.forward(request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void invalidateSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    protected void checkHttpSession(HttpServletRequest request) throws MospException {
        MospParams mospParams = this.getMospParams(request);
        CommandProperty commandProperty = mospParams.getCommandProperty();
        HttpSession session = request.getSession(false);
        MospStoredInfo storedInfo = mospParams.getStoredInfo();
        if (commandProperty.getNeedSession() == null) {
            if (session == null) {
                MessageUtility.addErrorSessionTimeout((MospParams)mospParams);
                mospParams.setNextCommand(this.ppt.getApplicationProperty(APP_COMMAND_INDEX));
                throw new MospException("FWW0001");
            }
            if (storedInfo.getUser() == null) {
                mospParams.setNextCommand(this.ppt.getApplicationProperty(APP_COMMAND_INDEX));
                throw new MospException("FWE9105");
            }
            if (!RoleUtility.hasAuthority((MospParams)mospParams, (String)commandProperty.getCommand())) {
                mospParams.addErrorMessage("FWW0102", new String[0]);
                mospParams.setNextCommand(this.ppt.getApplicationProperty(APP_COMMAND_INDEX));
                throw new MospException("FWW0102");
            }
        } else if (commandProperty.getNeedSession().equals(SESSION_NECESSARY)) {
            if (session == null) {
                MessageUtility.addErrorSessionTimeout((MospParams)mospParams);
                mospParams.setNextCommand(this.ppt.getApplicationProperty(APP_COMMAND_INDEX));
                throw new MospException("FWW0001");
            }
        } else if (commandProperty.getNeedSession().equals("unnecessary") && session == null) {
            session = request.getSession(true);
        }
        session.setAttribute(ATT_STORED_INFO, (Object)storedInfo);
        session.setMaxInactiveInterval(this.ppt.getApplicationProperty(APP_SESSION_INTERVAL, 0));
        if (session.getAttribute("procSeq") == null) {
            session.setAttribute("procSeq", (Object)String.valueOf(0));
        }
    }

    protected void checkHttpMethod(HttpServletRequest request) throws MospException {
        String httpMethod = (String)this.getMospParams(request).getGeneralParam("HTTP-METHOD");
        String[] acceptMethods = this.getMospParams(request).getCommandProperty().getAcceptMethods();
        if (acceptMethods.length == 0 && httpMethod.equals("POST")) {
            return;
        }
        for (String acceptMethod : acceptMethods) {
            if (!acceptMethod.equals(httpMethod)) continue;
            return;
        }
        this.getMospParams(request).setErrorViewUrl();
        throw new MospException("FWE9113", this.getMospParams(request).getCommand());
    }

    protected void issueProcSeq(HttpServletRequest request) throws MospException {
        int procSeq = this.getStoredProcSeq(request);
        String needProcSeq = this.getMospParams(request).getCommandProperty().getNeedProcSeq();
        if (needProcSeq == null) {
            ++procSeq;
        }
        this.setStoredProcSeq(request, procSeq);
        this.getMospParams(request).setProcSeq(procSeq);
    }

    protected void checkProcSeq(HttpServletRequest request) throws MospException {
        int requestedProcSeq;
        if (this.getMospParams(request).getNextCount() > 0) {
            return;
        }
        String needProcSeq = this.getMospParams(request).getCommandProperty().getNeedProcSeq();
        if (needProcSeq != null && needProcSeq.equals(PROC_SEQ_IGNORE)) {
            return;
        }
        int storedProcSeq = this.getStoredProcSeq(request);
        if (storedProcSeq == (requestedProcSeq = Integer.parseInt(this.getMospParams(request).getRequestParam("procSeq")))) {
            return;
        }
        if (needProcSeq != null && needProcSeq.equals(PROC_SEQ_ZERO_ACCEPT) && storedProcSeq == 0) {
            return;
        }
        List topicPathList = this.getMospParams(request).getTopicPathList();
        if (storedProcSeq > requestedProcSeq) {
            if (topicPathList.size() > 1) {
                this.getMospParams(request).setNextCommand(((TopicPath)topicPathList.get(topicPathList.size() - 2)).getCommand());
                throw new MospException("FWW0011");
            }
            if (topicPathList.size() == 1) {
                this.getMospParams(request).setNextCommand(this.ppt.getApplicationProperty(APP_COMMAND_LOGOUT));
                throw new MospException("FWW0011");
            }
        }
        this.getMospParams(request).setNextCommand(this.ppt.getApplicationProperty(APP_COMMAND_INDEX));
        throw new MospException("FWW0011");
    }

    protected MospParams getMospParams(HttpServletRequest request) {
        return (MospParams)request.getAttribute("mospParams");
    }

    protected MospStoredInfo getMospStoredInfo(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return (MospStoredInfo)session.getAttribute(ATT_STORED_INFO);
    }

    protected int getStoredProcSeq(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return 0;
        }
        String procSeq = (String)session.getAttribute("procSeq");
        if (procSeq == null) {
            return 0;
        }
        return Integer.parseInt(procSeq);
    }

    protected void setStoredProcSeq(HttpServletRequest request, int procSeq) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        session.setAttribute("procSeq", (Object)String.valueOf(procSeq));
    }

    protected MospProperties parseMospProperties(String docBase) throws MospException {
        return MospPropertiesParser.parseMospProperties((String)docBase);
    }

    protected void setApiParams(HttpServletRequest request) throws MospException {
        MospParams mospParams = this.getMospParams(request);
        if (mospParams.getProperties().getCommandProperty(CMD_API) == null) {
            return;
        }
        List apiParams = this.getApiParams(request);
        mospParams.addApiParams(apiParams);
        if (!(mospParams.getCommand() != null || mospParams.getRequestParam(CMD_API) == null && apiParams.isEmpty())) {
            mospParams.setCommand(CMD_API);
        }
        if (MospUtility.isContentTypeContain((MospParams)mospParams, (String)"application/json")) {
            mospParams.getApiParams().add(this.getMessageBody(request));
        }
    }

    protected List<String> getApiParams(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String srv = request.getServletPath() + API_SEPARATOR;
        String strParams = uri.substring(uri.indexOf(srv) + srv.length());
        return MospUtility.asList((String[])MospUtility.split((String)strParams, (String)API_SEPARATOR));
    }

    protected String getMessageBody(HttpServletRequest request) throws MospException {
        BufferedReader reader = null;
        try {
            reader = request.getReader();
            String string = JSON.encode((Object)JSON.decode((Reader)reader));
            return string;
        }
        catch (Throwable t) {
            throw new MospException(t);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable t) {
                    throw new MospException(t);
                }
            }
        }
    }
}

