/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.base;

import java.sql.Connection;
import java.util.Date;
import jp.mosp.framework.base.BaseBeanInterface;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.instance.InstanceFactory;
import jp.mosp.framework.utils.MessageUtility;
import jp.mosp.framework.utils.MospUtility;

public abstract class BaseBean
implements BaseBeanInterface {
    protected MospParams mospParams;
    protected Connection connection;

    public void setParams(MospParams mospParams, Connection connection) {
        this.mospParams = mospParams;
        this.connection = connection;
    }

    protected BaseDaoInterface createDao(Class<?> cls) throws MospException {
        return InstanceFactory.loadDao(cls, (MospParams)this.mospParams, (Connection)this.connection);
    }

    protected <T extends BaseDaoInterface> T createDaoInstance(Class<T> cls) throws MospException {
        return (T)InstanceFactory.loadDaoInstance(cls, (MospParams)this.mospParams, (Connection)this.connection);
    }

    protected BaseBeanInterface createBean(Class<?> cls) throws MospException {
        return InstanceFactory.loadBean(cls, (MospParams)this.mospParams, (Connection)this.connection);
    }

    protected <T extends BaseBeanInterface> T createBeanInstance(Class<T> cls) throws MospException {
        return (T)InstanceFactory.loadBeanInstance(cls, (MospParams)this.mospParams, (Connection)this.connection);
    }

    protected BaseBeanInterface createBean(Class<?> cls, Date targetDate) throws MospException {
        return InstanceFactory.loadBean(cls, (Date)targetDate, (MospParams)this.mospParams, (Connection)this.connection);
    }

    protected BaseBeanInterface createBean(String modelClass) throws MospException {
        return InstanceFactory.loadBean((String)modelClass, (MospParams)this.mospParams, (Connection)this.connection);
    }

    protected <T extends BaseBeanInterface> T createBean(Class<T> cls, String modelClass) throws MospException {
        return (T)InstanceFactory.loadBean(cls, (String)modelClass, (MospParams)this.mospParams, (Connection)this.connection);
    }

    protected <T> T createObject(Class<?> cls) throws MospException {
        return (T)MospUtility.createObject(cls, (MospParams)this.mospParams);
    }

    protected BaseDto findForKey(BaseDaoInterface dao, long id, boolean isUpdate) throws MospException {
        return dao.findForKey(id, isUpdate);
    }

    protected boolean checkExclusive(BaseDtoInterface formerDto, BaseDtoInterface baseDto) {
        return formerDto != null && baseDto != null && formerDto.getDeleteFlag() == 0 && formerDto.getUpdateDate().compareTo(baseDto.getUpdateDate()) == 0;
    }

    protected void checkLogicalDelete(BaseDaoInterface dao, long id) throws MospException {
        BaseDto dto = this.findForKey(dao, id, false);
        if (dto != null && dto.getDeleteFlag() == 0) {
            MessageUtility.addErrorDbUpdate((MospParams)this.mospParams);
        }
    }

    protected void logicalDelete(BaseDaoInterface dao, long id) throws MospException {
        if (id == Long.MIN_VALUE) {
            return;
        }
        BaseDto baseDto = dao.findForKey(id, true);
        baseDto.setDeleteFlag(1);
        if (this.checkExclusive((BaseDtoInterface)dao.findForKey(id, true), (BaseDtoInterface)baseDto)) {
            dao.update((BaseDtoInterface)baseDto);
            this.checkLogicalDelete(dao, id);
        } else {
            MessageUtility.addErrorDbDelete((MospParams)this.mospParams);
        }
    }
}

