/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.addon.ldap.bean.impl;

import java.util.Properties;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.LogUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.portal.AuthBeanInterface;
import jp.mosp.platform.utils.PfMessageUtility;

public class LdapAuthBean
extends PlatformBean
implements AuthBeanInterface {
    public static final String APP_SUFFIX_USER_ID = "SuffixUserId";
    public static final String APP_LDAP_PROVIDER_URL = "LdapProviderUrl";
    public static final String APP_LDAP_DIR_NAME = "LdapDirName";
    protected static final String REPLACE_CHARACTER = "%";

    public void initBean() {
    }

    public void authenticate(String userId, String password) throws MospException {
        String suffixedUserId = userId + this.mospParams.getApplicationProperty(APP_SUFFIX_USER_ID);
        for (String providerUrl : this.mospParams.getApplicationProperties(APP_LDAP_PROVIDER_URL)) {
            if (!this.isUserExist(suffixedUserId, providerUrl) || !this.isPasswordValid(suffixedUserId, password, providerUrl)) continue;
            return;
        }
        PfMessageUtility.addErrorAuthFailed((MospParams)this.mospParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUserExist(String userId, String providerUrl) {
        InitialDirContext dirContext = null;
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", providerUrl);
        try {
            dirContext = new InitialDirContext(env);
            SearchControls ctrl = new SearchControls();
            ctrl.setSearchScope(2);
            String dirName = this.mospParams.getApplicationProperty(APP_LDAP_DIR_NAME);
            dirName = dirName.replaceAll(REPLACE_CHARACTER, userId);
            NamingEnumeration<SearchResult> result = dirContext.search(dirName, "objectclass=*", ctrl);
            if (result.hasMoreElements()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (NameNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (Throwable t) {
            LogUtility.error((MospParams)this.mospParams, (Throwable)t);
            boolean bl = false;
            return bl;
        }
        finally {
            if (dirContext != null) {
                try {
                    dirContext.close();
                }
                catch (Throwable t) {
                    LogUtility.error((MospParams)this.mospParams, (Throwable)t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isPasswordValid(String userId, String password, String providerUrl) {
        InitialDirContext dirContext = null;
        String dirName = this.mospParams.getApplicationProperty(APP_LDAP_DIR_NAME);
        dirName = dirName.replaceAll(REPLACE_CHARACTER, userId);
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", providerUrl);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", dirName);
        env.put("java.naming.security.credentials", password);
        try {
            dirContext = new InitialDirContext(env);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            LogUtility.application((MospParams)this.mospParams, (String)this.getLdapAuthFailedMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (dirContext != null) {
                try {
                    dirContext.close();
                }
                catch (Throwable t) {
                    LogUtility.error((MospParams)this.mospParams, (Throwable)t);
                }
            }
        }
    }

    protected String getLdapAuthFailedMessage() {
        return this.mospParams.getName("ldapAuthFailed");
    }
}

