/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.utils;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MenuUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PlatformNamingUtility;
import jp.mosp.time.base.TimeVo;
import jp.mosp.time.dto.settings.HolidayDataDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.utils.TimeNamingUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class TimeUtility {
    public static final int DATE_UNLIMITED_YEAR = 5874897;
    public static final int DATE_YEAR_LAST_MONTH = 31;
    public static final String REG_ATTENDANCE_TIME = "([0-3][0-9]|[4][0-7])[0-5][0-9]";
    public static final String MAIN_MENU_TIME_INMPUT = "menuTimeInput";
    public static final String MENU_ATTENDANCE_LIST = "AttendanceList";
    public static final String MENU_OVERTIME_REQUEST = "OvertimeRequest";
    public static final String MENU_HOLIDAY_REQUEST = "HolidayRequest";
    public static final String MENU_WORK_ON_HOLIDAY_REQUEST = "WorkOnHolidayRequest";
    public static final String MENU_SUB_HOLIDAY_REQUEST = "SubHolidayRequest";
    public static final String MENU_WORK_TYPE_CHANGE_REQUEST = "WorkTypeChangeRequest";
    public static final String MENU_DIFFERENCE_REQUEST = "DifferenceRequest";
    public static final String MENU_CANCELLATION_REQUEST = "CancellationRequest";

    private TimeUtility() {
    }

    public static Date getDateTime(Date date, Date time) throws MospException {
        if (time == null) {
            return null;
        }
        int hour = DateUtility.getHour((Date)time, (Date)DateUtility.getDefaultTime());
        int minute = DateUtility.getMinute((Date)time);
        return TimeUtility.getDateTime((Date)date, (int)hour, (int)minute);
    }

    public static Date getDefaultTime(String hour, String minute) throws MospException {
        return TimeUtility.getDateTime((Date)DateUtility.getDefaultTime(), (String)hour, (String)minute);
    }

    public static Date getDateTime(Date date, String hour, String minute) {
        return TimeUtility.getDateTime((Date)date, (int)MospUtility.getInt((Object)hour), (int)MospUtility.getInt((Object)minute));
    }

    public static Date getDateTime(Date date, int hour, int minute) {
        if (date == null) {
            return null;
        }
        Date dateTime = DateUtility.getDate((Date)date);
        dateTime = DateUtility.addHour((Date)dateTime, (int)hour);
        dateTime = DateUtility.addMinute((Date)dateTime, (int)minute);
        return dateTime;
    }

    public static int getMinutes(Date targetTime) throws MospException {
        return TimeUtility.getMinutes((Date)targetTime, (Date)DateUtility.getDefaultTime());
    }

    public static int getMinutes(Date targetTime, Date targetDate) throws MospException {
        if (targetTime == null || targetDate == null) {
            return 0;
        }
        long defference = targetTime.getTime() - targetDate.getTime();
        return (int)(defference / 60000L);
    }

    public static int getDifferenceMinutes(Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            return 0;
        }
        long defference = endTime.getTime() - startTime.getTime();
        return (int)(defference / 60000L);
    }

    public static Date getAttendanceTime(Date date, String time, MospParams mospParams) {
        if (!time.matches("([0-3][0-9]|[4][0-7])[0-5][0-9]")) {
            mospParams.addErrorMessage("TMW0233", new String[]{DateUtility.getStringDate((Date)date)});
            return null;
        }
        String hour = time.substring(0, 2);
        String minute = time.substring(2, 4);
        return TimeUtility.getDateTime((Date)date, (String)hour, (String)minute);
    }

    public static Date getAttendanceTime(Date date, String hour, String minute, MospParams mospParams) {
        StringBuffer sb = new StringBuffer();
        if (hour.length() == 1) {
            sb.append(0);
        }
        sb.append(hour);
        if (minute.length() == 1) {
            sb.append(0);
        }
        sb.append(minute);
        return TimeUtility.getAttendanceTime((Date)date, (String)sb.toString(), (MospParams)mospParams);
    }

    public static Date getCutoffFirstDate(int cutoffDate, int targetYear, int targetMonth) throws MospException {
        int cutoffDay = TimeUtility.adjustCutoffDay((int)cutoffDate);
        return MonthUtility.getYearMonthTermFirstDate((int)targetYear, (int)targetMonth, (int)cutoffDay);
    }

    public static Date getCutoffLastDate(int cutoffDate, int targetYear, int targetMonth) throws MospException {
        int cutoffDay = TimeUtility.adjustCutoffDay((int)cutoffDate);
        return MonthUtility.getYearMonthTermLastDate((int)targetYear, (int)targetMonth, (int)cutoffDay);
    }

    protected static int adjustCutoffDay(int cutoffDay) {
        if (cutoffDay == 0) {
            return cutoffDay;
        }
        if (cutoffDay > 15) {
            return cutoffDay;
        }
        return cutoffDay + 100;
    }

    public static Date getCutoffTermTargetDate(int cutoffDate, int targetYear, int targetMonth) throws MospException {
        return TimeUtility.getCutoffLastDate((int)cutoffDate, (int)targetYear, (int)targetMonth);
    }

    public static Date getCutoffCalculationDate(int cutoffDate, int targetYear, int targetMonth) throws MospException {
        return TimeUtility.getCutoffLastDate((int)cutoffDate, (int)targetYear, (int)targetMonth);
    }

    public static Date getCutoffMonth(int cutoffDate, Date targetDate) throws MospException {
        int cutoffDay = TimeUtility.adjustCutoffDay((int)cutoffDate);
        return MonthUtility.getTargetYearMonth((Date)targetDate, (int)cutoffDay);
    }

    public static Set<String> getTimeFunctionSet() {
        HashSet<String> set = new HashSet<String>();
        set.add("1");
        set.add("2");
        set.add("3");
        set.add("4");
        set.add("5");
        set.add("6");
        set.add("7");
        return set;
    }

    public static Date getUnlimitedDate() throws MospException {
        return DateUtility.getDate((int)5874897, (int)12, (int)31);
    }

    public static boolean isUnlimited(HolidayDataDtoInterface dto) throws MospException {
        if (dto == null) {
            return false;
        }
        return TimeUtility.isUnlimited((Date)dto.getHolidayLimitDate());
    }

    public static boolean isUnlimited(Date limitDate) throws MospException {
        return DateUtility.isSame((Date)TimeUtility.getUnlimitedDate(), (Date)limitDate);
    }

    public static List<Date> getDateList(Date firstDate, Date lastDate) {
        ArrayList<Date> list = new ArrayList<Date>();
        if (firstDate == null || lastDate == null) {
            return list;
        }
        Date date = (Date)firstDate.clone();
        while (!date.after(lastDate)) {
            list.add(date);
            date = DateUtility.addDay((Date)date, (int)1);
        }
        return list;
    }

    public static int getRoundMinute(int time, int type, int unit) {
        if (time <= 0 || type == 0 || unit <= 0) {
            return time;
        }
        if (type == 1 || type == 2) {
            int remainder = time % unit;
            if (remainder == 0) {
                return time;
            }
            int rounded = time - remainder;
            if (type == 1) {
                return rounded;
            }
            if (type == 2) {
                return rounded + unit;
            }
        }
        return time;
    }

    public static Date getRoundMinute(Date time, int type, int unit) {
        if (time == null) {
            return null;
        }
        long milliseconds = time.getTime();
        if (milliseconds == 0L || type == 0 || unit <= 0) {
            return time;
        }
        if (type == 1 || type == 2) {
            int millisecondsUnit = unit * 60 * 1000;
            long remainder = milliseconds % (long)millisecondsUnit;
            if (remainder == 0L) {
                return time;
            }
            long rounded = milliseconds - remainder;
            if (type == 1) {
                return new Date(rounded);
            }
            if (type == 2) {
                return new Date(rounded + (long)millisecondsUnit);
            }
        }
        return time;
    }

    public static boolean isPrescribedHoliday(String workTypeCode) {
        return "prescribed_holiday".equals(workTypeCode);
    }

    public static boolean isLegalHoliday(String workTypeCode) {
        return "legal_holiday".equals(workTypeCode);
    }

    public static boolean isHoliday(String workTypeCode) {
        return TimeUtility.isPrescribedHoliday((String)workTypeCode) || TimeUtility.isLegalHoliday((String)workTypeCode);
    }

    public static boolean isWorkOnPrescribedHoliday(String workTypeCode) {
        return "work_on_prescribed".equals(workTypeCode);
    }

    public static boolean isWorkOnLegalHoliday(String workTypeCode) {
        return "work_on_legal".equals(workTypeCode);
    }

    public static boolean isAttendanceListAvailable(MospParams mospParams) {
        return MenuUtility.isTheMenuAvailable((MospParams)mospParams, (String)"menuTimeInput", (String)"AttendanceList");
    }

    public static boolean isOvertimeRequestValid(MospParams mospParams) {
        return MenuUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"OvertimeRequest");
    }

    public static boolean isOvertimeRequestAvailable(MospParams mospParams) {
        return MenuUtility.isTheMenuAvailable((MospParams)mospParams, (String)"menuTimeInput", (String)"OvertimeRequest");
    }

    public static boolean isHolidayRequestValid(MospParams mospParams) {
        return MenuUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"HolidayRequest");
    }

    public static boolean isHolidayRequestAvailable(MospParams mospParams) {
        return MenuUtility.isTheMenuAvailable((MospParams)mospParams, (String)"menuTimeInput", (String)"HolidayRequest");
    }

    public static boolean isWorkOnHolidayRequestValid(MospParams mospParams) {
        return MenuUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"WorkOnHolidayRequest");
    }

    public static boolean isWorkOnHolidayRequestAvailable(MospParams mospParams) {
        return MenuUtility.isTheMenuAvailable((MospParams)mospParams, (String)"menuTimeInput", (String)"WorkOnHolidayRequest");
    }

    public static boolean isSubHolidayRequestValid(MospParams mospParams) {
        return MenuUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"SubHolidayRequest");
    }

    public static boolean isSubHolidayRequestAvailable(MospParams mospParams) {
        return MenuUtility.isTheMenuAvailable((MospParams)mospParams, (String)"menuTimeInput", (String)"SubHolidayRequest");
    }

    public static boolean isWorkTypeChangeRequestValid(MospParams mospParams) {
        return MenuUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"WorkTypeChangeRequest");
    }

    public static boolean isWorkTypeChangeRequestAvailable(MospParams mospParams) {
        return MenuUtility.isTheMenuAvailable((MospParams)mospParams, (String)"menuTimeInput", (String)"WorkTypeChangeRequest");
    }

    public static boolean isDifferenceRequestValid(MospParams mospParams) {
        return MenuUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"DifferenceRequest");
    }

    public static boolean isCancellationRequestValid(MospParams mospParams) {
        return MenuUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"CancellationRequest");
    }

    public static double getRoundHalfUp2(double value) {
        BigDecimal bi = new BigDecimal(String.valueOf(value));
        return bi.setScale(2, 4).doubleValue();
    }

    public static double getMinuteToHour(double minutes) {
        double dotMinutes = minutes / 60.0;
        return TimeUtility.getRoundHalfUp2((double)dotMinutes);
    }

    public static boolean isPaidHolidayRequest(HolidayRequestDtoInterface dto) {
        return TimeUtility.isTheHoliday((HolidayRequestDtoInterface)dto, (int)1, (int)1);
    }

    public static boolean isStockHolidayRequest(HolidayRequestDtoInterface dto) {
        return TimeUtility.isTheHoliday((HolidayRequestDtoInterface)dto, (int)1, (int)2);
    }

    public static boolean isTheHoliday(HolidayRequestDtoInterface dto, int holidayType1, int holidayType2) {
        return TimeUtility.isTheHoliday((HolidayRequestDtoInterface)dto, (int)holidayType1, (String)String.valueOf(holidayType2));
    }

    public static boolean isTheHoliday(HolidayRequestDtoInterface dto, int holidayType1, String holidayType2) {
        if (dto == null) {
            return false;
        }
        if (dto.getHolidayType1() != holidayType1) {
            return false;
        }
        return MospUtility.isEqual((Object)dto.getHolidayType2(), (Object)holidayType2);
    }

    public static boolean isHourlyHoliday(HolidayRequestDtoInterface dto) {
        return TimeUtility.isTheHolidayRange((HolidayRequestDtoInterface)dto, (int)4);
    }

    public static boolean isTheHolidayRange(HolidayRequestDtoInterface dto, int holidayRange) {
        return dto != null && dto.getHolidayRange() == holidayRange;
    }

    public static boolean isHolidayTimesHalf(double holidayTimes) {
        return holidayTimes == 0.5;
    }

    public static boolean isHolidayRemain(HolidayDataDtoInterface dto, double useDays, int useHours, int hoursPerDay) {
        AbstractMap.SimpleEntry remains = TimeUtility.getHolidayRemains((HolidayDataDtoInterface)dto, (double)useDays, (int)useHours, (int)hoursPerDay);
        return (Double)remains.getKey() >= 0.0 && (Integer)remains.getValue() >= 0;
    }

    public static AbstractMap.SimpleEntry<Double, Integer> getHolidayRemains(HolidayDataDtoInterface dto, double useDays, int useHours, int hoursPerDay) {
        return TimeUtility.getHolidayRemains((double)TimeUtility.getCurrentDays((HolidayDataDtoInterface)dto), (int)TimeUtility.getCurrentHours((HolidayDataDtoInterface)dto), (double)useDays, (int)useHours, (int)hoursPerDay);
    }

    public static AbstractMap.SimpleEntry<Double, Integer> getHolidayRemains(double currentDays, int currentHours, double useDays, int useHours, int hoursPerDay) {
        double remainDays = currentDays;
        int remainHours = currentHours;
        remainDays -= useDays;
        remainHours -= useHours;
        if (hoursPerDay == 0) {
            return new AbstractMap.SimpleEntry<Double, Integer>(remainDays, remainHours);
        }
        if (remainHours > 0) {
            remainDays += (double)Math.abs(remainHours / hoursPerDay);
            remainHours %= hoursPerDay;
        } else if (remainHours < 0) {
            int breakDays = Math.abs(remainHours / hoursPerDay);
            remainDays -= (double)(breakDays += remainHours % hoursPerDay == 0 ? 0 : 1);
            remainHours += breakDays * hoursPerDay;
        }
        return new AbstractMap.SimpleEntry<Double, Integer>(remainDays, remainHours);
    }

    public static double getCurrentDays(HolidayDataDtoInterface dto) {
        double currentDays = 0.0;
        if (dto == null) {
            return currentDays;
        }
        currentDays += dto.getGivingDay();
        return currentDays -= dto.getCancelDay();
    }

    public static int getCurrentHours(HolidayDataDtoInterface dto) {
        int currentHours = 0;
        if (dto == null) {
            return currentHours;
        }
        currentHours += dto.getGivingHour();
        return currentHours -= dto.getCancelHour();
    }

    public static Date getUpdateActivateDate(MospParams mospParams) {
        TimeVo vo = (TimeVo)mospParams.getVo();
        return TimeUtility.getDate((MospParams)mospParams, (String)vo.getTxtUpdateActivateYear(), (String)vo.getTxtUpdateActivateMonth(), (String)vo.getTxtUpdateActivateDay());
    }

    public static Date getDate(MospParams mospParams, String year, String month, String day) {
        try {
            return DateUtility.getDate((String)year, (String)month, (String)day);
        }
        catch (Throwable e) {
            mospParams.addErrorMessage("PFW0116", new String[0]);
            return null;
        }
    }

    public static String getStringTime(MospParams mospParams, int time, String separator, String suffix) {
        StringBuilder sb = new StringBuilder();
        int hours = TimeUtility.getHours((int)time);
        int minutes = TimeUtility.getMinutes((int)time);
        if (time < 0 && hours == 0) {
            sb.append(PlatformNamingUtility.hyphen((MospParams)mospParams));
        }
        sb.append(hours);
        sb.append(separator);
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMinimumIntegerDigits(2);
        sb.append(format.format(minutes));
        sb.append(suffix);
        return sb.toString();
    }

    public static String getStringTime(MospParams mospParams, int time, String separator) {
        return TimeUtility.getStringTime((MospParams)mospParams, (int)time, (String)separator, (String)"");
    }

    public static String getStringPeriodTime(MospParams mospParams, int time) {
        return TimeUtility.getStringTime((MospParams)mospParams, (int)time, (String)TimeNamingUtility.halfPeriod((MospParams)mospParams));
    }

    public static String getStringColonTime(MospParams mospParams, int time) {
        return TimeUtility.getStringTime((MospParams)mospParams, (int)time, (String)TimeNamingUtility.singleColon((MospParams)mospParams));
    }

    public static String getStringJpTime(MospParams mospParams, int time) {
        return TimeUtility.getStringTime((MospParams)mospParams, (int)time, (String)PlatformNamingUtility.time((MospParams)mospParams), (String)PlatformNamingUtility.minutes((MospParams)mospParams));
    }

    public static int getHours(int time) {
        return time / 60;
    }

    public static int getMinutes(int time) {
        return Math.abs(time) % 60;
    }

    public static int getTime(int hours, int minutes) {
        return hours * 60 + minutes;
    }

    public static int getTime(String hours, String minutes) {
        int intHours = MospUtility.getInt((Object)hours);
        int intMinutes = MospUtility.getInt((Object)minutes);
        return TimeUtility.getTime((int)intHours, (int)intMinutes);
    }

    public static int getTime(String hours) {
        return TimeUtility.getTime((String)hours, (String)"");
    }

    public static boolean isNullTime(Date time) throws MospException {
        return TimeUtility.isNullTime((Date)time, (Date)DateUtility.getDefaultTime());
    }

    public static boolean isNullTime(Date time, Date targetDate) throws MospException {
        return time == null || time.getTime() == targetDate.getTime();
    }
}

