/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.utils;

import java.util.Date;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MessageUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.utils.PlatformNamingUtility;
import jp.mosp.time.dto.settings.CutoffErrorListDtoInterface;
import jp.mosp.time.utils.TimeNamingUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class TimeMessageUtility {
    protected static final String MSG_CUTOFF_ERROR = "TMW0318";
    public static final String MSG_RECORD_TIME = "TMI0004";
    public static final String MSG_W_WORK_TIME_OUT_CHECK = "TMW0237";
    public static final String MSG_W_END_BEFORE_START = "TMW0280";
    public static final String MSG_ALREADY_RECORDED = "TMW0301";
    protected static final String MSG_START_NOT_RECORDED = "TMW0302";
    protected static final String MSG_OVER_LIMIT = "TMW0303";
    protected static final String MSG_W_SHORT_TIME_BOUNDARY = "TMW0321";
    protected static final String MSG_W_SHORT_TYPE_PAIR = "TMW0322";
    protected static final String MSG_W_SELF_APPROVE_FAILED = "TMW0323";
    protected static final String MSG_W_MINUTELY_ALL_HOLIDAY = "TMW0328";
    protected static final String MSG_W_NOT_REGIST_FOR_ANOTHER_ITEM = "TMW0330";
    public static final String MSG_EXIST_HOLIDAY_REQUEST = "TMW0331";
    public static final String MSG_EXIST_PAID_HOLIDAY_TRANSACTION = "TMW0332";
    public static final String MSG_DISPLAY_SETTING_DESCRIPTION = "TMI0011";
    public static final String MSG_COLOR_SETTING_DESCRIPTION = "TMI0012";

    private TimeMessageUtility() {
    }

    public static void addMessageTotalSucceed(MospParams mospParams) {
        mospParams.addMessage("PFI0001", new String[]{TimeMessageUtility.getNameTotal((MospParams)mospParams)});
    }

    public static void addMessageTotalFailed(MospParams mospParams) {
        mospParams.addMessage("PFI0002", new String[]{TimeMessageUtility.getNameTotal((MospParams)mospParams)});
    }

    public static void addErrorCutoff(MospParams mospParams, CutoffErrorListDtoInterface dto) {
        String date = DateUtility.getStringDate((Date)dto.getDate());
        mospParams.addErrorMessage("TMW0318", new String[]{date, dto.getType(), dto.getState()});
    }

    public static void addErrorUnsetHumanInfo(MospParams mospParams, String itemName) {
        String topicPathName = MospUtility.getTopicPathName((MospParams)mospParams);
        MessageUtility.addErrorMessage((MospParams)mospParams, (String)"TMW0262", (String[])new String[]{itemName, topicPathName, PlatformNamingUtility.menuHumanManage((MospParams)mospParams)});
    }

    public static void addErrorTheMonthIsTighten(MospParams mospParams, int year, int month) {
        String rep = year + TimeMessageUtility.getNameYear((MospParams)mospParams) + month + TimeMessageUtility.getNameMonth((MospParams)mospParams);
        mospParams.addErrorMessage("TMW0272", new String[]{rep, TimeMessageUtility.getNameYearMonth((MospParams)mospParams)});
    }

    public static void addMessageRecordTimeFailed(MospParams mospParams) {
        mospParams.addMessage("PFI0005", new String[0]);
    }

    public static void addMessageRecordStartTimeFailed(MospParams mospParams) {
        mospParams.addMessage("PFI0006", new String[]{TimeMessageUtility.getNameRecordTime((MospParams)mospParams)});
    }

    public static void addMessageRecordStartWork(MospParams mospParams, String recordTime) {
        mospParams.addMessage("TMI0004", new String[]{recordTime, TimeMessageUtility.getNameStartWork((MospParams)mospParams), TimeMessageUtility.getNameRecordTime((MospParams)mospParams)});
    }

    public static void addMessageRecordEndWork(MospParams mospParams, String recordTime) {
        mospParams.addMessage("TMI0004", new String[]{recordTime, TimeMessageUtility.getNameEndWork((MospParams)mospParams), TimeMessageUtility.getNameRecordTime((MospParams)mospParams)});
    }

    public static void addMessageRecordStartRest(MospParams mospParams, String recordTime) {
        mospParams.addMessage("TMI0004", new String[]{recordTime, TimeMessageUtility.getNameStartRest((MospParams)mospParams), TimeMessageUtility.getNameRecordTime((MospParams)mospParams)});
    }

    public static void addMessageRecordEndRest(MospParams mospParams, String recordTime) {
        mospParams.addMessage("TMI0004", new String[]{recordTime, TimeMessageUtility.getNameEndRest((MospParams)mospParams), TimeMessageUtility.getNameRecordTime((MospParams)mospParams)});
    }

    public static void addMessageRecordRegularEnd(MospParams mospParams, String recordTime) {
        mospParams.addMessage("TMI0004", new String[]{recordTime, TimeMessageUtility.getNameRegularEnd((MospParams)mospParams), TimeMessageUtility.getNameRecordTime((MospParams)mospParams)});
    }

    public static void addMessageRecordRegularWork(MospParams mospParams, String recordTime) {
        mospParams.addMessage("TMI0004", new String[]{recordTime, TimeMessageUtility.getNameRegularWork((MospParams)mospParams), TimeMessageUtility.getNameRecordTime((MospParams)mospParams)});
    }

    public static void addMessageUpdateEndWork(MospParams mospParams, String recordTime) {
        mospParams.addMessage("TMI0004", new String[]{recordTime, TimeMessageUtility.getNameEndWorkTime((MospParams)mospParams), TimeMessageUtility.getNameUpdate((MospParams)mospParams)});
    }

    public static void addErrorStartWorkAlreadyRecorded(MospParams mospParams, Date targetDate) {
        mospParams.addErrorMessage("TMW0301", new String[]{DateUtility.getStringDate((Date)targetDate), TimeMessageUtility.getNameStartWork((MospParams)mospParams), TimeMessageUtility.getNameRecordTime((MospParams)mospParams)});
    }

    public static void addErrorStartRestAlreadyRecorded(MospParams mospParams, Date targetDate) {
        mospParams.addErrorMessage("TMW0301", new String[]{DateUtility.getStringDate((Date)targetDate), TimeMessageUtility.getNameStartRest((MospParams)mospParams), TimeMessageUtility.getNameRecordTime((MospParams)mospParams)});
    }

    public static void addErrorEndWorkAlreadyRecorded(MospParams mospParams, Date targetDate) {
        mospParams.addErrorMessage("TMW0301", new String[]{DateUtility.getStringDate((Date)targetDate), TimeMessageUtility.getNameEndWork((MospParams)mospParams), TimeMessageUtility.getNameRecordTime((MospParams)mospParams)});
    }

    public static void addErrorStartRestNotRecorded(MospParams mospParams, Date targetDate) {
        mospParams.addErrorMessage("TMW0302", new String[]{DateUtility.getStringDate((Date)targetDate), TimeMessageUtility.getNameEndRest((MospParams)mospParams), TimeMessageUtility.getNameStartRest((MospParams)mospParams), TimeMessageUtility.getNameRecordTime((MospParams)mospParams)});
    }

    public static void addErrorEndRestNotRecorded(MospParams mospParams, Date targetDate) {
        mospParams.addErrorMessage("TMW0302", new String[]{DateUtility.getStringDate((Date)targetDate), TimeMessageUtility.getNameEndWork((MospParams)mospParams), TimeMessageUtility.getNameEndRest((MospParams)mospParams), TimeMessageUtility.getNameRecordTime((MospParams)mospParams)});
    }

    public static void addErrorStratWorkNotRecorded(MospParams mospParams, Date targetDate, String process) {
        mospParams.addErrorMessage("TMW0302", new String[]{DateUtility.getStringDate((Date)targetDate), process, TimeMessageUtility.getNameStartWork((MospParams)mospParams), TimeMessageUtility.getNameRecordTime((MospParams)mospParams)});
    }

    public static void addErrorRestOverLimit(MospParams mospParams, Date targetDate) {
        mospParams.addErrorMessage("TMW0303", new String[]{DateUtility.getStringDate((Date)targetDate), TimeMessageUtility.getNameStartRest((MospParams)mospParams), TimeMessageUtility.getNameRecordTime((MospParams)mospParams)});
    }

    public static void addErrorTimeFormat(MospParams mospParams, String targetName) {
        mospParams.addErrorMessage("TMW0233", new String[]{targetName});
    }

    public static void addErrorShort1TimeBoundary(MospParams mospParams) {
        mospParams.addErrorMessage("TMW0321", new String[]{TimeMessageUtility.getNameShort1Time((MospParams)mospParams), TimeMessageUtility.getNameStartTime((MospParams)mospParams), TimeMessageUtility.getNameStartWorkTime((MospParams)mospParams)});
    }

    public static void addErrorShort2TimeBoundary(MospParams mospParams) {
        mospParams.addErrorMessage("TMW0321", new String[]{TimeMessageUtility.getNameShort2Time((MospParams)mospParams), TimeMessageUtility.getNameEndTime((MospParams)mospParams), TimeMessageUtility.getNameEndWorkTime((MospParams)mospParams)});
    }

    public static void addErrorShortTypePair(MospParams mospParams) {
        mospParams.addErrorMessage("TMW0322", new String[0]);
    }

    public static void addErrorSelfApproveFailed(MospParams mospParams) {
        mospParams.addErrorMessage("TMW0323", new String[0]);
    }

    public static void addErrorShort1EndBeforeStart(MospParams mospParams) {
        mospParams.addErrorMessage("TMW0280", new String[]{TimeMessageUtility.getNameShort1Time((MospParams)mospParams), TimeMessageUtility.getNameShort1Time((MospParams)mospParams)});
    }

    public static void addErrorShort2EndBeforeStart(MospParams mospParams) {
        mospParams.addErrorMessage("TMW0280", new String[]{TimeMessageUtility.getNameShort2Time((MospParams)mospParams), TimeMessageUtility.getNameShort2Time((MospParams)mospParams)});
    }

    public static void addErrorActivateDateEndBeforeStart(MospParams mospParams) {
        mospParams.addErrorMessage("TMW0280", new String[]{TimeMessageUtility.getNameActivateDate((MospParams)mospParams), TimeMessageUtility.getNameActivateDate((MospParams)mospParams)});
    }

    public static void addErrorShort1OutOfWorkTime(MospParams mospParams) {
        mospParams.addErrorMessage("TMW0237", new String[]{TimeMessageUtility.getNameShort1Time((MospParams)mospParams)});
    }

    public static void addErrorShort2OutOfWorkTime(MospParams mospParams) {
        mospParams.addErrorMessage("TMW0237", new String[]{TimeMessageUtility.getNameShort2Time((MospParams)mospParams)});
    }

    public static void addErrorMinutelyAOutOfWorkTime(MospParams mospParams) {
        mospParams.addErrorMessage("TMW0310", new String[]{TimeMessageUtility.getNameMinutelyHolidayA((MospParams)mospParams), TimeMessageUtility.getNamePrescribedWorkTime((MospParams)mospParams)});
    }

    public static void addErrorMinutelyBOutOfWorkTime(MospParams mospParams) {
        mospParams.addErrorMessage("TMW0310", new String[]{TimeMessageUtility.getNameMinutelyHolidayB((MospParams)mospParams), TimeMessageUtility.getNamePrescribedWorkTime((MospParams)mospParams)});
    }

    public static void addErrorMinutelyAllHoliday(MospParams mospParams) {
        mospParams.addErrorMessage("TMW0328", new String[0]);
    }

    public static void addErrorNotApplicableForHoliday(MospParams mospParams, Date targetDate, Integer row) {
        mospParams.addErrorMessage("TMW0279", new String[]{TimeMessageUtility.getRowedFieldName((MospParams)mospParams, (String)DateUtility.getStringDate((Date)targetDate), (Integer)row), TimeMessageUtility.getNameVacation((MospParams)mospParams), TimeMessageUtility.getNameWorkManage((MospParams)mospParams)});
    }

    public static void addErrorAlreadyApplyWork(MospParams mospParams, Date targetDate, Integer row) {
        mospParams.addErrorMessage("TMW0240", new String[]{TimeMessageUtility.getRowedFieldName((MospParams)mospParams, (String)DateUtility.getStringDate((Date)targetDate), (Integer)row), TimeMessageUtility.getNameWorkManage((MospParams)mospParams), TimeMessageUtility.getNameWorkDate((MospParams)mospParams)});
    }

    public static void addErrorWorkTimeOrderInvalid(MospParams mospParams, Integer row) {
        TimeMessageUtility.addErrorTimeOrderInvalid((MospParams)mospParams, (String)TimeMessageUtility.getNameStartWorkTime((MospParams)mospParams), (String)TimeMessageUtility.getNameEndWorkTime((MospParams)mospParams), (Integer)row);
    }

    public static void addErrorRestTimeOrderInvalid(MospParams mospParams, Integer row) {
        TimeMessageUtility.addErrorTimeOrderInvalid((MospParams)mospParams, (String)TimeMessageUtility.getNameStartRest((MospParams)mospParams), (String)TimeMessageUtility.getNameEndRest((MospParams)mospParams), (Integer)row);
    }

    public static void addErrorTimeOrderInvalid(MospParams mospParams, String beforeName, String afterName, Integer row) {
        mospParams.addErrorMessage("PFW0217", new String[]{TimeMessageUtility.getRowedFieldName((MospParams)mospParams, (String)afterName, (Integer)row), beforeName});
    }

    public static void addErrorAnotherItemInvalid(MospParams mospParams) {
        mospParams.addErrorMessage("TMW0330", new String[0]);
    }

    public static void addErrorNoDeleteForHolidayRequest(MospParams mospParams, Date acquisitionDate, Date requestDate) {
        String[] rep = new String[]{DateUtility.getStringDate((Date)acquisitionDate), DateUtility.getStringDate((Date)requestDate)};
        mospParams.addErrorMessage("TMW0331", rep);
    }

    public static void addErrorHalfHolidayInvalid(MospParams mospParams, String holidayName) {
        TimeMessageUtility.addErrorHolidayRangeInvalid((MospParams)mospParams, (String)holidayName, (String)TimeNamingUtility.halfHoliday((MospParams)mospParams));
    }

    public static void addErrorHourlyHolidayInvalid(MospParams mospParams, String holidayName) {
        TimeMessageUtility.addErrorHolidayRangeInvalid((MospParams)mospParams, (String)holidayName, (String)TimeNamingUtility.hourlyHoliday((MospParams)mospParams));
    }

    public static void addErrorHolidayRangeInvalid(MospParams mospParams, String holidayName, String holidayRange) {
        StringBuilder range = new StringBuilder(holidayRange);
        range.append(PlatformNamingUtility.application((MospParams)mospParams));
        MessageUtility.addErrorMessage((MospParams)mospParams, (String)"TMW0245", (String[])new String[]{holidayName, range.toString(), TimeNamingUtility.holidayType((MospParams)mospParams)});
    }

    public static void addErrorHalfAndHourlyHoliday(MospParams mospParams) {
        StringBuilder range = new StringBuilder(TimeNamingUtility.halfHoliday((MospParams)mospParams));
        range.append(TimeNamingUtility.and((MospParams)mospParams));
        range.append(TimeNamingUtility.hourlyHoliday((MospParams)mospParams));
        StringBuilder application = new StringBuilder(TimeNamingUtility.same((MospParams)mospParams));
        application.append(PlatformNamingUtility.day((MospParams)mospParams));
        application.append(TimeNamingUtility.in((MospParams)mospParams));
        application.append(PlatformNamingUtility.application((MospParams)mospParams));
        StringBuilder correction = new StringBuilder(TimeNamingUtility.holidayDate((MospParams)mospParams));
        correction.append(TimeNamingUtility.or((MospParams)mospParams));
        correction.append(TimeNamingUtility.holidayRange((MospParams)mospParams));
        MessageUtility.addErrorMessage((MospParams)mospParams, (String)"TMW0245", (String[])new String[]{range.toString(), application.toString(), correction.toString()});
    }

    public static void addErrorNoDeleteForPaidHolidayTransaction(MospParams mospParams, Date acquisitionDate, Date activateDate) {
        String[] rep = new String[]{DateUtility.getStringDate((Date)acquisitionDate), DateUtility.getStringDate((Date)activateDate)};
        mospParams.addErrorMessage("TMW0332", rep);
    }

    public static String getLimitSettingDescription(MospParams mospParams) {
        return mospParams.getMessage("TMI0011", new String[]{TimeNamingUtility.overtimeRequestScreen((MospParams)mospParams), TimeNamingUtility.applicableTime((MospParams)mospParams)});
    }

    public static String getAttentionSettingDescription(MospParams mospParams) {
        return mospParams.getMessage("TMI0012", new String[]{TimeNamingUtility.attendanceListScreen((MospParams)mospParams), TimeNamingUtility.overtimeOutAbbr((MospParams)mospParams), PlatformNamingUtility.yellow((MospParams)mospParams)});
    }

    public static String getWarningSettingDescription(MospParams mospParams) {
        return mospParams.getMessage("TMI0012", new String[]{TimeNamingUtility.attendanceListScreen((MospParams)mospParams), TimeNamingUtility.overtimeOutAbbr((MospParams)mospParams), PlatformNamingUtility.red((MospParams)mospParams)});
    }

    protected static String getRowedFieldName(MospParams mospParams, String fieldName, Integer row) {
        return MessageUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row);
    }

    public static String getNameWorkManage(MospParams mospParams) {
        return mospParams.getName("WorkManage");
    }

    public static String getNameVacation(MospParams mospParams) {
        return mospParams.getName("Vacation");
    }

    public static String getNameWorkDate(MospParams mospParams) {
        return mospParams.getName("Work", new String[]{"Day"});
    }

    public static String getNameWorkType(MospParams mospParams) {
        return mospParams.getName("Work", new String[]{"Form"});
    }

    protected static String getNameTotal(MospParams mospParams) {
        return mospParams.getName("Total");
    }

    protected static String getNameYearMonth(MospParams mospParams) {
        return mospParams.getName("Year", new String[]{"Month"});
    }

    protected static String getNameYear(MospParams mospParams) {
        return mospParams.getName("Year");
    }

    protected static String getNameMonth(MospParams mospParams) {
        return mospParams.getName("Month");
    }

    protected static String getNameRecordTime(MospParams mospParams) {
        return mospParams.getName("RecordTime");
    }

    protected static String getNameUpdate(MospParams mospParams) {
        return mospParams.getName("Update");
    }

    protected static String getNameStartWork(MospParams mospParams) {
        return mospParams.getName("StartWork");
    }

    public static String getNameEndWork(MospParams mospParams) {
        return mospParams.getName("EndWork");
    }

    public static String getNameStartRest(MospParams mospParams) {
        return mospParams.getName("RestTime", new String[]{"Into"});
    }

    public static String getNameEndRest(MospParams mospParams) {
        return mospParams.getName("RestTime", new String[]{"Return"});
    }

    public static String getNameRegularEnd(MospParams mospParams) {
        return mospParams.getName("RegularTime", new String[]{"EndWork"});
    }

    public static String getNameOverEnd(MospParams mospParams) {
        return mospParams.getName("OvertimeWork", new String[]{"EffectivenessExistence", "EndWork"});
    }

    protected static String getNameRegularWork(MospParams mospParams) {
        return mospParams.getName("GoingWork");
    }

    protected static String getNameRest1Time(MospParams mospParams) {
        return mospParams.getName("Rest1");
    }

    protected static String getNameRest2Time(MospParams mospParams) {
        return mospParams.getName("Rest2");
    }

    protected static String getNameShort1Time(MospParams mospParams) {
        return mospParams.getName("ShortTime", new String[]{"Time", "No1"});
    }

    protected static String getNameShort2Time(MospParams mospParams) {
        return mospParams.getName("ShortTime", new String[]{"Time", "No2"});
    }

    protected static String getNameMinutelyHolidayA(MospParams mospParams) {
        return mospParams.getName("MinutelyHolidayA");
    }

    protected static String getNameMinutelyHolidayB(MospParams mospParams) {
        return mospParams.getName("MinutelyHolidayB");
    }

    protected static String getNamePrescribedWorkTime(MospParams mospParams) {
        return mospParams.getName("Prescribed", new String[]{"Labor", "Time"});
    }

    public static String getNameStartTime(MospParams mospParams) {
        return mospParams.getName("Start", new String[]{"Moment"});
    }

    public static String getNameEndTime(MospParams mospParams) {
        return mospParams.getName("End", new String[]{"Moment"});
    }

    public static String getNameStartWorkTime(MospParams mospParams) {
        return mospParams.getName("StartWork", new String[]{"Moment"});
    }

    public static String getNameEndWorkTime(MospParams mospParams) {
        return mospParams.getName("EndWork", new String[]{"Moment"});
    }

    public static String getNameRest(MospParams mospParams) {
        return mospParams.getName("RestTime");
    }

    public static String getNameActivateDate(MospParams mospParams) {
        return mospParams.getName("ActivateDate");
    }
}

