/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.bean.WorkTypePatternCardBeanInterface;
import jp.mosp.time.bean.WorkTypePatternItemReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypePatternReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypePatternRegistBeanInterface;
import jp.mosp.time.dto.settings.WorkTypePatternDtoInterface;
import jp.mosp.time.dto.settings.WorkTypePatternItemDtoInterface;
import jp.mosp.time.settings.base.TimeSettingAction;
import jp.mosp.time.settings.vo.WorkTypePatternCardVo;

public class WorkTypePatternCardAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM5820";
    public static final String CMD_SELECT_SHOW = "TM5821";
    public static final String CMD_REGIST = "TM5825";
    public static final String CMD_DELETE = "TM5827";
    public static final String CMD_SET_ACTIVATION_DATE = "TM5870";
    public static final String CMD_INSERT_MODE = "TM5871";
    public static final String CMD_ADD_MODE = "TM5873";
    protected static final String CODE_KEY_ADDONS = "WorkTypePatternAddons";

    protected BaseVo getSpecificVo() {
        return new WorkTypePatternCardVo();
    }

    protected BaseVo prepareVo(boolean useStoredVo, boolean useParametersMapper) throws MospException {
        BaseVo vo = super.prepareVo(useStoredVo, useParametersMapper);
        if (!useParametersMapper) {
            return vo;
        }
        for (WorkTypePatternCardBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.mapping();
        }
        return vo;
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_MODE)) {
            this.prepareVo();
            this.addMode();
        }
    }

    protected void show() throws MospException {
        this.insertMode();
    }

    protected void regist() throws MospException {
        WorkTypePatternCardVo vo = (WorkTypePatternCardVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("add")) {
            this.add();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        WorkTypePatternCardVo vo = (WorkTypePatternCardVo)this.mospParams.getVo();
        WorkTypePatternRegistBeanInterface regist = this.time().workTypePatternRegist();
        WorkTypePatternDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        this.time().workTypePatternItemRegist().insert(vo.getTxtPatternCode(), this.getActivateDate(), this.getInt(vo.getPltEditInactivate()), vo.getJsPltSelectSelected());
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertNewMessage();
        this.setEditUpdateMode(dto.getPatternCode(), dto.getActivateDate());
    }

    protected void add() throws MospException {
        WorkTypePatternCardVo vo = (WorkTypePatternCardVo)this.mospParams.getVo();
        WorkTypePatternRegistBeanInterface regist = this.time().workTypePatternRegist();
        WorkTypePatternDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.add(dto);
        this.time().workTypePatternItemRegist().add(vo.getTxtPatternCode(), this.getActivateDate(), this.getInt(vo.getPltEditInactivate()), vo.getJsPltSelectSelected());
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertHistoryMessage();
        this.setEditUpdateMode(dto.getPatternCode(), dto.getActivateDate());
    }

    protected void update() throws MospException {
        WorkTypePatternCardVo vo = (WorkTypePatternCardVo)this.mospParams.getVo();
        WorkTypePatternRegistBeanInterface regist = this.time().workTypePatternRegist();
        WorkTypePatternDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.update(dto);
        this.time().workTypePatternItemRegist().update(vo.getTxtPatternCode(), this.getActivateDate(), this.getInt(vo.getPltEditInactivate()), vo.getJsPltSelectSelected());
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.setEditUpdateMode(dto.getPatternCode(), dto.getActivateDate());
    }

    protected void delete() throws MospException {
        WorkTypePatternCardVo vo = (WorkTypePatternCardVo)this.mospParams.getVo();
        WorkTypePatternRegistBeanInterface regist = this.time().workTypePatternRegist();
        WorkTypePatternDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        this.time().workTypePatternRegist().delete(dto);
        this.time().workTypePatternItemRegist().delete(vo.getTxtPatternCode(), this.getActivateDate());
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteMessage();
        this.insertMode();
    }

    protected void setActivationDate() throws MospException {
        WorkTypePatternCardVo vo = (WorkTypePatternCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            this.setModeActivateDate("fixed");
        } else {
            this.setModeActivateDate("chaning");
        }
        this.setPulldown();
    }

    protected void insertMode() throws MospException {
        this.setEditInsertMode();
        this.setDefaultValues();
        this.setModeActivateDate("chaning");
        this.setPulldown();
    }

    protected void addMode() {
        this.setEditAddMode();
        this.setModeActivateDate("chaning");
    }

    protected void editMode() throws MospException {
        this.setDefaultValues();
        this.setEditUpdateMode(this.getTransferredCode(), this.getDate(this.getTransferredActivateDate()));
    }

    protected void setEditUpdateMode(String patternCode, Date activateDate) throws MospException {
        WorkTypePatternReferenceBeanInterface reference = this.timeReference().workTypePattern();
        WorkTypePatternItemReferenceBeanInterface itemReference = this.timeReference().workTypePatternItem();
        WorkTypePatternDtoInterface dto = reference.findForKey(patternCode, activateDate);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        this.setVoFields(itemReference.getWorkTypePatternItemList(dto.getPatternCode(), dto.getActivateDate()));
        this.setModeActivateDate("fixed");
        this.setPulldown();
        this.setEditUpdateMode(reference.getWorkTypePatternHistory(patternCode));
    }

    public void setDefaultValues() throws MospException {
        WorkTypePatternCardVo vo = (WorkTypePatternCardVo)this.mospParams.getVo();
        vo.setTxtPatternCode("");
        vo.setTxtPatternName("");
        vo.setTxtPatternAbbr("");
        vo.setJsPltSelectSelected(new String[0]);
        vo.setAddonJsps(this.getAddonJsps());
        vo.setAddonParams(new HashMap());
        vo.setAddonArrays(new HashMap());
        for (WorkTypePatternCardBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.initVoFields();
        }
    }

    protected void setPulldown() throws MospException {
        WorkTypePatternCardVo vo = (WorkTypePatternCardVo)this.mospParams.getVo();
        vo.setJsPltSelectTable(new String[0][0]);
        if (vo.getModeActivateDate().equals("fixed")) {
            int targetYear = this.getInt(vo.getTxtEditActivateYear());
            int targetMonth = this.getInt(vo.getTxtEditActivateMonth());
            Date targetDate = MonthUtility.getYearMonthTargetDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
            vo.setJsPltSelectTable(this.timeReference().workType().getNameTimeSelectArray(targetDate));
            for (WorkTypePatternCardBeanInterface addonBean : this.getAddonBeans()) {
                addonBean.setPulldown();
            }
        }
    }

    protected void setDtoFields(WorkTypePatternDtoInterface dto) throws MospException {
        WorkTypePatternCardVo vo = (WorkTypePatternCardVo)this.mospParams.getVo();
        dto.setTmmWorkTypePatternId(vo.getRecordId());
        dto.setActivateDate(this.getActivateDate());
        dto.setPatternCode(vo.getTxtPatternCode());
        dto.setPatternName(vo.getTxtPatternName());
        dto.setPatternAbbr(vo.getTxtPatternAbbr());
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
    }

    protected void setVoFields(WorkTypePatternDtoInterface dto) throws MospException {
        WorkTypePatternCardVo vo = (WorkTypePatternCardVo)this.mospParams.getVo();
        vo.setRecordId(dto.getTmmWorkTypePatternId());
        vo.setTxtEditActivateYear(this.getStringYear(dto.getActivateDate()));
        vo.setTxtEditActivateMonth(this.getStringMonth(dto.getActivateDate()));
        vo.setTxtEditActivateDay(this.getStringDay(dto.getActivateDate()));
        vo.setTxtPatternCode(dto.getPatternCode());
        vo.setTxtPatternName(dto.getPatternName());
        vo.setTxtPatternAbbr(dto.getPatternAbbr());
        vo.setPltEditInactivate(Integer.toString(dto.getInactivateFlag()));
        for (WorkTypePatternCardBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.setVoFields();
        }
    }

    protected void setVoFields(List<WorkTypePatternItemDtoInterface> list) {
        WorkTypePatternCardVo vo = (WorkTypePatternCardVo)this.mospParams.getVo();
        String[] jsPltSelectSelected = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            WorkTypePatternItemDtoInterface dto = list.get(i);
            jsPltSelectSelected[i] = dto.getWorkTypeCode();
        }
        vo.setJsPltSelectSelected(jsPltSelectSelected);
    }

    protected Date getActivateDate() {
        WorkTypePatternCardVo vo = (WorkTypePatternCardVo)this.mospParams.getVo();
        int targetYear = this.getInt(vo.getTxtEditActivateYear());
        int targetMonth = this.getInt(vo.getTxtEditActivateMonth());
        return MonthUtility.getYearMonthDate((int)targetYear, (int)targetMonth);
    }

    protected List<WorkTypePatternCardBeanInterface> getAddonBeans() throws MospException {
        ArrayList<WorkTypePatternCardBeanInterface> addonBeans = new ArrayList<WorkTypePatternCardBeanInterface>();
        for (String[] addon : this.getCodeArray(CODE_KEY_ADDONS, false)) {
            String addonBean = addon[0];
            if (MospUtility.isEmpty((String[])new String[]{addonBean})) continue;
            WorkTypePatternCardBeanInterface bean = (WorkTypePatternCardBeanInterface)this.platform().createBean(addonBean);
            addonBeans.add(bean);
        }
        return addonBeans;
    }

    protected List<String> getAddonJsps() {
        ArrayList<String> addonJsps = new ArrayList<String>();
        for (String[] addon : this.getCodeArray(CODE_KEY_ADDONS, false)) {
            String addonJsp = addon[1];
            if (MospUtility.isEmpty((String[])new String[]{addonJsp})) continue;
            addonJsps.add(addonJsp);
        }
        return addonJsps;
    }

    protected void registAddon() throws MospException {
        for (WorkTypePatternCardBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.regist();
        }
    }
}

