/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.time.base.TimeBeanHandlerInterface;
import jp.mosp.time.bean.TimeSettingSearchBeanInterface;
import jp.mosp.time.comparator.settings.TimeSettingMasterWorkSettingCodeComparator;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.settings.base.TimeSettingAction;
import jp.mosp.time.settings.vo.TimeSettingListVo;

public class TimeSettingListAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM5110";
    public static final String CMD_SEARCH = "TM5112";
    public static final String CMD_RE_SHOW = "TM5113";
    public static final String CMD_SORT = "TM5118";
    public static final String CMD_PAGE = "TM5119";
    public static final String CMD_SET_ACTIVATION_DATE = "TM5180";
    public static final String CMD_BATCH_UPDATE = "TM5185";

    public TimeSettingListAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new TimeSettingListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        }
    }

    protected void show() throws MospException {
        TimeSettingListVo vo = (TimeSettingListVo)this.mospParams.getVo();
        this.initTimeSettingVoFields();
        vo.setTxtSearchTimeSettingCode("");
        vo.setTxtSearchTimeSettingName("");
        vo.setTxtSearchTimeSettingAbbr("");
        vo.setPltSearchCutoffDate("");
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(TimeSettingMasterWorkSettingCodeComparator.class.getName());
        vo.setModeActivateDate("fixed");
        vo.setAryPltSearchCutoffDate(this.timeReference().cutoff().getSelectArray(this.getSearchActivateDate()));
    }

    protected void search() throws MospException {
        TimeSettingListVo vo = (TimeSettingListVo)this.mospParams.getVo();
        TimeSettingSearchBeanInterface search = this.timeReference().timeSettingSearch();
        search.setActivateDate(this.getSearchActivateDate());
        search.setWorkSettingCode(vo.getTxtSearchTimeSettingCode());
        search.setWorkSettingName(vo.getTxtSearchTimeSettingName());
        search.setWorkSettingAbbr(vo.getTxtSearchTimeSettingAbbr());
        search.setCutoffCode(vo.getPltSearchCutoffDate());
        search.setInactivateFlag(vo.getPltSearchInactivate());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(TimeSettingMasterWorkSettingCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        this.initCkbSelect();
        if (list.size() == 0) {
            this.addNoSearchResultMessage();
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void batchUpdate() throws MospException {
        TimeSettingListVo vo = (TimeSettingListVo)this.mospParams.getVo();
        TimeBeanHandlerInterface time = this.time();
        time.timeSettingRegist().update(this.getIdArray(vo.getCkbSelect()), this.getUpdateActivateDate(), this.getInt(vo.getPltUpdateInactivate()));
        this.doAdditionalLogic("AdditionalTimeSettingUpdate");
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.setSearchActivateDate(this.getUpdateActivateDate());
        vo.setAryPltSearchCutoffDate(this.timeReference().cutoff().getSelectArray(this.getSearchActivateDate()));
        vo.setPltSearchCutoffDate("");
        this.search();
    }

    protected void setActivationDate() throws MospException {
        TimeSettingListVo vo = (TimeSettingListVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
            vo.setAryPltSearchCutoffDate(this.timeReference().cutoff().getSelectArray(this.getSearchActivateDate()));
        } else {
            vo.setModeActivateDate("chaning");
            vo.setAryPltSearchCutoffDate(this.getInputActivateDatePulldown());
        }
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        TimeSettingListVo vo = (TimeSettingListVo)this.mospParams.getVo();
        long[] aryCkbRecordId = new long[list.size()];
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblTimeSettingCode = new String[list.size()];
        String[] aryLblTimeSettingName = new String[list.size()];
        String[] aryLblTimeSettingAbbr = new String[list.size()];
        String[] aryLblCutoff = new String[list.size()];
        String[] aryLblTimeSettingInactivate = new String[list.size()];
        String[][] cutoffDateArray = this.timeReference().cutoff().getSelectArray(this.getSearchActivateDate());
        for (int i = 0; i < list.size(); ++i) {
            TimeSettingDtoInterface dto = (TimeSettingDtoInterface)list.get(i);
            aryCkbRecordId[i] = dto.getTmmTimeSettingId();
            aryLblActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryLblTimeSettingCode[i] = dto.getWorkSettingCode();
            aryLblTimeSettingName[i] = dto.getWorkSettingName();
            aryLblTimeSettingAbbr[i] = dto.getWorkSettingAbbr();
            aryLblCutoff[i] = this.getCodeName(dto.getCutoffCode(), cutoffDateArray);
            aryLblTimeSettingInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
        }
        vo.setAryCkbRecordId(aryCkbRecordId);
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblSettingCode(aryLblTimeSettingCode);
        vo.setAryLblSettingName(aryLblTimeSettingName);
        vo.setAryLblSettingAbbr(aryLblTimeSettingAbbr);
        vo.setAryLblCutoff(aryLblCutoff);
        vo.setAryLblInactivate(aryLblTimeSettingInactivate);
    }
}

