/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.time.bean.LimitStandardRegistBeanInterface;
import jp.mosp.time.bean.TimeSettingBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.bean.TimeSettingRegistBeanInterface;
import jp.mosp.time.dto.settings.LimitStandardDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.entity.TimeSettingEntityInterface;
import jp.mosp.time.settings.base.TimeSettingAction;
import jp.mosp.time.settings.vo.TimeSettingCardVo;

public class TimeSettingCardAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM5120";
    public static final String CMD_SELECT_SHOW = "TM5121";
    public static final String CMD_REGIST = "TM5125";
    public static final String CMD_DELETE = "TM5127";
    public static final String CMD_SET_ACTIVATION_DATE = "TM5170";
    public static final String CMD_INSERT_MODE = "TM5171";
    public static final String CMD_ADD_MODE = "TM5173";
    public static final String CMD_REPLICATION_MODE = "TM5176";
    protected static final String CODE_KEY_ADDONS = "TimeSettingAddons";

    protected BaseVo getSpecificVo() {
        return new TimeSettingCardVo();
    }

    protected BaseVo prepareVo(boolean useStoredVo, boolean useParametersMapper) throws MospException {
        BaseVo vo = super.prepareVo(useStoredVo, useParametersMapper);
        if (!useParametersMapper) {
            return vo;
        }
        for (TimeSettingBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.mapping();
        }
        return vo;
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(true, false);
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_MODE)) {
            this.prepareVo();
            this.addMode();
        } else if (this.mospParams.getCommand().equals(CMD_REPLICATION_MODE)) {
            this.prepareVo();
            this.replicationMode();
        }
    }

    protected void show() throws MospException {
        this.insertMode();
    }

    protected void regist() throws MospException {
        TimeSettingCardVo vo = (TimeSettingCardVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("add")) {
            this.add();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        TimeSettingRegistBeanInterface regist = this.time().timeSettingRegist();
        TimeSettingDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        LimitStandardRegistBeanInterface limitRegist = this.time().limitStandardRegist();
        limitRegist.regist((Collection)this.getLimitDtos(limitRegist));
        this.registAddon();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertNewMessage();
        this.setEditUpdateMode(dto.getWorkSettingCode(), dto.getActivateDate());
    }

    protected void add() throws MospException {
        TimeSettingRegistBeanInterface regist = this.time().timeSettingRegist();
        TimeSettingDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.add(dto);
        LimitStandardRegistBeanInterface limitRegist = this.time().limitStandardRegist();
        limitRegist.regist((Collection)this.getLimitDtos(limitRegist));
        this.registAddon();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertHistoryMessage();
        this.setEditUpdateMode(dto.getWorkSettingCode(), dto.getActivateDate());
    }

    protected void update() throws MospException {
        TimeSettingRegistBeanInterface regist = this.time().timeSettingRegist();
        TimeSettingDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.update(dto);
        LimitStandardRegistBeanInterface limitRegist = this.time().limitStandardRegist();
        limitRegist.regist((Collection)this.getLimitDtos(limitRegist));
        this.registAddon();
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.setEditUpdateMode(dto.getWorkSettingCode(), dto.getActivateDate());
    }

    protected void delete() throws MospException {
        this.time().timeSettingRegist().delete(this.getRecordId());
        this.time().limitStandardRegist().delete(this.getSettingCode(), this.getEditActivateDate());
        for (TimeSettingBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.delete();
        }
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteMessage();
        this.insertMode();
    }

    protected void setEditUpdateMode(String settingCode, Date activateDate) throws MospException {
        TimeSettingCardVo vo = (TimeSettingCardVo)this.mospParams.getVo();
        this.setDefaultValues();
        TimeSettingReferenceBeanInterface timeSetting = this.timeReference().timeSetting();
        TimeSettingEntityInterface entity = timeSetting.getEntityForKey(settingCode, activateDate);
        this.checkSelectedDataExist((Object)entity.getTimeSettingDto());
        this.setVoFields(entity.getTimeSettingDto());
        this.setLimitVoFields(entity);
        for (TimeSettingBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.setVoFields();
        }
        this.setEditUpdateMode(timeSetting.getTimeSettingHistory(settingCode));
        vo.setModeActivateDate("fixed");
        this.setPulldown();
        this.setCutoffPulldouwn();
    }

    protected void setActivationDate() throws MospException {
        TimeSettingCardVo vo = (TimeSettingCardVo)this.mospParams.getVo();
        TimeSettingReferenceBeanInterface timeSetting = this.timeReference().timeSetting();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setCutoffPulldouwn();
        TimeSettingDtoInterface timeSettingDto = timeSetting.getTimeSettingInfo(vo.getTxtSettingCode(), this.getEditActivateDate());
        if (timeSettingDto == null) {
            return;
        }
        vo.setPltCutoffDate(timeSettingDto.getCutoffCode());
    }

    protected void insertMode() throws MospException {
        this.setEditInsertMode();
        this.setDefaultValues();
        TimeSettingCardVo vo = (TimeSettingCardVo)this.mospParams.getVo();
        vo.setModeActivateDate("chaning");
        this.setPulldown();
        this.setCutoffPulldouwn();
    }

    protected void addMode() throws MospException {
        this.setEditAddMode();
        this.setModeActivateDate("chaning");
        this.setCutoffPulldouwn();
    }

    protected void editMode() throws MospException {
        this.setEditUpdateMode(this.getTransferredCode(), this.getDate(this.getTransferredActivateDate()));
    }

    protected void replicationMode() {
        this.setEditReplicationMode();
        TimeSettingCardVo vo = (TimeSettingCardVo)this.mospParams.getVo();
        vo.setTxtSettingCode("");
    }

    protected void setPulldown() {
        TimeSettingCardVo vo = (TimeSettingCardVo)this.mospParams.getVo();
        vo.setAryPltStartYear(this.getMonthArray());
        vo.setAryPltRoundingItems(this.mospParams.getProperties().getCodeArray("RoundingItems", false));
    }

    protected void setCutoffPulldouwn() throws MospException {
        TimeSettingCardVo vo = (TimeSettingCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setAryPltCutoffDate(this.getInputActivateDatePulldown());
            return;
        }
        String[][] aryPltCutoffDate = this.timeReference().cutoff().getSelectArray(this.getEditActivateDate());
        if (aryPltCutoffDate[0][0].isEmpty()) {
            vo.setModeActivateDate("chaning");
            vo.setAryPltCutoffDate(this.getInputActivateDatePulldown());
            this.mospParams.addErrorMessage("TMW0214", new String[]{this.mospParams.getName("CutoffDate")});
            return;
        }
        vo.setAryPltCutoffDate(aryPltCutoffDate);
    }

    public void setDefaultValues() throws MospException {
        TimeSettingCardVo vo = (TimeSettingCardVo)this.mospParams.getVo();
        vo.setTxtSettingCode("");
        vo.setTxtSettingName("");
        vo.setTxtSettingAbbr("");
        vo.setPltCutoffDate("");
        vo.setPltTimeManagement("0");
        vo.setPltDailyApproval("0");
        vo.setPltBeforeOverTime("0");
        vo.setPltSpecificHoliday("1");
        vo.setPltStartWeek("0");
        vo.setPltStartYear("0");
        vo.setTxtGeneralWorkTimeHour("00");
        vo.setTxtGeneralWorkTimeMinute("00");
        vo.setTxtStartDayHour("09");
        vo.setTxtStartDayMinute("00");
        vo.setTxtLateEarlyFullHour("00");
        vo.setTxtLateEarlyFullMinute("00");
        vo.setTxtLateEarlyHalfHour("00");
        vo.setTxtLateEarlyHalfMinute("00");
        vo.setTxtTransferAheadLimitMonth("0");
        vo.setTxtTransferAheadLimitDate("0");
        vo.setTxtTransferLaterLimitMonth("0");
        vo.setTxtTransferLaterLimitDate("0");
        vo.setTxtSubHolidayLimitMonth("0");
        vo.setTxtSubHolidayLimitDate("0");
        vo.setTxtSubHolidayAllNormHour("00");
        vo.setTxtSubHolidayAllNormMinute("00");
        vo.setTxtSubHolidayHalfNormHour("00");
        vo.setTxtSubHolidayHalfNormMinute("00");
        vo.setPltPortalTimeButtons("1");
        vo.setPltPortalRestButtons("1");
        vo.setPltUseScheduledTime(String.valueOf(1));
        vo.setTxtRoundDailyStart("0");
        vo.setPltRoundDailyStart("0");
        vo.setTxtRoundDailyEnd("0");
        vo.setPltRoundDailyEnd("0");
        vo.setTxtRoundDailyWork("0");
        vo.setPltRoundDailyWork("0");
        vo.setTxtRoundDailyRestStart("0");
        vo.setPltRoundDailyRestStart("0");
        vo.setTxtRoundDailyRestEnd("0");
        vo.setPltRoundDailyRestEnd("0");
        vo.setTxtRoundDailyRestTime("0");
        vo.setPltRoundDailyRestTime("0");
        vo.setTxtRoundDailyLate("0");
        vo.setPltRoundDailyLate("0");
        vo.setTxtRoundDailyLeaveEarly("0");
        vo.setPltRoundDailyLeaveEaly("0");
        vo.setTxtRoundDailyPrivateIn("0");
        vo.setPltRoundDailyPrivateIn("0");
        vo.setTxtRoundDailyPrivateOut("0");
        vo.setPltRoundDailyPrivateOut("0");
        vo.setTxtRoundDailyPublicIn("0");
        vo.setPltRoundDailyPublicIn("0");
        vo.setTxtRoundDailyPublicOut("0");
        vo.setPltRoundDailyPublicOut("0");
        vo.setTxtRoundDailyDecreaseTime("0");
        vo.setPltRoundDailyDecreaseTime("0");
        vo.setTxtRoundDailyShortUnpaid("0");
        vo.setPltRoundDailyShortUnpaid("0");
        vo.setTxtRoundMonthlyWork("0");
        vo.setPltRoundMonthlyWork("0");
        vo.setTxtRoundMonthlyRest("0");
        vo.setPltRoundMonthlyRest("0");
        vo.setTxtRoundMonthlyLate("0");
        vo.setPltRoundMonthlyLate("0");
        vo.setTxtRoundMonthlyLeaveEarly("0");
        vo.setPltRoundMonthlyLeaveEarly("0");
        vo.setTxtRoundMonthlyPrivate("0");
        vo.setPltRoundMonthlyPrivate("0");
        vo.setTxtRoundMonthlyPublic("0");
        vo.setPltRoundMonthlyPublic("0");
        vo.setTxtRoundMonthlyDecreaseTime("0");
        vo.setPltRoundMonthlyDecreaseTime("0");
        vo.setTxtRoundMonthlyShortUnpaid("0");
        vo.setPltRoundMonthlyShortUnpaid("0");
        vo.setTxtLimit1WeekHour("");
        vo.setTxtLimit1WeekMinute("");
        vo.setTxtLimit1MonthHour("");
        vo.setTxtLimit1MonthMinute("");
        vo.setTxtAttention1MonthHour("");
        vo.setTxtAttention1MonthMinute("");
        vo.setTxtWarning1MonthHour("");
        vo.setTxtWarning1MonthMinute("");
        vo.setPlt60HourFunction("0");
        vo.setPlt60HourAlternative("0");
        vo.setTxtMonth60HourSurcharge("0");
        vo.setTxtWeekdayOver("0");
        vo.setTxtWeekdayAlternative("0");
        vo.setTxtAltnativeCancel("0");
        vo.setTxtAltnativeSpecific("0");
        vo.setTxtAltnativeLegal("0");
        vo.setTxtSpecificHoliday("0");
        vo.setTxtLegalHoliday("0");
        vo.setAddonJsps(this.getAddonJsps());
        vo.setAddonParams(new HashMap());
        vo.setAddonArrays(new HashMap());
        for (TimeSettingBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.initVoFields();
        }
    }

    protected void setDtoFields(TimeSettingDtoInterface dto) throws MospException {
        TimeSettingCardVo vo = (TimeSettingCardVo)this.mospParams.getVo();
        dto.setTmmTimeSettingId(vo.getRecordId());
        dto.setActivateDate(this.getEditActivateDate());
        dto.setWorkSettingCode(this.getSettingCode());
        dto.setWorkSettingName(vo.getTxtSettingName());
        dto.setWorkSettingAbbr(vo.getTxtSettingAbbr());
        dto.setCutoffCode(vo.getPltCutoffDate());
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
        dto.setTimeManagementFlag(this.getInt(vo.getPltTimeManagement()));
        dto.setDailyApprovalFlag(this.getInt(vo.getPltDailyApproval()));
        dto.setBeforeOvertimeFlag(this.getInt(vo.getPltBeforeOverTime()));
        dto.setSpecificHolidayHandling(this.getInt(vo.getPltSpecificHoliday()));
        dto.setStartWeek(this.getInt(vo.getPltStartWeek()));
        dto.setStartMonth(0);
        dto.setStartYear(this.getInt(vo.getPltStartYear()));
        dto.setGeneralWorkTime(DateUtility.getTime((String)vo.getTxtGeneralWorkTimeHour(), (String)vo.getTxtGeneralWorkTimeMinute()));
        dto.setStartDayTime(DateUtility.getTime((String)vo.getTxtStartDayHour(), (String)vo.getTxtStartDayMinute()));
        dto.setLateEarlyFull(DateUtility.getTime((String)vo.getTxtLateEarlyFullHour(), (String)vo.getTxtLateEarlyFullMinute()));
        dto.setLateEarlyHalf(DateUtility.getTime((String)vo.getTxtLateEarlyHalfHour(), (String)vo.getTxtLateEarlyHalfMinute()));
        dto.setTransferAheadLimitMonth(this.getInt(vo.getTxtTransferAheadLimitMonth()));
        dto.setTransferAheadLimitDate(this.getInt(vo.getTxtTransferAheadLimitDate()));
        dto.setTransferLaterLimitMonth(this.getInt(vo.getTxtTransferLaterLimitMonth()));
        dto.setTransferLaterLimitDate(this.getInt(vo.getTxtTransferLaterLimitDate()));
        dto.setSubHolidayLimitMonth(this.getInt(vo.getTxtSubHolidayLimitMonth()));
        dto.setSubHolidayLimitDate(this.getInt(vo.getTxtSubHolidayLimitDate()));
        dto.setTransferExchange(0);
        dto.setSubHolidayExchange(0);
        dto.setSubHolidayAllNorm(DateUtility.getTime((String)vo.getTxtSubHolidayAllNormHour(), (String)vo.getTxtSubHolidayAllNormMinute()));
        dto.setSubHolidayHalfNorm(DateUtility.getTime((String)vo.getTxtSubHolidayHalfNormHour(), (String)vo.getTxtSubHolidayHalfNormMinute()));
        dto.setPortalTimeButtons(this.getInt(vo.getPltPortalTimeButtons()));
        dto.setPortalRestButtons(this.getInt(vo.getPltPortalRestButtons()));
        dto.setUseScheduledTime(this.getInt(vo.getPltUseScheduledTime()));
        dto.setRoundDailyStartUnit(this.getInt(vo.getTxtRoundDailyStart()));
        dto.setRoundDailyStart(this.getInt(vo.getPltRoundDailyStart()));
        dto.setRoundDailyEndUnit(this.getInt(vo.getTxtRoundDailyEnd()));
        dto.setRoundDailyEnd(this.getInt(vo.getPltRoundDailyEnd()));
        dto.setRoundDailyTimeWork(this.getInt(vo.getTxtRoundDailyWork()));
        dto.setRoundDailyWork(this.getInt(vo.getPltRoundDailyWork()));
        dto.setRoundDailyRestStartUnit(this.getInt(vo.getTxtRoundDailyRestStart()));
        dto.setRoundDailyRestStart(this.getInt(vo.getPltRoundDailyRestStart()));
        dto.setRoundDailyRestEndUnit(this.getInt(vo.getTxtRoundDailyRestEnd()));
        dto.setRoundDailyRestEnd(this.getInt(vo.getPltRoundDailyRestEnd()));
        dto.setRoundDailyRestTimeUnit(this.getInt(vo.getTxtRoundDailyRestTime()));
        dto.setRoundDailyRestTime(this.getInt(vo.getPltRoundDailyRestTime()));
        dto.setRoundDailyLateUnit(this.getInt(vo.getTxtRoundDailyLate()));
        dto.setRoundDailyLate(this.getInt(vo.getPltRoundDailyLate()));
        dto.setRoundDailyLeaveEarlyUnit(this.getInt(vo.getTxtRoundDailyLeaveEarly()));
        dto.setRoundDailyLeaveEarly(this.getInt(vo.getPltRoundDailyLeaveEaly()));
        dto.setRoundDailyPrivateStartUnit(this.getInt(vo.getTxtRoundDailyPrivateIn()));
        dto.setRoundDailyPrivateStart(this.getInt(vo.getPltRoundDailyPrivateIn()));
        dto.setRoundDailyPrivateEndUnit(this.getInt(vo.getTxtRoundDailyPrivateOut()));
        dto.setRoundDailyPrivateEnd(this.getInt(vo.getPltRoundDailyPrivateOut()));
        dto.setRoundDailyPublicStartUnit(this.getInt(vo.getTxtRoundDailyPublicIn()));
        dto.setRoundDailyPublicStart(this.getInt(vo.getPltRoundDailyPublicIn()));
        dto.setRoundDailyPublicEndUnit(this.getInt(vo.getTxtRoundDailyPublicOut()));
        dto.setRoundDailyPublicEnd(this.getInt(vo.getPltRoundDailyPublicOut()));
        dto.setRoundDailyDecreaseTimeUnit(this.getInt(vo.getTxtRoundDailyDecreaseTime()));
        dto.setRoundDailyDecreaseTime(this.getInt(vo.getPltRoundDailyDecreaseTime()));
        dto.setRoundDailyShortUnpaidUnit(this.getInt(vo.getTxtRoundDailyShortUnpaid()));
        dto.setRoundDailyShortUnpaid(this.getInt(vo.getPltRoundDailyShortUnpaid()));
        dto.setRoundMonthlyWorkUnit(this.getInt(vo.getTxtRoundMonthlyWork()));
        dto.setRoundMonthlyWork(this.getInt(vo.getPltRoundMonthlyWork()));
        dto.setRoundMonthlyRestUnit(this.getInt(vo.getTxtRoundMonthlyRest()));
        dto.setRoundMonthlyRest(this.getInt(vo.getPltRoundMonthlyRest()));
        dto.setRoundMonthlyLateUnit(this.getInt(vo.getTxtRoundMonthlyLate()));
        dto.setRoundMonthlyLate(this.getInt(vo.getPltRoundMonthlyLate()));
        dto.setRoundMonthlyEarlyUnit(this.getInt(vo.getTxtRoundMonthlyLeaveEarly()));
        dto.setRoundMonthlyEarly(this.getInt(vo.getPltRoundMonthlyLeaveEarly()));
        dto.setRoundMonthlyPrivateTime(this.getInt(vo.getTxtRoundMonthlyPrivate()));
        dto.setRoundMonthlyPrivate(this.getInt(vo.getPltRoundMonthlyPrivate()));
        dto.setRoundMonthlyPublicTime(this.getInt(vo.getTxtRoundMonthlyPublic()));
        dto.setRoundMonthlyPublic(this.getInt(vo.getPltRoundMonthlyPublic()));
        dto.setRoundMonthlyDecreaseTime(this.getInt(vo.getTxtRoundMonthlyDecreaseTime()));
        dto.setRoundMonthlyDecrease(this.getInt(vo.getPltRoundMonthlyDecreaseTime()));
        dto.setRoundMonthlyShortUnpaidUnit(this.getInt(vo.getTxtRoundMonthlyShortUnpaid()));
        dto.setRoundMonthlyShortUnpaid(this.getInt(vo.getPltRoundMonthlyShortUnpaid()));
        dto.setSixtyHourFunctionFlag(this.getInt(vo.getPlt60HourFunction()));
        dto.setSixtyHourAlternativeFlag(this.getInt(vo.getPlt60HourAlternative()));
        dto.setMonthSixtyHourSurcharge(this.getInt(vo.getTxtMonth60HourSurcharge()));
        dto.setWeekdayOver(this.getInt(vo.getTxtWeekdayOver()));
        dto.setWeekdayAlternative(this.getInt(vo.getTxtWeekdayAlternative()));
        dto.setAlternativeCancel(this.getInt(vo.getTxtAltnativeCancel()));
        dto.setAlternativeSpecific(this.getInt(vo.getTxtAltnativeSpecific()));
        dto.setAlternativeLegal(this.getInt(vo.getTxtAltnativeLegal()));
        dto.setSpecificHoliday(this.getInt(vo.getTxtSpecificHoliday()));
        dto.setLegalHoliday(this.getInt(vo.getTxtLegalHoliday()));
        dto.setProspectsMonths("");
    }

    protected Set<LimitStandardDtoInterface> getLimitDtos(LimitStandardRegistBeanInterface limitRegist) throws MospException {
        TimeSettingCardVo vo = (TimeSettingCardVo)this.mospParams.getVo();
        LinkedHashSet<LimitStandardDtoInterface> dtos = new LinkedHashSet<LimitStandardDtoInterface>();
        LimitStandardDtoInterface week1Dto = limitRegist.getInitDto();
        LimitStandardDtoInterface month1Dto = limitRegist.getInitDto();
        dtos.add(week1Dto);
        dtos.add(month1Dto);
        week1Dto.setWorkSettingCode(this.getSettingCode());
        week1Dto.setActivateDate(this.getEditActivateDate());
        week1Dto.setTerm("week1");
        week1Dto.setLimitTime(this.getTimeValue(vo.getTxtLimit1WeekHour(), vo.getTxtLimit1WeekMinute()));
        month1Dto.setWorkSettingCode(this.getSettingCode());
        month1Dto.setActivateDate(this.getEditActivateDate());
        month1Dto.setTerm("month1");
        month1Dto.setLimitTime(this.getTimeValue(vo.getTxtLimit1MonthHour(), vo.getTxtLimit1MonthMinute()));
        month1Dto.setAttentionTime(this.getTimeValue(vo.getTxtAttention1MonthHour(), vo.getTxtAttention1MonthMinute()));
        month1Dto.setWarningTime(this.getTimeValue(vo.getTxtWarning1MonthHour(), vo.getTxtWarning1MonthMinute()));
        return dtos;
    }

    protected void setVoFields(TimeSettingDtoInterface dto) {
        TimeSettingCardVo vo = (TimeSettingCardVo)this.mospParams.getVo();
        vo.setRecordId(dto.getTmmTimeSettingId());
        vo.setTxtEditActivateYear(this.getStringYear(dto.getActivateDate()));
        vo.setTxtEditActivateMonth(this.getStringMonth(dto.getActivateDate()));
        vo.setTxtEditActivateDay(this.getStringDay(dto.getActivateDate()));
        vo.setTxtSettingCode(dto.getWorkSettingCode());
        vo.setTxtSettingName(dto.getWorkSettingName());
        vo.setTxtSettingAbbr(dto.getWorkSettingAbbr());
        vo.setPltCutoffDate(dto.getCutoffCode());
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
        vo.setPltTimeManagement(String.valueOf(dto.getTimeManagementFlag()));
        vo.setPltDailyApproval(String.valueOf(dto.getDailyApprovalFlag()));
        vo.setPltBeforeOverTime(String.valueOf(dto.getBeforeOvertimeFlag()));
        vo.setPltSpecificHoliday(String.valueOf(dto.getSpecificHolidayHandling()));
        vo.setPltStartWeek(String.valueOf(dto.getStartWeek()));
        vo.setPltStartYear(String.valueOf(dto.getStartYear()));
        vo.setTxtGeneralWorkTimeHour(DateUtility.getStringHour((Date)dto.getGeneralWorkTime()));
        vo.setTxtGeneralWorkTimeMinute(DateUtility.getStringMinute((Date)dto.getGeneralWorkTime()));
        vo.setTxtStartDayHour(DateUtility.getStringHour((Date)dto.getStartDayTime()));
        vo.setTxtStartDayMinute(DateUtility.getStringMinute((Date)dto.getStartDayTime()));
        vo.setTxtLateEarlyFullHour(DateUtility.getStringHour((Date)dto.getLateEarlyFull()));
        vo.setTxtLateEarlyFullMinute(DateUtility.getStringMinute((Date)dto.getLateEarlyFull()));
        vo.setTxtLateEarlyHalfHour(DateUtility.getStringHour((Date)dto.getLateEarlyHalf()));
        vo.setTxtLateEarlyHalfMinute(DateUtility.getStringMinute((Date)dto.getLateEarlyHalf()));
        vo.setTxtTransferAheadLimitMonth(String.valueOf(dto.getTransferAheadLimitMonth()));
        vo.setTxtTransferAheadLimitDate(String.valueOf(dto.getTransferAheadLimitDate()));
        vo.setTxtTransferLaterLimitMonth(String.valueOf(dto.getTransferLaterLimitMonth()));
        vo.setTxtTransferLaterLimitDate(String.valueOf(dto.getTransferLaterLimitDate()));
        vo.setTxtSubHolidayLimitMonth(String.valueOf(dto.getSubHolidayLimitMonth()));
        vo.setTxtSubHolidayLimitDate(String.valueOf(dto.getSubHolidayLimitDate()));
        vo.setTxtSubHolidayAllNormHour(DateUtility.getStringHour((Date)dto.getSubHolidayAllNorm()));
        vo.setTxtSubHolidayAllNormMinute(DateUtility.getStringMinute((Date)dto.getSubHolidayAllNorm()));
        vo.setTxtSubHolidayHalfNormHour(DateUtility.getStringHour((Date)dto.getSubHolidayHalfNorm()));
        vo.setTxtSubHolidayHalfNormMinute(DateUtility.getStringMinute((Date)dto.getSubHolidayHalfNorm()));
        vo.setPltPortalTimeButtons(String.valueOf(dto.getPortalTimeButtons()));
        vo.setPltPortalRestButtons(String.valueOf(dto.getPortalRestButtons()));
        vo.setPltUseScheduledTime(String.valueOf(dto.getUseScheduledTime()));
        vo.setTxtRoundDailyStart(String.valueOf(dto.getRoundDailyStartUnit()));
        vo.setPltRoundDailyStart(String.valueOf(dto.getRoundDailyStart()));
        vo.setTxtRoundDailyEnd(String.valueOf(dto.getRoundDailyEndUnit()));
        vo.setPltRoundDailyEnd(String.valueOf(dto.getRoundDailyEnd()));
        vo.setTxtRoundDailyWork(String.valueOf(dto.getRoundDailyTimeWork()));
        vo.setPltRoundDailyWork(String.valueOf(dto.getRoundDailyWork()));
        vo.setTxtRoundDailyRestStart(String.valueOf(dto.getRoundDailyRestStartUnit()));
        vo.setPltRoundDailyRestStart(String.valueOf(dto.getRoundDailyRestStart()));
        vo.setTxtRoundDailyRestEnd(String.valueOf(dto.getRoundDailyRestEndUnit()));
        vo.setPltRoundDailyRestEnd(String.valueOf(dto.getRoundDailyRestEnd()));
        vo.setTxtRoundDailyRestTime(String.valueOf(dto.getRoundDailyRestTimeUnit()));
        vo.setPltRoundDailyRestTime(String.valueOf(dto.getRoundDailyRestTime()));
        vo.setTxtRoundDailyLate(String.valueOf(dto.getRoundDailyLateUnit()));
        vo.setPltRoundDailyLate(String.valueOf(dto.getRoundDailyLate()));
        vo.setTxtRoundDailyLeaveEarly(String.valueOf(dto.getRoundDailyLeaveEarlyUnit()));
        vo.setPltRoundDailyLeaveEaly(String.valueOf(dto.getRoundDailyLeaveEarly()));
        vo.setTxtRoundDailyPrivateIn(String.valueOf(dto.getRoundDailyPrivateStartUnit()));
        vo.setPltRoundDailyPrivateIn(String.valueOf(dto.getRoundDailyPrivateStart()));
        vo.setTxtRoundDailyPrivateOut(String.valueOf(dto.getRoundDailyPrivateEndUnit()));
        vo.setPltRoundDailyPrivateOut(String.valueOf(dto.getRoundDailyPrivateEnd()));
        vo.setTxtRoundDailyPublicIn(String.valueOf(dto.getRoundDailyPublicStartUnit()));
        vo.setPltRoundDailyPublicIn(String.valueOf(dto.getRoundDailyPublicStart()));
        vo.setTxtRoundDailyPublicOut(String.valueOf(dto.getRoundDailyPublicEndUnit()));
        vo.setPltRoundDailyPublicOut(String.valueOf(dto.getRoundDailyPublicEnd()));
        vo.setTxtRoundDailyDecreaseTime(String.valueOf(dto.getRoundDailyDecreaseTimeUnit()));
        vo.setPltRoundDailyDecreaseTime(String.valueOf(dto.getRoundDailyDecreaseTime()));
        vo.setTxtRoundDailyShortUnpaid(String.valueOf(dto.getRoundDailyShortUnpaidUnit()));
        vo.setPltRoundDailyShortUnpaid(String.valueOf(dto.getRoundDailyShortUnpaid()));
        vo.setTxtRoundMonthlyWork(String.valueOf(dto.getRoundMonthlyWorkUnit()));
        vo.setPltRoundMonthlyWork(String.valueOf(dto.getRoundMonthlyWork()));
        vo.setTxtRoundMonthlyRest(String.valueOf(dto.getRoundMonthlyRestUnit()));
        vo.setPltRoundMonthlyRest(String.valueOf(dto.getRoundMonthlyRest()));
        vo.setTxtRoundMonthlyLate(String.valueOf(dto.getRoundMonthlyLateUnit()));
        vo.setPltRoundMonthlyLate(String.valueOf(dto.getRoundMonthlyLate()));
        vo.setTxtRoundMonthlyLeaveEarly(String.valueOf(dto.getRoundMonthlyEarlyUnit()));
        vo.setPltRoundMonthlyLeaveEarly(String.valueOf(dto.getRoundMonthlyEarly()));
        vo.setTxtRoundMonthlyPrivate(String.valueOf(dto.getRoundMonthlyPrivateTime()));
        vo.setPltRoundMonthlyPrivate(String.valueOf(dto.getRoundMonthlyPrivate()));
        vo.setTxtRoundMonthlyPublic(String.valueOf(dto.getRoundMonthlyPublicTime()));
        vo.setPltRoundMonthlyPublic(String.valueOf(dto.getRoundMonthlyPublic()));
        vo.setTxtRoundMonthlyDecreaseTime(String.valueOf(dto.getRoundMonthlyDecreaseTime()));
        vo.setPltRoundMonthlyDecreaseTime(String.valueOf(dto.getRoundMonthlyDecrease()));
        vo.setTxtRoundMonthlyShortUnpaid(String.valueOf(dto.getRoundMonthlyShortUnpaidUnit()));
        vo.setPltRoundMonthlyShortUnpaid(String.valueOf(dto.getRoundMonthlyShortUnpaid()));
        vo.setPlt60HourFunction(String.valueOf(dto.getSixtyHourFunctionFlag()));
        vo.setPlt60HourAlternative(String.valueOf(dto.getSixtyHourAlternativeFlag()));
        vo.setTxtMonth60HourSurcharge(String.valueOf(dto.getMonthSixtyHourSurcharge()));
        vo.setTxtWeekdayOver(String.valueOf(dto.getWeekdayOver()));
        vo.setTxtWeekdayAlternative(String.valueOf(dto.getWeekdayAlternative()));
        vo.setTxtAltnativeCancel(String.valueOf(dto.getAlternativeCancel()));
        vo.setTxtAltnativeSpecific(String.valueOf(dto.getAlternativeSpecific()));
        vo.setTxtAltnativeLegal(String.valueOf(dto.getAlternativeLegal()));
        vo.setTxtSpecificHoliday(String.valueOf(dto.getSpecificHoliday()));
        vo.setTxtLegalHoliday(String.valueOf(dto.getLegalHoliday()));
    }

    protected void setLimitVoFields(TimeSettingEntityInterface entity) {
        TimeSettingCardVo vo = (TimeSettingCardVo)this.mospParams.getVo();
        vo.setTxtLimit1WeekHour(entity.getOneWeekLimitHours());
        vo.setTxtLimit1WeekMinute(entity.getOneWeekLimitMinutes());
        vo.setTxtLimit1MonthHour(entity.getOneMonthLimitHours());
        vo.setTxtLimit1MonthMinute(entity.getOneMonthLimitMinutes());
        vo.setTxtAttention1MonthHour(entity.getOneMonthAttentionHours());
        vo.setTxtAttention1MonthMinute(entity.getOneMonthAttentionMinutes());
        vo.setTxtWarning1MonthHour(entity.getOneMonthWarningHours());
        vo.setTxtWarning1MonthMinute(entity.getOneMonthWarningMinutes());
    }

    protected String getSettingCode() {
        TimeSettingCardVo vo = (TimeSettingCardVo)this.mospParams.getVo();
        return MospUtility.getString((Object)vo.getTxtSettingCode());
    }

    protected List<TimeSettingBeanInterface> getAddonBeans() throws MospException {
        ArrayList<TimeSettingBeanInterface> addonBeans = new ArrayList<TimeSettingBeanInterface>();
        for (String[] addon : this.getCodeArray(CODE_KEY_ADDONS, false)) {
            String addonBean = addon[0];
            if (MospUtility.isEmpty((String[])new String[]{addonBean})) continue;
            TimeSettingBeanInterface bean = (TimeSettingBeanInterface)this.platform().createBean(addonBean);
            addonBeans.add(bean);
        }
        return addonBeans;
    }

    protected List<String> getAddonJsps() {
        ArrayList<String> addonJsps = new ArrayList<String>();
        for (String[] addon : this.getCodeArray(CODE_KEY_ADDONS, false)) {
            String addonJsp = addon[1];
            if (MospUtility.isEmpty((String[])new String[]{addonJsp})) continue;
            addonJsps.add(addonJsp);
        }
        return addonJsps;
    }

    protected void registAddon() throws MospException {
        for (TimeSettingBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.regist();
        }
    }
}

