/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.comparator.base.ActivateDateComparator;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.PaidHolidayManagementSearchBeanInterface;
import jp.mosp.time.dto.settings.PaidHolidayManagementListDtoInterface;
import jp.mosp.time.settings.action.PaidHolidayHistoryAction;
import jp.mosp.time.settings.action.PaidHolidayReferenceAction;
import jp.mosp.time.settings.vo.PaidHolidayManagementVo;

public class PaidHolidayManagementAction
extends TimeAction {
    public static final String CMD_SHOW = "TM4410";
    public static final String CMD_SEARCH = "TM4412";
    public static final String CMD_RE_SHOW = "TM4413";
    public static final String CMD_TRANSFER = "TM4416";
    public static final String CMD_SORT = "TM4418";
    public static final String CMD_PAGE = "TM4419";
    public static final String CMD_SET_ACTIVATION_DATE = "TM4480";

    public PaidHolidayManagementAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new PaidHolidayManagementVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        }
    }

    protected void show() throws MospException {
        PaidHolidayManagementVo vo = (PaidHolidayManagementVo)this.mospParams.getVo();
        this.setDefaultValues();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(ActivateDateComparator.class.getName());
        vo.setModeActivateDate("fixed");
        this.setPulldown();
    }

    protected void search() throws MospException {
        PaidHolidayManagementVo vo = (PaidHolidayManagementVo)this.mospParams.getVo();
        PaidHolidayManagementSearchBeanInterface search = this.timeReference().paidHolidayManagementSearch();
        if (vo.getModeActivateDate().equals("chaning")) {
            this.mospParams.addErrorMessage("PFW0107", new String[0]);
            return;
        }
        this.checkSearchCondition(new String[]{vo.getTxtSearchEmployeeCode(), vo.getTxtSearchEmployeeName(), vo.getPltSearchWorkPlace(), vo.getPltSearchEmployment(), vo.getPltSearchSection(), vo.getPltSearchPosition()});
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        search.setActivateDate(this.getSearchActivateDate());
        search.setEmployeeCode(vo.getTxtSearchEmployeeCode());
        search.setEmployeeName(vo.getTxtSearchEmployeeName());
        search.setWorkPlaceCode(vo.getPltSearchWorkPlace());
        search.setEmploymentCode(vo.getPltSearchEmployment());
        search.setSectionCode(vo.getPltSearchSection());
        search.setPositionCode(vo.getPltSearchPosition());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(ActivateDateComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty()) {
            this.addNoSearchResultMessage();
        }
    }

    protected void transfer() {
        PaidHolidayManagementVo vo = (PaidHolidayManagementVo)this.mospParams.getVo();
        this.setTargetPersonalId(vo.getAryPersonalId(this.getTransferredIndex()));
        this.setTargetDate(this.getDate(vo.getAryLblActivateDate()[this.getTransferredIndex()]));
        String actionName = this.getTransferredAction();
        if (actionName.equals(PaidHolidayReferenceAction.class.getName())) {
            this.mospParams.setNextCommand("TM4431");
        } else if (actionName.equals(PaidHolidayHistoryAction.class.getName())) {
            this.mospParams.setNextCommand("TM4421");
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void setActivationDate() throws MospException {
        PaidHolidayManagementVo vo = (PaidHolidayManagementVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
    }

    public void setDefaultValues() {
        PaidHolidayManagementVo vo = (PaidHolidayManagementVo)this.mospParams.getVo();
        Date date = DateUtility.getSystemDate();
        vo.setTxtSearchActivateYear(DateUtility.getStringYear((Date)date));
        vo.setTxtSearchActivateMonth(DateUtility.getStringMonth((Date)date));
        vo.setTxtSearchActivateDay(DateUtility.getStringDay((Date)date));
        vo.setTxtSearchEmployeeCode("");
        vo.setTxtSearchEmployeeName("");
        vo.setPltSearchEmployment("");
        vo.setPltSearchPosition("");
        vo.setPltSearchSection("");
        vo.setPltSearchWorkPlace("");
        vo.setJsSearchConditionRequired(this.isSearchConditionRequired());
    }

    private void setPulldown() throws MospException {
        PaidHolidayManagementVo vo = (PaidHolidayManagementVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("fixed")) {
            Date date = DateUtility.getSystemDate();
            String[][] aryWorkPlace = this.reference().workPlace().getCodedSelectArray(date, true, null);
            vo.setAryPltSearchWorkPlace(aryWorkPlace);
            String[][] aryEmployment = this.reference().employmentContract().getCodedSelectArray(date, true, null);
            vo.setAryPltSearchEmployment(aryEmployment);
            String[][] arySection = this.reference().section().getCodedSelectArray(date, true, null);
            vo.setAryPltSearchSection(arySection);
            String[][] aryPosition = this.reference().position().getCodedSelectArray(date, true, null);
            vo.setAryPltSearchPosition(aryPosition);
        } else {
            vo.setAryPltSearchWorkPlace(this.getInputActivateDatePulldown());
            vo.setAryPltSearchEmployment(this.getInputActivateDatePulldown());
            vo.setAryPltSearchSection(this.getInputActivateDatePulldown());
            vo.setAryPltSearchPosition(this.getInputActivateDatePulldown());
        }
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        PaidHolidayManagementVo vo = (PaidHolidayManagementVo)this.mospParams.getVo();
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryPersonalId = new String[list.size()];
        String[] aryLblEmployeeCode = new String[list.size()];
        String[] aryLblEmployeeName = new String[list.size()];
        String[] aryLblSection = new String[list.size()];
        String[] aryLblFormerDate = new String[list.size()];
        String[] aryLblFormerTime = new String[list.size()];
        String[] aryLblDate = new String[list.size()];
        String[] aryLblTime = new String[list.size()];
        String[] aryLblStockDate = new String[list.size()];
        String[] aryLblInactivate = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            PaidHolidayManagementListDtoInterface dto = (PaidHolidayManagementListDtoInterface)list.get(i);
            SectionReferenceBeanInterface getSection = this.reference().section();
            Date date = DateUtility.getSystemDate();
            aryLblActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryPersonalId[i] = dto.getPersonalId();
            aryLblEmployeeCode[i] = dto.getEmployeeCode();
            aryLblEmployeeName[i] = this.getLastFirstName(dto.getLastName(), dto.getFirstName());
            aryLblSection[i] = getSection.getSectionAbbr(dto.getSectionCode(), date);
            aryLblFormerDate[i] = this.getNumberString(dto.getFormerDate(), 1);
            aryLblFormerTime[i] = String.valueOf(dto.getFormerTime());
            aryLblDate[i] = this.getNumberString(dto.getDate(), 1);
            aryLblTime[i] = String.valueOf(dto.getTime());
            aryLblStockDate[i] = this.getNumberString(dto.getStockDate(), 1);
            aryLblInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
        }
        vo.setAryPersonalId(aryPersonalId);
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblEmployeeCode(aryLblEmployeeCode);
        vo.setAryLblEmployeeName(aryLblEmployeeName);
        vo.setAryLblSection(aryLblSection);
        vo.setAryLblFormerDate(aryLblFormerDate);
        vo.setAryLblFormerTime(aryLblFormerTime);
        vo.setAryLblDate(aryLblDate);
        vo.setAryLblTime(aryLblTime);
        vo.setAryLblStockDate(aryLblStockDate);
        vo.setAryLblInactivate(aryLblInactivate);
    }
}

