/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.MospProperties;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.comparator.base.ActivateDateComparator;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.CutoffReferenceBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataGrantBeanInterface;
import jp.mosp.time.bean.PaidHolidayEntranceDateReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayFirstYearReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayHistorySearchBeanInterface;
import jp.mosp.time.bean.PaidHolidayTransactionRegistBeanInterface;
import jp.mosp.time.bean.StockHolidayDataReferenceBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayEntranceDateDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayFirstYearDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayHistoryListDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayTransactionDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayTransactionDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.settings.action.PaidHolidayReferenceAction;
import jp.mosp.time.settings.base.TimeSettingAction;
import jp.mosp.time.settings.vo.PaidHolidayHistoryVo;
import jp.mosp.time.utils.TimeUtility;

public class PaidHolidayHistoryAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM4420";
    public static final String CMD_SELECT_SHOW = "TM4421";
    public static final String CMD_SEARCH = "TM4422";
    public static final String CMD_RE_SHOW = "TM4423";
    public static final String CMD_REGIST = "TM4425";
    public static final String CMD_PAIDHOLIDAY_CALC = "TM4426";
    public static final String CMD_TRANSFER = "TM4427";
    public static final String CMD_SORT = "TM4428";
    public static final String CMD_PAGE = "TM4429";
    public static final String CMD_SET_EMPLOYEE_CODE = "TM4470";
    public static final String CMD_INSERT_MODE = "TM4471";
    public static final String CMD_EDIT_TARGET = "TM4472";
    public static final String CMD_SET_ACTIVATE_DATE = "TM4477";

    public PaidHolidayHistoryAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new PaidHolidayHistoryVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo();
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_PAIDHOLIDAY_CALC)) {
            this.prepareVo();
            this.paidHolydayCalc();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_SET_EMPLOYEE_CODE)) {
            this.prepareVo();
            this.setEmployeeCode();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_TARGET)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATE_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        }
    }

    protected void show() throws MospException {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.setPulldown();
        this.insertMode();
        vo.setComparatorName(ActivateDateComparator.class.getName());
    }

    protected void select() throws MospException {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.setDefaultValues();
        this.setPulldown();
        vo.setComparatorName(ActivateDateComparator.class.getName());
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getSystemDate();
        vo.setModeCardEdit("insert");
        HumanDtoInterface humanDto = this.reference().human().getHumanInfo(personalId, targetDate);
        if (humanDto != null) {
            vo.setTxtEditEmployeeCode(humanDto.getEmployeeCode());
        }
        vo.setTxtEditActivateYear(this.getStringYear(targetDate));
        vo.setTxtEditActivateMonth(this.getStringMonth(targetDate));
        vo.setTxtEditActivateDay(this.getStringDay(targetDate));
    }

    protected void search() throws MospException {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        PaidHolidayHistorySearchBeanInterface search = this.timeReference().paidHolidayHistorySearch();
        search.setActivateDate(this.getSearchActivateDate());
        search.setEmployeeCode(vo.getTxtSearchEmployeeCode());
        search.setEmployeeName(vo.getTxtSearchEmployeeName());
        search.setWorkPlaceCode(vo.getPltSearchWorkPlace());
        search.setEmploymentCode(vo.getPltSearchEmployment());
        search.setSectionCode(vo.getPltSearchSection());
        search.setPositionCode(vo.getPltSearchPosition());
        search.setInactivateFlag(String.valueOf(0));
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(ActivateDateComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty()) {
            this.addNoSearchResultMessage();
        }
    }

    protected void regist() throws MospException {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void paidHolydayCalc() throws MospException {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        double beforeFormerDate = this.getDouble(vo.getLblBeforeFormerDate());
        double beforeFormerTime = this.getDouble(vo.getLblBeforeFormerTime());
        double beforeDate = this.getDouble(vo.getLblBeforeDate());
        double beforeTime = this.getDouble(vo.getLblBeforeTime());
        double beforeStockDate = this.getDouble(vo.getLblBeforeStockDate());
        double editFormerDate = 0.0;
        double editFormerTime = 0.0;
        double editDate = 0.0;
        double editTime = 0.0;
        double editStockDate = 0.0;
        if (vo.getTxtEditFormerGivingDay().isEmpty()) {
            vo.setTxtEditFormerGivingDay("0.0");
        } else {
            editFormerDate = this.getDouble(vo.getTxtEditFormerGivingDay());
        }
        if (vo.getTxtEditFormerGivingTime().isEmpty()) {
            vo.setTxtEditFormerGivingTime("0");
        } else {
            editFormerTime = this.getDouble(vo.getTxtEditFormerGivingTime());
        }
        if (vo.getTxtEditGivingDay().isEmpty()) {
            vo.setTxtEditGivingDay("0.0");
        } else {
            editDate = this.getDouble(vo.getTxtEditGivingDay());
        }
        if (vo.getTxtEditGivingTime().isEmpty()) {
            vo.setTxtEditGivingTime("0");
        } else {
            editTime = this.getDouble(vo.getTxtEditGivingTime());
        }
        if (vo.getTxtEditGivingStockDay().isEmpty()) {
            vo.setTxtEditGivingStockDay("0.0");
        } else {
            editStockDate = this.getDouble(vo.getTxtEditGivingStockDay());
        }
        double afterFormerDate = 0.0;
        double afterFormerTime = 0.0;
        double afterDate = 0.0;
        double afterTime = 0.0;
        double afterStockDate = 0.0;
        if (vo.getPltEditFormerGivingType().equals("1")) {
            afterFormerDate = beforeFormerDate + editFormerDate;
            afterFormerTime = beforeFormerTime + editFormerTime;
        } else {
            afterFormerDate = beforeFormerDate - editFormerDate;
            afterFormerTime = beforeFormerTime - editFormerTime;
        }
        if (vo.getPltEditGivingType().equals("1")) {
            afterDate = beforeDate + editDate;
            afterTime = beforeTime + editTime;
        } else {
            afterDate = beforeDate - editDate;
            afterTime = beforeTime - editTime;
        }
        afterStockDate = vo.getPltEditStockType().equals("1") ? beforeStockDate + editStockDate : beforeStockDate - editStockDate;
        vo.setLblAfterFormerDate(String.valueOf(afterFormerDate));
        vo.setLblAfterFormerTime(String.valueOf(afterFormerTime));
        vo.setLblAfterDate(String.valueOf(afterDate));
        vo.setLblAfterTime(String.valueOf(afterTime));
        vo.setLblAfterStockDate(String.valueOf(afterStockDate));
        vo.setLblAfterTotalDate(String.valueOf(afterFormerDate + afterDate + afterStockDate));
        vo.setLblAfterTotalTime(String.valueOf(afterFormerTime + afterTime));
        vo.setClaAfterTotalDate(this.setHistoryDateTimeDoubleColor(afterFormerDate + afterDate + afterStockDate));
        vo.setClaAfterTotalTime(this.setHistoryDateTimeDoubleColor(afterFormerTime + afterTime));
        vo.setClaAfterFormerDate(this.setHistoryDateTimeDoubleColor(afterFormerDate));
        vo.setClaAfterFormerTime(this.setHistoryDateTimeDoubleColor(afterFormerTime));
        vo.setClaAfterDate(this.setHistoryDateTimeDoubleColor(afterDate));
        vo.setClaAfterTime(this.setHistoryDateTimeDoubleColor(afterTime));
        vo.setClaAfterStockDate(this.setHistoryDateTimeDoubleColor(afterStockDate));
    }

    protected void transfer() {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        this.setTargetPersonalId(vo.getAryPersonalId(this.getTransferredIndex()));
        String actionName = this.getTransferredAction();
        if (actionName.equals(PaidHolidayReferenceAction.class.getName())) {
            this.mospParams.setNextCommand("TM4431");
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void setEmployeeCode() throws MospException {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        if (vo.getJsModeEmployeeCode().equals("chaning")) {
            Date activateDate = this.getEditActivateDate();
            HumanDtoInterface humanDto = this.reference().human().getHumanInfoForEmployeeCode(vo.getTxtEditEmployeeCode(), activateDate);
            if (humanDto == null) {
                this.addNotExistEmployeesErrorMessage();
                return;
            }
            String personalId = humanDto.getPersonalId();
            vo.setPersonalId(personalId);
            if (!this.reference().entrance().isEntered(personalId, activateDate)) {
                this.addNotJoinedEmployeesErrorMessage(activateDate, this.getEmployeeCode(personalId));
                return;
            }
            if (this.reference().retirement().isRetired(personalId, activateDate)) {
                this.addNotRetirementEmployeesErrorMessage(activateDate, this.getEmployeeCode(personalId));
                return;
            }
            ApplicationDtoInterface appDto = this.timeReference().application().findForPerson(personalId, activateDate);
            this.timeReference().application().chkExistApplication(appDto, activateDate);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            PaidHolidayDtoInterface paidDto = this.timeReference().paidHoliday().getPaidHolidayInfo(appDto.getPaidHolidayCode(), activateDate);
            if (paidDto == null) {
                this.addNoItemErrorMessage(this.mospParams.getName("PaidVacation"), null);
                return;
            }
            if (paidDto.getTimelyPaidHolidayFlag() == 0) {
                vo.setJsModeGivingtime(Boolean.valueOf(true));
            } else {
                vo.setJsModeGivingtime(Boolean.valueOf(false));
            }
            vo.setLblEditEmployeeName(this.getLastFirstName(humanDto.getLastName(), humanDto.getFirstName()));
            vo.setJsModeEmployeeCode("fixed");
        } else {
            vo.setJsModeEmployeeCode("chaning");
            vo.setPersonalId("");
            vo.setLblEditEmployeeName("");
            vo.setLblBeforeTotalDate("0");
            vo.setLblBeforeTotalTime("0");
            vo.setLblBeforeFormerDate("0");
            vo.setLblBeforeFormerTime("0");
            vo.setLblBeforeDate("0");
            vo.setLblBeforeTime("0");
            vo.setLblBeforeStockDate("0");
            vo.setTxtEditFormerGivingDay("0");
            vo.setTxtEditFormerGivingTime("0");
            vo.setTxtEditGivingDay("0");
            vo.setTxtEditGivingTime("0");
            vo.setTxtEditGivingStockDay("0");
            vo.setLblAfterTotalDate("0");
            vo.setLblAfterTotalTime("0");
            vo.setLblAfterFormerDate("0");
            vo.setLblAfterFormerTime("0");
            vo.setLblAfterDate("0");
            vo.setLblAfterTime("0");
            vo.setLblAfterStockDate("0");
            vo.setPltEditFormerGivingType("0");
            vo.setPltEditGivingType("0");
            vo.setPltEditStockType("0");
            vo.setJsModeGivingtime(Boolean.valueOf(false));
        }
    }

    protected void insertMode() {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        vo.setModeCardEdit("insert");
        this.setDefaultValues();
    }

    protected void editMode() throws MospException {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        String personalId = this.getTransferredCode();
        Date date = this.getDate(this.getTransferredActivateDate());
        HumanDtoInterface humanDto = this.reference().human().getHumanInfo(personalId, date);
        if (humanDto == null) {
            this.addNoItemErrorMessage(this.mospParams.getName("Employee"), null);
            vo.setJsModeEmployeeCode("chaning");
            vo.setModeCardEdit("insert");
            return;
        }
        vo.setTxtEditActivateYear(this.getStringYear(date));
        vo.setTxtEditActivateMonth(this.getStringMonth(date));
        vo.setTxtEditActivateDay(this.getStringDay(date));
        vo.setTxtEditEmployeeCode(humanDto.getEmployeeCode());
        vo.setPersonalId(personalId);
        this.setEditUpdateMode(personalId, date);
        vo.setJsModeEmployeeCode("fixed");
        vo.setModeCardEdit("edit");
        vo.setLblEditEmployeeName(this.getLastFirstName(humanDto.getLastName(), humanDto.getFirstName()));
    }

    protected void setActivationDate() throws MospException {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
            this.setPulldown();
        } else {
            vo.setModeActivateDate("chaning");
            vo.setAryPltSearchWorkPlace(this.getInputActivateDatePulldown());
            vo.setAryPltSearchEmployment(this.getInputActivateDatePulldown());
            vo.setAryPltSearchSection(this.getInputActivateDatePulldown());
            vo.setAryPltSearchPosition(this.getInputActivateDatePulldown());
        }
    }

    protected void insert() throws MospException {
        StockHolidayTransactionDtoInterface dtoStock;
        PaidHolidayDataDtoInterface formerPaidHolidayDataDto;
        PaidHolidayTransactionDtoInterface dtoFormer;
        PaidHolidayDataDtoInterface formerDataDto;
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        PaidHolidayTransactionRegistBeanInterface regist = this.time().paidHolidayTransactionRegist();
        if (!this.checkCutoffDayRecord()) {
            return;
        }
        PaidHolidayDataDtoInterface dataDto = this.getPaidHolidayDataDto(this.getEditActivateDate());
        if (dataDto == null) {
            vo.setJsModeEmployeeCode("chaning");
            this.addSalariedVacationExceptErrorMessage();
            return;
        }
        PaidHolidayTransactionDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto, dataDto.getAcquisitionDate());
        regist.insert(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        PaidHolidayDataDtoInterface paidHolidayDataDto = this.timeReference().paidHolidayData().getPaidHolidayDataInfo(dto.getPersonalId(), dto.getActivateDate(), dto.getAcquisitionDate());
        if (paidHolidayDataDto == null) {
            this.time().paidHolidayDataRegist().insert(dataDto);
        }
        if ((formerDataDto = this.getPaidHolidayDataDto(DateUtility.addYear((Date)this.getEditActivateDate(), (int)-1))) == null) {
            if (Double.parseDouble(vo.getTxtEditFormerGivingDay()) > 0.0 || Integer.parseInt(vo.getTxtEditFormerGivingTime()) > 0) {
                vo.setJsModeEmployeeCode("chaning");
                this.addSalariedVacationExceptErrorMessage();
                return;
            }
            dtoFormer = regist.getInitDto();
            this.setDtoFieldsFormer(dtoFormer, DateUtility.addYear((Date)dataDto.getAcquisitionDate(), (int)-1));
            regist.insert(dtoFormer);
            formerPaidHolidayDataDto = this.timeReference().paidHolidayData().getPaidHolidayDataInfo(dtoFormer.getPersonalId(), dtoFormer.getActivateDate(), dtoFormer.getAcquisitionDate());
            if (formerPaidHolidayDataDto == null) {
                formerDataDto = this.time().paidHolidayDataRegist().getInitDto();
                formerDataDto.setPersonalId(dataDto.getPersonalId());
                formerDataDto.setActivateDate(this.getEditActivateDate());
                formerDataDto.setAcquisitionDate(DateUtility.addYear((Date)dataDto.getAcquisitionDate(), (int)-1));
                formerDataDto.setLimitDate(DateUtility.addYear((Date)dataDto.getLimitDate(), (int)-1));
                formerDataDto.setTemporaryFlag(1);
                this.time().paidHolidayDataRegist().insert(formerDataDto);
            }
        } else {
            dtoFormer = regist.getInitDto();
            this.setDtoFieldsFormer(dtoFormer, formerDataDto.getAcquisitionDate());
            regist.insert(dtoFormer);
            formerPaidHolidayDataDto = this.timeReference().paidHolidayData().getPaidHolidayDataInfo(dtoFormer.getPersonalId(), dtoFormer.getActivateDate(), dtoFormer.getAcquisitionDate());
            if (formerPaidHolidayDataDto == null) {
                this.time().paidHolidayDataRegist().insert(formerDataDto);
            }
        }
        StockHolidayDataDtoInterface stockDataDto = this.getStockHolidayDataDto(this.getEditActivateDate(), null);
        if (stockDataDto == null) {
            if (this.getDouble(vo.getTxtEditGivingStockDay()) > 0.0) {
                vo.setJsModeEmployeeCode("chaning");
                this.addNotStockVacationGrantErrorMessage();
                return;
            }
            stockDataDto = this.time().stockHolidayDataRegist().getInitDto();
            this.setStockHolidayDataDtoFields(stockDataDto, dataDto);
            dtoStock = this.time().stockHolidayTransactionRegist().getInitDto();
            this.setDtoFieldsStock(dtoStock, stockDataDto.getAcquisitionDate());
            this.time().stockHolidayTransactionRegist().insert(dtoStock);
            StockHolidayDataDtoInterface stockHolidayDataDto = this.timeReference().stockHolidayData().getStockHolidayDataInfo(dtoStock.getPersonalId(), dtoStock.getActivateDate(), dtoStock.getAcquisitionDate());
            if (stockHolidayDataDto == null) {
                this.time().stockHolidayDataRegist().insert(stockDataDto);
            }
        } else {
            dtoStock = this.time().stockHolidayTransactionRegist().getInitDto();
            this.setDtoFieldsStock(dtoStock, stockDataDto.getAcquisitionDate());
            this.time().stockHolidayTransactionRegist().insert(dtoStock);
            StockHolidayDataDtoInterface stockHolidayDataDto = this.timeReference().stockHolidayData().getStockHolidayDataInfo(dtoStock.getPersonalId(), dtoStock.getActivateDate(), dtoStock.getAcquisitionDate());
            if (stockHolidayDataDto == null) {
                this.time().stockHolidayDataRegist().insert(stockDataDto);
            }
        }
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertNewMessage();
        this.setEditUpdateMode(dto.getPersonalId(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        vo.setTxtSearchEmployeeCode(vo.getTxtEditEmployeeCode());
        this.search();
    }

    protected void update() throws MospException {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        PaidHolidayTransactionRegistBeanInterface regist = this.time().paidHolidayTransactionRegist();
        if (!this.checkCutoffDayRecord()) {
            return;
        }
        PaidHolidayDataDtoInterface dataDto = this.getPaidHolidayDataDto(this.getEditActivateDate());
        if (dataDto == null) {
            vo.setJsModeEmployeeCode("chaning");
            this.addNotWithPayVacationGrantErrorMessage();
            return;
        }
        PaidHolidayTransactionDtoInterface dto = null;
        List list = this.timeReference().paidHolidayTransaction().findForList(vo.getPersonalId(), this.getEditActivateDate());
        for (PaidHolidayTransactionDtoInterface paidHolidayTransactionDto : list) {
            if (paidHolidayTransactionDto.getAcquisitionDate().compareTo(dataDto.getAcquisitionDate()) != 0) continue;
            dto = paidHolidayTransactionDto;
            break;
        }
        if (dto == null) {
            this.addInsertFailedMessage();
            return;
        }
        this.setDtoFields(dto, dataDto.getAcquisitionDate());
        regist.update(dto);
        if (Double.parseDouble(vo.getTxtEditFormerGivingDay()) > 0.0 || Integer.parseInt(vo.getTxtEditFormerGivingTime()) > 0) {
            PaidHolidayDataDtoInterface formerDataDto = this.getPaidHolidayDataDto(DateUtility.addYear((Date)this.getEditActivateDate(), (int)-1));
            if (formerDataDto == null) {
                vo.setJsModeEmployeeCode("chaning");
                this.addNotWithPayVacationGrantErrorMessage();
                return;
            }
            PaidHolidayTransactionDtoInterface dtoFormer = null;
            for (PaidHolidayTransactionDtoInterface paidHolidayTransactionDto : list) {
                if (paidHolidayTransactionDto.getAcquisitionDate().compareTo(formerDataDto.getAcquisitionDate()) != 0) continue;
                dtoFormer = paidHolidayTransactionDto;
                break;
            }
            if (dtoFormer == null) {
                this.addInsertFailedMessage();
                return;
            }
            this.setDtoFieldsFormer(dtoFormer, formerDataDto.getAcquisitionDate());
            regist.update(dtoFormer);
        }
        if (this.getDouble(vo.getTxtEditGivingStockDay()) > 0.0) {
            Date acquisitionDate = DateUtility.addDay((Date)dataDto.getLimitDate(), (int)1);
            while (this.getEditActivateDate().before(acquisitionDate)) {
                acquisitionDate = DateUtility.addYear((Date)acquisitionDate, (int)-1);
            }
            StockHolidayDataDtoInterface stockDataDto = this.getStockHolidayDataDto(this.getEditActivateDate(), acquisitionDate);
            if (stockDataDto == null) {
                vo.setJsModeEmployeeCode("chaning");
                this.addNotStockVacationGrantErrorMessage();
                return;
            }
            StockHolidayTransactionDtoInterface dtoStock = this.timeReference().stockHolidayTransaction().findForKey(vo.getPersonalId(), this.getEditActivateDate(), stockDataDto.getAcquisitionDate());
            this.setDtoFieldsStock(dtoStock, stockDataDto.getAcquisitionDate());
            this.time().stockHolidayTransactionRegist().update(dtoStock);
            if (this.mospParams.hasErrorMessage()) {
                this.addUpdateFailedMessage();
                return;
            }
        }
        this.commit();
        this.addUpdateHistoryMessage();
        this.setEditUpdateMode(dto.getPersonalId(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        vo.setTxtSearchEmployeeCode(vo.getTxtEditEmployeeCode());
        this.search();
    }

    public void setDefaultValues() {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        vo.setPersonalId("");
        Date date = this.getSystemDate();
        vo.setTxtEditActivateYear(this.getStringYear(date));
        vo.setTxtEditActivateMonth(this.getStringMonth(date));
        vo.setTxtEditActivateDay(this.getStringDay(date));
        vo.setTxtEditEmployeeCode("");
        vo.setLblEditEmployeeName("");
        vo.setPltEditInactivate(String.valueOf(0));
        vo.setTxtSearchActivateYear(this.getStringYear(date));
        vo.setTxtSearchActivateMonth(this.getStringMonth(date));
        vo.setTxtSearchActivateDay(this.getStringDay(date));
        vo.setTxtSearchEmployeeCode("");
        vo.setTxtSearchEmployeeName("");
        vo.setPltSearchWorkPlace("");
        vo.setPltSearchEmployment("");
        vo.setPltSearchSection("");
        vo.setPltSearchPosition("");
        vo.setTxtEditFormerGivingDay("0");
        vo.setTxtEditFormerGivingTime("0");
        vo.setTxtEditGivingDay("0");
        vo.setTxtEditGivingTime("0");
        vo.setTxtEditGivingStockDay("0");
        vo.setLblAfterTotalDate("0");
        vo.setLblAfterTotalTime("0");
        vo.setLblAfterFormerDate("0");
        vo.setLblAfterFormerTime("0");
        vo.setLblAfterDate("0");
        vo.setLblAfterTime("0");
        vo.setLblAfterStockDate("0");
        vo.setTxtUpdateActivateYear(this.getStringYear(date));
        vo.setTxtUpdateActivateMonth(this.getStringMonth(date));
        vo.setTxtUpdateActivateDay(this.getStringDay(date));
        vo.setPltUpdateInactivate(String.valueOf(0));
        vo.setJsModeGivingtime(Boolean.valueOf(false));
        vo.setClaAfterTotalDate("");
        vo.setClaAfterTotalTime("");
        vo.setClaAfterFormerDate("");
        vo.setClaAfterFormerTime("");
        vo.setClaAfterDate("");
        vo.setClaAfterTime("");
        vo.setClaAfterStockDate("");
        this.setDefaltValuesFormer();
        this.setDefaltValuesFields();
        this.setDefaltValuesStock();
        vo.setModeActivateDate("fixed");
        vo.setJsModeEmployeeCode("chaning");
    }

    public void setDefaltValuesFormer() {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        vo.setTmtPaidHolidayFormerId(0L);
        vo.setLblBeforeFormerDate("0");
        vo.setLblBeforeFormerTime("0");
        vo.setClaBeforeFormerDate("");
        vo.setClaBeforeFormerTime("");
        vo.setPltEditFormerGivingType("0");
    }

    public void setDefaltValuesFields() {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        vo.setTmtPaidHolidayId(0L);
        vo.setLblBeforeDate("0");
        vo.setLblBeforeTime("0");
        vo.setPltEditGivingType("0");
        vo.setClaBeforeDate("");
        vo.setClaBeforeTime("");
    }

    public void setDefaltValuesStock() {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        vo.setTmtStockHolidayId(0L);
        vo.setLblBeforeStockDate("0");
        vo.setClaBeforeStockDate("");
        vo.setPltEditStockType("0");
        vo.setLblBeforeTotalDate("0");
        vo.setLblBeforeTotalTime("0");
        vo.setClaBeforeTotalDate("");
        vo.setClaBeforeTotalTime("");
    }

    private void setPulldown() throws MospException {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        MospProperties properties = this.mospParams.getProperties();
        String[][] aryGivingType = properties.getCodeArray("GivingType", false);
        vo.setAryPltFormerGivingType(aryGivingType);
        vo.setAryPltGivingType(aryGivingType);
        vo.setAryPltStockType(aryGivingType);
        Date date = this.getSystemDate();
        String[][] aryWorkPlace = this.reference().workPlace().getCodedSelectArray(date, true, null);
        vo.setAryPltSearchWorkPlace(aryWorkPlace);
        String[][] aryEmployment = this.reference().employmentContract().getCodedSelectArray(date, true, null);
        vo.setAryPltSearchEmployment(aryEmployment);
        String[][] arySection = this.reference().section().getCodedSelectArray(date, true, null);
        vo.setAryPltSearchSection(arySection);
        String[][] aryPosition = this.reference().position().getCodedSelectArray(date, true, null);
        vo.setAryPltSearchPosition(aryPosition);
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        long[] aryCkbRecordId = new long[list.size()];
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblPersonalId = new String[list.size()];
        String[] aryLblEmployeeCode = new String[list.size()];
        String[] aryLblEmployeeName = new String[list.size()];
        String[] aryLblSection = new String[list.size()];
        String[] aryLblFormerDate = new String[list.size()];
        String[] aryLblFormerTime = new String[list.size()];
        String[] aryLblDate = new String[list.size()];
        String[] aryLblTime = new String[list.size()];
        String[] aryLblStockDate = new String[list.size()];
        String[] aryClaFormerDate = new String[list.size()];
        String[] aryClaFormerTime = new String[list.size()];
        String[] aryClaDate = new String[list.size()];
        String[] aryClaTime = new String[list.size()];
        String[] aryClaStockDate = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            PaidHolidayHistoryListDtoInterface dto = (PaidHolidayHistoryListDtoInterface)list.get(i);
            SectionReferenceBeanInterface getSection = this.reference().section();
            Date date = this.getSystemDate();
            aryCkbRecordId[i] = dto.getTmdPaidHolidayHistoryListId();
            aryLblActivateDate[i] = DateUtility.getStringDate((Date)dto.getActivateDate());
            aryLblPersonalId[i] = dto.getPersonalId();
            aryLblEmployeeCode[i] = dto.getEmployeeCode();
            aryLblEmployeeName[i] = this.getLastFirstName(dto.getLastName(), dto.getFirstName());
            aryLblSection[i] = getSection.getSectionAbbr(dto.getSectionCode(), date);
            aryLblFormerDate[i] = this.getNumberString(dto.getFormerDate(), 1);
            aryClaFormerDate[i] = this.setHistoryDateTimeDoubleColor(dto.getFormerDate());
            aryLblFormerTime[i] = String.valueOf(dto.getFormerTime());
            aryClaFormerTime[i] = this.setHistoryDateTimeColor(dto.getFormerTime());
            aryLblDate[i] = this.getNumberString(dto.getDate(), 1);
            aryClaDate[i] = this.setHistoryDateTimeDoubleColor(dto.getDate());
            aryLblTime[i] = String.valueOf(dto.getTime());
            aryClaTime[i] = this.setHistoryDateTimeColor(dto.getTime());
            aryLblStockDate[i] = this.getNumberString(dto.getStockDate(), 1);
            aryClaStockDate[i] = this.setHistoryDateTimeDoubleColor(dto.getStockDate());
        }
        vo.setAryCkbRecordId(aryCkbRecordId);
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryPersonalId(aryLblPersonalId);
        vo.setAryLblEmployeeCode(aryLblEmployeeCode);
        vo.setAryLblEmployeeName(aryLblEmployeeName);
        vo.setAryLblSection(aryLblSection);
        vo.setAryLblFormerDate(aryLblFormerDate);
        vo.setAryLblFormerTime(aryLblFormerTime);
        vo.setAryLblDate(aryLblDate);
        vo.setAryLblTime(aryLblTime);
        vo.setAryLblStockDate(aryLblStockDate);
        vo.setAryClaFormerDate(aryClaFormerDate);
        vo.setAryClaFormerTime(aryClaFormerTime);
        vo.setAryClaDate(aryClaDate);
        vo.setAryClaTime(aryClaTime);
        vo.setAryClaStockDate(aryClaStockDate);
    }

    protected void setDtoFields(PaidHolidayTransactionDtoInterface dto, Date acquisitionDate) throws MospException {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        dto.setTmtPaidHolidayId(vo.getTmtPaidHolidayId());
        dto.setActivateDate(this.getEditActivateDate());
        dto.setPersonalId(vo.getPersonalId());
        dto.setInactivateFlag(0);
        if (vo.getPltEditGivingType().equals("1")) {
            dto.setGivingDay(dto.getGivingDay() + this.getDouble(vo.getTxtEditGivingDay()));
            dto.setGivingHour(dto.getGivingHour() + this.getInt(vo.getTxtEditGivingTime()));
        } else {
            dto.setCancelDay(dto.getCancelDay() + this.getDouble(vo.getTxtEditGivingDay()));
            dto.setCancelHour(dto.getCancelHour() + this.getInt(vo.getTxtEditGivingTime()));
        }
        dto.setAcquisitionDate(acquisitionDate);
    }

    public void setVoFields(PaidHolidayTransactionDtoInterface dto) throws MospException {
        double date = 0.0;
        int time = 0;
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        vo.setTmtPaidHolidayId(dto.getTmtPaidHolidayId());
        date = dto.getGivingDay() - dto.getCancelDay();
        time = dto.getGivingHour() - dto.getCancelHour();
        vo.setLblBeforeDate(this.getNumberString(date, 1));
        vo.setLblBeforeTime(String.valueOf(time));
        vo.setPltEditGivingType("1");
        vo.setClaBeforeDate(this.setHistoryDateTimeDoubleColor(date));
        vo.setClaBeforeTime(this.setHistoryDateTimeDoubleColor((double)time));
    }

    protected void setDtoFieldsFormer(PaidHolidayTransactionDtoInterface dto, Date acquisitionDate) throws MospException {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        dto.setTmtPaidHolidayId(vo.getTmtPaidHolidayFormerId());
        dto.setActivateDate(this.getEditActivateDate());
        dto.setPersonalId(vo.getPersonalId());
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
        if (vo.getPltEditFormerGivingType().equals("1")) {
            double day = dto.getGivingDay() + this.getDouble(vo.getTxtEditFormerGivingDay());
            dto.setGivingDay(day);
            int hour = dto.getGivingHour() + this.getInt(vo.getTxtEditFormerGivingTime());
            dto.setGivingHour(hour);
        } else {
            double day = dto.getCancelDay() + this.getDouble(vo.getTxtEditFormerGivingDay());
            dto.setCancelDay(day);
            int hour = dto.getCancelHour() + this.getInt(vo.getTxtEditFormerGivingTime());
            dto.setCancelHour(hour);
        }
        dto.setAcquisitionDate(acquisitionDate);
    }

    public void setVoFieldsFormer(PaidHolidayTransactionDtoInterface dto) throws MospException {
        double date = 0.0;
        int time = 0;
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        vo.setTmtPaidHolidayFormerId(dto.getTmtPaidHolidayId());
        date = dto.getGivingDay() - dto.getCancelDay();
        time = dto.getGivingHour() - dto.getCancelHour();
        vo.setLblBeforeFormerDate(this.getNumberString(date, 1));
        vo.setLblBeforeFormerTime(String.valueOf(time));
        vo.setClaBeforeFormerDate(this.setHistoryDateTimeDoubleColor(date));
        vo.setClaBeforeFormerTime(this.setHistoryDateTimeDoubleColor((double)time));
        vo.setPltEditFormerGivingType("1");
    }

    protected void setDtoFieldsStock(StockHolidayTransactionDtoInterface dto, Date acquisitionDate) throws MospException {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        dto.setTmtStockHolidayId(vo.getTmtStockHolidayId());
        dto.setActivateDate(this.getEditActivateDate());
        dto.setPersonalId(vo.getPersonalId());
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
        double givingDay = 0.0;
        if (vo.getPltEditStockType().equals("1")) {
            givingDay = dto.getGivingDay() + this.getDouble(vo.getTxtEditGivingStockDay());
            dto.setGivingDay(givingDay);
        } else {
            givingDay = dto.getCancelDay() + this.getDouble(vo.getTxtEditGivingStockDay());
            dto.setCancelDay(givingDay);
        }
        dto.setAcquisitionDate(acquisitionDate);
    }

    public void setVoFieldsStock(StockHolidayTransactionDtoInterface dto) throws MospException {
        double date = 0.0;
        double totalDate = 0.0;
        int totalTime = 0;
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        vo.setTmtStockHolidayId(dto.getTmtStockHolidayId());
        date = dto.getGivingDay() - dto.getCancelDay();
        vo.setLblBeforeStockDate(this.getNumberString(date, 1));
        vo.setClaBeforeStockDate(this.setHistoryDateTimeDoubleColor(date));
        vo.setPltEditStockType("1");
        totalDate = this.getDouble(vo.getLblBeforeFormerDate()) + this.getDouble(vo.getLblBeforeDate()) + date;
        totalTime = this.getInt(vo.getLblBeforeFormerTime()) + this.getInt(vo.getLblBeforeTime());
        vo.setLblBeforeTotalDate(this.getNumberString(totalDate, 1));
        vo.setLblBeforeTotalTime(String.valueOf(totalTime));
        vo.setClaBeforeTotalDate(this.setHistoryDateTimeDoubleColor(totalDate));
        vo.setClaBeforeTotalTime(this.setHistoryDateTimeDoubleColor((double)totalTime));
    }

    protected void setEditUpdateMode(String personalId, Date activateDate) throws MospException {
        StockHolidayTransactionDtoInterface dtoStock;
        this.setDefaltValuesFormer();
        this.setDefaltValuesFields();
        this.setDefaltValuesStock();
        List list = this.timeReference().paidHolidayTransaction().findForInfoList(personalId, activateDate, String.valueOf(0));
        PaidHolidayTransactionDtoInterface dto = null;
        if (list.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            dto = (PaidHolidayTransactionDtoInterface)list.get(i);
            this.checkSelectedDataExist((Object)dto);
            if (i == 0) {
                this.setVoFieldsFormer(dto);
                continue;
            }
            if (i != 1) continue;
            this.setVoFields(dto);
        }
        StockHolidayDataDtoInterface stockHolidayDataDto = this.getStockHolidayDataDto(activateDate, null);
        if (stockHolidayDataDto == null) {
            stockHolidayDataDto = this.time().stockHolidayDataRegist().getInitDto();
            PaidHolidayDataDtoInterface paidHolidayDataDto = this.getPaidHolidayDataDto(activateDate);
            if (paidHolidayDataDto == null) {
                return;
            }
            this.setStockHolidayDataDtoFields(stockHolidayDataDto, paidHolidayDataDto);
        }
        if ((dtoStock = this.timeReference().stockHolidayTransaction().getStockHolidayTransactionInfo(personalId, activateDate, stockHolidayDataDto.getAcquisitionDate())) == null) {
            return;
        }
        this.checkSelectedDataExist((Object)dtoStock);
        this.setVoFieldsStock(dtoStock);
        List grantHistoryList = this.timeReference().paidHolidayTransaction().findForHistoryList(personalId);
        ArrayList<PaidHolidayTransactionDtoInterface> notOverlapGrantHistoryList = new ArrayList<PaidHolidayTransactionDtoInterface>();
        for (PaidHolidayTransactionDtoInterface transactionDto : grantHistoryList) {
            if (this.isDate(transactionDto.getActivateDate(), notOverlapGrantHistoryList)) continue;
            notOverlapGrantHistoryList.add(transactionDto);
        }
        this.setEditUpdateMode(notOverlapGrantHistoryList);
        this.setModeActivateDate("fixed");
        this.setPulldown();
        this.paidHolydayCalc();
    }

    protected boolean isDate(Date targetDate, List<PaidHolidayTransactionDtoInterface> list) throws MospException {
        if (list.isEmpty()) {
            return false;
        }
        for (PaidHolidayTransactionDtoInterface dto : list) {
            if (!targetDate.equals(dto.getActivateDate())) continue;
            return true;
        }
        return false;
    }

    protected boolean checkCutoffDayRecord() throws MospException {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        int[] calcMonth = this.getCalcMonth(personalId, this.getEditActivateDate());
        if (this.mospParams.hasErrorMessage()) {
            return false;
        }
        Integer state = this.timeReference().totalTimeEmployeeTransaction().getCutoffState(personalId, calcMonth[0], calcMonth[1]);
        if (state == null) {
            return true;
        }
        int intState = state;
        if (intState == 0) {
            return true;
        }
        if (intState == 1) {
            StringBuffer sb = new StringBuffer();
            sb.append(calcMonth[0]);
            sb.append(this.mospParams.getName("Year"));
            sb.append(calcMonth[1]);
            sb.append(this.mospParams.getName("Month"));
            this.mospParams.addErrorMessage("TMW0272", new String[]{sb.toString(), this.mospParams.getName("GrantDate")});
            return false;
        }
        return false;
    }

    protected int[] getCalcMonth(String personalId, Date date) throws MospException {
        ApplicationReferenceBeanInterface applicationReference = this.timeReference().application();
        ApplicationDtoInterface applicationDto = applicationReference.findForPerson(personalId, date);
        applicationReference.chkExistApplication(applicationDto, date);
        if (this.mospParams.hasErrorMessage()) {
            return new int[0];
        }
        TimeSettingReferenceBeanInterface timeSettingReference = this.timeReference().timeSetting();
        TimeSettingDtoInterface timeSettingDto = timeSettingReference.getTimeSettingInfo(applicationDto.getWorkSettingCode(), date);
        timeSettingReference.chkExistTimeSetting(timeSettingDto, date);
        if (this.mospParams.hasErrorMessage()) {
            return new int[0];
        }
        CutoffUtilBeanInterface cutoffUtil = this.timeReference().cutoffUtil();
        CutoffDtoInterface cutoffDto = cutoffUtil.getCutoff(timeSettingDto.getCutoffCode(), date);
        if (this.mospParams.hasErrorMessage()) {
            return new int[0];
        }
        int cutoffDate = cutoffDto.getCutoffDate();
        Date cutoffMounth = TimeUtility.getCutoffMonth((int)cutoffDate, (Date)date);
        return new int[]{DateUtility.getYear((Date)cutoffMounth), DateUtility.getMonth((Date)cutoffMounth)};
    }

    private void setStockHolidayDataDtoFields(StockHolidayDataDtoInterface dto, PaidHolidayDataDtoInterface paidHolidayDataDto) throws MospException {
        String personalId = paidHolidayDataDto.getPersonalId();
        Date activateDate = this.getEditActivateDate();
        ApplicationDtoInterface applicationDto = this.timeReference().application().findForPerson(personalId, activateDate);
        this.timeReference().application().chkExistApplication(applicationDto, this.getEditActivateDate());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        PaidHolidayDtoInterface paidHolidayDto = this.timeReference().paidHoliday().getPaidHolidayInfo(applicationDto.getPaidHolidayCode(), this.getEditActivateDate());
        this.timeReference().paidHoliday().chkExistPaidHoliday(paidHolidayDto, this.getEditActivateDate());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        StockHolidayDtoInterface stockHolidayDto = this.timeReference().stockHoliday().getStockHolidayInfo(paidHolidayDto.getPaidHolidayCode(), paidHolidayDto.getActivateDate());
        if (stockHolidayDto == null) {
            this.addNotStockVacationGrantErrorMessage();
            return;
        }
        dto.setPersonalId(personalId);
        dto.setActivateDate(activateDate);
        Date acquisitionDate = DateUtility.addDay((Date)paidHolidayDataDto.getLimitDate(), (int)1);
        while (this.getEditActivateDate().before(acquisitionDate)) {
            acquisitionDate = DateUtility.addYear((Date)acquisitionDate, (int)-1);
        }
        dto.setAcquisitionDate(acquisitionDate);
        dto.setLimitDate(DateUtility.addDay((Date)DateUtility.addMonth((Date)dto.getAcquisitionDate(), (int)stockHolidayDto.getStockLimitDate()), (int)-1));
    }

    private PaidHolidayDataDtoInterface getPaidHolidayDataDto(Date activateDate) throws MospException {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        PaidHolidayDataGrantBeanInterface paidHolidayDataGrant = this.time().paidHolidayDataGrant();
        String personalId = vo.getPersonalId();
        Date entranceDate = this.reference().entrance().getEntranceDate(personalId);
        if (entranceDate == null) {
            this.addNotJoinedGrantErrorMessage();
            return null;
        }
        ApplicationDtoInterface applicationDto = this.timeReference().application().findForPerson(personalId, this.getEditActivateDate());
        this.timeReference().application().chkExistApplication(applicationDto, this.getEditActivateDate());
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        PaidHolidayDtoInterface paidHolidayDto = this.timeReference().paidHoliday().getPaidHolidayInfo(applicationDto.getPaidHolidayCode(), this.getEditActivateDate());
        this.timeReference().paidHoliday().chkExistPaidHoliday(paidHolidayDto, this.getEditActivateDate());
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        int paidHolidayType = paidHolidayDto.getPaidHolidayType();
        if (paidHolidayType == 0) {
            return this.getPaidHolidayDataDtoForPoint(paidHolidayDto, entranceDate, activateDate);
        }
        if (paidHolidayType == 1) {
            return this.getPaidHolidayDataDtoForEntranceMonth(paidHolidayDto, entranceDate, activateDate);
        }
        if (paidHolidayType == 2) {
            return this.getPaidHolidayDataDtoForEntranceDate(paidHolidayDto, entranceDate, activateDate);
        }
        if (paidHolidayType == 3) {
            return null;
        }
        if (paidHolidayType == 4) {
            return paidHolidayDataGrant.create(vo.getPersonalId(), activateDate, false);
        }
        return null;
    }

    protected PaidHolidayDataDtoInterface getPaidHolidayDataDtoForPoint(PaidHolidayDtoInterface paidHolidayDto, Date entranceDate, Date activateDate) throws MospException {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        PaidHolidayDataDtoInterface dto = this.time().paidHolidayDataRegist().getInitDto();
        dto.setPersonalId(vo.getPersonalId());
        dto.setTemporaryFlag(1);
        int pointDay = paidHolidayDto.getPointDateDay();
        Date pointDate = DateUtility.getDate((int)DateUtility.getYear((Date)entranceDate), (int)paidHolidayDto.getPointDateMonth(), (int)pointDay);
        if (!entranceDate.before(pointDate)) {
            pointDate = DateUtility.addYear((Date)pointDate, (int)1);
        }
        PaidHolidayFirstYearDtoInterface paidHolidayFirstYearDto = this.timeReference().paidHolidayFirstYear().findForKey(paidHolidayDto.getPaidHolidayCode(), paidHolidayDto.getActivateDate(), DateUtility.getMonth((Date)entranceDate));
        Date firstYearAcquisitionDate = null;
        if (paidHolidayFirstYearDto != null) {
            firstYearAcquisitionDate = DateUtility.addDay((Date)DateUtility.addMonth((Date)MonthUtility.getYearMonthTermFirstDate((int)DateUtility.getYear((Date)entranceDate), (int)DateUtility.getMonth((Date)entranceDate), (MospParams)this.mospParams), (int)paidHolidayFirstYearDto.getGivingMonth()), (int)(pointDay - 1));
            if (paidHolidayFirstYearDto.getGivingAmount() > 0) {
                Date acquisitionDate = firstYearAcquisitionDate;
                Date limitDate = DateUtility.addDay((Date)DateUtility.addMonth((Date)firstYearAcquisitionDate, (int)paidHolidayFirstYearDto.getGivingLimit()), (int)-1);
                if (limitDate.before(firstYearAcquisitionDate)) {
                    limitDate = firstYearAcquisitionDate;
                }
                if (!pointDate.after(acquisitionDate)) {
                    pointDate = DateUtility.addYear((Date)pointDate, (int)1);
                }
                if (activateDate.before(acquisitionDate)) {
                    return null;
                }
                if (!activateDate.after(limitDate) && activateDate.before(pointDate)) {
                    dto.setActivateDate(acquisitionDate);
                    dto.setAcquisitionDate(acquisitionDate);
                    dto.setLimitDate(limitDate);
                    return dto;
                }
                if (activateDate.before(pointDate)) {
                    return null;
                }
            }
        }
        while (pointDate.before(activateDate)) {
            pointDate = DateUtility.addYear((Date)pointDate, (int)1);
        }
        if (pointDate.compareTo(activateDate) != 0) {
            pointDate = DateUtility.addYear((Date)pointDate, (int)-1);
        }
        if (firstYearAcquisitionDate != null && pointDate.before(firstYearAcquisitionDate)) {
            return null;
        }
        dto.setActivateDate(pointDate);
        dto.setAcquisitionDate(pointDate);
        int maxCarryOverYear = paidHolidayDto.getMaxCarryOverYear();
        if (maxCarryOverYear == 0) {
            dto.setLimitDate(DateUtility.addDay((Date)DateUtility.addYear((Date)pointDate, (int)2), (int)-1));
        } else if (maxCarryOverYear == 1) {
            dto.setLimitDate(DateUtility.addDay((Date)DateUtility.addYear((Date)pointDate, (int)1), (int)-1));
        }
        return dto;
    }

    protected PaidHolidayDataDtoInterface getPaidHolidayDataDtoForEntranceMonth(PaidHolidayDtoInterface paidHolidayDto, Date entranceDate, Date activateDate) throws MospException {
        Date acquisitionDate;
        PaidHolidayDataDtoInterface dto;
        block19: {
            Date workDate;
            PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
            int entranceYear = DateUtility.getYear((Date)entranceDate);
            int entranceMonth = DateUtility.getMonth((Date)entranceDate);
            ApplicationDtoInterface applicationDto = this.timeReference().application().findForPerson(vo.getPersonalId(), this.getEditActivateDate());
            if (applicationDto == null) {
                return null;
            }
            TimeSettingDtoInterface timeSettingDto = this.timeReference().timeSetting().getTimeSettingInfo(applicationDto.getWorkSettingCode(), this.getEditActivateDate());
            if (timeSettingDto == null) {
                return null;
            }
            CutoffDtoInterface cutoffDto = this.timeReference().cutoff().getCutoffInfo(timeSettingDto.getCutoffCode(), this.getEditActivateDate());
            if (cutoffDto == null) {
                return null;
            }
            dto = this.time().paidHolidayDataRegist().getInitDto();
            dto.setPersonalId(vo.getPersonalId());
            dto.setTemporaryFlag(1);
            Date pointDate = DateUtility.addDay((Date)MonthUtility.getYearMonthTermLastDate((int)entranceYear, (int)entranceMonth, (MospParams)this.mospParams), (int)1);
            int cutoffDate = cutoffDto.getCutoffDate();
            if (cutoffDate != 0) {
                pointDate = DateUtility.addDay((Date)DateUtility.getDate((int)entranceYear, (int)entranceMonth, (int)cutoffDate), (int)1);
            }
            List list = this.timeReference().paidHolidayEntranceDate().findForList(paidHolidayDto.getPaidHolidayCode(), paidHolidayDto.getActivateDate());
            Date nextAcquisitionDate = null;
            PaidHolidayFirstYearDtoInterface paidHolidayFirstYearDto = this.timeReference().paidHolidayFirstYear().findForKey(paidHolidayDto.getPaidHolidayCode(), paidHolidayDto.getActivateDate(), DateUtility.getMonth((Date)entranceDate));
            if (paidHolidayFirstYearDto != null && paidHolidayFirstYearDto.getGivingAmount() > 0) {
                acquisitionDate = DateUtility.addMonth((Date)pointDate, (int)paidHolidayFirstYearDto.getGivingMonth());
                Date limitDate = DateUtility.addDay((Date)DateUtility.addMonth((Date)acquisitionDate, (int)paidHolidayFirstYearDto.getGivingLimit()), (int)-1);
                Date maxDate = pointDate;
                for (PaidHolidayEntranceDateDtoInterface paidHolidayEntranceDateDto : list) {
                    workDate = DateUtility.addMonth((Date)entranceDate, (int)paidHolidayEntranceDateDto.getWorkMonth());
                    if (!acquisitionDate.before(workDate)) continue;
                    if (maxDate.before(workDate)) {
                        maxDate = workDate;
                    }
                    if (nextAcquisitionDate != null && !nextAcquisitionDate.after(workDate)) continue;
                    nextAcquisitionDate = workDate;
                }
                while (nextAcquisitionDate == null) {
                    if (!acquisitionDate.before(maxDate = DateUtility.addMonth((Date)maxDate, (int)paidHolidayDto.getGeneralJoiningMonth()))) continue;
                    nextAcquisitionDate = maxDate;
                }
                if (activateDate.before(acquisitionDate)) {
                    return null;
                }
                if (!activateDate.after(limitDate) && activateDate.before(nextAcquisitionDate)) {
                    dto.setActivateDate(acquisitionDate);
                    dto.setAcquisitionDate(acquisitionDate);
                    dto.setLimitDate(limitDate);
                    return dto;
                }
                if (activateDate.before(nextAcquisitionDate)) {
                    return null;
                }
            }
            acquisitionDate = null;
            Date maxDate = pointDate;
            Date maxWorkDate = null;
            for (PaidHolidayEntranceDateDtoInterface paidHolidayEntranceDateDto : list) {
                workDate = DateUtility.addMonth((Date)pointDate, (int)paidHolidayEntranceDateDto.getWorkMonth());
                if (maxDate.before(workDate)) {
                    maxDate = workDate;
                }
                if (workDate.after(activateDate) || maxWorkDate != null && !maxWorkDate.before(workDate)) continue;
                maxWorkDate = workDate;
            }
            if (maxWorkDate.equals(maxDate)) {
                while (true) {
                    Date nextDate = DateUtility.addMonth((Date)maxDate, (int)paidHolidayDto.getGeneralJoiningMonth());
                    if (!maxDate.after(activateDate) && nextDate.after(activateDate)) {
                        acquisitionDate = maxDate;
                        break block19;
                    }
                    maxDate = nextDate;
                }
            }
            acquisitionDate = maxWorkDate;
        }
        dto.setActivateDate(acquisitionDate);
        dto.setAcquisitionDate(acquisitionDate);
        int maxCarryOverYear = paidHolidayDto.getMaxCarryOverYear();
        if (maxCarryOverYear == 0) {
            dto.setLimitDate(DateUtility.addDay((Date)DateUtility.addYear((Date)acquisitionDate, (int)2), (int)-1));
        } else if (maxCarryOverYear == 1) {
            dto.setLimitDate(DateUtility.addDay((Date)DateUtility.addYear((Date)acquisitionDate, (int)1), (int)-1));
        }
        return dto;
    }

    protected PaidHolidayDataDtoInterface getPaidHolidayDataDtoForEntranceDate(PaidHolidayDtoInterface paidHolidayDto, Date entranceDate, Date activateDate) throws MospException {
        Date acquisitionDate;
        PaidHolidayDataDtoInterface dto;
        block15: {
            Date workDate;
            PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
            dto = this.time().paidHolidayDataRegist().getInitDto();
            dto.setPersonalId(vo.getPersonalId());
            dto.setTemporaryFlag(1);
            List list = this.timeReference().paidHolidayEntranceDate().findForList(paidHolidayDto.getPaidHolidayCode(), paidHolidayDto.getActivateDate());
            Date nextAcquisitionDate = null;
            PaidHolidayFirstYearDtoInterface paidHolidayFirstYearDto = this.timeReference().paidHolidayFirstYear().findForKey(paidHolidayDto.getPaidHolidayCode(), paidHolidayDto.getActivateDate(), DateUtility.getMonth((Date)entranceDate));
            if (paidHolidayFirstYearDto != null && paidHolidayFirstYearDto.getGivingAmount() > 0) {
                acquisitionDate = DateUtility.addMonth((Date)entranceDate, (int)paidHolidayFirstYearDto.getGivingMonth());
                Date limitDate = DateUtility.addDay((Date)DateUtility.addMonth((Date)acquisitionDate, (int)paidHolidayFirstYearDto.getGivingLimit()), (int)-1);
                Date maxDate = entranceDate;
                for (PaidHolidayEntranceDateDtoInterface paidHolidayEntranceDateDto : list) {
                    workDate = DateUtility.addMonth((Date)entranceDate, (int)paidHolidayEntranceDateDto.getWorkMonth());
                    if (!acquisitionDate.before(workDate)) continue;
                    if (maxDate.before(workDate)) {
                        maxDate = workDate;
                    }
                    if (nextAcquisitionDate != null && !nextAcquisitionDate.after(workDate)) continue;
                    nextAcquisitionDate = workDate;
                }
                while (nextAcquisitionDate == null) {
                    if (!acquisitionDate.before(maxDate = DateUtility.addMonth((Date)maxDate, (int)paidHolidayDto.getGeneralJoiningMonth()))) continue;
                    nextAcquisitionDate = maxDate;
                }
                if (activateDate.before(acquisitionDate)) {
                    return null;
                }
                if (!activateDate.after(limitDate) && activateDate.before(nextAcquisitionDate)) {
                    dto.setActivateDate(acquisitionDate);
                    dto.setAcquisitionDate(acquisitionDate);
                    dto.setLimitDate(limitDate);
                    return dto;
                }
                if (activateDate.before(nextAcquisitionDate)) {
                    return null;
                }
            }
            acquisitionDate = null;
            Date maxDate = entranceDate;
            Date maxWorkDate = null;
            for (PaidHolidayEntranceDateDtoInterface paidHolidayEntranceDateDto : list) {
                workDate = DateUtility.addMonth((Date)entranceDate, (int)paidHolidayEntranceDateDto.getWorkMonth());
                if (maxDate.before(workDate)) {
                    maxDate = workDate;
                }
                if (workDate.after(activateDate) || maxWorkDate != null && !maxWorkDate.before(workDate)) continue;
                maxWorkDate = workDate;
            }
            if (maxWorkDate.equals(maxDate)) {
                while (true) {
                    Date nextDate = DateUtility.addMonth((Date)maxDate, (int)paidHolidayDto.getGeneralJoiningMonth());
                    if (!maxDate.after(activateDate) && nextDate.after(activateDate)) {
                        acquisitionDate = maxDate;
                        break block15;
                    }
                    maxDate = nextDate;
                }
            }
            acquisitionDate = maxWorkDate;
        }
        dto.setActivateDate(acquisitionDate);
        dto.setAcquisitionDate(acquisitionDate);
        int maxCarryOverYear = paidHolidayDto.getMaxCarryOverYear();
        if (maxCarryOverYear == 0) {
            dto.setLimitDate(DateUtility.addDay((Date)DateUtility.addYear((Date)acquisitionDate, (int)2), (int)-1));
        } else if (maxCarryOverYear == 1) {
            dto.setLimitDate(DateUtility.addDay((Date)DateUtility.addYear((Date)acquisitionDate, (int)1), (int)-1));
        }
        return dto;
    }

    private StockHolidayDataDtoInterface getStockHolidayDataDto(Date activateDate, Date editAcquisitionDate) throws MospException {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        EntranceDtoInterface entranceDto = this.reference().entrance().getEntranceInfo(personalId);
        if (entranceDto == null) {
            this.addNotJoinedGrantErrorMessage();
            return null;
        }
        ApplicationDtoInterface applicationDto = this.timeReference().application().findForPerson(personalId, this.getEditActivateDate());
        this.timeReference().application().chkExistApplication(applicationDto, this.getEditActivateDate());
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        PaidHolidayDtoInterface paidHolidayDto = this.timeReference().paidHoliday().getPaidHolidayInfo(applicationDto.getPaidHolidayCode(), this.getEditActivateDate());
        this.timeReference().paidHoliday().chkExistPaidHoliday(paidHolidayDto, this.getEditActivateDate());
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        StockHolidayDtoInterface stockHolidayDto = this.timeReference().stockHoliday().getStockHolidayInfo(paidHolidayDto.getPaidHolidayCode(), paidHolidayDto.getActivateDate());
        if (stockHolidayDto == null) {
            this.addNotStockVacationGrantErrorMessage();
            return null;
        }
        int paidHolidayType = paidHolidayDto.getPaidHolidayType();
        if (paidHolidayType == 0) {
            return this.getStockHolidayDataDtoForPoint(entranceDto.getEntranceDate(), paidHolidayDto, stockHolidayDto, activateDate, editAcquisitionDate);
        }
        if (paidHolidayType == 1) {
            return this.getStockHolidayDataDtoForEntranceMonth(entranceDto.getEntranceDate(), paidHolidayDto, stockHolidayDto, activateDate, editAcquisitionDate);
        }
        if (paidHolidayType == 2) {
            return this.getStockHolidayDataDtoForEntranceDate(entranceDto.getEntranceDate(), paidHolidayDto, stockHolidayDto, activateDate, editAcquisitionDate);
        }
        if (paidHolidayType == 4) {
            return this.getStockHolidayDataDtoForProportionally(stockHolidayDto, activateDate);
        }
        return null;
    }

    protected StockHolidayDataDtoInterface getStockHolidayDataDtoForPoint(Date entranceDate, PaidHolidayDtoInterface paidHolidayDto, StockHolidayDtoInterface stockHolidayDto, Date activateDate, Date editAcquisitionDate) throws MospException {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        PaidHolidayFirstYearReferenceBeanInterface firstYearRefer = this.timeReference().paidHolidayFirstYear();
        StockHolidayDataReferenceBeanInterface stockHolidayDataRefer = this.timeReference().stockHolidayData();
        String paidHolidayCode = paidHolidayDto.getPaidHolidayCode();
        Date paidHolidayActivateDate = paidHolidayDto.getActivateDate();
        int pointDay = paidHolidayDto.getPointDateDay();
        Date pointDate = DateUtility.getDate((int)DateUtility.getYear((Date)entranceDate), (int)paidHolidayDto.getPointDateMonth(), (int)pointDay);
        if (!entranceDate.before(pointDate)) {
            pointDate = DateUtility.addYear((Date)pointDate, (int)1);
        }
        Date paidHolidayLimitDate = null;
        PaidHolidayFirstYearDtoInterface paidHolidayFirstYearDto = firstYearRefer.findForKey(paidHolidayCode, paidHolidayActivateDate, DateUtility.getMonth((Date)entranceDate));
        Date firstYearAcquisitionDate = null;
        if (paidHolidayFirstYearDto != null) {
            firstYearAcquisitionDate = DateUtility.addDay((Date)DateUtility.addMonth((Date)MonthUtility.getYearMonthTermFirstDate((int)DateUtility.getYear((Date)entranceDate), (int)DateUtility.getMonth((Date)entranceDate), (MospParams)this.mospParams), (int)paidHolidayFirstYearDto.getGivingMonth()), (int)(pointDay - 1));
            if (paidHolidayFirstYearDto.getGivingAmount() > 0) {
                Date acquisitionDate = firstYearAcquisitionDate;
                paidHolidayLimitDate = DateUtility.addDay((Date)DateUtility.addMonth((Date)firstYearAcquisitionDate, (int)paidHolidayFirstYearDto.getGivingLimit()), (int)-1);
                if (paidHolidayLimitDate.before(firstYearAcquisitionDate)) {
                    paidHolidayLimitDate = firstYearAcquisitionDate;
                }
                if (!pointDate.after(acquisitionDate)) {
                    pointDate = DateUtility.addYear((Date)pointDate, (int)1);
                }
                if (!activateDate.after(paidHolidayLimitDate)) {
                    StockHolidayDataDtoInterface stockDataDto = null;
                    if (editAcquisitionDate != null) {
                        stockDataDto = stockHolidayDataRefer.findForKey(vo.getPersonalId(), this.getEditActivateDate(), editAcquisitionDate);
                    }
                    return stockDataDto;
                }
            }
        }
        Date paidHolidayAfterLimitDate = null;
        while (true) {
            int maxCarryOverYear;
            if ((maxCarryOverYear = paidHolidayDto.getMaxCarryOverYear()) == 0) {
                paidHolidayAfterLimitDate = DateUtility.addDay((Date)DateUtility.addYear((Date)pointDate, (int)2), (int)-1);
            } else if (maxCarryOverYear == 1) {
                paidHolidayAfterLimitDate = DateUtility.addDay((Date)DateUtility.addYear((Date)pointDate, (int)1), (int)-1);
            } else {
                StockHolidayDataDtoInterface stockDataDto = null;
                if (editAcquisitionDate != null) {
                    stockDataDto = stockHolidayDataRefer.findForKey(vo.getPersonalId(), this.getEditActivateDate(), editAcquisitionDate);
                }
                return stockDataDto;
            }
            if (paidHolidayLimitDate == null && !activateDate.after(paidHolidayAfterLimitDate)) {
                StockHolidayDataDtoInterface stockDataDto = null;
                if (editAcquisitionDate != null) {
                    stockDataDto = stockHolidayDataRefer.findForKey(vo.getPersonalId(), this.getEditActivateDate(), editAcquisitionDate);
                }
                return stockDataDto;
            }
            if (paidHolidayLimitDate != null && activateDate.after(paidHolidayLimitDate) && !activateDate.after(paidHolidayAfterLimitDate)) {
                StockHolidayDataDtoInterface dto = this.time().stockHolidayDataRegist().getInitDto();
                dto.setPersonalId(vo.getPersonalId());
                dto.setAcquisitionDate(DateUtility.addDay((Date)paidHolidayLimitDate, (int)1));
                dto.setActivateDate(dto.getAcquisitionDate());
                dto.setLimitDate(DateUtility.addDay((Date)DateUtility.addMonth((Date)dto.getAcquisitionDate(), (int)stockHolidayDto.getStockLimitDate()), (int)-1));
                return dto;
            }
            pointDate = DateUtility.addYear((Date)pointDate, (int)1);
            paidHolidayLimitDate = paidHolidayAfterLimitDate;
        }
    }

    protected StockHolidayDataDtoInterface getStockHolidayDataDtoForEntranceMonth(Date entranceDate, PaidHolidayDtoInterface paidHolidayDto, StockHolidayDtoInterface stockHolidayDto, Date activateDate, Date editAcquisitionDate) throws MospException {
        Date paidHolidayLimitDate;
        String personalId;
        block20: {
            int entranceYear = DateUtility.getYear((Date)entranceDate);
            int entranceMonth = DateUtility.getMonth((Date)entranceDate);
            PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
            ApplicationReferenceBeanInterface applicationRefer = this.timeReference().application();
            TimeSettingReferenceBeanInterface timeSettingRefer = this.timeReference().timeSetting();
            CutoffReferenceBeanInterface cutOffRefer = this.timeReference().cutoff();
            PaidHolidayEntranceDateReferenceBeanInterface paidHolidayEntranceDate = this.timeReference().paidHolidayEntranceDate();
            StockHolidayDataReferenceBeanInterface stockHolidayData = this.timeReference().stockHolidayData();
            personalId = vo.getPersonalId();
            String paidHolidayCode = paidHolidayDto.getPaidHolidayCode();
            Date paidHolidayActivateDate = paidHolidayDto.getActivateDate();
            ApplicationDtoInterface applicationDto = applicationRefer.findForPerson(personalId, this.getEditActivateDate());
            if (applicationDto == null) {
                return null;
            }
            TimeSettingDtoInterface timeSettingDto = timeSettingRefer.getTimeSettingInfo(applicationDto.getWorkSettingCode(), this.getEditActivateDate());
            if (timeSettingDto == null) {
                return null;
            }
            CutoffDtoInterface cutoffDto = cutOffRefer.getCutoffInfo(timeSettingDto.getCutoffCode(), this.getEditActivateDate());
            if (cutoffDto == null) {
                return null;
            }
            Date pointDate = DateUtility.addDay((Date)MonthUtility.getYearMonthTermLastDate((int)entranceYear, (int)entranceMonth, (MospParams)this.mospParams), (int)1);
            int cutoffDate = cutoffDto.getCutoffDate();
            if (cutoffDate != 0) {
                pointDate = DateUtility.addDay((Date)DateUtility.getDate((int)entranceYear, (int)entranceMonth, (int)cutoffDate), (int)1);
            }
            List list = paidHolidayEntranceDate.findForList(paidHolidayCode, paidHolidayActivateDate);
            Date nextAcquisitionDate = null;
            paidHolidayLimitDate = null;
            PaidHolidayFirstYearDtoInterface paidHolidayFirstYearDto = this.timeReference().paidHolidayFirstYear().findForKey(paidHolidayCode, paidHolidayActivateDate, DateUtility.getMonth((Date)entranceDate));
            if (paidHolidayFirstYearDto != null && paidHolidayFirstYearDto.getGivingAmount() > 0) {
                Date acquisitionDate = DateUtility.addMonth((Date)pointDate, (int)paidHolidayFirstYearDto.getGivingMonth());
                paidHolidayLimitDate = DateUtility.addDay((Date)DateUtility.addMonth((Date)acquisitionDate, (int)paidHolidayFirstYearDto.getGivingLimit()), (int)-1);
                Date maxDate = entranceDate;
                for (PaidHolidayEntranceDateDtoInterface paidHolidayEntranceDateDto : list) {
                    Date workDate = DateUtility.addMonth((Date)entranceDate, (int)paidHolidayEntranceDateDto.getWorkMonth());
                    if (!acquisitionDate.before(workDate)) continue;
                    if (maxDate.before(workDate)) {
                        maxDate = workDate;
                    }
                    if (nextAcquisitionDate != null && !nextAcquisitionDate.after(workDate)) continue;
                    nextAcquisitionDate = workDate;
                }
                while (nextAcquisitionDate == null) {
                    if (!acquisitionDate.before(maxDate = DateUtility.addMonth((Date)maxDate, (int)paidHolidayDto.getGeneralJoiningMonth()))) continue;
                    nextAcquisitionDate = maxDate;
                }
                if (!activateDate.after(paidHolidayLimitDate)) {
                    StockHolidayDataDtoInterface stockDataDto = null;
                    if (editAcquisitionDate != null) {
                        stockDataDto = stockHolidayData.findForKey(personalId, this.getEditActivateDate(), editAcquisitionDate);
                    }
                    return stockDataDto;
                }
            }
            Date maxDate = pointDate;
            Date maxWorkDate = null;
            Date maxLimitDate = null;
            int maxCarryOverYear = paidHolidayDto.getMaxCarryOverYear();
            for (PaidHolidayEntranceDateDtoInterface paidHolidayEntranceDateDto : list) {
                Date workDate = DateUtility.addMonth((Date)pointDate, (int)paidHolidayEntranceDateDto.getWorkMonth());
                if (maxDate.before(workDate)) {
                    maxDate = workDate;
                }
                Date limitDate = DateUtility.addDay((Date)DateUtility.addYear((Date)workDate, (int)1), (int)-1);
                if (maxCarryOverYear == 0) {
                    limitDate = DateUtility.addDay((Date)DateUtility.addYear((Date)workDate, (int)2), (int)-1);
                }
                if (limitDate.after(activateDate) || maxLimitDate != null && !maxLimitDate.before(limitDate)) continue;
                maxLimitDate = limitDate;
                maxWorkDate = workDate;
            }
            if (maxWorkDate != null) {
                if (maxWorkDate.equals(maxDate)) {
                    while (true) {
                        Date nextDate = DateUtility.addMonth((Date)maxDate, (int)paidHolidayDto.getGeneralJoiningMonth());
                        Date nextLimitDate = null;
                        if (maxCarryOverYear == 0) {
                            nextLimitDate = DateUtility.addDay((Date)DateUtility.addYear((Date)nextDate, (int)2), (int)-1);
                        } else if (maxCarryOverYear == 1) {
                            nextLimitDate = DateUtility.addDay((Date)DateUtility.addYear((Date)nextDate, (int)1), (int)-1);
                        }
                        if (!maxLimitDate.after(activateDate) && nextLimitDate.after(activateDate)) {
                            paidHolidayLimitDate = maxLimitDate;
                            break block20;
                        }
                        maxLimitDate = nextLimitDate;
                    }
                }
                paidHolidayLimitDate = maxLimitDate;
            }
        }
        StockHolidayDataDtoInterface dto = this.time().stockHolidayDataRegist().getInitDto();
        dto.setPersonalId(personalId);
        dto.setAcquisitionDate(DateUtility.addDay((Date)paidHolidayLimitDate, (int)1));
        dto.setActivateDate(dto.getAcquisitionDate());
        dto.setLimitDate(DateUtility.addDay((Date)DateUtility.addMonth((Date)dto.getAcquisitionDate(), (int)stockHolidayDto.getStockLimitDate()), (int)-1));
        return dto;
    }

    protected StockHolidayDataDtoInterface getStockHolidayDataDtoForEntranceDate(Date entranceDate, PaidHolidayDtoInterface paidHolidayDto, StockHolidayDtoInterface stockHolidayDto, Date activateDate, Date editAcquisitionDate) throws MospException {
        Date paidHolidayLimitDate;
        PaidHolidayHistoryVo vo;
        block18: {
            vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
            List list = this.timeReference().paidHolidayEntranceDate().findForList(paidHolidayDto.getPaidHolidayCode(), paidHolidayDto.getActivateDate());
            Date nextAcquisitionDate = null;
            paidHolidayLimitDate = null;
            PaidHolidayFirstYearDtoInterface paidHolidayFirstYearDto = this.timeReference().paidHolidayFirstYear().findForKey(paidHolidayDto.getPaidHolidayCode(), paidHolidayDto.getActivateDate(), DateUtility.getMonth((Date)entranceDate));
            if (paidHolidayFirstYearDto != null && paidHolidayFirstYearDto.getGivingAmount() > 0) {
                Date acquisitionDate = DateUtility.addMonth((Date)entranceDate, (int)paidHolidayFirstYearDto.getGivingMonth());
                paidHolidayLimitDate = DateUtility.addDay((Date)DateUtility.addMonth((Date)acquisitionDate, (int)paidHolidayFirstYearDto.getGivingLimit()), (int)-1);
                Date maxDate = entranceDate;
                for (PaidHolidayEntranceDateDtoInterface paidHolidayEntranceDateDto : list) {
                    Date workDate = DateUtility.addMonth((Date)entranceDate, (int)paidHolidayEntranceDateDto.getWorkMonth());
                    if (!acquisitionDate.before(workDate)) continue;
                    if (maxDate.before(workDate)) {
                        maxDate = workDate;
                    }
                    if (nextAcquisitionDate != null && !nextAcquisitionDate.after(workDate)) continue;
                    nextAcquisitionDate = workDate;
                }
                while (nextAcquisitionDate == null) {
                    if (!acquisitionDate.before(maxDate = DateUtility.addMonth((Date)maxDate, (int)paidHolidayDto.getGeneralJoiningMonth()))) continue;
                    nextAcquisitionDate = maxDate;
                }
                if (!activateDate.after(paidHolidayLimitDate)) {
                    StockHolidayDataDtoInterface stockDataDto = null;
                    if (editAcquisitionDate != null) {
                        stockDataDto = this.timeReference().stockHolidayData().findForKey(vo.getPersonalId(), this.getEditActivateDate(), editAcquisitionDate);
                    }
                    return stockDataDto;
                }
            }
            Date maxDate = entranceDate;
            Date maxWorkDate = null;
            Date maxLimitDate = null;
            int maxCarryOverYear = paidHolidayDto.getMaxCarryOverYear();
            for (PaidHolidayEntranceDateDtoInterface paidHolidayEntranceDateDto : list) {
                Date workDate = DateUtility.addMonth((Date)entranceDate, (int)paidHolidayEntranceDateDto.getWorkMonth());
                if (maxDate.before(workDate)) {
                    maxDate = workDate;
                }
                Date limitDate = null;
                if (maxCarryOverYear == 0) {
                    limitDate = DateUtility.addDay((Date)DateUtility.addYear((Date)workDate, (int)2), (int)-1);
                } else if (maxCarryOverYear == 1) {
                    limitDate = DateUtility.addDay((Date)DateUtility.addYear((Date)workDate, (int)1), (int)-1);
                }
                if (limitDate == null || limitDate.after(activateDate) || maxLimitDate != null && !maxLimitDate.before(limitDate)) continue;
                maxLimitDate = limitDate;
                maxWorkDate = workDate;
            }
            if (maxWorkDate != null) {
                if (maxWorkDate.equals(maxDate)) {
                    while (true) {
                        Date nextDate = DateUtility.addMonth((Date)maxDate, (int)paidHolidayDto.getGeneralJoiningMonth());
                        Date nextLimitDate = null;
                        if (maxCarryOverYear == 0) {
                            nextLimitDate = DateUtility.addDay((Date)DateUtility.addYear((Date)nextDate, (int)2), (int)-1);
                        } else if (maxCarryOverYear == 1) {
                            nextLimitDate = DateUtility.addDay((Date)DateUtility.addYear((Date)nextDate, (int)1), (int)-1);
                        }
                        if (nextLimitDate != null && !maxLimitDate.after(activateDate) && nextLimitDate.after(activateDate)) {
                            paidHolidayLimitDate = maxLimitDate;
                            break block18;
                        }
                        maxLimitDate = nextLimitDate;
                    }
                }
                paidHolidayLimitDate = maxLimitDate;
            }
        }
        StockHolidayDataDtoInterface dto = this.time().stockHolidayDataRegist().getInitDto();
        dto.setPersonalId(vo.getPersonalId());
        dto.setAcquisitionDate(DateUtility.addDay((Date)paidHolidayLimitDate, (int)1));
        dto.setActivateDate(dto.getAcquisitionDate());
        dto.setLimitDate(DateUtility.addDay((Date)DateUtility.addMonth((Date)dto.getAcquisitionDate(), (int)stockHolidayDto.getStockLimitDate()), (int)-1));
        return dto;
    }

    protected StockHolidayDataDtoInterface getStockHolidayDataDtoForProportionally(StockHolidayDtoInterface stockHolidayDto, Date activateDate) throws MospException {
        String personalId;
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        PaidHolidayDataGrantBeanInterface paidHolidayDataGrant = this.time().paidHolidayDataGrant();
        int grantTimes = paidHolidayDataGrant.getGrantTimes(personalId = vo.getPersonalId(), activateDate);
        if (grantTimes == 0) {
            return null;
        }
        Date grantDate = paidHolidayDataGrant.getGrantDate(personalId, grantTimes);
        if (grantDate == null) {
            return null;
        }
        Date paidHolidayLimitDate = paidHolidayDataGrant.getExpirationDate(personalId, grantDate, grantTimes);
        while (activateDate.compareTo(paidHolidayLimitDate) <= 0) {
            if (--grantTimes == 0) {
                return null;
            }
            grantDate = paidHolidayDataGrant.getGrantDate(personalId, grantTimes);
            paidHolidayLimitDate = paidHolidayDataGrant.getExpirationDate(personalId, grantDate, grantTimes);
        }
        Date stockHolidayAcquisitionDate = DateUtility.addDay((Date)paidHolidayLimitDate, (int)1);
        StockHolidayDataDtoInterface dto = this.timeReference().stockHolidayData().findForKey(personalId, activateDate, stockHolidayAcquisitionDate);
        if (dto == null) {
            dto = this.time().stockHolidayDataRegist().getInitDto();
            dto.setPersonalId(vo.getPersonalId());
            dto.setAcquisitionDate(stockHolidayAcquisitionDate);
            dto.setActivateDate(dto.getAcquisitionDate());
            dto.setLimitDate(DateUtility.addDay((Date)DateUtility.addMonth((Date)dto.getAcquisitionDate(), (int)stockHolidayDto.getStockLimitDate()), (int)-1));
        }
        return dto;
    }

    protected void addNoItemErrorMessage(String mes1, String mes2) {
        this.mospParams.addErrorMessage("PFW0201", new String[]{mes1, mes2});
    }

    protected void addSalariedVacationExceptErrorMessage() {
        String mes = this.mospParams.getName("Salaried", new String[]{"Vacation", "Effectiveness", "Period", "Except"});
        this.mospParams.addErrorMessage("TMW0255", new String[]{mes});
    }

    protected void addNotStockVacationGrantErrorMessage() {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        String mes1 = DateUtility.getStringDate((Date)this.getEditActivateDate());
        String mes2 = vo.getTxtEditEmployeeCode();
        this.mospParams.addErrorMessage("TMW0256", new String[]{mes1, mes2});
    }

    protected void addNotJoinedGrantErrorMessage() {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        String mes1 = DateUtility.getStringDate((Date)this.getEditActivateDate());
        String mes2 = vo.getTxtEditEmployeeCode();
        this.mospParams.addErrorMessage("TMW0257", new String[]{mes1, mes2});
    }

    protected void addNotWithPayVacationGrantErrorMessage() {
        PaidHolidayHistoryVo vo = (PaidHolidayHistoryVo)this.mospParams.getVo();
        String mes1 = DateUtility.getStringDate((Date)this.getEditActivateDate());
        String mes2 = vo.getTxtEditEmployeeCode();
        this.mospParams.addErrorMessage("TMW0258", new String[]{mes1, mes2});
    }
}

