/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataGrantBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataRegistBeanInterface;
import jp.mosp.time.bean.PaidHolidayGrantReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayGrantRegistBeanInterface;
import jp.mosp.time.bean.PaidHolidayReferenceBeanInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayGrantDtoInterface;
import jp.mosp.time.settings.vo.PaidHolidayDataGrantCardVo;

public class PaidHolidayDataGrantCardAction
extends TimeAction {
    public static final String CMD_SELECT_SHOW = "TM041001";
    public static final String CMD_REGIST = "TM041004";
    public static final String CMD_DELETE = "TM041005";

    protected BaseVo getSpecificVo() {
        return new PaidHolidayDataGrantCardVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected void select() throws MospException {
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getTargetDate();
        this.setEmployeeInfo(personalId, targetDate);
        this.setPaidHolidayDataList();
    }

    protected void regist() throws MospException {
        PaidHolidayDataGrantCardVo vo = (PaidHolidayDataGrantCardVo)this.mospParams.getVo();
        PaidHolidayDataReferenceBeanInterface paidHolidayData = this.timeReference().paidHolidayData();
        PaidHolidayDataRegistBeanInterface paidHolidayDataRegist = this.time().paidHolidayDataRegist();
        for (int i = 0; i < vo.getAryRecordId().length; ++i) {
            PaidHolidayDataDtoInterface dto = paidHolidayData.findForKey(vo.getAryRecordId()[i]);
            if (dto == null) {
                dto = paidHolidayDataRegist.getInitDto();
                this.insert(dto, i);
            } else {
                this.update(dto, i);
            }
            if (this.mospParams.hasErrorMessage()) {
                this.addUpdateFailedMessage();
                return;
            }
            this.paidHolidayGrantRegist(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.setPaidHolidayDataList();
    }

    protected void insert(PaidHolidayDataDtoInterface dto, int i) throws MospException {
        PaidHolidayDataGrantCardVo vo = (PaidHolidayDataGrantCardVo)this.mospParams.getVo();
        PaidHolidayDataRegistBeanInterface regist = this.time().paidHolidayDataRegist();
        ApplicationReferenceBeanInterface application = this.timeReference().application();
        PaidHolidayReferenceBeanInterface paidHoliday = this.timeReference().paidHoliday();
        Date grantDate = this.getDate(vo.getAryLblGrantDate()[i]);
        ApplicationDtoInterface applicationDto = application.findForPerson(vo.getPersonalId(), grantDate);
        application.chkExistApplication(applicationDto, grantDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        PaidHolidayDtoInterface paidHolidayDto = paidHoliday.getPaidHolidayInfo(applicationDto.getPaidHolidayCode(), grantDate);
        paidHoliday.chkExistPaidHoliday(paidHolidayDto, grantDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.setDtoFields(dto, paidHolidayDto);
        this.setDtoFields(dto, i, true);
        regist.checkModify(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        regist.insert(dto);
    }

    protected void update(PaidHolidayDataDtoInterface dto, int i) throws MospException {
        PaidHolidayDataRegistBeanInterface regist = this.time().paidHolidayDataRegist();
        this.setDtoFields(dto, i, false);
        regist.checkModify(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        regist.update(dto);
    }

    protected void delete() throws MospException {
        PaidHolidayDataGrantCardVo vo = (PaidHolidayDataGrantCardVo)this.mospParams.getVo();
        PaidHolidayDataRegistBeanInterface regist = this.time().paidHolidayDataRegist();
        PaidHolidayDataReferenceBeanInterface paidHolidayData = this.timeReference().paidHolidayData();
        PaidHolidayDataDtoInterface dto = paidHolidayData.findForKey(vo.getAryRecordId()[this.getTransferredIndex()]);
        if (dto == null) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        regist.checkDeleteConfirm(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        regist.delete(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.paidHolidayGrantDelete(dto.getAcquisitionDate());
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteMessage();
        this.setPaidHolidayDataList();
    }

    protected void paidHolidayGrantRegist(PaidHolidayDataDtoInterface dto) throws MospException {
        PaidHolidayDataGrantCardVo vo = (PaidHolidayDataGrantCardVo)this.mospParams.getVo();
        PaidHolidayGrantReferenceBeanInterface paidHolidayGrant = this.timeReference().paidHolidayGrant();
        PaidHolidayGrantRegistBeanInterface paidHolidayGrantRegist = this.time().paidHolidayGrantRegist();
        PaidHolidayGrantDtoInterface paidHolidayGrantDto = paidHolidayGrant.findForKey(vo.getPersonalId(), dto.getAcquisitionDate());
        if (paidHolidayGrantDto == null) {
            paidHolidayGrantDto = paidHolidayGrantRegist.getInitDto();
        }
        this.setDtoFields(paidHolidayGrantDto, dto);
        paidHolidayGrantRegist.regist(paidHolidayGrantDto);
    }

    protected void paidHolidayGrantDelete(Date grantDate) throws MospException {
        PaidHolidayDataGrantCardVo vo = (PaidHolidayDataGrantCardVo)this.mospParams.getVo();
        PaidHolidayGrantReferenceBeanInterface paidHolidayGrant = this.timeReference().paidHolidayGrant();
        PaidHolidayGrantRegistBeanInterface paidHolidayGrantRegist = this.time().paidHolidayGrantRegist();
        PaidHolidayGrantDtoInterface dto = paidHolidayGrant.findForKey(vo.getPersonalId(), grantDate);
        if (dto == null) {
            return;
        }
        paidHolidayGrantRegist.delete(dto);
    }

    protected void setPaidHolidayDataList() throws MospException {
        boolean granted;
        PaidHolidayDataGrantCardVo vo = (PaidHolidayDataGrantCardVo)this.mospParams.getVo();
        PaidHolidayDataReferenceBeanInterface paidHolidayData = this.timeReference().paidHolidayData();
        PaidHolidayDataGrantBeanInterface paidHolidayDataGrant = this.time().paidHolidayDataGrant();
        PaidHolidayDataDtoInterface dto = paidHolidayData.findForKey(vo.getPersonalId(), vo.getTargetDate(), vo.getTargetDate());
        boolean bl = granted = dto != null;
        if (!granted) {
            dto = paidHolidayDataGrant.create(vo.getPersonalId(), vo.getTargetDate(), false);
        }
        ArrayList<PaidHolidayDataDtoInterface> list = new ArrayList<PaidHolidayDataDtoInterface>();
        if (dto == null) {
            this.setVoFields(list, granted);
            return;
        }
        for (PaidHolidayDataDtoInterface paidHolidayDataDto : paidHolidayData.getPaidHolidayDataInfoAllList(vo.getPersonalId(), vo.getTargetDate())) {
            if (paidHolidayDataDto.getAcquisitionDate().equals(dto.getAcquisitionDate())) continue;
            list.add(paidHolidayDataDto);
        }
        list.add(dto);
        this.setVoFields(list, granted);
    }

    protected void setVoFields(List<PaidHolidayDataDtoInterface> list, boolean isGranted) {
        PaidHolidayDataGrantCardVo vo = (PaidHolidayDataGrantCardVo)this.mospParams.getVo();
        long[] aryRecordId = new long[list.size()];
        String[] aryLblGrantDate = new String[list.size()];
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblExpirationDate = new String[list.size()];
        String[] aryLblGrantDays = new String[list.size()];
        String[] aryTxtGrantDays = new String[list.size()];
        Format format = this.getNumberFormat();
        for (int i = 0; i < list.size(); ++i) {
            PaidHolidayDataDtoInterface dto = list.get(i);
            aryRecordId[i] = dto.getTmdPaidHolidayId();
            aryLblGrantDate[i] = this.getStringDateAndDay(dto.getAcquisitionDate());
            aryLblActivateDate[i] = this.getStringDateAndDay(dto.getActivateDate());
            aryLblExpirationDate[i] = this.getStringDateAndDay(dto.getLimitDate());
            aryLblGrantDays[i] = this.mospParams.getName("Hyphen");
            if (i != list.size() - 1 || isGranted) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.getGrantDays(dto.getHoldDay(), format));
                sb.append(this.mospParams.getName("Day"));
                aryLblGrantDays[i] = sb.toString();
            }
            aryTxtGrantDays[i] = this.getGrantDays(Math.floor(dto.getHoldDay()), format);
        }
        vo.setAryRecordId(aryRecordId);
        vo.setAryLblGrantDate(aryLblGrantDate);
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblExpirationDate(aryLblExpirationDate);
        vo.setAryLblGrantDays(aryLblGrantDays);
        vo.setAryTxtGrantDays(aryTxtGrantDays);
    }

    protected void setDtoFields(PaidHolidayDataDtoInterface dto, int i, boolean isInsert) {
        PaidHolidayDataGrantCardVo vo = (PaidHolidayDataGrantCardVo)this.mospParams.getVo();
        if (isInsert) {
            Date grantDate = this.getDate(vo.getAryLblGrantDate()[i]);
            dto.setPersonalId(vo.getPersonalId());
            dto.setAcquisitionDate(grantDate);
            dto.setActivateDate(grantDate);
            dto.setLimitDate(this.getDate(vo.getAryLblExpirationDate()[i]));
        }
        dto.setHoldDay(Double.parseDouble(vo.getAryTxtGrantDays()[i]));
    }

    protected void setDtoFields(PaidHolidayDataDtoInterface dto, PaidHolidayDtoInterface paidHolidayDto) {
        dto.setDenominatorDayHour(paidHolidayDto.getTimeAcquisitionLimitTimes());
        dto.setTemporaryFlag(1);
    }

    protected void setDtoFields(PaidHolidayGrantDtoInterface dto, PaidHolidayDataDtoInterface paidHolidayDataDto) {
        PaidHolidayDataGrantCardVo vo = (PaidHolidayDataGrantCardVo)this.mospParams.getVo();
        dto.setPersonalId(vo.getPersonalId());
        dto.setGrantDate(paidHolidayDataDto.getAcquisitionDate());
        dto.setGrantStatus(3);
    }

    protected String getGrantDays(double grantDays, Format format) {
        return format.format(grantDays);
    }
}

