/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.comparator.base.ActivateDateComparator;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.bean.HolidayDataRegistBeanInterface;
import jp.mosp.time.bean.HolidayHistorySearchBeanInterface;
import jp.mosp.time.dto.settings.HolidayDataDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.HolidayHistoryListDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdHolidayDataDto;
import jp.mosp.time.settings.base.TimeSettingAction;
import jp.mosp.time.settings.vo.OtherHolidayHistoryVo;
import jp.mosp.time.utils.TimeUtility;

public class OtherHolidayHistoryAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM4320";
    public static final String CMD_SELECT_SHOW = "TM4321";
    public static final String CMD_SEARCH = "TM4322";
    public static final String CMD_RE_SHOW = "TM4323";
    public static final String CMD_REGISTER = "TM4325";
    public static final String CMD_SET_DAY_GRANT = "TM4326";
    public static final String CMD_SORT = "TM4328";
    public static final String CMD_PAGE = "TM4329";
    public static final String CMD_SET_EMPLOYEE_DECISION = "TM4370";
    public static final String CMD_INSERT_MODE = "TM4371";
    public static final String CMD_EDIT_MODE = "TM4372";
    public static final String CMD_SET_ACTIVATION_DATE = "TM4377";

    public OtherHolidayHistoryAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new OtherHolidayHistoryVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo();
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_REGISTER)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_SET_DAY_GRANT)) {
            this.prepareVo();
            this.setDayGrant();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_SET_EMPLOYEE_DECISION)) {
            this.prepareVo();
            this.setEmployeeDecision();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_MODE)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        }
    }

    protected void show() throws MospException {
        OtherHolidayHistoryVo vo = (OtherHolidayHistoryVo)this.mospParams.getVo();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.insertMode();
        vo.setComparatorName(ActivateDateComparator.class.getName());
    }

    protected void select() throws MospException {
        try {
            OtherHolidayHistoryVo vo = (OtherHolidayHistoryVo)this.mospParams.getVo();
            this.setPageInfo(CMD_PAGE, this.getListLength());
            this.editMode();
            vo.setModeCardEdit("edit");
        }
        catch (Exception e) {
            throw new MospException((Throwable)e);
        }
    }

    protected void search() throws MospException {
        OtherHolidayHistoryVo vo = (OtherHolidayHistoryVo)this.mospParams.getVo();
        HolidayHistorySearchBeanInterface search = this.timeReference().holidayHistorySearch();
        search.setActivateDate(this.getSearchActivateDate());
        search.setEmployeeCode(vo.getTxtSearchEmployeeCode());
        search.setEmployeeName(vo.getTxtSearchEmployeeName());
        search.setWorkPlaceCode(vo.getPltSearchWorkPlace());
        search.setEmploymentCode(vo.getPltSearchEmployment());
        search.setSectionCode(vo.getPltSearchSection());
        search.setPositionCode(vo.getPltSearchPosition());
        search.setInactivateFlag(vo.getPltSearchInactivate());
        List list = search.getSearchList(Integer.parseInt(this.mospParams.getProperties().getCodeArray("HolidayTypeMaster", false)[1][0]));
        vo.setList(list);
        vo.setComparatorName(ActivateDateComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.size() == 0) {
            this.addNoSearchResultMessage();
        }
    }

    protected void regist() throws MospException {
        OtherHolidayHistoryVo vo = (OtherHolidayHistoryVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        TmdHolidayDataDto dto = new TmdHolidayDataDto();
        HolidayDataRegistBeanInterface regist = this.time().holidayDataRegist();
        this.setDtoFields((HolidayDataDtoInterface)dto);
        regist.insert((HolidayDataDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertNewMessage();
        this.setEditUpdateMode(dto.getPersonalId(), dto.getActivateDate(), dto.getHolidayCode());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void add() throws MospException {
        TmdHolidayDataDto dto = new TmdHolidayDataDto();
        this.setDtoFields((HolidayDataDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertHistoryMessage();
        this.setEditUpdateMode(dto.getPersonalId(), dto.getActivateDate(), dto.getHolidayCode());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void update() throws MospException {
        TmdHolidayDataDto dto = new TmdHolidayDataDto();
        HolidayDataRegistBeanInterface regist = this.time().holidayDataRegist();
        this.setDtoFields((HolidayDataDtoInterface)dto);
        regist.update((HolidayDataDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateHistoryMessage();
        this.setEditUpdateMode(dto.getPersonalId(), dto.getActivateDate(), dto.getHolidayCode());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void setDayGrant() throws MospException {
        OtherHolidayHistoryVo vo = (OtherHolidayHistoryVo)this.mospParams.getVo();
        HolidayDtoInterface otherHolidayDto = this.timeReference().holiday().getHolidayInfo(vo.getPltEditHolidayType(), this.getEditActivateDate(), 3);
        if (otherHolidayDto != null) {
            vo.setTxtEditHolidayGiving(String.valueOf(otherHolidayDto.getHolidayGiving()));
            vo.setTxtEditHolidayLimitMonth(String.valueOf(otherHolidayDto.getHolidayLimitMonth()));
            vo.setTxtEditHolidayLimitDay(String.valueOf(otherHolidayDto.getHolidayLimitDay()));
            this.setJsEditNoLimit();
        } else {
            vo.setJsEditActivateDate("chaning");
            vo.setAryPltEditHolidayType(this.getInputActivateDatePulldown());
            vo.setTxtEditEmployeeCode("");
            vo.setLblEmployeeName("");
            String message = this.mospParams.getName("Vacation") + this.mospParams.getName("Classification");
            this.mospParams.addMessage("TMW0214", new String[]{message});
        }
    }

    protected void setJsEditNoLimit() throws MospException {
        OtherHolidayHistoryVo vo = (OtherHolidayHistoryVo)this.mospParams.getVo();
        HolidayDtoInterface holidayDto = this.timeReference().holiday().getHolidayInfo(vo.getPltEditHolidayType(), this.getEditActivateDate(), 3);
        if (holidayDto == null || holidayDto.getNoLimit() != this.getInt("1")) {
            vo.setJsEditNoLimit(Boolean.valueOf(false));
            return;
        }
        vo.setJsEditNoLimit(Boolean.valueOf(true));
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void setEmployeeDecision() throws MospException {
        OtherHolidayHistoryVo vo = (OtherHolidayHistoryVo)this.mospParams.getVo();
        if (vo.getJsEditActivateDate().equals("chaning")) {
            vo.setJsEditActivateDate("fixed");
        } else {
            vo.setJsEditActivateDate("chaning");
        }
        this.setEditEmployee();
        this.setEditDecision();
    }

    protected void setEditEmployee() throws MospException {
        OtherHolidayHistoryVo vo = (OtherHolidayHistoryVo)this.mospParams.getVo();
        if (vo.getJsEditActivateDate().equals("fixed")) {
            Date activateDate = this.getEditActivateDate();
            HumanDtoInterface humanDto = this.reference().human().getHumanInfoForEmployeeCode(vo.getTxtEditEmployeeCode(), activateDate);
            if (humanDto == null) {
                vo.setJsEditActivateDate("chaning");
                vo.setLblEmployeeName(this.mospParams.getName("NoEmployee"));
                this.addNotExistEmployeesErrorMessage();
                return;
            }
            String personalId = humanDto.getPersonalId();
            if (!this.reference().entrance().isEntered(personalId, activateDate)) {
                vo.setJsEditActivateDate("chaning");
                vo.setLblEmployeeName(this.mospParams.getName("NoEmployee"));
                this.addNotJoinedEmployeesErrorMessage(activateDate, this.getEmployeeCode(personalId));
                return;
            }
            if (this.reference().retirement().isRetired(personalId, activateDate)) {
                vo.setJsEditActivateDate("chaning");
                vo.setLblEmployeeName(this.mospParams.getName("NoEmployee"));
                this.addNotRetirementEmployeesErrorMessage(activateDate, this.getEmployeeCode(personalId));
                return;
            }
            vo.setLblEmployeeName(this.getLastFirstName(humanDto.getLastName(), humanDto.getFirstName()));
            vo.setPersonalId(personalId);
            return;
        }
        vo.setLblEmployeeName("");
    }

    protected void setEditDecision() throws MospException {
        this.setEditPulldown();
    }

    public void setDefaultValues() {
        OtherHolidayHistoryVo vo = (OtherHolidayHistoryVo)this.mospParams.getVo();
        Date date = DateUtility.getSystemDate();
        vo.setTxtEditActivateYear(DateUtility.getStringYear((Date)date));
        vo.setTxtEditActivateMonth(DateUtility.getStringMonth((Date)date));
        vo.setTxtEditActivateDay(DateUtility.getStringDay((Date)date));
        vo.setTxtEditEmployeeCode("");
        vo.setPltEditInactivate(String.valueOf(0));
        vo.setLblEmployeeName("");
        vo.setTxtSearchActivateYear(DateUtility.getStringYear((Date)date));
        vo.setTxtSearchActivateMonth(DateUtility.getStringMonth((Date)date));
        vo.setTxtSearchActivateDay(DateUtility.getStringDay((Date)date));
        vo.setTxtSearchEmployeeCode("");
        vo.setTxtSearchEmployeeName("");
        vo.setPltSearchWorkPlace("");
        vo.setPltSearchEmployment("");
        vo.setPltSearchSection("");
        vo.setPltSearchPosition("");
        vo.setPltSearchInactivate(String.valueOf(0));
        vo.setTxtUpdateActivateYear(DateUtility.getStringYear((Date)date));
        vo.setTxtUpdateActivateMonth(DateUtility.getStringMonth((Date)date));
        vo.setTxtUpdateActivateDay(DateUtility.getStringDay((Date)date));
        vo.setPltUpdateInactivate("");
        vo.setJsEditHistoryMode("");
        vo.setJsEditNoLimit(Boolean.valueOf(false));
    }

    protected void insertMode() throws MospException {
        OtherHolidayHistoryVo vo = (OtherHolidayHistoryVo)this.mospParams.getVo();
        this.setDefaultValues();
        vo.setModeCardEdit("insert");
        this.setJsMode();
        this.setPulldown();
        this.setEditPulldown();
    }

    private void setEditPulldown() throws MospException {
        OtherHolidayHistoryVo vo = (OtherHolidayHistoryVo)this.mospParams.getVo();
        if (vo.getJsEditActivateDate().equals("fixed")) {
            String[][] aryHolidayType = this.timeReference().holiday().getSelectArray(this.getEditActivateDate(), 3, false);
            vo.setAryPltEditHolidayType(aryHolidayType);
            if (vo.getModeCardEdit().equals("insert")) {
                vo.setPltEditHolidayType(aryHolidayType[0][0]);
                this.setDayGrant();
                return;
            }
            this.setJsEditNoLimit();
            return;
        }
        vo.setTxtEditHolidayGiving("");
        vo.setTxtEditHolidayLimitMonth("");
        vo.setTxtEditHolidayLimitDay("");
        vo.setAryPltEditHolidayType(this.getInputActivateDatePulldown());
    }

    private void setPulldown() throws MospException {
        OtherHolidayHistoryVo vo = (OtherHolidayHistoryVo)this.mospParams.getVo();
        if (!vo.getJsSearchActivateDate().equals("fixed")) {
            vo.setAryPltSearchSection(this.getInputActivateDatePulldown());
            vo.setAryPltSearchPosition(this.getInputActivateDatePulldown());
            vo.setAryPltSearchEmployment(this.getInputActivateDatePulldown());
            vo.setAryPltSearchWorkPlace(this.getInputActivateDatePulldown());
            return;
        }
        Date targetDate = this.getSearchActivateDate();
        vo.setAryPltSearchSection(this.reference().section().getCodedSelectArray(targetDate, true, null));
        vo.setAryPltSearchPosition(this.reference().position().getCodedSelectArray(targetDate, true, null));
        vo.setAryPltSearchEmployment(this.reference().employmentContract().getCodedSelectArray(targetDate, true, null));
        vo.setAryPltSearchWorkPlace(this.reference().workPlace().getCodedSelectArray(targetDate, true, null));
    }

    protected void editMode() throws MospException {
        OtherHolidayHistoryVo vo = (OtherHolidayHistoryVo)this.mospParams.getVo();
        this.setDefaultValues();
        String employeeCode = this.getTransferredCode();
        String holidayCode = this.getTransferredGenericCode();
        Date activeDate = this.getDate(this.getTransferredActivateDate());
        String personalId = this.reference().human().getPersonalId(employeeCode, activeDate);
        this.setEditUpdateMode(personalId, activeDate, holidayCode);
        this.setEditEmployee();
        HolidayDataDtoInterface dto = this.timeReference().holidayData().findForKey(personalId, activeDate, holidayCode, 3);
        vo.setTxtEditActivateYear(DateUtility.getStringYear((Date)dto.getActivateDate()));
        vo.setTxtEditActivateMonth(DateUtility.getStringMonth((Date)dto.getActivateDate()));
        vo.setTxtEditActivateDay(DateUtility.getStringDay((Date)dto.getActivateDate()));
        vo.setTxtEditEmployeeCode(this.getEmployeeCode(dto.getPersonalId()));
        vo.setTxtEditHolidayGiving(String.valueOf(dto.getGivingDay()));
        vo.setTxtEditHolidayLimitMonth(String.valueOf(dto.getHolidayLimitMonth()));
        vo.setTxtEditHolidayLimitDay(String.valueOf(dto.getHolidayLimitDay()));
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
        this.setEditDecision();
        this.setPulldown();
        vo.setJsEditHistoryMode("fixed");
        vo.setComparatorName(ActivateDateComparator.class.getName());
    }

    protected void setActivationDate() throws MospException {
        OtherHolidayHistoryVo vo = (OtherHolidayHistoryVo)this.mospParams.getVo();
        if (vo.getJsSearchActivateDate().equals("chaning")) {
            vo.setJsSearchActivateDate("fixed");
        } else {
            vo.setJsSearchActivateDate("chaning");
        }
        this.setPulldown();
    }

    protected void setEditUpdateMode(String personalId, Date activateDate, String holidayCode) throws MospException {
        OtherHolidayHistoryVo vo = (OtherHolidayHistoryVo)this.mospParams.getVo();
        HolidayDataDtoInterface dto = this.timeReference().holidayData().findForKey(personalId, activateDate, holidayCode, 3);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        vo.setModeCardEdit("edit");
        vo.setJsEditActivateDate("fixed");
        vo.setJsSearchActivateDate("fixed");
    }

    protected void setDtoFields(HolidayDataDtoInterface dto) throws MospException {
        OtherHolidayHistoryVo vo = (OtherHolidayHistoryVo)this.mospParams.getVo();
        dto.setTmdHolidayId(vo.getTmdHolidayId());
        dto.setActivateDate(this.getEditActivateDate());
        dto.setPersonalId(vo.getPersonalId());
        dto.setGivingDay(Double.valueOf(vo.getTxtEditHolidayGiving()).doubleValue());
        dto.setGivingHour(0);
        if ("0".equals(vo.getTxtEditHolidayLimitMonth()) && "0".equals(vo.getTxtEditHolidayLimitDay())) {
            dto.setHolidayLimitDate(TimeUtility.getUnlimitedDate());
        } else {
            dto.setHolidayLimitDate(DateUtility.addDay((Date)DateUtility.addMonth((Date)this.getEditActivateDate(), (int)Integer.parseInt(vo.getTxtEditHolidayLimitMonth())), (int)(Integer.parseInt(vo.getTxtEditHolidayLimitDay()) - 1)));
        }
        dto.setHolidayLimitMonth(this.getInt(vo.getTxtEditHolidayLimitMonth()));
        dto.setHolidayLimitDay(this.getInt(vo.getTxtEditHolidayLimitDay()));
        dto.setHolidayType(3);
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
        dto.setCancelDay(0.0);
        dto.setCancelHour(0);
        dto.setHolidayCode(vo.getPltEditHolidayType());
    }

    protected void setVoFields(HolidayDataDtoInterface dto) throws MospException {
        OtherHolidayHistoryVo vo = (OtherHolidayHistoryVo)this.mospParams.getVo();
        vo.setTmdHolidayId(dto.getTmdHolidayId());
        vo.setTxtActivateYear(this.getStringYear(dto.getActivateDate()));
        vo.setTxtActivateMonth(this.getStringMonth(dto.getActivateDate()));
        vo.setTxtActivateDay(this.getStringDay(dto.getActivateDate()));
        vo.setTxtEditEmployeeCode(this.getEmployeeCode(dto.getPersonalId()));
        vo.setPltEditHolidayType(String.valueOf(dto.getHolidayCode()));
        vo.setTxtEditHolidayGiving(String.valueOf(dto.getGivingDay()));
        vo.setTxtEditHolidayLimitMonth(String.valueOf(dto.getHolidayLimitMonth()));
        vo.setTxtEditHolidayLimitDay(String.valueOf(dto.getHolidayLimitDay()));
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        OtherHolidayHistoryVo vo = (OtherHolidayHistoryVo)this.mospParams.getVo();
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblEmployeeCode = new String[list.size()];
        String[] aryLblEmployeeName = new String[list.size()];
        String[] aryLblSection = new String[list.size()];
        String[] aryLblHolidayCode = new String[list.size()];
        String[] aryLblHolidayType = new String[list.size()];
        String[] aryLblHolidayGiving = new String[list.size()];
        String[] aryLblHolidayLimit = new String[list.size()];
        String[] aryLblInactivate = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            HolidayHistoryListDtoInterface dto = (HolidayHistoryListDtoInterface)list.get(i);
            aryLblActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryLblEmployeeCode[i] = dto.getEmployeeCode();
            aryLblEmployeeName[i] = this.getLastFirstName(dto.getLastName(), dto.getFirstName());
            aryLblSection[i] = this.reference().section().getSectionAbbr(dto.getSectionCode(), this.getSearchActivateDate());
            aryLblHolidayCode[i] = dto.getHolidayCode();
            aryLblHolidayType[i] = this.getHolidayAbbr(dto.getHolidayCode(), this.getSearchActivateDate(), 3);
            if (TimeUtility.getUnlimitedDate().compareTo(dto.getHolidayLimit()) == 0) {
                aryLblHolidayGiving[i] = this.mospParams.getName("NoLimit");
                aryLblHolidayLimit[i] = this.mospParams.getName("NoLimit");
            } else {
                aryLblHolidayGiving[i] = this.getFormatRestDay(dto.getHolidayGiving());
                aryLblHolidayLimit[i] = DateUtility.getStringDate((Date)dto.getHolidayLimit());
            }
            aryLblInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
        }
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblEmployeeCode(aryLblEmployeeCode);
        vo.setAryLblEmployeeName(aryLblEmployeeName);
        vo.setAryLblSection(aryLblSection);
        vo.setAryLblHolidayCode(aryLblHolidayCode);
        vo.setAryLblHolidayType(aryLblHolidayType);
        vo.setAryLblHolidayGiving(aryLblHolidayGiving);
        vo.setAryLblHolidayLimit(aryLblHolidayLimit);
        vo.setAryLblInactivate(aryLblInactivate);
    }

    protected void setJsMode() {
        OtherHolidayHistoryVo vo = (OtherHolidayHistoryVo)this.mospParams.getVo();
        vo.setJsEditActivateDate("chaning");
        vo.setJsSearchActivateDate("fixed");
    }
}

