/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.time.bean.HolidayReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRegistBeanInterface;
import jp.mosp.time.bean.HolidaySearchBeanInterface;
import jp.mosp.time.comparator.settings.HolidayMasterHolidayCodeComparator;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.settings.base.TimeSettingAction;
import jp.mosp.time.settings.vo.HolidayMasterVo;

public class HolidayMasterAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM4100";
    public static final String CMD_SEARCH = "TM4102";
    public static final String CMD_RE_SHOW = "TM4103";
    public static final String CMD_REGIST = "TM4105";
    public static final String CMD_DELETE = "TM4107";
    public static final String CMD_SORT = "TM4108";
    public static final String CMD_PAGE = "TM4109";
    public static final String CMD_INSERT_MODE = "TM4191";
    public static final String CMD_EDIT_MODE = "TM4192";
    public static final String CMD_ADD_MODE = "TM4193";
    public static final String CMD_BATCH_UPDATE = "TM4195";
    public static final int TYPE_SALARY_PAY_NONE = 1;

    public HolidayMasterAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new HolidayMasterVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_MODE)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_MODE)) {
            this.prepareVo();
            this.addMode();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        }
    }

    protected void show() {
        this.initTimeSettingVoFields();
        this.insertMode();
        HolidayMasterVo vo = (HolidayMasterVo)this.mospParams.getVo();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(HolidayMasterHolidayCodeComparator.class.getName());
    }

    protected void search() throws MospException {
        HolidayMasterVo vo = (HolidayMasterVo)this.mospParams.getVo();
        HolidaySearchBeanInterface search = this.timeReference().holidaySearch();
        search.setActivateDate(this.getSearchActivateDate());
        search.setHolidayType(vo.getPltSearchHolidayType());
        search.setHolidayCode(vo.getTxtSearchHolidayCode());
        search.setInactivateFlag(vo.getPltSearchInactivate());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(HolidayMasterHolidayCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty()) {
            this.addNoSearchResultMessage();
        }
    }

    protected void regist() throws MospException {
        HolidayMasterVo vo = (HolidayMasterVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("add")) {
            this.add();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        HolidayMasterVo vo = (HolidayMasterVo)this.mospParams.getVo();
        HolidaySearchBeanInterface search = this.timeReference().holidaySearch();
        search.setActivateDate(this.getSearchActivateDate());
        search.setHolidayType(vo.getPltEditHolidayType());
        search.setHolidayCode("");
        search.setInactivateFlag("");
        List list = search.getSearchList();
        if (vo.getPltEditHolidayType().equals(String.valueOf(2))) {
            if (list.size() >= 30) {
                this.mospParams.addErrorMessage("TMW0227", new String[]{this.mospParams.getName("Specially") + this.mospParams.getName("Vacation"), String.valueOf(30)});
                return;
            }
        } else if (vo.getPltEditHolidayType().equals(String.valueOf(3))) {
            if (list.size() >= 50) {
                this.mospParams.addErrorMessage("TMW0227", new String[]{this.mospParams.getName("Others") + this.mospParams.getName("Vacation"), String.valueOf(50)});
                return;
            }
        } else if (vo.getPltEditHolidayType().equals(String.valueOf(4)) && list.size() >= 20) {
            this.mospParams.addErrorMessage("TMW0227", new String[]{this.mospParams.getName("Absence"), String.valueOf(20)});
            return;
        }
        HolidayRegistBeanInterface regist = this.time().holidayRegist();
        HolidayDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addInsertMessage();
        this.setVoFields(dto);
        this.setEditUpdateMode(dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayType());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void add() throws MospException {
        HolidayRegistBeanInterface regist = this.time().holidayRegist();
        HolidayDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.add(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addInsertHistoryMessage();
        this.setVoFields(dto);
        this.setEditUpdateMode(dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayType());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void update() throws MospException {
        HolidayRegistBeanInterface regist = this.time().holidayRegist();
        HolidayDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.update(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.setVoFields(dto);
        this.setEditUpdateMode(dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayType());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void batchUpdate() throws MospException {
        HolidayMasterVo vo = (HolidayMasterVo)this.mospParams.getVo();
        this.time().holidayRegist().update(this.getIdArray(vo.getCkbSelect()), this.getUpdateActivateDate(), this.getInt(vo.getPltUpdateInactivate()));
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.setSearchActivateDate(this.getUpdateActivateDate());
        this.search();
    }

    protected void delete() throws MospException {
        HolidayMasterVo vo = (HolidayMasterVo)this.mospParams.getVo();
        long[] idArray = this.getIdArray(vo.getCkbSelect());
        this.time().holidayRegist().delete(idArray);
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteHistoryMessage(idArray.length);
        this.insertMode();
        this.search();
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() {
        this.setVoList(this.pageList());
    }

    protected void insertMode() {
        this.setEditInsertMode();
        this.setDefaultValues();
    }

    protected void addMode() throws MospException {
        this.setEditAddMode();
    }

    protected void editMode() throws MospException {
        String holidayType = this.getTransferredType();
        if (holidayType == null || holidayType.isEmpty()) {
            HolidayMasterVo vo = (HolidayMasterVo)this.mospParams.getVo();
            holidayType = vo.getPltEditHolidayType();
        }
        this.setEditUpdateMode(this.getTransferredCode(), this.getDate(this.getTransferredActivateDate()), this.getInt(holidayType));
    }

    protected void setEditUpdateMode(String holidayCode, Date activateDate, int holidayType) throws MospException {
        HolidayReferenceBeanInterface reference = this.timeReference().holiday();
        HolidayDtoInterface dto = reference.findForKey(holidayCode, activateDate, holidayType);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        this.setEditUpdateMode(reference.getHolidayHistory(holidayCode, holidayType));
    }

    public void setDefaultValues() {
        HolidayMasterVo vo = (HolidayMasterVo)this.mospParams.getVo();
        vo.setTxtEditHolidayName("");
        vo.setTxtEditHolidayAbbr("");
        vo.setTxtEditHolidayGiving("");
        vo.setTxtEditHolidayLimitMonth("");
        vo.setTxtEditHolidayLimitDay("");
        vo.setTxtEditHolidayCode("");
        vo.setPltEditHalfHolidayRequest("");
        vo.setPltEditHourlyHoliday(String.valueOf(1));
        vo.setPltEditHolidayType("");
        vo.setPltEditContinue("");
        vo.setPltEditSalary("");
        vo.setPltEditReasonType("");
        vo.setPltEditPaidHolidayCalc("");
        vo.setCkbNoLimit("0");
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) {
        HolidayMasterVo vo = (HolidayMasterVo)this.mospParams.getVo();
        long[] aryCkbRecordId = new long[list.size()];
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblHolidayCode = new String[list.size()];
        String[] aryLblHolidayType = new String[list.size()];
        String[] aryLblHolidayTypeName = new String[list.size()];
        String[] aryLblHolidayName = new String[list.size()];
        String[] aryLblHolidayAbbr = new String[list.size()];
        String[] aryLblHolidayGiving = new String[list.size()];
        String[] aryLblHolidayLimit = new String[list.size()];
        String[] aryLblHolidayContinue = new String[list.size()];
        String[] aryLblTimelyHoliday = new String[list.size()];
        String[] aryLblHolidaySalary = new String[list.size()];
        String[] aryLblInactivate = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            HolidayDtoInterface dto = (HolidayDtoInterface)list.get(i);
            aryCkbRecordId[i] = dto.getTmmHolidayId();
            aryLblActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryLblHolidayCode[i] = dto.getHolidayCode();
            aryLblHolidayType[i] = String.valueOf(dto.getHolidayType());
            aryLblHolidayTypeName[i] = this.mospParams.getProperties().getCodeItemName("HolidayTypeMaster", aryLblHolidayType[i]);
            aryLblHolidayName[i] = dto.getHolidayName();
            aryLblHolidayAbbr[i] = dto.getHolidayAbbr();
            aryLblHolidayGiving[i] = dto.getNoLimit() == this.getInt("1") ? this.mospParams.getName("NoLimit") : dto.getHolidayGiving() + this.mospParams.getName("Day");
            aryLblHolidayLimit[i] = dto.getHolidayLimitDay() == 0 ? (dto.getHolidayLimitMonth() == 0 ? dto.getHolidayLimitDay() + this.mospParams.getName("Day") : dto.getHolidayLimitMonth() + this.mospParams.getName("Months")) : (dto.getHolidayLimitMonth() == 0 ? dto.getHolidayLimitDay() + this.mospParams.getName("Day") : dto.getHolidayLimitMonth() + this.mospParams.getName("Months") + dto.getHolidayLimitDay() + this.mospParams.getName("Day"));
            aryLblHolidayContinue[i] = this.mospParams.getProperties().getCodeItemName("Continue", String.valueOf(dto.getContinuousAcquisition()));
            aryLblTimelyHoliday[i] = this.mospParams.getProperties().getCodeItemName("InactivateFlag", String.valueOf(dto.getTimelyHolidayFlag()));
            aryLblHolidaySalary[i] = this.mospParams.getProperties().getCodeItemName("SalaryPayType", String.valueOf(dto.getSalary()));
            aryLblInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
        }
        vo.setAryCkbRecordId(aryCkbRecordId);
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblHolidayCode(aryLblHolidayCode);
        vo.setAryLblHolidayType(aryLblHolidayType);
        vo.setAryLblHolidayTypeName(aryLblHolidayTypeName);
        vo.setAryLblHolidayName(aryLblHolidayName);
        vo.setAryLblHolidayAbbr(aryLblHolidayAbbr);
        vo.setAryLblHolidayGiving(aryLblHolidayGiving);
        vo.setAryLblHolidayLimit(aryLblHolidayLimit);
        vo.setAryLblHolidayContinue(aryLblHolidayContinue);
        vo.setAryLblTimelyHoliday(aryLblTimelyHoliday);
        vo.setAryLblHolidaySalary(aryLblHolidaySalary);
        vo.setAryLblInactivate(aryLblInactivate);
    }

    protected void setDtoFields(HolidayDtoInterface dto) {
        HolidayMasterVo vo = (HolidayMasterVo)this.mospParams.getVo();
        dto.setTmmHolidayId(vo.getRecordId());
        dto.setActivateDate(this.getEditActivateDate());
        dto.setHolidayType(this.getInt(vo.getPltEditHolidayType()));
        dto.setHolidayName(vo.getTxtEditHolidayName());
        dto.setHolidayAbbr(vo.getTxtEditHolidayAbbr());
        dto.setHolidayGiving(this.getDouble(vo.getTxtEditHolidayGiving()));
        dto.setNoLimit(MospUtility.getInt((Object)vo.getCkbNoLimit()));
        dto.setHolidayLimitMonth(this.getInt(vo.getTxtEditHolidayLimitMonth()));
        dto.setHolidayLimitDay(this.getInt(vo.getTxtEditHolidayLimitDay()));
        dto.setHolidayCode(vo.getTxtEditHolidayCode());
        dto.setHalfHolidayRequest(this.getInt(vo.getPltEditHalfHolidayRequest()));
        dto.setTimelyHolidayFlag(this.getInt(vo.getPltEditHourlyHoliday()));
        dto.setContinuousAcquisition(MospUtility.getInt((Object)vo.getPltEditContinue()));
        dto.setPaidHolidayCalc(this.getInt(vo.getPltEditPaidHolidayCalc()));
        dto.setReasonType(this.getInt(vo.getPltEditReasonType()));
        dto.setSalary(MospUtility.getInt((Object)vo.getPltEditSalary()));
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
        if (dto.getHolidayType() == 4) {
            dto.setNoLimit(this.getInt("1"));
            dto.setSalary(1);
        }
        if (dto.getTimelyHolidayFlag() == 0 || dto.getNoLimit() == this.getInt("1")) {
            dto.setContinuousAcquisition(2);
        }
    }

    protected void setVoFields(HolidayDtoInterface dto) {
        HolidayMasterVo vo = (HolidayMasterVo)this.mospParams.getVo();
        vo.setRecordId(dto.getTmmHolidayId());
        vo.setTxtEditActivateYear(DateUtility.getStringYear((Date)dto.getActivateDate()));
        vo.setTxtEditActivateMonth(DateUtility.getStringMonth((Date)dto.getActivateDate()));
        vo.setTxtEditActivateDay(DateUtility.getStringDay((Date)dto.getActivateDate()));
        vo.setTxtEditHolidayName(dto.getHolidayName());
        vo.setTxtEditHolidayAbbr(dto.getHolidayAbbr());
        vo.setTxtEditHolidayGiving(String.valueOf(dto.getHolidayGiving()));
        vo.setCkbNoLimit(String.valueOf(dto.getNoLimit()));
        vo.setTxtEditHolidayLimitMonth(String.valueOf(dto.getHolidayLimitMonth()));
        vo.setTxtEditHolidayLimitDay(String.valueOf(dto.getHolidayLimitDay()));
        vo.setTxtEditHolidayCode(dto.getHolidayCode());
        vo.setPltEditHalfHolidayRequest(String.valueOf(dto.getHalfHolidayRequest()));
        vo.setPltEditHourlyHoliday(String.valueOf(dto.getTimelyHolidayFlag()));
        vo.setPltEditHolidayType(String.valueOf(dto.getHolidayType()));
        vo.setPltEditContinue(String.valueOf(dto.getContinuousAcquisition()));
        vo.setPltEditPaidHolidayCalc(String.valueOf(dto.getPaidHolidayCalc()));
        vo.setPltEditSalary(String.valueOf(dto.getSalary()));
        vo.setPltEditReasonType(String.valueOf(dto.getReasonType()));
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
    }
}

