/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.system.PlatformMasterBeanInterface;
import jp.mosp.time.bean.ApplicationRegistBeanInterface;
import jp.mosp.time.bean.ApplicationSearchBeanInterface;
import jp.mosp.time.bean.PaidHolidayReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleReferenceBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.comparator.settings.ApplicationMasterApplicationCodeComparator;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.settings.base.TimeSettingAction;
import jp.mosp.time.settings.vo.ApplicationListVo;

public class ApplicationListAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM5610";
    public static final String CMD_SEARCH = "TM5612";
    public static final String CMD_RE_SEARCH = "TM5613";
    public static final String CMD_DELETE = "TM5617";
    public static final String CMD_SORT = "TM5618";
    public static final String CMD_PAGE = "TM5619";
    public static final String CMD_SET_ACTIVATION_DATE = "TM5680";
    public static final String CMD_BATCH_UPDATE = "TM5685";

    public ApplicationListAction() {
        this.topicPathCommand = CMD_RE_SEARCH;
    }

    protected BaseVo getSpecificVo() {
        return new ApplicationListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        }
    }

    protected void show() throws MospException {
        ApplicationListVo vo = (ApplicationListVo)this.mospParams.getVo();
        this.initTimeSettingVoFields();
        vo.setTxtSearchApplicationCode("");
        vo.setTxtSearchApplicationName("");
        vo.setTxtSearchApplicationAbbr("");
        vo.setRadApplicationType("0");
        vo.setPltSearchWorkPlaceMaster("");
        vo.setPltSearchEmploymentMaster("");
        vo.setPltSearchSectionMaster("");
        vo.setPltSearchPositionMaster("");
        vo.setTxtSearchEmployeeCode("");
        vo.setPltSearchWorkSetting("");
        vo.setPltSearchSchedule("");
        vo.setPltSearchPaidHoliday("");
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(ApplicationMasterApplicationCodeComparator.class.getName());
        vo.setModeActivateDate("fixed");
        this.setPulldown();
    }

    protected void search() throws MospException {
        ApplicationListVo vo = (ApplicationListVo)this.mospParams.getVo();
        ApplicationSearchBeanInterface search = this.timeReference().applicationSearch();
        search.setActivateDate(this.getSearchActivateDate());
        search.setApplicationCode(vo.getTxtSearchApplicationCode());
        search.setApplicationType(vo.getRadApplicationType());
        search.setApplicationName(vo.getTxtSearchApplicationName());
        search.setApplicationAbbr(vo.getTxtSearchApplicationAbbr());
        search.setInactivateFlag(vo.getPltSearchInactivate());
        search.setWorkSettingCode(vo.getPltSearchWorkSetting());
        search.setScheduleCode(vo.getPltSearchSchedule());
        search.setPaidHolidayCode(vo.getPltSearchPaidHoliday());
        search.setWorkPlaceCode(vo.getPltSearchWorkPlaceMaster());
        search.setEmploymentCode(vo.getPltSearchEmploymentMaster());
        search.setSectionCode(vo.getPltSearchSectionMaster());
        search.setPositionCode(vo.getPltSearchPositionMaster());
        search.setEmployeeCode(vo.getTxtSearchEmployeeCode());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(ApplicationMasterApplicationCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.size() == 0) {
            this.addNoSearchResultMessage();
        }
    }

    protected void delete() throws MospException {
        ApplicationListVo vo = (ApplicationListVo)this.mospParams.getVo();
        long[] idArray = this.getIdArray(vo.getCkbSelect());
        this.time().applicationRegist().delete(idArray);
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteHistoryMessage(idArray.length);
        this.search();
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void setActivationDate() throws MospException {
        ApplicationListVo vo = (ApplicationListVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
    }

    protected void batchUpdate() throws MospException {
        ApplicationListVo vo = (ApplicationListVo)this.mospParams.getVo();
        ApplicationRegistBeanInterface regist = this.time().applicationRegist();
        long[] chbSelect = this.getIdArray(vo.getCkbSelect());
        int inactiveFlag = this.getInt(vo.getPltUpdateInactivate());
        regist.update(chbSelect, this.getUpdateActivateDate(), inactiveFlag);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.search();
    }

    private void setPulldown() throws MospException {
        ApplicationListVo vo = (ApplicationListVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setAryPltSearchWorkPlaceMaster(this.getInputActivateDatePulldown());
            vo.setAryPltSearchEmploymentMaster(this.getInputActivateDatePulldown());
            vo.setAryPltSearchSectionMaster(this.getInputActivateDatePulldown());
            vo.setAryPltSearchPositionMaster(this.getInputActivateDatePulldown());
            vo.setAryPltSearchWorkSetting(this.getInputActivateDatePulldown());
            vo.setAryPltSearchSchedule(this.getInputActivateDatePulldown());
            vo.setAryPltSearchPaidHoliday(this.getInputActivateDatePulldown());
            return;
        }
        Date date = this.getSearchActivateDate();
        String[][] workPlace = this.reference().workPlace().getCodedSelectArray(date, true, null);
        vo.setAryPltSearchWorkPlaceMaster(workPlace);
        String[][] aryEmployment = this.reference().employmentContract().getCodedSelectArray(date, true, null);
        vo.setAryPltSearchEmploymentMaster(aryEmployment);
        String[][] arySection = this.reference().section().getCodedSelectArray(date, true, null);
        vo.setAryPltSearchSectionMaster(arySection);
        String[][] aryPosition = this.reference().position().getCodedSelectArray(date, true, null);
        vo.setAryPltSearchPositionMaster(aryPosition);
        vo.setAryPltSearchWorkSetting(this.timeReference().timeSetting().getCodedSelectArray(date, true));
        vo.setAryPltSearchSchedule(this.timeReference().schedule().getCodedSelectArray(date, true));
        vo.setAryPltSearchPaidHoliday(this.timeReference().paidHoliday().getCodedSelectArray(date, true));
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        ApplicationListVo vo = (ApplicationListVo)this.mospParams.getVo();
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblApplicationCode = new String[list.size()];
        String[] aryLblApplicationAbbr = new String[list.size()];
        String[] aryLblWorkPlace = new String[list.size()];
        String[] aryLblEmployment = new String[list.size()];
        String[] aryLblSection = new String[list.size()];
        String[] aryLblPosition = new String[list.size()];
        String[] aryLblEmployeeCode = new String[list.size()];
        String[] aryLblWorkSetting = new String[list.size()];
        String[] aryLblSchadeule = new String[list.size()];
        String[] aryLblPaidHoliday = new String[list.size()];
        String[] aryLblInactivate = new String[list.size()];
        Date targetDate = this.getSearchActivateDate();
        TimeSettingReferenceBeanInterface timeSetting = this.timeReference().timeSetting();
        ScheduleReferenceBeanInterface schedule = this.timeReference().schedule();
        PaidHolidayReferenceBeanInterface paidHoliday = this.timeReference().paidHoliday();
        HumanReferenceBeanInterface human = this.reference().human();
        PlatformMasterBeanInterface platformMaster = this.reference().master();
        for (int i = 0; i < list.size(); ++i) {
            ApplicationDtoInterface dto = (ApplicationDtoInterface)list.get(i);
            aryLblActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryLblApplicationCode[i] = dto.getApplicationCode();
            aryLblApplicationAbbr[i] = dto.getApplicationAbbr();
            aryLblWorkPlace[i] = this.reference().workPlace().getWorkPlaceAbbr(dto.getWorkPlaceCode(), targetDate);
            aryLblEmployment[i] = this.reference().employmentContract().getContractAbbr(dto.getEmploymentContractCode(), targetDate);
            aryLblSection[i] = platformMaster.getSectionAbbr(dto.getSectionCode(), targetDate);
            aryLblPosition[i] = this.reference().position().getPositionAbbr(dto.getPositionCode(), targetDate);
            aryLblWorkSetting[i] = timeSetting.getTimeSettingAbbr(dto.getWorkSettingCode(), targetDate);
            aryLblSchadeule[i] = schedule.getScheduleAbbr(dto.getScheduleCode(), targetDate);
            aryLblPaidHoliday[i] = paidHoliday.getPaidHolidayAbbr(dto.getPaidHolidayCode(), targetDate);
            aryLblInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
            aryLblEmployeeCode[i] = human.getHumanNames(dto.getPersonalIds(), targetDate);
        }
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblApplicationCode(aryLblApplicationCode);
        vo.setAryLblApplicationAbbr(aryLblApplicationAbbr);
        vo.setAryLblWorkPlace(aryLblWorkPlace);
        vo.setAryLblEmployment(aryLblEmployment);
        vo.setAryLblSection(aryLblSection);
        vo.setAryLblPosition(aryLblPosition);
        vo.setAryLblEmployeeCode(aryLblEmployeeCode);
        vo.setAryLblWorkSetting(aryLblWorkSetting);
        vo.setAryLblSchadeule(aryLblSchadeule);
        vo.setAryLblPaidHoliday(aryLblPaidHoliday);
        vo.setAryLblInactivate(aryLblInactivate);
    }
}

