/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.report.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.ExportTableReferenceBeanInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.file.vo.TimeExportListVo;
import jp.mosp.time.utils.TimeUtility;

public class TimeExportAction
extends TimeAction {
    public static final String CMD_EXECUTION = "TM3315";

    protected BaseVo getSpecificVo() {
        return new TimeExportListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_EXECUTION)) {
            this.prepareVo();
            this.execution();
        }
    }

    protected void execution() throws MospException {
        TimeExportListVo vo = (TimeExportListVo)this.mospParams.getVo();
        ExportDtoInterface dto = this.reference().export().findForKey(vo.getRadSelect());
        if (dto == null) {
            this.addNoSearchResultMessage();
            return;
        }
        int startYear = this.getInt(vo.getTxtStartYear());
        int startMonth = this.getInt(vo.getTxtStartMonth());
        int endYear = this.getInt(vo.getTxtEndYear());
        int endMonth = this.getInt(vo.getTxtEndMonth());
        int ckbNeedLowerSection = this.getInt(vo.getCkbNeedLowerSection());
        if ("export_tmd_sub_holiday".equals(dto.getExportTable())) {
            this.timeReference().subHolidayExport().export(vo.getRadSelect(), startYear, startMonth, endYear, endMonth, vo.getPltCutoff(), vo.getPltWorkPlace(), vo.getPltEmployment(), vo.getPltSection(), ckbNeedLowerSection, vo.getPltPosition());
            return;
        }
        if ("export_holiday_request_data".equals(dto.getExportTable())) {
            this.timeReference().holidayRequestDataExport().export(vo.getRadSelect(), this.getInt(vo.getTxtStartYear()), this.getInt(vo.getTxtStartMonth()), this.getInt(vo.getTxtEndYear()), this.getInt(vo.getTxtEndMonth()), vo.getPltCutoff(), vo.getPltWorkPlace(), vo.getPltEmployment(), vo.getPltSection(), this.getInt(vo.getCkbNeedLowerSection()), vo.getPltPosition());
            return;
        }
        if ("export_attendance_reapplication".equals(dto.getExportTable())) {
            this.timeReference().attendanceReapplicationExport().export(vo.getRadSelect(), this.getInt(vo.getTxtStartYear()), this.getInt(vo.getTxtStartMonth()), this.getInt(vo.getTxtEndYear()), this.getInt(vo.getTxtEndMonth()), vo.getPltCutoff(), vo.getPltWorkPlace(), vo.getPltEmployment(), vo.getPltSection(), this.getInt(vo.getCkbNeedLowerSection()), vo.getPltPosition());
            return;
        }
        if ("export_appli_reason_data".equals(dto.getExportTable())) {
            this.timeReference().appliResonDataExport().export(vo.getRadSelect(), this.getInt(vo.getTxtStartYear()), this.getInt(vo.getTxtStartMonth()), this.getInt(vo.getTxtEndYear()), this.getInt(vo.getTxtEndMonth()), vo.getPltCutoff(), vo.getPltWorkPlace(), vo.getPltEmployment(), vo.getPltSection(), this.getInt(vo.getCkbNeedLowerSection()), vo.getPltPosition());
            return;
        }
        if (this.addGeneralExportTimeType(dto.getExportTable(), startYear, startMonth, endYear, endMonth)) {
            return;
        }
        ExportTableReferenceBeanInterface exportTable = this.timeReference().exportTable();
        exportTable.setExportCode(vo.getRadSelect());
        exportTable.setStartYear(startYear);
        exportTable.setStartMonth(startMonth);
        exportTable.setEndYear(endYear);
        exportTable.setEndMonth(endMonth);
        exportTable.setCutoffCode(vo.getPltCutoff());
        exportTable.setWorkPlaceCode(vo.getPltWorkPlace());
        exportTable.setEmploymentCode(vo.getPltEmployment());
        exportTable.setSectionCode(vo.getPltSection());
        exportTable.setCkbNeedLowerSection(ckbNeedLowerSection);
        exportTable.setPositionCode(vo.getPltPosition());
        List csvDataList = exportTable.export();
        if (this.mospParams.hasErrorMessage()) {
            vo.setRadSelect("");
            return;
        }
        if (csvDataList.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("Export"));
            sb.append(this.mospParams.getName("Information"));
            this.mospParams.addErrorMessage("PFW0201", new String[]{sb.toString()});
            vo.setRadSelect("");
            return;
        }
        this.mospParams.setFile((Object)OrangeSignalUtility.getOrangeSignalParams((List)csvDataList));
        this.setFileName();
    }

    protected void setFileName() throws MospException {
        TimeExportListVo vo = (TimeExportListVo)this.mospParams.getVo();
        ExportDtoInterface dto = this.reference().export().findForKey(vo.getRadSelect());
        String exportCode = "";
        String fileExtension = "";
        if (dto != null) {
            if (dto.getExportCode() != null) {
                exportCode = dto.getExportCode();
            }
            if ("1".equals(dto.getType())) {
                fileExtension = ".csv";
            }
        }
        String hyphen = this.mospParams.getName("Hyphen");
        int startYear = this.getInt(vo.getTxtStartYear());
        int startMonth = this.getInt(vo.getTxtStartMonth());
        Date targetDate = MonthUtility.getYearMonthTargetDate((int)startYear, (int)startMonth, (MospParams)this.mospParams);
        CutoffDtoInterface cutoffDto = this.timeReference().cutoff().getCutoffInfo(vo.getPltCutoff(), targetDate);
        this.timeReference().cutoff().chkExistCutoff(cutoffDto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        Date startDate = TimeUtility.getCutoffFirstDate((int)cutoffDto.getCutoffDate(), (int)startYear, (int)startMonth);
        Date endDate = TimeUtility.getCutoffLastDate((int)cutoffDto.getCutoffDate(), (int)this.getInt(vo.getTxtEndYear()), (int)this.getInt(vo.getTxtEndMonth()));
        StringBuffer sb = new StringBuffer();
        sb.append(exportCode);
        sb.append(hyphen);
        sb.append(this.getStringYear(startDate));
        sb.append(this.getStringMonth(startDate));
        sb.append(this.getStringDay(startDate));
        sb.append(hyphen);
        sb.append(this.getStringYear(endDate));
        sb.append(this.getStringMonth(endDate));
        sb.append(this.getStringDay(endDate));
        sb.append(fileExtension);
        this.mospParams.setFileName(sb.toString());
    }

    public boolean addGeneralExportTimeType(String exportTable, int startYear, int startMonth, int endYear, int endMonth) {
        return false;
    }
}

