/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.portal.bean.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.portal.PortalBeanInterface;
import jp.mosp.platform.bean.portal.impl.PortalBean;
import jp.mosp.time.bean.TimeRecordBeanInterface;
import jp.mosp.time.utils.TimeMessageUtility;

public class PortalTimeLoginBean
extends PortalBean
implements PortalBeanInterface {
    public static final String PRM_RECODE_TYPE = "RecodeType";
    public static final String RECODE_START_WORK = "StartWork";
    TimeRecordBeanInterface timeRecord;

    public PortalTimeLoginBean() {
    }

    protected PortalTimeLoginBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.timeRecord = (TimeRecordBeanInterface)this.createBean(TimeRecordBeanInterface.class);
    }

    public void show() throws MospException {
        String recodeType = this.mospParams.getRequestParam(PRM_RECODE_TYPE);
        if (recodeType == null || recodeType.isEmpty()) {
            return;
        }
        if (recodeType.equals(RECODE_START_WORK)) {
            this.recordStartWork();
            if (!this.mospParams.hasErrorMessage()) {
                this.commit();
            }
        }
    }

    protected void recordStartWork() throws MospException {
        String recordTime = DateUtility.getStringTimeAndSecond((Date)this.timeRecord.recordStartWork());
        if (this.mospParams.hasErrorMessage()) {
            TimeMessageUtility.addMessageRecordTimeFailed((MospParams)this.mospParams);
            return;
        }
        TimeMessageUtility.addMessageRecordStartWork((MospParams)this.mospParams, (String)recordTime);
    }

    public void regist() {
    }

    public void commit() throws MospException {
        if (this.connection == null) {
            return;
        }
        try {
            if (this.connection.isClosed()) {
                return;
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }
}

