/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.portal.bean.impl;

import java.sql.Connection;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.RoleUtility;
import jp.mosp.platform.bean.portal.PortalBeanInterface;
import jp.mosp.platform.bean.portal.impl.PortalBean;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.bean.ApprovalInfoReferenceBeanInterface;

public class PortalApprovalListBean
extends PortalBean
implements PortalBeanInterface {
    protected static final String PATH_PORTAL_VIEW = "/jsp/time/portal/portalApprovalList.jsp";
    public static final String PRM_APPROVAL_LIST_WORK_MANAGE = "Attendance";
    public static final String PRM_APPROVAL_LIST_OVERTIME_WORK = "Overtime";
    public static final String PRM_APPROVAL_LIST_VACATION = "Holiday";
    public static final String PRM_APPROVAL_LIST_HOLIDAY_GOINGWORK = "WorkOnHoliday";
    public static final String PRM_APPROVAL_LIST_COMPENSATORY_HOLIDAY = "SubHoliday";
    public static final String PRM_APPROVAL_LIST_WORK_TYPE_CHANGE = "WorkTypeChange";
    public static final String PRM_APPROVAL_LIST_TIME_DIFFERENCE_GOINGWORK = "ApprovedDifference";
    public static final String PRM_APPROVAL_LIST_ALL_APPROVAL = "AllApproval";
    public static final String PRM_APPROVAL_LIST_ALL_CANCEL = "AllCancel";
    protected ApprovalInfoReferenceBeanInterface approvalInfoRefer;

    public PortalApprovalListBean() {
    }

    protected PortalApprovalListBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.approvalInfoRefer = (ApprovalInfoReferenceBeanInterface)this.createBean(ApprovalInfoReferenceBeanInterface.class);
    }

    public void show() throws MospException {
        if (!RoleUtility.isApprover((MospParams)this.mospParams)) {
            return;
        }
        this.addPortalViewList(PATH_PORTAL_VIEW);
        String personalId = this.mospParams.getUser().getPersonalId();
        this.setRangeMap("ApprovalList");
        Map approvableMap = this.approvalInfoRefer.getApprovableMap(personalId);
        Map subApprovableMap = this.approvalInfoRefer.getSubApprovableMap(personalId, approvableMap);
        Map cancelableMap = this.approvalInfoRefer.getCancelableMap(personalId);
        Map subCancelableMap = this.approvalInfoRefer.getSubCancelableMap(personalId, cancelableMap);
        this.setVoList(approvableMap, subApprovableMap, cancelableMap, subCancelableMap);
        this.removeRangeMap();
    }

    public void regist() {
    }

    protected void setVoList(Map<String, Map<Long, WorkflowDtoInterface>> approvableMap, Map<String, Map<Long, WorkflowDtoInterface>> subApprovableMap, Map<String, Map<Long, WorkflowDtoInterface>> cancelableMap, Map<String, Map<Long, WorkflowDtoInterface>> subCancelableMap) throws MospException {
        int attendanceCount = approvableMap.get("1").size();
        int overTimeCount = approvableMap.get("2").size();
        int holidayCount = approvableMap.get("3").size();
        int workOnHolidayCount = approvableMap.get("4").size();
        int subHolidayCount = approvableMap.get("5").size();
        int differenceCount = approvableMap.get("6").size();
        int workTypeChangeCount = approvableMap.get("7").size();
        attendanceCount += subApprovableMap.get("1").size();
        overTimeCount += subApprovableMap.get("2").size();
        holidayCount += subApprovableMap.get("3").size();
        workOnHolidayCount += subApprovableMap.get("4").size();
        subHolidayCount += subApprovableMap.get("5").size();
        differenceCount += subApprovableMap.get("6").size();
        workTypeChangeCount += subApprovableMap.get("7").size();
        this.putPortalParameter(PRM_APPROVAL_LIST_WORK_MANAGE, String.valueOf(attendanceCount));
        this.putPortalParameter(PRM_APPROVAL_LIST_OVERTIME_WORK, String.valueOf(overTimeCount));
        this.putPortalParameter(PRM_APPROVAL_LIST_VACATION, String.valueOf(holidayCount));
        this.putPortalParameter(PRM_APPROVAL_LIST_HOLIDAY_GOINGWORK, String.valueOf(workOnHolidayCount));
        this.putPortalParameter(PRM_APPROVAL_LIST_COMPENSATORY_HOLIDAY, String.valueOf(subHolidayCount));
        this.putPortalParameter(PRM_APPROVAL_LIST_TIME_DIFFERENCE_GOINGWORK, String.valueOf(differenceCount));
        this.putPortalParameter(PRM_APPROVAL_LIST_WORK_TYPE_CHANGE, String.valueOf(workTypeChangeCount));
        this.putPortalParameter(PRM_APPROVAL_LIST_ALL_APPROVAL, String.valueOf(attendanceCount + overTimeCount + holidayCount + workOnHolidayCount + subHolidayCount + differenceCount + workTypeChangeCount));
        this.putPortalParameter(PRM_APPROVAL_LIST_ALL_CANCEL, String.valueOf(cancelableMap.get("1").size() + cancelableMap.get("2").size() + cancelableMap.get("3").size() + cancelableMap.get("4").size() + cancelableMap.get("5").size() + cancelableMap.get("6").size() + cancelableMap.get("7").size() + subCancelableMap.get("1").size() + subCancelableMap.get("2").size() + subCancelableMap.get("3").size() + subCancelableMap.get("4").size() + subCancelableMap.get("5").size() + subCancelableMap.get("6").size() + subCancelableMap.get("7").size()));
    }
}

