/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.input.action;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceTransactionRegistBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.HolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.HolidayReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestRegistBeanInterface;
import jp.mosp.time.bean.HolidayRequestSearchBeanInterface;
import jp.mosp.time.bean.PaidHolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayReferenceBeanInterface;
import jp.mosp.time.bean.StockHolidayInfoReferenceBeanInterface;
import jp.mosp.time.comparator.settings.HolidayRequestRequestDateComparator;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.HolidayDataDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestListDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.input.vo.HolidayRequestVo;
import jp.mosp.time.utils.TimeUtility;

public class HolidayRequestAction
extends TimeAction {
    public static final String CMD_SHOW = "TM1500";
    public static final String CMD_SELECT_SHOW = "TM1501";
    public static final String CMD_SEARCH = "TM1502";
    public static final String CMD_RE_SHOW = "TM1503";
    public static final String CMD_DRAFT = "TM1504";
    public static final String CMD_APPLI = "TM1505";
    public static final String CMD_TRANSFER = "TM1506";
    public static final String CMD_WITHDRAWN = "TM1507";
    public static final String CMD_SORT = "TM1508";
    public static final String CMD_PAGE = "TM1509";
    public static final String CMD_BATCH_WITHDRAWN = "TM1536";
    public static final String CMD_SET_ACTIVATION_DATE = "TM1590";
    public static final String CMD_INSERT_MODE = "TM1591";
    public static final String CMD_EDIT_MODE = "TM1592";
    public static final String CMD_BATCH_UPDATE = "TM1595";
    public static final String CMD_SET_VIEW_PERIOD = "TM1597";
    public static final String CMD_SET_TRANSFER_HOLIDAY = "TM1598";
    public static final String CMD_SELECT_ACTIVATION_DATE = "TM1599";

    public HolidayRequestAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new HolidayRequestVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_DRAFT)) {
            this.prepareVo();
            this.draft();
        } else if (this.mospParams.getCommand().equals(CMD_APPLI)) {
            this.prepareVo();
            this.appli();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_WITHDRAWN)) {
            this.prepareVo();
            this.withdrawn();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_WITHDRAWN)) {
            this.prepareVo();
            this.batchWithdrawn();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setEditActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_MODE)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        } else if (this.mospParams.getCommand().equals(CMD_SET_VIEW_PERIOD)) {
            this.prepareVo();
            this.setSearchActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_SET_TRANSFER_HOLIDAY)) {
            this.prepareVo();
            this.setHolidayContinue();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_ACTIVATION_DATE)) {
            this.prepareVo(false, false);
            this.selectActivationDate();
        }
    }

    protected void show() throws MospException {
        String personalId = this.mospParams.getUser().getPersonalId();
        Date targetDate = this.getSystemDate();
        this.setEmployeeInfo(personalId, targetDate);
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.insertMode();
        this.search();
    }

    protected void select() throws MospException {
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getSystemDate();
        if (personalId == null || personalId.isEmpty()) {
            personalId = this.mospParams.getUser().getPersonalId();
        }
        this.setEmployeeInfo(personalId, targetDate);
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.insertMode();
        this.search();
    }

    protected void search() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayRequestSearchBeanInterface search = this.timeReference().holidayRequestSearch();
        search.setPersonalId(vo.getPersonalId());
        String holidayType1 = vo.getPltSearchHolidayType();
        search.setHolidayType1(holidayType1);
        search.setHolidayType2("");
        search.setHolidayLength("");
        if (holidayType1 != null && !holidayType1.isEmpty()) {
            int holidayType = Integer.parseInt(holidayType1);
            String holidayType2 = "";
            String holidayLength = vo.getPltSearchHolidayRange1();
            if (1 == holidayType) {
                holidayType2 = vo.getPltSearchStatusWithPay();
            } else if (2 == holidayType) {
                holidayType2 = vo.getPltSearchStatusSpecial();
            } else if (3 == holidayType) {
                holidayType2 = vo.getPltSearchSpecialOther();
            } else if (4 == holidayType) {
                holidayType2 = vo.getPltSearchSpecialAbsence();
            }
            search.setHolidayType2(holidayType2);
            search.setHolidayLength(holidayLength);
        }
        int year = Integer.parseInt(vo.getPltSearchYear());
        int startMonth = this.getInt("1");
        int endMonth = this.getInt("12");
        if (!vo.getPltSearchMonth().isEmpty()) {
            endMonth = startMonth = this.getInt(vo.getPltSearchMonth());
        }
        CutoffUtilBeanInterface cutoffUtil = this.timeReference().cutoffUtil();
        CutoffDtoInterface startMonthCutoffDto = cutoffUtil.getCutoffForPersonalId(vo.getPersonalId(), year, startMonth);
        if (this.mospParams.hasErrorMessage()) {
            this.addNoSearchResultMessage();
            return;
        }
        CutoffDtoInterface endMonthCutoffDto = cutoffUtil.getCutoffForPersonalId(vo.getPersonalId(), year, endMonth);
        String startMonthCutoffCode = startMonthCutoffDto == null ? null : startMonthCutoffDto.getCutoffCode();
        String endMonthCutoffCode = endMonthCutoffDto == null ? null : endMonthCutoffDto.getCutoffCode();
        Date firstDate = null;
        if (startMonthCutoffCode != null) {
            firstDate = cutoffUtil.getCutoffFirstDate(startMonthCutoffCode, year, startMonth);
        }
        Date lastDate = null;
        if (endMonthCutoffCode != null) {
            lastDate = cutoffUtil.getCutoffLastDate(endMonthCutoffCode, year, endMonth);
        }
        search.setRequestStartDate(firstDate);
        search.setRequestEndDate(lastDate);
        search.setWorkflowStatus(vo.getPltSearchState());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(HolidayRequestRequestDateComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty() && this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.addNoSearchResultMessage();
        }
    }

    public void setDefaultValues() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayRequestReferenceBeanInterface holidayRequest = this.timeReference().holidayRequest();
        Date date = this.getSystemDate();
        String personalId = vo.getPersonalId();
        String nameNoLimit = this.mospParams.getName("NoLimit");
        PaidHolidayInfoReferenceBeanInterface paidHolidayInfo = this.timeReference().paidHolidayInfo();
        HolidayInfoReferenceBeanInterface holidayInfo = this.timeReference().holidayInfo();
        StockHolidayInfoReferenceBeanInterface stockHolidayInfo = this.timeReference().stockHolidayInfo();
        vo.setJsPaidHolidayReasonRequired(holidayRequest.isPaidHolidayReasonRequired());
        List specialList = holidayInfo.getHolidayPossibleRequestList(personalId, date, 2);
        List otherList = holidayInfo.getHolidayPossibleRequestList(personalId, date, 3);
        String[] aryGivingDate = new String[specialList.size() + otherList.size()];
        String[] arySpecialHolidayType = new String[specialList.size() + otherList.size()];
        String[] arySpecialHolidayName = new String[specialList.size() + otherList.size()];
        String[] aryRemainder = new String[specialList.size() + otherList.size()];
        String[] aryLimit = new String[specialList.size() + otherList.size()];
        int cnt = 0;
        for (cnt = 0; cnt < specialList.size(); ++cnt) {
            HolidayDataDtoInterface dto = (HolidayDataDtoInterface)specialList.get(cnt);
            aryGivingDate[cnt] = DateUtility.getStringDateAndDay((Date)dto.getActivateDate());
            arySpecialHolidayType[cnt] = this.mospParams.getName("Specially", new String[]{"Vacation"});
            HolidayDtoInterface holidayDto = this.timeReference().holiday().getHolidayInfo(dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayType());
            arySpecialHolidayName[cnt] = holidayDto != null ? holidayDto.getHolidayName() : dto.getHolidayCode();
            if (TimeUtility.getUnlimitedDate().compareTo(dto.getHolidayLimitDate()) == 0) {
                aryRemainder[cnt] = nameNoLimit;
                aryLimit[cnt] = nameNoLimit;
                continue;
            }
            aryRemainder[cnt] = this.getFormatDaysAndHours(dto.getGivingDay(), dto.getGivingHour(), false);
            aryLimit[cnt] = DateUtility.getStringDateAndDay((Date)dto.getHolidayLimitDate());
        }
        for (int i = 0; i < otherList.size(); ++i) {
            HolidayDataDtoInterface dto = (HolidayDataDtoInterface)otherList.get(i);
            aryGivingDate[cnt] = DateUtility.getStringDateAndDay((Date)dto.getActivateDate());
            arySpecialHolidayType[cnt] = this.mospParams.getName("Others", new String[]{"Vacation"});
            HolidayDtoInterface holidayDto = this.timeReference().holiday().getHolidayInfo(dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayType());
            arySpecialHolidayName[cnt] = holidayDto != null ? holidayDto.getHolidayName() : dto.getHolidayCode();
            if (TimeUtility.getUnlimitedDate().compareTo(dto.getHolidayLimitDate()) == 0) {
                aryRemainder[cnt] = nameNoLimit;
                aryLimit[cnt] = nameNoLimit;
            } else {
                aryRemainder[cnt] = this.getFormatDaysAndHours(dto.getGivingDay(), dto.getGivingHour(), false);
                aryLimit[cnt] = DateUtility.getStringDateAndDay((Date)dto.getHolidayLimitDate());
            }
            ++cnt;
        }
        vo.setRecordId(0L);
        vo.setAryLblGivingDate(aryGivingDate);
        vo.setAryLblSpecialHolidayType(arySpecialHolidayType);
        vo.setAryLblSpecialHolidayName(arySpecialHolidayName);
        vo.setAryLblRemainder(aryRemainder);
        vo.setAryLblLimit(aryLimit);
        if (this.getTargetDate() == null) {
            vo.setPltEditStartYear(DateUtility.getStringYear((Date)date));
            vo.setPltEditStartMonth(DateUtility.getStringMonthM((Date)date));
            vo.setPltEditStartDay(DateUtility.getStringDayD((Date)date));
            vo.setPltEditEndYear(DateUtility.getStringYear((Date)date));
            vo.setPltEditEndMonth(DateUtility.getStringMonthM((Date)date));
            vo.setPltEditEndDay(DateUtility.getStringDayD((Date)date));
        } else {
            vo.setPltEditStartYear(DateUtility.getStringYear((Date)this.getTargetDate()));
            vo.setPltEditStartMonth(DateUtility.getStringMonthM((Date)this.getTargetDate()));
            vo.setPltEditStartDay(DateUtility.getStringDayD((Date)this.getTargetDate()));
            vo.setPltEditEndYear(DateUtility.getStringYear((Date)this.getTargetDate()));
            vo.setPltEditEndMonth(DateUtility.getStringMonthM((Date)this.getTargetDate()));
            vo.setPltEditEndDay(DateUtility.getStringDayD((Date)this.getTargetDate()));
        }
        int[] timeUnitLimit = paidHolidayInfo.getHolidayTimeUnitLimit(personalId, date, false, null);
        vo.setLblHolidayTimeUnitLimit(this.getNumberOfDayAndHour(timeUnitLimit[0], timeUnitLimit[1]));
        this.initVo();
        this.setPaidLeaveByHour();
        double stock = 0.0;
        Double remainDay = stockHolidayInfo.getRemainDay(personalId, date);
        if (remainDay != null) {
            stock = remainDay;
        }
        vo.setLblPaidHolidayStock(String.valueOf(stock));
        this.setPaidLeave();
        Map nextYearMap = paidHolidayInfo.getNextGivingInfo(personalId);
        if (nextYearMap == null) {
            return;
        }
        double nextYearDay = (Double)nextYearMap.get("NextPlantYearDay");
        if (nextYearDay == -1.0) {
            nextYearDay = 0.0;
        }
        int nextYearTime = (Integer)nextYearMap.get("NextPlanTime");
        Date nextYearGivingDate = (Date)nextYearMap.get("NextPlanGivingDate");
        Date nextYearrLimitDate = (Date)nextYearMap.get("NextPlanLimitDate");
        vo.setLblNextGivingDate(DateUtility.getStringDateAndDay((Date)nextYearGivingDate));
        vo.setLblNextGivingAmount(this.getFormatDaysAndHours(nextYearDay, nextYearTime, false));
        vo.setLblNextLimitDate(DateUtility.getStringDateAndDay((Date)nextYearrLimitDate));
        Date nextManualGivingDate = paidHolidayInfo.getNextManualGivingDate(personalId);
        if (null == nextManualGivingDate) {
            return;
        }
        vo.setLblNextManualGivingDate(DateUtility.getStringDateAndDay((Date)nextManualGivingDate));
        vo.setLblNextManualGivingAmount(paidHolidayInfo.getNextManualGivingDaysAndHours(vo.getPersonalId()));
    }

    protected void setPaidLeave() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        PaidHolidayInfoReferenceBeanInterface paidHolidayInfo = this.timeReference().paidHolidayInfo();
        Date date = this.getSystemDate();
        List list = paidHolidayInfo.getPaidHolidayDataListForView(vo.getPersonalId(), date);
        String[] aryLblPaidLeaveFiscalYear = new String[list.size()];
        String[] aryLblStyle = new String[list.size()];
        String[] aryLblPaidLeaveGrantDate = new String[list.size()];
        String[] aryLblPaidLeaveExpirationDate = new String[list.size()];
        String[] aryLblPaidLeaveRemainDays = new String[list.size()];
        String[] aryLblPaidLeaveGrantDays = new String[list.size()];
        double totalRemainDays = 0.0;
        int totalRemainHours = 0;
        for (int i = 0; i < list.size(); ++i) {
            Map m = (Map)list.get(i);
            aryLblStyle[i] = "";
            aryLblPaidLeaveGrantDate[i] = "";
            Object grantDate = m.get("PaidLeaveGrantDate");
            if (grantDate != null) {
                aryLblPaidLeaveGrantDate[i] = DateUtility.getStringDateAndDay((Date)((Date)grantDate));
                if (this.getSystemDate().compareTo((Date)grantDate) < 0) {
                    aryLblStyle[i] = "style=\"color: gray\"";
                }
            }
            String fiscalYearString = "";
            Object fiscalYear = m.get("PaidLeaveFiscalYear");
            if (fiscalYear != null) {
                fiscalYearString = fiscalYear.toString();
            }
            aryLblPaidLeaveFiscalYear[i] = fiscalYearString;
            aryLblPaidLeaveExpirationDate[i] = "";
            Object expirationDate = m.get("PaidLeaveExpirationDate");
            if (expirationDate != null) {
                aryLblPaidLeaveExpirationDate[i] = DateUtility.getStringDateAndDay((Date)((Date)expirationDate));
            }
            double remainDaysDouble = 0.0;
            Object remainDays = m.get("PaidLeaveRemainDays");
            if (remainDays != null) {
                remainDaysDouble = (Double)remainDays;
            }
            int remainHoursInt = 0;
            Object remainHours = m.get("PaidLeaveRemainHours");
            if (remainHours != null) {
                remainHoursInt = (Integer)remainHours;
            }
            double grantDaysDouble = 0.0;
            Object grantDays = m.get("PaidLeaveGrantDays");
            if (grantDays != null) {
                grantDaysDouble = (Double)grantDays;
            }
            int grantHoursInt = 0;
            Object grantHours = m.get("PaidLeaveGrantHours");
            if (grantHours != null) {
                grantHoursInt = (Integer)grantHours;
            }
            aryLblPaidLeaveRemainDays[i] = this.getFormatDaysAndHours(remainDaysDouble, remainHoursInt, false);
            aryLblPaidLeaveGrantDays[i] = this.getFormatDaysAndHours(grantDaysDouble, grantHoursInt, false);
            if (!this.mospParams.getName("PreviousYear", new String[]{"Times"}).equals(fiscalYearString) && !this.mospParams.getName("ThisYear", new String[]{"Times"}).equals(fiscalYearString)) continue;
            totalRemainDays += remainDaysDouble;
            totalRemainHours += remainHoursInt;
        }
        vo.setAryLblPaidLeaveFiscalYear(aryLblPaidLeaveFiscalYear);
        vo.setAryLblStyle(aryLblStyle);
        vo.setAryLblPaidLeaveGrantDate(aryLblPaidLeaveGrantDate);
        vo.setAryLblPaidLeaveExpirationDate(aryLblPaidLeaveExpirationDate);
        vo.setAryLblPaidLeaveRemainDays(aryLblPaidLeaveRemainDays);
        vo.setAryLblPaidLeaveGrantDays(aryLblPaidLeaveGrantDays);
        vo.setLblTotalDay(Double.toString(totalRemainDays));
        vo.setLblTotalTime(Integer.toString(totalRemainHours));
    }

    protected void setPaidLeaveByHour() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        ApplicationReferenceBeanInterface applicationReference = this.timeReference().application();
        PaidHolidayReferenceBeanInterface paidHolidayReference = this.timeReference().paidHoliday();
        vo.setPaidLeaveByHour(false);
        Date date = this.getSystemDate();
        ApplicationDtoInterface applicationDto = applicationReference.findForPerson(vo.getPersonalId(), date);
        if (applicationDto == null) {
            return;
        }
        PaidHolidayDtoInterface paidHolidayDto = paidHolidayReference.getPaidHolidayInfo(applicationDto.getPaidHolidayCode(), date);
        if (paidHolidayDto == null) {
            return;
        }
        vo.setPaidLeaveByHour(paidHolidayDto.getTimelyPaidHolidayFlag() == 0);
    }

    protected String getNumberOfDayAndHour(int day, int hour) {
        StringBuffer sb = new StringBuffer();
        sb.append(day);
        sb.append(this.mospParams.getName("Day"));
        if (hour > 0) {
            sb.append(hour);
            sb.append(this.mospParams.getName("Time"));
        }
        return sb.toString();
    }

    protected void setSearchRequestDate(String year, String month) {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        vo.setPltSearchYear(year);
        vo.setPltSearchMonth(month);
    }

    protected void initVo() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        Date date = this.getSystemDate();
        vo.setPltEditHolidayType1(String.valueOf(1));
        vo.setPltEditStatusWithPay("");
        vo.setPltEditStatusSpecial("");
        vo.setPltEditSpecialOther("");
        vo.setPltEditSpecialAbsence("");
        vo.setPltEditHolidayRange("");
        vo.setPltEditHolidayRangePaidHoliday("");
        vo.setPltEditStartHour("0");
        vo.setPltEditStartMinute("0");
        vo.setPltEditEndTime("1");
        vo.setTxtEditRequestReason("");
        vo.setPltSearchHolidayType("");
        vo.setPltSearchHolidayType1("");
        vo.setPltSearchHolidayType2("");
        vo.setPltSearchHolidayType3("");
        vo.setPltSearchState("");
        Date searchDate = this.timeReference().cutoffUtil().getCutoffMonth(vo.getPersonalId(), date);
        vo.setPltSearchYear(DateUtility.getStringYear((Date)searchDate));
        vo.setPltSearchMonth(DateUtility.getStringMonthM((Date)searchDate));
        String[] aryPltLblApproverSetting = new String[]{};
        vo.setAryPltLblApproverSetting(aryPltLblApproverSetting);
        vo.setPltApproverSetting1("");
        vo.setPltApproverSetting2("");
        vo.setPltApproverSetting3("");
        vo.setPltApproverSetting4("");
        vo.setPltApproverSetting5("");
        vo.setPltApproverSetting6("");
        vo.setPltApproverSetting7("");
        vo.setPltApproverSetting8("");
        vo.setPltApproverSetting9("");
        vo.setPltApproverSetting10("");
        vo.setTxtEditRequestReason("");
        vo.setLblTotalDay("0");
        vo.setLblTotalTime("0");
        vo.setLblNextGivingDate("0");
        vo.setLblNextGivingAmount("0");
        String hyphen = this.mospParams.getName("Hyphen");
        vo.setLblNextManualGivingDate(hyphen);
        vo.setLblNextManualGivingAmount(hyphen);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void draft() throws MospException {
        boolean isAbsence;
        boolean isOtherHoliday;
        boolean isSpecialHoliday;
        boolean isPaidHoliday;
        Date startDate;
        HolidayRequestVo vo;
        block62: {
            Iterator i$;
            int count;
            Date endDate;
            HolidayReferenceBeanInterface holiday;
            HolidayRequestRegistBeanInterface regist;
            block66: {
                Date startTime;
                int hour;
                HolidayDataDtoInterface holidayDataDto;
                block65: {
                    Date startTime2;
                    int hour2;
                    block61: {
                        Date targetDate;
                        Iterator i$2;
                        block58: {
                            Iterator i$3;
                            PaidHolidayInfoReferenceBeanInterface paidHolidayInfo;
                            block57: {
                                List dateList;
                                block63: {
                                    HolidayDtoInterface holidayDto;
                                    block64: {
                                        HolidayInfoReferenceBeanInterface holidayInfo;
                                        block59: {
                                            HolidayDtoInterface holidayDto2;
                                            block60: {
                                                block55: {
                                                    block56: {
                                                        vo = (HolidayRequestVo)this.mospParams.getVo();
                                                        regist = this.time().holidayRequestRegist();
                                                        holiday = this.timeReference().holiday();
                                                        holidayInfo = this.timeReference().holidayInfo();
                                                        paidHolidayInfo = this.timeReference().paidHolidayInfo();
                                                        startDate = this.getEditStartDate();
                                                        endDate = this.getEditEndDate();
                                                        isPaidHoliday = 1 == this.getInt(vo.getPltEditHolidayType1());
                                                        isSpecialHoliday = 2 == this.getInt(vo.getPltEditHolidayType1());
                                                        isOtherHoliday = 3 == this.getInt(vo.getPltEditHolidayType1());
                                                        isAbsence = 4 == this.getInt(vo.getPltEditHolidayType1());
                                                        dateList = TimeUtility.getDateList((Date)startDate, (Date)endDate);
                                                        if (!isPaidHoliday) break block55;
                                                        if (!vo.getPltEditStatusWithPay().equals(String.valueOf(1))) break block56;
                                                        i$3 = dateList.iterator();
                                                        break block57;
                                                    }
                                                    if (!vo.getPltEditStatusWithPay().equals(String.valueOf(2))) {
                                                        this.addInsertFailedMessage();
                                                        return;
                                                    }
                                                    i$2 = dateList.iterator();
                                                    break block58;
                                                }
                                                if (!isSpecialHoliday) break block59;
                                                holidayDto2 = holiday.getHolidayInfo(vo.getPltEditStatusSpecial(), startDate, Integer.parseInt(vo.getPltEditHolidayType1()));
                                                if (holidayDto2 == null || holidayDto2.getInactivateFlag() == 1) {
                                                    this.addInsertFailedMessage();
                                                    String errorMes = this.mospParams.getName("Vacation", new String[]{"Classification"});
                                                    this.mospParams.addErrorMessage("PFW0201", new String[]{errorMes});
                                                    return;
                                                }
                                                holidayDataDto = holidayInfo.getHolidayPossibleRequestForRequest(vo.getPersonalId(), startDate, vo.getPltEditStatusSpecial(), Integer.parseInt(vo.getPltEditHolidayType1()));
                                                if (holidayDataDto == null) {
                                                    this.addInsertFailedMessage();
                                                    this.addHolidayNotGiveErrorMessage(holidayDto2.getHolidayName());
                                                    return;
                                                }
                                                if (4 != this.getInt(vo.getPltEditHolidayRange())) break block60;
                                                hour2 = this.getInt(vo.getPltEditEndTime());
                                                startTime2 = DateUtility.addMinute((Date)DateUtility.addHour((Date)startDate, (int)Integer.parseInt(vo.getPltEditStartHour())), (int)Integer.parseInt(vo.getPltEditStartMinute()));
                                                break block61;
                                            }
                                            double useDay = this.getHolidayDays(holidayDto2, holidayDataDto);
                                            if (this.mospParams.hasErrorMessage()) {
                                                this.addInsertFailedMessage();
                                                return;
                                            }
                                            this.draft(startDate, endDate, startDate, startDate, holidayDataDto.getActivateDate(), null, useDay, 0);
                                            if (this.mospParams.hasErrorMessage()) {
                                                this.addInsertFailedMessage();
                                                return;
                                            }
                                            break block62;
                                        }
                                        if (!isOtherHoliday) break block63;
                                        holidayDto = holiday.getHolidayInfo(vo.getPltEditSpecialOther(), startDate, Integer.parseInt(vo.getPltEditHolidayType1()));
                                        if (holidayDto == null || holidayDto.getInactivateFlag() == 1) {
                                            this.addInsertFailedMessage();
                                            String errorMes = this.mospParams.getName("Vacation", new String[]{"Classification"});
                                            this.mospParams.addErrorMessage("PFW0201", new String[]{errorMes});
                                            return;
                                        }
                                        holidayDataDto = holidayInfo.getHolidayPossibleRequestForRequest(vo.getPersonalId(), startDate, vo.getPltEditSpecialOther(), Integer.parseInt(vo.getPltEditHolidayType1()));
                                        if (holidayDataDto == null) {
                                            this.addInsertFailedMessage();
                                            this.addHolidayNotGiveErrorMessage(holidayDto.getHolidayName());
                                            return;
                                        }
                                        if (4 != this.getInt(vo.getPltEditHolidayRange())) break block64;
                                        hour = this.getInt(vo.getPltEditEndTime());
                                        startTime = DateUtility.addMinute((Date)DateUtility.addHour((Date)startDate, (int)Integer.parseInt(vo.getPltEditStartHour())), (int)Integer.parseInt(vo.getPltEditStartMinute()));
                                        break block65;
                                    }
                                    double useDay = this.getHolidayDays(holidayDto, holidayDataDto);
                                    if (this.mospParams.hasErrorMessage()) {
                                        this.addInsertFailedMessage();
                                        return;
                                    }
                                    this.draft(startDate, endDate, startDate, startDate, holidayDataDto.getActivateDate(), null, useDay, 0);
                                    if (this.mospParams.hasErrorMessage()) {
                                        this.addInsertFailedMessage();
                                        return;
                                    }
                                    break block62;
                                }
                                if (!isAbsence) {
                                    this.addInsertFailedMessage();
                                    return;
                                }
                                count = 0;
                                i$ = dateList.iterator();
                                break block66;
                            }
                            while (i$3.hasNext()) {
                                Date startTime3;
                                int hour3;
                                int useHour;
                                block70: {
                                    List list;
                                    double useDay;
                                    block68: {
                                        Iterator i$4;
                                        boolean isHalfPaidLeave;
                                        boolean addErrorMessage;
                                        block69: {
                                            block67: {
                                                targetDate = (Date)i$3.next();
                                                String workTypeCode = regist.getScheduledWorkTypeCode(vo.getPersonalId(), targetDate);
                                                regist.checkWorkType(startDate, endDate, targetDate, workTypeCode);
                                                if (this.mospParams.hasErrorMessage()) {
                                                    this.addInsertFailedMessage();
                                                    return;
                                                }
                                                if (TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) continue;
                                                useDay = 0.0;
                                                useHour = 0;
                                                if (1 != this.getInt(vo.getPltEditHolidayRangePaidHoliday())) break block67;
                                                list = paidHolidayInfo.getPaidHolidayPossibleRequestForRequestList(vo.getPersonalId(), targetDate);
                                                if (list.size() < 2) break block68;
                                                addErrorMessage = false;
                                                isHalfPaidLeave = false;
                                                i$4 = list.iterator();
                                                break block69;
                                            }
                                            if (2 == this.getInt(vo.getPltEditHolidayRangePaidHoliday()) || 3 == this.getInt(vo.getPltEditHolidayRangePaidHoliday())) {
                                                Date acquisitionDate = null;
                                                List list2 = paidHolidayInfo.getPaidHolidayPossibleRequestForRequestList(vo.getPersonalId(), targetDate);
                                                for (PaidHolidayDataDtoInterface paidHolidayDataDto : list2) {
                                                    if (!(paidHolidayDataDto.getHoldDay() >= 0.5)) continue;
                                                    acquisitionDate = paidHolidayDataDto.getAcquisitionDate();
                                                    break;
                                                }
                                                if (acquisitionDate == null) {
                                                    this.addHolidayNumUnitExcessErrorMessage(this.mospParams.getName("Day"));
                                                    return;
                                                }
                                                useDay = 0.5;
                                                this.draft(targetDate, targetDate, targetDate, targetDate, acquisitionDate, targetDate, useDay, 0);
                                                if (!this.mospParams.hasErrorMessage()) continue;
                                                this.addInsertFailedMessage();
                                                return;
                                            }
                                            if (4 != this.getInt(vo.getPltEditHolidayRangePaidHoliday())) {
                                                this.addInsertFailedMessage();
                                                this.mospParams.addErrorMessage("TMW0305", new String[0]);
                                                return;
                                            }
                                            hour3 = this.getInt(vo.getPltEditEndTime());
                                            startTime3 = DateUtility.addMinute((Date)DateUtility.addHour((Date)targetDate, (int)Integer.parseInt(vo.getPltEditStartHour())), (int)Integer.parseInt(vo.getPltEditStartMinute()));
                                            break block70;
                                        }
                                        while (i$4.hasNext()) {
                                            PaidHolidayDataDtoInterface paidHolidayDataDto = (PaidHolidayDataDtoInterface)i$4.next();
                                            double holdDay = paidHolidayDataDto.getHoldDay();
                                            if (holdDay >= 1.0 && isHalfPaidLeave) {
                                                addErrorMessage = true;
                                                break;
                                            }
                                            isHalfPaidLeave = TimeUtility.isHolidayTimesHalf((double)holdDay) ? true : isHalfPaidLeave;
                                        }
                                        if (addErrorMessage) {
                                            this.addInsertFailedMessage();
                                            this.addPaidLeaveForPreviousFiscalYearErrorMessage();
                                            return;
                                        }
                                    }
                                    Date acquisitionDate = null;
                                    for (PaidHolidayDataDtoInterface paidHolidayDataDto : list) {
                                        if (!(paidHolidayDataDto.getHoldDay() >= 1.0)) continue;
                                        acquisitionDate = paidHolidayDataDto.getAcquisitionDate();
                                        break;
                                    }
                                    if (acquisitionDate == null) {
                                        this.addHolidayNumUnitExcessErrorMessage(this.mospParams.getName("Day"));
                                        return;
                                    }
                                    useDay = 1.0;
                                    this.draft(targetDate, targetDate, targetDate, targetDate, acquisitionDate, targetDate, useDay, 0);
                                    if (!this.mospParams.hasErrorMessage()) continue;
                                    this.addInsertFailedMessage();
                                    return;
                                }
                                for (int i = 0; i < hour3; ++i) {
                                    Date endTime = DateUtility.addHour((Date)startTime3, (int)1);
                                    Date acquisitionDate = null;
                                    List list = paidHolidayInfo.getPaidHolidayPossibleRequestForRequestList(vo.getPersonalId(), targetDate);
                                    for (PaidHolidayDataDtoInterface paidHolidayDataDto : list) {
                                        if (paidHolidayDataDto.getHoldHour() >= 1) {
                                            acquisitionDate = paidHolidayDataDto.getAcquisitionDate();
                                            break;
                                        }
                                        if (!(paidHolidayDataDto.getHoldDay() >= 1.0)) continue;
                                        acquisitionDate = paidHolidayDataDto.getAcquisitionDate();
                                        break;
                                    }
                                    if (acquisitionDate == null) {
                                        this.addHolidayNumUnitExcessErrorMessage(this.mospParams.getName("Time"));
                                        return;
                                    }
                                    useHour = 1;
                                    this.draft(targetDate, targetDate, startTime3, endTime, acquisitionDate, targetDate, 0.0, useHour);
                                    if (this.mospParams.hasErrorMessage()) {
                                        this.addInsertFailedMessage();
                                        return;
                                    }
                                    startTime3 = endTime;
                                }
                            }
                            break block62;
                        }
                        while (i$2.hasNext()) {
                            targetDate = (Date)i$2.next();
                            String workTypeCode = regist.getScheduledWorkTypeCode(vo.getPersonalId(), targetDate);
                            regist.checkWorkType(startDate, endDate, targetDate, workTypeCode);
                            if (this.mospParams.hasErrorMessage()) {
                                this.addInsertFailedMessage();
                                return;
                            }
                            if (TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) continue;
                            double useDay = 0.0;
                            if (1 == this.getInt(vo.getPltEditHolidayRange())) {
                                useDay = 1.0;
                            } else {
                                if (2 != this.getInt(vo.getPltEditHolidayRange()) && 3 != this.getInt(vo.getPltEditHolidayRange())) {
                                    this.addHolidayNumUnitExcessErrorMessage(this.mospParams.getName("Day"));
                                    return;
                                }
                                useDay = 0.5;
                            }
                            Date acquisitionDate = this.getStockHolidayAcquisitionDate(targetDate);
                            if (acquisitionDate == null) {
                                this.addInsertFailedMessage();
                                this.addHolidayNumDaysExcessErrorMessage(this.mospParams.getName("Stock") + this.mospParams.getName("Vacation"));
                                return;
                            }
                            this.draft(targetDate, targetDate, targetDate, targetDate, acquisitionDate, targetDate, useDay, 0);
                            if (!this.mospParams.hasErrorMessage()) continue;
                            this.addInsertFailedMessage();
                            return;
                        }
                        break block62;
                    }
                    for (int i = 0; i < hour2; ++i) {
                        Date endTime = DateUtility.addHour((Date)startTime2, (int)1);
                        Date activateDate = holidayDataDto.getActivateDate();
                        this.draft(startDate, endDate, startTime2, endTime, activateDate, null, 0.0, 1);
                        if (this.mospParams.hasErrorMessage()) {
                            this.addInsertFailedMessage();
                            return;
                        }
                        startTime2 = endTime;
                    }
                    break block62;
                }
                for (int i = 0; i < hour; ++i) {
                    Date endTime = DateUtility.addHour((Date)startTime, (int)1);
                    Date activateDate = holidayDataDto.getActivateDate();
                    this.draft(startDate, endDate, startTime, endTime, activateDate, null, 0.0, 1);
                    if (this.mospParams.hasErrorMessage()) {
                        this.addInsertFailedMessage();
                        return;
                    }
                    startTime = endTime;
                }
                break block62;
            }
            while (i$.hasNext()) {
                Date targetDate = (Date)i$.next();
                String workTypeCode = regist.getScheduledWorkTypeCode(vo.getPersonalId(), targetDate);
                regist.checkWorkType(startDate, endDate, targetDate, workTypeCode);
                if (this.mospParams.hasErrorMessage()) {
                    this.addInsertFailedMessage();
                    return;
                }
                if (TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) continue;
                ++count;
            }
            HolidayDtoInterface holidayDto = holiday.getHolidayInfo(vo.getPltEditSpecialAbsence(), startDate, Integer.parseInt(vo.getPltEditHolidayType1()));
            if (holidayDto == null || holidayDto.getInactivateFlag() == 1) {
                this.addInsertFailedMessage();
                this.mospParams.addErrorMessage("PFW0201", new String[]{this.mospParams.getName("Vacation", new String[]{"Classification"})});
                return;
            }
            if (4 != this.getInt(vo.getPltEditHolidayRange())) {
                double useDay = 0.0;
                if (1 == this.getInt(vo.getPltEditHolidayRange())) {
                    useDay = count;
                } else if (2 == this.getInt(vo.getPltEditHolidayRange()) || 3 == this.getInt(vo.getPltEditHolidayRange())) {
                    useDay = (float)count * 0.5f;
                }
                this.draft(startDate, endDate, startDate, startDate, startDate, null, useDay, 0);
                if (this.mospParams.hasErrorMessage()) {
                    this.addInsertFailedMessage();
                    return;
                }
            } else {
                int useHour = 0;
                int hour = this.getInt(vo.getPltEditEndTime());
                Date startTime = DateUtility.addMinute((Date)DateUtility.addHour((Date)startDate, (int)Integer.parseInt(vo.getPltEditStartHour())), (int)Integer.parseInt(vo.getPltEditStartMinute()));
                for (int i = 0; i < hour; ++i) {
                    Date endTime = DateUtility.addHour((Date)startTime, (int)1);
                    Date activateDate = holidayDto.getActivateDate();
                    useHour = 1;
                    this.draft(startDate, endDate, startTime, endTime, activateDate, null, 0.0, useHour);
                    if (this.mospParams.hasErrorMessage()) {
                        this.addInsertFailedMessage();
                        return;
                    }
                    startTime = endTime;
                }
            }
        }
        this.commit();
        this.addDraftMessage();
        vo.setPltSearchYear(vo.getPltEditStartYear());
        vo.setPltSearchMonth(vo.getPltEditStartMonth());
        this.setSearchPulldown();
        this.search();
        String holidayType2 = "";
        if (isPaidHoliday) {
            holidayType2 = vo.getPltEditStatusWithPay();
        } else if (isSpecialHoliday) {
            holidayType2 = vo.getPltEditStatusSpecial();
        } else if (isOtherHoliday) {
            holidayType2 = vo.getPltEditSpecialOther();
        } else if (isAbsence) {
            holidayType2 = vo.getPltEditSpecialAbsence();
        }
        String range = vo.getPltEditHolidayRange();
        if (1 == this.getInt(vo.getPltEditHolidayType1()) && 1 == this.getInt(vo.getPltEditStatusWithPay())) {
            range = vo.getPltEditHolidayRangePaidHoliday();
        }
        this.setEditUpdateMode(startDate, vo.getPltEditHolidayType1(), holidayType2, range, DateUtility.getStringTime((Date)this.getEditStartTime(), (Date)startDate));
        vo.setModeCardEdit("draft");
    }

    protected void draft(Date startDate, Date endDate, Date startTime, Date endTime, Date acquisitionDate, Date targetDate, double useDay, int useHour) throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayRequestRegistBeanInterface regist = this.time().holidayRequestRegist();
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        HolidayRequestDtoInterface dto = this.timeReference().holidayRequest().findForKey(vo.getRecordId());
        if (dto == null) {
            dto = regist.getInitDto();
        }
        if (useHour > 0 && !startTime.equals(this.getEditStartTime())) {
            dto = regist.getInitDto();
        }
        if (targetDate != null && targetDate.compareTo(DateUtility.getDate((Date)this.getEditStartDate())) != 0) {
            dto = regist.getInitDto();
        }
        this.setDtoFields(dto, startDate, endDate, startTime, endTime, acquisitionDate, useDay, useHour);
        if (useHour > 0 && !startTime.equals(this.getEditStartTime())) {
            dto.setTmdHolidayRequestId(0L);
        }
        if (targetDate != null && targetDate.compareTo(DateUtility.getDate((Date)this.getEditStartDate())) != 0) {
            dto.setTmdHolidayRequestId(0L);
        }
        regist.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        regist.checkDraft(dto);
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        if (workflowDto == null) {
            workflowDto = workflowRegist.getInitDto();
            workflowDto.setFunctionCode("3");
        }
        workflowRegist.setDtoApproverIds(workflowDto, this.getSelectApproverIds());
        workflowDto = workflowRegist.draft(workflowDto, dto.getPersonalId(), dto.getRequestStartDate(), 1);
        if (workflowDto != null) {
            this.platform().workflowCommentRegist().addComment(workflowDto, this.mospParams.getUser().getPersonalId(), this.mospParams.getProperties().getMessage("PFI0001", new String[]{this.mospParams.getName("WorkPaper")}));
            dto.setWorkflow(workflowDto.getWorkflow());
            regist.regist(dto);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void appli() throws MospException {
        HolidayRequestVo vo;
        block54: {
            Date startTime;
            int useHour;
            int hour;
            HolidayDtoInterface holidayDto;
            Date startDate;
            block59: {
                Date startTime2;
                int hour2;
                HolidayDataDtoInterface holidayDataDto;
                block57: {
                    Date startTime3;
                    int hour3;
                    block53: {
                        Date targetDate;
                        Iterator i$;
                        Date endDate;
                        HolidayRequestRegistBeanInterface regist;
                        block50: {
                            PaidHolidayInfoReferenceBeanInterface paidHolidayInfo;
                            block49: {
                                Double count;
                                block58: {
                                    boolean isAbsence;
                                    HolidayReferenceBeanInterface holiday;
                                    block55: {
                                        HolidayDtoInterface holidayDto2;
                                        block56: {
                                            boolean isOtherHoliday;
                                            HolidayInfoReferenceBeanInterface holidayInfo;
                                            block51: {
                                                block52: {
                                                    boolean isSpecialHoliday;
                                                    block47: {
                                                        List dateList;
                                                        block48: {
                                                            vo = (HolidayRequestVo)this.mospParams.getVo();
                                                            regist = this.time().holidayRequestRegist();
                                                            holiday = this.timeReference().holiday();
                                                            holidayInfo = this.timeReference().holidayInfo();
                                                            paidHolidayInfo = this.timeReference().paidHolidayInfo();
                                                            startDate = this.getEditStartDate();
                                                            endDate = this.getEditEndDate();
                                                            dateList = TimeUtility.getDateList((Date)startDate, (Date)endDate);
                                                            boolean isPaidHoliday = 1 == this.getInt(vo.getPltEditHolidayType1());
                                                            isSpecialHoliday = 2 == this.getInt(vo.getPltEditHolidayType1());
                                                            isOtherHoliday = 3 == this.getInt(vo.getPltEditHolidayType1());
                                                            boolean bl = isAbsence = 4 == this.getInt(vo.getPltEditHolidayType1());
                                                            if (!isPaidHoliday) break block47;
                                                            if (!vo.getPltEditStatusWithPay().equals(String.valueOf(1))) break block48;
                                                            i$ = dateList.iterator();
                                                            break block49;
                                                        }
                                                        if (!vo.getPltEditStatusWithPay().equals(String.valueOf(2))) {
                                                            this.addInsertFailedMessage();
                                                            return;
                                                        }
                                                        i$ = dateList.iterator();
                                                        break block50;
                                                    }
                                                    if (!isSpecialHoliday) break block51;
                                                    holidayDto2 = holiday.getHolidayInfo(vo.getPltEditStatusSpecial(), startDate, Integer.parseInt(vo.getPltEditHolidayType1()));
                                                    if (holidayDto2 == null || holidayDto2.getInactivateFlag() == 1) {
                                                        this.addInsertFailedMessage();
                                                        String errorMes = this.mospParams.getName("Vacation", new String[]{"Classification"});
                                                        this.mospParams.addErrorMessage("PFW0201", new String[]{errorMes});
                                                        return;
                                                    }
                                                    holidayDataDto = holidayInfo.getHolidayPossibleRequestForRequest(vo.getPersonalId(), startDate, vo.getPltEditStatusSpecial(), Integer.parseInt(vo.getPltEditHolidayType1()));
                                                    if (holidayDataDto == null) {
                                                        this.addInsertFailedMessage();
                                                        this.addHolidayNotGiveErrorMessage(holidayDto2.getHolidayName());
                                                        return;
                                                    }
                                                    if (4 != this.getInt(vo.getPltEditHolidayRange())) break block52;
                                                    hour3 = this.getInt(vo.getPltEditEndTime());
                                                    if (hour3 == 0) {
                                                        this.addInsertFailedMessage();
                                                        this.mospParams.addErrorMessage("PFW0102", new String[]{this.mospParams.getName("Time", new String[]{"Rest", "Application", "Time"})});
                                                        return;
                                                    }
                                                    startTime3 = DateUtility.addMinute((Date)DateUtility.addHour((Date)startDate, (int)Integer.parseInt(vo.getPltEditStartHour())), (int)Integer.parseInt(vo.getPltEditStartMinute()));
                                                    break block53;
                                                }
                                                double useDay = this.getHolidayDays(holidayDto2, holidayDataDto);
                                                if (this.mospParams.hasErrorMessage()) {
                                                    this.addInsertFailedMessage();
                                                    return;
                                                }
                                                this.regist(startDate, endDate, startDate, startDate, holidayDataDto.getActivateDate(), null, useDay, 0);
                                                if (this.mospParams.hasErrorMessage()) {
                                                    this.addInsertFailedMessage();
                                                    return;
                                                }
                                                break block54;
                                            }
                                            if (!isOtherHoliday) break block55;
                                            holidayDto2 = holiday.getHolidayInfo(vo.getPltEditSpecialOther(), startDate, Integer.parseInt(vo.getPltEditHolidayType1()));
                                            if (holidayDto2 == null || holidayDto2.getInactivateFlag() == 1) {
                                                this.addInsertFailedMessage();
                                                String errorMes = this.mospParams.getName("Vacation", new String[]{"Classification"});
                                                this.mospParams.addErrorMessage("PFW0201", new String[]{errorMes});
                                                return;
                                            }
                                            holidayDataDto = holidayInfo.getHolidayPossibleRequestForRequest(vo.getPersonalId(), startDate, vo.getPltEditSpecialOther(), Integer.parseInt(vo.getPltEditHolidayType1()));
                                            if (holidayDataDto == null) {
                                                this.addInsertFailedMessage();
                                                this.addHolidayNotGiveErrorMessage(holidayDto2.getHolidayName());
                                                return;
                                            }
                                            if (4 != this.getInt(vo.getPltEditHolidayRange())) break block56;
                                            hour2 = this.getInt(vo.getPltEditEndTime());
                                            if (hour2 == 0) {
                                                this.addInsertFailedMessage();
                                                this.mospParams.addErrorMessage("PFW0102", new String[]{this.mospParams.getName("Time", new String[]{"Rest", "Application", "Time"})});
                                                return;
                                            }
                                            startTime2 = DateUtility.addMinute((Date)DateUtility.addHour((Date)startDate, (int)Integer.parseInt(vo.getPltEditStartHour())), (int)Integer.parseInt(vo.getPltEditStartMinute()));
                                            break block57;
                                        }
                                        double useDay = this.getHolidayDays(holidayDto2, holidayDataDto);
                                        if (this.mospParams.hasErrorMessage()) {
                                            this.addInsertFailedMessage();
                                            return;
                                        }
                                        this.regist(startDate, endDate, startDate, startDate, holidayDataDto.getActivateDate(), null, useDay, 0);
                                        if (this.mospParams.hasErrorMessage()) {
                                            this.addInsertFailedMessage();
                                            return;
                                        }
                                        break block54;
                                    }
                                    if (!isAbsence) {
                                        this.addInsertFailedMessage();
                                        return;
                                    }
                                    count = this.getHolidayCount(startDate, endDate);
                                    holidayDto = holiday.getHolidayInfo(vo.getPltEditSpecialAbsence(), startDate, Integer.parseInt(vo.getPltEditHolidayType1()));
                                    if (holidayDto == null || holidayDto.getInactivateFlag() == 1) {
                                        this.addInsertFailedMessage();
                                        this.mospParams.addErrorMessage("PFW0201", new String[]{this.mospParams.getName("Vacation", new String[]{"Classification"})});
                                        return;
                                    }
                                    if (4 != this.getInt(vo.getPltEditHolidayRange())) break block58;
                                    hour = this.getInt(vo.getPltEditEndTime());
                                    useHour = 0;
                                    if (hour == 0) {
                                        this.addInsertFailedMessage();
                                        this.mospParams.addErrorMessage("PFW0102", new String[]{this.mospParams.getName("Time", new String[]{"Rest", "Application", "Time"})});
                                        return;
                                    }
                                    startTime = DateUtility.addMinute((Date)DateUtility.addHour((Date)startDate, (int)Integer.parseInt(vo.getPltEditStartHour())), (int)Integer.parseInt(vo.getPltEditStartMinute()));
                                    break block59;
                                }
                                double useDay = 0.0;
                                if (1 == this.getInt(vo.getPltEditHolidayRange())) {
                                    useDay = count;
                                } else if (2 == this.getInt(vo.getPltEditHolidayRange()) || 3 == this.getInt(vo.getPltEditHolidayRange())) {
                                    useDay = count * 0.5;
                                }
                                this.regist(startDate, endDate, startDate, startDate, startDate, null, useDay, 0);
                                if (this.mospParams.hasErrorMessage()) {
                                    this.addInsertFailedMessage();
                                    return;
                                }
                                break block54;
                            }
                            while (i$.hasNext()) {
                                Date startTime4;
                                int hour4;
                                int useHour2;
                                block63: {
                                    Date acquisitionDate;
                                    List list;
                                    double useDay;
                                    block61: {
                                        Iterator i$2;
                                        boolean isHalfPaidLeave;
                                        boolean addErrorMessage;
                                        block62: {
                                            block60: {
                                                targetDate = (Date)i$.next();
                                                String workTypeCode = regist.getScheduledWorkTypeCode(vo.getPersonalId(), targetDate);
                                                regist.checkWorkType(startDate, endDate, targetDate, workTypeCode);
                                                if (this.mospParams.hasErrorMessage()) {
                                                    this.addInsertFailedMessage();
                                                    return;
                                                }
                                                if (TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) continue;
                                                useDay = 0.0;
                                                useHour2 = 0;
                                                if (1 != this.getInt(vo.getPltEditHolidayRangePaidHoliday())) break block60;
                                                list = paidHolidayInfo.getPaidHolidayPossibleRequestForRequestList(vo.getPersonalId(), targetDate);
                                                if (list.size() < 2) break block61;
                                                addErrorMessage = false;
                                                isHalfPaidLeave = false;
                                                i$2 = list.iterator();
                                                break block62;
                                            }
                                            if (2 == this.getInt(vo.getPltEditHolidayRangePaidHoliday()) || 3 == this.getInt(vo.getPltEditHolidayRangePaidHoliday())) {
                                                List list2 = paidHolidayInfo.getPaidHolidayPossibleRequestForRequestList(vo.getPersonalId(), targetDate);
                                                acquisitionDate = this.getAcquisitionDate(list2, Float.valueOf(0.5f), targetDate);
                                                if (this.mospParams.hasErrorMessage()) {
                                                    return;
                                                }
                                                useDay = 0.5;
                                                this.regist(targetDate, targetDate, targetDate, targetDate, acquisitionDate, targetDate, useDay, 0);
                                                if (!this.mospParams.hasErrorMessage()) continue;
                                                this.addInsertFailedMessage();
                                                return;
                                            }
                                            if (4 != this.getInt(vo.getPltEditHolidayRangePaidHoliday())) {
                                                this.addInsertFailedMessage();
                                                this.mospParams.addErrorMessage("TMW0305", new String[0]);
                                                return;
                                            }
                                            hour4 = this.getInt(vo.getPltEditEndTime());
                                            if (hour4 == 0) {
                                                this.addInsertFailedMessage();
                                                this.mospParams.addErrorMessage("PFW0102", new String[]{this.mospParams.getName("Time", new String[]{"Rest", "Application", "Time"})});
                                                return;
                                            }
                                            startTime4 = DateUtility.addMinute((Date)DateUtility.addHour((Date)targetDate, (int)Integer.parseInt(vo.getPltEditStartHour())), (int)Integer.parseInt(vo.getPltEditStartMinute()));
                                            break block63;
                                        }
                                        while (i$2.hasNext()) {
                                            PaidHolidayDataDtoInterface paidHolidayDataDto = (PaidHolidayDataDtoInterface)i$2.next();
                                            double holdDay = paidHolidayDataDto.getHoldDay();
                                            if (holdDay >= 1.0 && isHalfPaidLeave) {
                                                addErrorMessage = true;
                                                break;
                                            }
                                            isHalfPaidLeave = TimeUtility.isHolidayTimesHalf((double)holdDay) ? true : isHalfPaidLeave;
                                        }
                                        if (addErrorMessage) {
                                            this.addInsertFailedMessage();
                                            this.addPaidLeaveForPreviousFiscalYearErrorMessage();
                                            return;
                                        }
                                    }
                                    acquisitionDate = this.getAcquisitionDate(list, Float.valueOf(1.0f), targetDate);
                                    if (this.mospParams.hasErrorMessage()) {
                                        return;
                                    }
                                    useDay = 1.0;
                                    this.regist(targetDate, targetDate, targetDate, targetDate, acquisitionDate, targetDate, useDay, 0);
                                    if (!this.mospParams.hasErrorMessage()) continue;
                                    this.addInsertFailedMessage();
                                    return;
                                }
                                for (int i = 0; i < hour4; ++i) {
                                    Date endTime = DateUtility.addHour((Date)startTime4, (int)1);
                                    Date acquisitionDate = null;
                                    List list = paidHolidayInfo.getPaidHolidayPossibleRequestForRequestList(vo.getPersonalId(), targetDate);
                                    for (PaidHolidayDataDtoInterface paidHolidayDataDto : list) {
                                        if (paidHolidayDataDto.getHoldHour() >= 1) {
                                            acquisitionDate = paidHolidayDataDto.getAcquisitionDate();
                                            break;
                                        }
                                        if (!(paidHolidayDataDto.getHoldDay() >= 1.0)) continue;
                                        acquisitionDate = paidHolidayDataDto.getAcquisitionDate();
                                        break;
                                    }
                                    if (acquisitionDate == null) {
                                        this.addHolidayNumUnitExcessErrorMessage(this.mospParams.getName("Time"));
                                        return;
                                    }
                                    useHour2 = 1;
                                    this.regist(targetDate, targetDate, startTime4, endTime, acquisitionDate, targetDate, 0.0, useHour2);
                                    if (this.mospParams.hasErrorMessage()) {
                                        this.addInsertFailedMessage();
                                        return;
                                    }
                                    startTime4 = endTime;
                                }
                            }
                            break block54;
                        }
                        while (i$.hasNext()) {
                            targetDate = (Date)i$.next();
                            String workTypeCode = regist.getScheduledWorkTypeCode(vo.getPersonalId(), targetDate);
                            regist.checkWorkType(startDate, endDate, targetDate, workTypeCode);
                            if (this.mospParams.hasErrorMessage()) {
                                this.addInsertFailedMessage();
                                return;
                            }
                            if (TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) continue;
                            double useDay = 0.0;
                            if (1 == this.getInt(vo.getPltEditHolidayRange())) {
                                useDay = 1.0;
                            } else {
                                if (2 != this.getInt(vo.getPltEditHolidayRange()) && 3 != this.getInt(vo.getPltEditHolidayRange())) {
                                    this.addHolidayNumUnitExcessErrorMessage(this.mospParams.getName("Day"));
                                    return;
                                }
                                useDay = 0.5;
                            }
                            Date acquisitionDate = this.getStockHolidayAcquisitionDate(targetDate);
                            if (acquisitionDate == null) {
                                this.addInsertFailedMessage();
                                this.addHolidayNumDaysExcessErrorMessage(this.mospParams.getName("Stock") + this.mospParams.getName("Vacation"));
                                return;
                            }
                            this.regist(targetDate, targetDate, targetDate, targetDate, acquisitionDate, targetDate, useDay, 0);
                            if (!this.mospParams.hasErrorMessage()) continue;
                            this.addInsertFailedMessage();
                            return;
                        }
                        break block54;
                    }
                    for (int i = 0; i < hour3; ++i) {
                        Date endTime = DateUtility.addHour((Date)startTime3, (int)1);
                        Date activateDate = holidayDataDto.getActivateDate();
                        this.regist(startDate, startDate, startTime3, endTime, activateDate, null, 0.0, 1);
                        if (this.mospParams.hasErrorMessage()) {
                            this.addInsertFailedMessage();
                            return;
                        }
                        startTime3 = endTime;
                    }
                    break block54;
                }
                for (int i = 0; i < hour2; ++i) {
                    Date endTime = DateUtility.addHour((Date)startTime2, (int)1);
                    Date activateDate = holidayDataDto.getActivateDate();
                    this.regist(startDate, startDate, startTime2, endTime, activateDate, null, 0.0, 1);
                    if (this.mospParams.hasErrorMessage()) {
                        this.addInsertFailedMessage();
                        return;
                    }
                    startTime2 = endTime;
                }
                break block54;
            }
            for (int i = 0; i < hour; ++i) {
                Date endTime = DateUtility.addHour((Date)startTime, (int)1);
                Date activateDate = holidayDto.getActivateDate();
                useHour = 1;
                this.regist(startDate, startDate, startTime, endTime, activateDate, null, 0.0, useHour);
                if (this.mospParams.hasErrorMessage()) {
                    this.addInsertFailedMessage();
                    return;
                }
                startTime = endTime;
            }
        }
        this.commit();
        this.addAppliMessage();
        if (Integer.parseInt(vo.getPltEditHolidayRangePaidHoliday()) == 2 || Integer.parseInt(vo.getPltEditHolidayRangePaidHoliday()) == 3) {
            this.addHalfHolidayRequestMessage();
        }
        if (!this.mospParams.hasErrorMessage()) {
            String startYear = vo.getPltEditStartYear();
            String startMonth = vo.getPltEditStartMonth();
            this.insertMode();
            vo.setPltSearchYear(startYear);
            vo.setPltSearchMonth(startMonth);
            this.setSearchPulldown();
            this.search();
        }
    }

    protected void appli(HolidayRequestDtoInterface dto) throws MospException {
        HolidayRequestRegistBeanInterface regist = this.time().holidayRequestRegist();
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        AttendanceTransactionRegistBeanInterface attendanceTransactionRegist = this.time().attendanceTransactionRegist();
        regist.checkAppli(dto);
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        if (workflowDto == null) {
            workflowDto = workflowRegist.getInitDto();
            workflowDto.setFunctionCode("3");
        }
        if (!this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            workflowRegist.setDtoApproverIds(workflowDto, this.getSelectApproverIds());
        }
        if ((workflowDto = workflowRegist.appli(workflowDto, dto.getPersonalId(), dto.getRequestStartDate(), 1, null)) != null) {
            dto.setWorkflow(workflowDto.getWorkflow());
            regist.regist(dto);
            regist.deleteAttendance(dto);
            regist.draftAttendance(dto);
            attendanceTransactionRegist.regist(dto);
        }
    }

    protected void regist(Date startDate, Date endDate, Date startTime, Date endTime, Date acquisitionDate, Date targetDate, double useDay, int useHour) throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayRequestRegistBeanInterface regist = this.time().holidayRequestRegist();
        HolidayRequestDtoInterface dto = this.timeReference().holidayRequest().findForKey(vo.getRecordId());
        if (dto == null) {
            dto = regist.getInitDto();
        }
        if (useHour > 0 && !startTime.equals(this.getEditStartTime())) {
            dto = regist.getInitDto();
        }
        if (targetDate != null && targetDate.compareTo(DateUtility.getDate((Date)this.getEditStartDate())) != 0) {
            dto = regist.getInitDto();
        }
        this.setDtoFields(dto, startDate, endDate, startTime, endTime, acquisitionDate, useDay, useHour);
        if (useHour > 0 && !startTime.equals(this.getEditStartTime())) {
            dto.setTmdHolidayRequestId(0L);
        }
        if (targetDate != null && targetDate.compareTo(DateUtility.getDate((Date)this.getEditStartDate())) != 0) {
            dto.setTmdHolidayRequestId(0L);
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.appli(dto);
    }

    protected void withdrawn() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayRequestRegistBeanInterface regist = this.time().holidayRequestRegist();
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        WorkflowCommentRegistBeanInterface workflowCommentRegist = this.platform().workflowCommentRegist();
        HolidayRequestDtoInterface dto = this.timeReference().holidayRequest().findForKey(vo.getRecordId());
        this.checkSelectedDataExist((Object)dto);
        regist.checkWithdrawn(dto);
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        this.checkSelectedDataExist((Object)workflowDto);
        boolean isDraft = "0".equals(workflowDto.getWorkflowStatus());
        if (isDraft) {
            workflowRegist.delete(workflowDto);
            workflowCommentRegist.deleteList(this.reference().workflowComment().getWorkflowCommentList(workflowDto.getWorkflow()));
            regist.delete(dto);
        } else if ((workflowDto = workflowRegist.withdrawn(workflowDto)) != null) {
            workflowCommentRegist.addComment(workflowDto, this.mospParams.getUser().getPersonalId(), this.mospParams.getProperties().getMessage("PFI0001", new String[]{this.mospParams.getName("TakeDown")}));
        }
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        if (isDraft) {
            this.addDeleteMessage();
        } else {
            this.addTakeDownMessage();
        }
        String searchYear = vo.getPltEditStartYear();
        String searchMonth = vo.getPltEditStartMonth();
        this.insertMode();
        vo.setPltSearchYear(searchYear);
        vo.setPltSearchMonth(searchMonth);
        this.setSearchPulldown();
        this.search();
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void batchWithdrawn() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        this.time().holidayRequestRegist().withdrawn(this.getIdArray(vo.getCkbSelect()));
        if (this.mospParams.hasErrorMessage()) {
            this.addBatchUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addTakeDownMessage();
        String searchYear = vo.getPltSearchYear();
        String searchMonth = vo.getPltSearchMonth();
        this.insertMode();
        this.setSearchRequestDate(searchYear, searchMonth);
        this.search();
    }

    protected void setPulldown() throws MospException {
        PaidHolidayDtoInterface paidHolidayDto;
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        Date date = this.getEditStartDate();
        int editRequestYear = DateUtility.getYear((Date)date);
        vo.setAryPltEditStartYear(this.getYearArray(editRequestYear));
        vo.setAryPltEditStartMonth(this.getMonthArray());
        vo.setAryPltEditStartDay(this.getDayArray());
        vo.setAryPltEditEndYear(this.getYearArray(editRequestYear));
        vo.setAryPltEditEndMonth(this.getMonthArray());
        vo.setAryPltEditEndDay(this.getDayArray());
        vo.setAryPltEditHolidayType1(this.mospParams.getProperties().getCodeArray("HolidayType", false));
        vo.setAryPltEditHolidayType2WithPay(this.mospParams.getProperties().getCodeArray("HolidayType2WithPay", false));
        vo.setAryPltEditStartHour(this.getHourArray());
        String[][] aryRange = MospUtility.getCodeArray((MospParams)this.mospParams, (String)"HolidayType3Range2", (boolean)false);
        String[][] aryHourlyRange = MospUtility.getCodeArray((MospParams)this.mospParams, (String)"HolidayType3Range1", (boolean)false);
        vo.setAryPltEditHolidayRangePaidHoliday(aryRange);
        vo.setAryPltEditHolidayRange(aryRange);
        ApplicationEntity entity = this.timeReference().master().getApplicationEntity(personalId, date);
        TimeSettingDtoInterface timeSettingDto = entity.getTimeSettingDto();
        if (timeSettingDto != null) {
            vo.setAryPltEditStartHour(this.getHourArray(DateUtility.getHour((Date)timeSettingDto.getStartDayTime()) + 23, true));
            vo.setAryPltEditEndTime(this.getHourArray(DateUtility.getHour((Date)timeSettingDto.getGeneralWorkTime()), false));
        }
        if ((paidHolidayDto = entity.getPaidHolidayDto()) != null) {
            vo.setAryPltEditStartMinute(this.getMinuteArray(paidHolidayDto.getAppliTimeInterval()));
            if (PlatformUtility.isActivate((int)paidHolidayDto.getTimelyPaidHolidayFlag())) {
                vo.setAryPltEditHolidayRangePaidHoliday(aryHourlyRange);
            }
        }
        if (this.timeReference().holiday().isTimelyHoliday(date)) {
            vo.setAryPltEditHolidayRange(aryHourlyRange);
        }
        vo.setAryPltSearchYear(this.getYearArray(editRequestYear));
        vo.setAryPltSearchMonth(this.getMonthArray(true));
    }

    protected void setEditActivationDate() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayRequestRegistBeanInterface regist = this.time().holidayRequestRegist();
        this.setPulldown();
        if (vo.getModeActivateDate().equals("chaning")) {
            if (this.chkActivationDateValidate()) {
                return;
            }
            if (!this.setApproverPullDown(vo.getPersonalId(), this.getEditStartDate(), 1)) {
                return;
            }
            HolidayRequestDtoInterface dto = this.timeReference().holidayRequest().findForKey(vo.getRecordId());
            if (dto == null) {
                dto = regist.getInitDto();
            }
            dto.setPersonalId(vo.getPersonalId());
            dto.setRequestStartDate(this.getEditStartDate());
            dto.setRequestEndDate(this.getEditEndDate());
            regist.checkSetRequestDate(dto);
            if (this.mospParams.hasErrorMessage()) {
                this.addFixFailedMessage();
                return;
            }
            if (!this.getEditStartDate().equals(this.getEditEndDate())) {
                vo.setPltEditHolidayRange(String.valueOf(1));
                vo.setPltEditHolidayRangePaidHoliday(String.valueOf(1));
            }
            this.setHolidayContinue();
            vo.setModeActivateDate("fixed");
        } else {
            String[] aryPltLblApproverSetting = new String[]{};
            vo.setAryPltLblApproverSetting(aryPltLblApproverSetting);
            vo.setModeActivateDate("chaning");
        }
        this.setEditPulldown();
    }

    protected void setEditPulldown() throws MospException {
        String[][] holidayArray;
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayReferenceBeanInterface holidayReference = this.timeReference().holiday();
        HolidayInfoReferenceBeanInterface holidayInfoReference = this.timeReference().holidayInfo();
        if (!vo.getModeActivateDate().equals("fixed")) {
            return;
        }
        Date startDate = this.getEditStartDate();
        boolean paidLeave = this.isPaidLeaveHoliday(vo.getPersonalId(), startDate);
        boolean stockLeave = this.isStockLeaveHoliday(vo.getPersonalId(), startDate);
        List specialList = holidayInfoReference.getHolidayPossibleRequestListForRequest(vo.getPersonalId(), this.getEditStartDate(), 2);
        HashSet<String> specialSet = new HashSet<String>();
        for (HolidayDataDtoInterface holidayDataDto : specialList) {
            specialSet.add(holidayDataDto.getHolidayCode());
        }
        List otherList = holidayInfoReference.getHolidayPossibleRequestListForRequest(vo.getPersonalId(), this.getEditStartDate(), 3);
        HashSet<String> otherSet = new HashSet<String>();
        for (HolidayDataDtoInterface holidayDataDto : otherList) {
            otherSet.add(holidayDataDto.getHolidayCode());
        }
        String[][] paidArray = this.getAryPltEditHolidayType2Paid(paidLeave, stockLeave);
        String[][] specialArray = holidayReference.getSelectArray(startDate, 2, false, specialSet);
        String[][] otherArray = holidayReference.getSelectArray(startDate, 3, false, otherSet);
        String[][] absenceArray = holidayReference.getSelectArray(this.getEditStartDate(), 4, false);
        String noObjectData = this.mospParams.getName("NoObjectData");
        boolean paidStockDeleteFlag = !paidLeave && !stockLeave;
        boolean specialDeleteFlag = noObjectData.equals(specialArray[0][1]);
        boolean otherDeleteFlag = noObjectData.equals(otherArray[0][1]);
        boolean absenceDeleteFlag = noObjectData.equals(absenceArray[0][1]);
        String[][] newHolidayArray = holidayArray = this.mospParams.getProperties().getCodeArray("HolidayType", false);
        int minus = 0;
        if (paidStockDeleteFlag) {
            ++minus;
        }
        if (specialDeleteFlag) {
            ++minus;
        }
        if (otherDeleteFlag) {
            ++minus;
        }
        if (absenceDeleteFlag) {
            ++minus;
        }
        if (minus > 0) {
            newHolidayArray = new String[holidayArray.length - minus][2];
            int i = 0;
            for (String[] holiday : holidayArray) {
                if (paidStockDeleteFlag && Integer.toString(1).equals(holiday[0]) || specialDeleteFlag && Integer.toString(2).equals(holiday[0]) || otherDeleteFlag && Integer.toString(3).equals(holiday[0]) || absenceDeleteFlag && Integer.toString(4).equals(holiday[0])) continue;
                newHolidayArray[i][0] = holiday[0];
                newHolidayArray[i][1] = holiday[1];
                ++i;
            }
        }
        if (newHolidayArray.length == 0) {
            vo.setModeActivateDate("chaning");
            this.addFixFailedMessage();
            this.mospParams.addErrorMessage("PFW0220", new String[]{this.mospParams.getName("Vacation")});
            return;
        }
        vo.setAryPltEditHolidayType1(newHolidayArray);
        vo.setAryPltEditHolidayType2WithPay(paidArray);
        vo.setAryPltEditHolidayType2Special(specialArray);
        vo.setAryPltEditHolidayType2Other(otherArray);
        vo.setAryPltEditHolidayType2Absence(absenceArray);
        Date endDate = this.getEditEndDate();
        if (startDate.compareTo(endDate) == 0) {
            this.getDifferenceRequest1(vo.getPersonalId(), startDate);
        }
    }

    protected void setSearchActivationDate() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        if (vo.getJsSearchModeActivateDate().equals("chaning")) {
            vo.setJsSearchModeActivateDate("fixed");
        } else {
            vo.setJsSearchModeActivateDate("chaning");
        }
        this.setSearchPulldown();
    }

    protected void setHolidayContinue() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayRequestRegistBeanInterface regist = this.time().holidayRequestRegist();
        vo.setJsHolidayTerm(Integer.toString(1));
        vo.setJsHolidayContinue(Integer.toString(2));
        vo.setJsHolidayRemainDay("");
        if (1 == this.getInt(vo.getPltEditHolidayType1()) || 4 == this.getInt(vo.getPltEditHolidayType1())) {
            return;
        }
        Date startDate = this.getEditStartDate();
        Date endDate = this.getEditEndDate();
        int count = 0;
        List dateList = TimeUtility.getDateList((Date)startDate, (Date)endDate);
        for (Date targetDate : dateList) {
            String workTypeCode = regist.getScheduledWorkTypeCode(vo.getPersonalId(), targetDate);
            regist.checkWorkType(startDate, endDate, targetDate, workTypeCode);
            if (this.mospParams.hasErrorMessage()) {
                this.addInsertFailedMessage();
                return;
            }
            if (TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) continue;
            ++count;
        }
        vo.setJsHolidayTerm(Integer.toString(count));
        String holidayCode = "";
        HolidayDataDtoInterface holidayDataDto = null;
        if (2 == this.getInt(vo.getPltEditHolidayType1())) {
            holidayCode = vo.getPltEditStatusSpecial();
            holidayDataDto = this.timeReference().holidayInfo().getHolidayPossibleRequestForRequest(vo.getPersonalId(), this.getEditStartDate(), vo.getPltEditStatusSpecial(), Integer.parseInt(vo.getPltEditHolidayType1()));
        } else if (3 == this.getInt(vo.getPltEditHolidayType1())) {
            holidayCode = vo.getPltEditSpecialOther();
            holidayDataDto = this.timeReference().holidayInfo().getHolidayPossibleRequestForRequest(vo.getPersonalId(), this.getEditStartDate(), vo.getPltEditSpecialOther(), Integer.parseInt(vo.getPltEditHolidayType1()));
        }
        if (holidayDataDto == null || holidayDataDto.getInactivateFlag() == 1 || holidayDataDto.getGivingDay() - holidayDataDto.getCancelDay() <= 0.0) {
            vo.setJsHolidayRemainDay("0");
            return;
        }
        HolidayDtoInterface holidayDto = this.timeReference().holiday().getHolidayInfo(holidayCode, this.getEditStartDate(), Integer.parseInt(vo.getPltEditHolidayType1()));
        if (holidayDto == null || holidayDto.getInactivateFlag() == 1) {
            vo.setJsHolidayRemainDay("0");
            return;
        }
        vo.setJsHolidayContinue(Integer.toString(holidayDto.getContinuousAcquisition()));
        vo.setJsHolidayRemainDay(Double.toString(holidayDataDto.getGivingDay() - holidayDataDto.getCancelDay()));
    }

    protected void selectActivationDate() throws MospException {
        String transferredHolidayRange;
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        this.select();
        String transferredHolidayType1 = this.getTransferredHolidayType1();
        if (transferredHolidayType1 != null) {
            vo.setPltEditHolidayType1(transferredHolidayType1);
        }
        boolean isPaid = 1 == this.getInt(vo.getPltEditHolidayType1());
        boolean isSpecial = 2 == this.getInt(vo.getPltEditHolidayType1());
        boolean isOther = 3 == this.getInt(vo.getPltEditHolidayType1());
        boolean isAbsence = 4 == this.getInt(vo.getPltEditHolidayType1());
        String transferredHolidayType2 = this.getTransferredHolidayType2();
        if (transferredHolidayType2 != null) {
            if (isPaid) {
                vo.setPltEditStatusWithPay(transferredHolidayType2);
            } else if (isSpecial) {
                vo.setPltEditStatusSpecial(transferredHolidayType2);
            } else if (isOther) {
                vo.setPltEditSpecialOther(transferredHolidayType2);
            } else if (isAbsence) {
                vo.setPltEditSpecialAbsence(transferredHolidayType2);
            }
        }
        if ((transferredHolidayRange = this.getTransferredHolidayRange()) != null) {
            if (isPaid) {
                vo.setPltEditHolidayRangePaidHoliday(transferredHolidayRange);
            } else if (isSpecial || isOther || isAbsence) {
                vo.setPltEditHolidayRange(transferredHolidayRange);
            }
        }
        this.setEditActivationDate();
    }

    protected void setSearchPulldown() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayReferenceBeanInterface holidayRefer = this.timeReference().holiday();
        ApplicationReferenceBeanInterface appRefer = this.timeReference().application();
        PaidHolidayReferenceBeanInterface paidHolidayRefer = this.timeReference().paidHoliday();
        if (vo.getJsSearchModeActivateDate().equals("fixed")) {
            ApplicationDtoInterface applicationDto;
            Date date = vo.getPltSearchMonth().isEmpty() ? MonthUtility.getYearMonthTargetDate((int)this.getInt(vo.getPltSearchYear()), (int)1, (MospParams)this.mospParams) : MonthUtility.getYearMonthTargetDate((int)this.getInt(vo.getPltSearchYear()), (int)this.getInt(vo.getPltSearchMonth()), (MospParams)this.mospParams);
            vo.setAryPltSearchHolidayType2Special(holidayRefer.getSelectArray(date, 2, true));
            vo.setAryPltSearchHolidayType2Other(holidayRefer.getSelectArray(date, 3, true));
            vo.setAryPltSearchHolidayType2Absence(holidayRefer.getSelectArray(date, 4, true));
            vo.setAryPltSearchHolidayRangePaidHoliday(this.mospParams.getProperties().getCodeArray("HolidayType3Range2", true));
            if (holidayRefer.isTimelyHoliday(date)) {
                vo.setAryPltSearchHolidayRangePaidHoliday(this.mospParams.getProperties().getCodeArray("HolidayType3Range1", true));
            }
            if ((applicationDto = appRefer.findForPerson(vo.getPersonalId(), date)) == null) {
                return;
            }
            PaidHolidayDtoInterface paidHolidayDto = paidHolidayRefer.getPaidHolidayInfo(applicationDto.getPaidHolidayCode(), date);
            if (paidHolidayDto == null) {
                return;
            }
            if (paidHolidayDto.getTimelyPaidHolidayFlag() == 0) {
                vo.setAryPltSearchHolidayRangePaidHoliday(this.mospParams.getProperties().getCodeArray("HolidayType3Range1", true));
            }
        }
    }

    protected void insertMode() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        this.setDefaultValues();
        this.setPulldown();
        vo.setModeCardEdit("new");
        vo.setModeActivateDate("chaning");
        vo.setJsSearchModeActivateDate("fixed");
        vo.setComparatorName(HolidayRequestRequestDateComparator.class.getName());
        vo.setJsModeDifferenceRequest1("");
        this.setEditPulldown();
        this.setSearchPulldown();
        this.timeReference().holidayRequest().chkBasicInfo(vo.getPersonalId(), this.getEditStartDate());
    }

    protected void editMode() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getSystemDate();
        if (personalId != null) {
            this.setEmployeeInfo(personalId, targetDate);
            this.setPageInfo(CMD_PAGE, this.getListLength());
            this.insertMode();
            this.search();
        }
        this.setEditUpdateMode(this.getDate(this.getTransferredActivateDate()), this.getTransferredHolidayType1(), this.getTransferredHolidayType2(), this.getTransferredHolidayRange(), this.getTransferredStartTime());
        vo.setModeActivateDate("chaning");
        this.setEditActivationDate();
    }

    protected void setEditUpdateMode(Date requestStartDate, String holidayType1, String holidayType2, String holidayRange, String paidTime) throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayRequestDtoInterface dto = null;
        if (this.getInt(holidayRange) == 4) {
            String[] startTime = MospUtility.split((String)paidTime, (String)this.mospParams.getName("SingleColon"));
            Date startDateTime = DateUtility.addMinute((Date)DateUtility.addHour((Date)requestStartDate, (int)Integer.parseInt(startTime[0])), (int)Integer.parseInt(startTime[1]));
            dto = this.timeReference().holidayRequest().findForKeyOnWorkflow(vo.getPersonalId(), requestStartDate, Integer.parseInt(holidayType1), holidayType2, Integer.parseInt(holidayRange), startDateTime);
        } else {
            dto = this.timeReference().holidayRequest().findForKeyOnWorkflow(vo.getPersonalId(), requestStartDate, Integer.parseInt(holidayType1), holidayType2, Integer.parseInt(holidayRange), requestStartDate);
        }
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        vo.setModeActivateDate("fixed");
    }

    protected void batchUpdate() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayRequestRegistBeanInterface regist = this.time().holidayRequestRegist();
        boolean containsHalfHoliday = false;
        long[] idArray = this.getIdArray(vo.getCkbSelect());
        if (idArray == null || idArray.length == 0) {
            this.addBatchUpdateFailedMessage();
            this.mospParams.addErrorMessage("PFW0103", new String[0]);
            return;
        }
        for (long id : idArray) {
            boolean isHalf;
            HolidayRequestDtoInterface dto = this.timeReference().holidayRequest().findForKey(id);
            if (dto == null || dto.getDeleteFlag() == 1) {
                this.addBatchUpdateFailedMessage();
                this.mospParams.addErrorMessage("PFW0206", new String[0]);
                return;
            }
            int count = 0;
            List dateList = TimeUtility.getDateList((Date)dto.getRequestStartDate(), (Date)dto.getRequestEndDate());
            for (Date date : dateList) {
                String workTypeCode = regist.getScheduledWorkTypeCode(dto.getPersonalId(), date);
                regist.checkWorkType(dto, date, workTypeCode);
                if (this.mospParams.hasErrorMessage()) {
                    this.addBatchUpdateFailedMessage();
                    return;
                }
                if (TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) continue;
                ++count;
            }
            boolean isSpecial = dto.getHolidayType1() == 2;
            boolean isOther = dto.getHolidayType1() == 3;
            boolean isAbsence = dto.getHolidayType1() == 4;
            boolean bl = isHalf = dto.getHolidayRange() == 2 || dto.getHolidayRange() == 3;
            if (isHalf) {
                containsHalfHoliday = true;
            }
            if (dto.getHolidayType1() == 1) {
                Date acquisitionDate;
                if (Integer.toString(1).equals(dto.getHolidayType2())) {
                    boolean isAll = dto.getHolidayRange() == 1;
                    List list = this.timeReference().paidHolidayInfo().getPaidHolidayPossibleRequestForRequestList(dto.getPersonalId(), dto.getRequestStartDate());
                    acquisitionDate = null;
                    if (isAll || isHalf) {
                        double days = count;
                        if (isHalf) {
                            days = (float)count * 0.5f;
                        }
                        if (Double.compare(dto.getUseDay(), days) != 0) {
                            this.addBatchUpdateFailedMessage();
                            this.addHolidayNumUnitExcessErrorMessage(this.mospParams.getName("Day"));
                            return;
                        }
                        if (isAll && list.size() >= 2) {
                            boolean isHalfPaidLeave = false;
                            for (PaidHolidayDataDtoInterface paidHolidayDataDto : list) {
                                double holdDay = paidHolidayDataDto.getHoldDay();
                                if (holdDay >= days && isHalfPaidLeave) {
                                    this.addBatchUpdateFailedMessage();
                                    this.addPaidLeaveForPreviousFiscalYearErrorMessage();
                                    return;
                                }
                                isHalfPaidLeave = holdDay == 0.5 ? true : isHalfPaidLeave;
                            }
                        }
                        for (PaidHolidayDataDtoInterface paidHolidayDataDto : list) {
                            if (!(paidHolidayDataDto.getHoldDay() >= days)) continue;
                            acquisitionDate = paidHolidayDataDto.getAcquisitionDate();
                            break;
                        }
                        if (acquisitionDate == null) {
                            this.addBatchUpdateFailedMessage();
                            this.addHolidayNumUnitExcessErrorMessage(this.mospParams.getName("Day"));
                            return;
                        }
                    } else if (dto.getHolidayRange() == 4) {
                        if (Double.compare(dto.getUseDay(), 0.0) != 0) {
                            this.addBatchUpdateFailedMessage();
                            this.addHolidayNumUnitExcessErrorMessage(this.mospParams.getName("Day"));
                            return;
                        }
                        for (PaidHolidayDataDtoInterface paidHolidayDataDto : list) {
                            if (paidHolidayDataDto.getHoldHour() >= 1) {
                                acquisitionDate = paidHolidayDataDto.getAcquisitionDate();
                                break;
                            }
                            if (!(paidHolidayDataDto.getHoldDay() >= 1.0)) continue;
                            acquisitionDate = paidHolidayDataDto.getAcquisitionDate();
                            break;
                        }
                        if (acquisitionDate == null) {
                            this.addBatchUpdateFailedMessage();
                            this.addHolidayNumUnitExcessErrorMessage(this.mospParams.getName("Time"));
                            return;
                        }
                    } else {
                        this.addBatchUpdateFailedMessage();
                        this.mospParams.addErrorMessage("TMW0305", new String[0]);
                        return;
                    }
                    this.setDtoFields(dto, acquisitionDate);
                    this.appli(dto);
                    if (!this.mospParams.hasErrorMessage()) continue;
                    this.addBatchUpdateFailedMessage();
                    return;
                }
                if (!Integer.toString(2).equals(dto.getHolidayType2())) continue;
                double days = count;
                if (isHalf) {
                    days = (float)count * 0.5f;
                }
                if (Double.compare(dto.getUseDay(), days) != 0) {
                    this.addBatchUpdateFailedMessage();
                    this.addHolidayNumUnitExcessErrorMessage(this.mospParams.getName("Day"));
                    return;
                }
                acquisitionDate = null;
                List list = this.timeReference().stockHolidayInfo().getStockHolidayPossibleRequestForRequest(dto.getPersonalId(), dto.getRequestStartDate());
                for (StockHolidayDataDtoInterface stockHolidayDataDto : list) {
                    if (!(stockHolidayDataDto.getHoldDay() + stockHolidayDataDto.getGivingDay() - stockHolidayDataDto.getCancelDay() - stockHolidayDataDto.getUseDay() >= days)) continue;
                    acquisitionDate = stockHolidayDataDto.getAcquisitionDate();
                    break;
                }
                if (acquisitionDate == null) {
                    this.addBatchUpdateFailedMessage();
                    this.addHolidayNumDaysExcessErrorMessage(this.mospParams.getName("Stock", new String[]{"Vacation"}));
                    return;
                }
                this.setDtoFields(dto, acquisitionDate);
                this.appli(dto);
                if (!this.mospParams.hasErrorMessage()) continue;
                this.addBatchUpdateFailedMessage();
                return;
            }
            if (isSpecial || isOther || isAbsence) {
                HolidayDtoInterface holidayDto;
                double days = count;
                if (isHalf) {
                    days = (float)count * 0.5f;
                }
                if ((holidayDto = this.timeReference().holiday().getHolidayInfo(dto.getHolidayType2(), dto.getRequestStartDate(), dto.getHolidayType1())) == null || holidayDto.getInactivateFlag() == 1) {
                    this.addBatchUpdateFailedMessage();
                    this.mospParams.addErrorMessage("PFW0201", new String[]{this.mospParams.getName("Vacation", new String[]{"Classification"})});
                    return;
                }
                Date acquisitionDate = dto.getRequestStartDate();
                double useDay = days;
                if (isSpecial || isOther) {
                    HolidayDataDtoInterface holidayDataDto = null;
                    holidayDataDto = this.timeReference().holidayInfo().getHolidayPossibleRequestForRequest(dto.getPersonalId(), dto.getRequestStartDate(), dto.getHolidayType2(), dto.getHolidayType1());
                    if (holidayDataDto == null) {
                        this.addBatchUpdateFailedMessage();
                        this.addHolidayNotGiveErrorMessage(holidayDto.getHolidayName());
                        return;
                    }
                    acquisitionDate = holidayDataDto.getActivateDate();
                    if (dto.getHolidayRange() == 4) {
                        if (Double.compare(dto.getUseDay(), 0.0) != 0) {
                            this.addBatchUpdateFailedMessage();
                            this.addHolidayNumUnitExcessErrorMessage(this.mospParams.getName("Day"));
                            return;
                        }
                        if (holidayDataDto.getGivingHour() >= 1) {
                            acquisitionDate = holidayDataDto.getActivateDate();
                        } else if (holidayDataDto.getGivingDay() >= 1.0) {
                            acquisitionDate = holidayDataDto.getActivateDate();
                        }
                        if (acquisitionDate == null) {
                            this.addBatchUpdateFailedMessage();
                            this.addHolidayNumUnitExcessErrorMessage(this.mospParams.getName("Time"));
                            return;
                        }
                    } else {
                        useDay = this.getHolidayDays(days, holidayDto, holidayDataDto);
                        if (this.mospParams.hasErrorMessage()) {
                            this.addBatchUpdateFailedMessage();
                            return;
                        }
                        if (Double.compare(dto.getUseDay(), useDay) != 0) {
                            this.addBatchUpdateFailedMessage();
                            this.addHolidayNumUnitExcessErrorMessage(this.mospParams.getName("Day"));
                            return;
                        }
                    }
                }
                this.setDtoFields(dto, acquisitionDate);
                this.appli(dto);
                if (!this.mospParams.hasErrorMessage()) continue;
                this.addBatchUpdateFailedMessage();
                return;
            }
            this.addBatchUpdateFailedMessage();
            return;
        }
        if (this.mospParams.hasErrorMessage()) {
            this.addBatchUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        if (containsHalfHoliday) {
            this.addHalfHolidayRequestMessage();
        }
        String searchYear = vo.getPltSearchYear();
        String searchMonth = vo.getPltSearchMonth();
        this.insertMode();
        vo.setPltSearchYear(searchYear);
        vo.setPltSearchMonth(searchMonth);
        this.setSearchPulldown();
        this.search();
    }

    protected void transfer() {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        this.setTargetWorkflow(vo.getAryWorkflow(this.getTransferredIndex()));
        this.mospParams.setNextCommand("TM1831");
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        String[] aryCkbRecordId = new String[list.size()];
        String[] aryLblRequestDate = new String[list.size()];
        String[] aryLblHolidayType1 = new String[list.size()];
        String[] aryLblHolidayType2 = new String[list.size()];
        String[] aryLblHolidayRange = new String[list.size()];
        String[] aryLblRequestReason = new String[list.size()];
        String[] aryLblWorkflowStatus = new String[list.size()];
        String[] aryLblApproverName = new String[list.size()];
        String[] aryLblWorkflow = new String[list.size()];
        String[] aryStatusStyle = new String[list.size()];
        String[] aryHolidayType1 = new String[list.size()];
        String[] aryHolidayType2 = new String[list.size()];
        String[] aryHolidayRange = new String[list.size()];
        String[] aryStartTime = new String[list.size()];
        String[] aryLblOnOff = new String[list.size()];
        String[] aryWorkflowStatus = new String[list.size()];
        long[] aryWorkflow = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            HolidayRequestListDtoInterface dto = (HolidayRequestListDtoInterface)list.get(i);
            aryCkbRecordId[i] = String.valueOf(dto.getTmdHolidayRequestId());
            aryLblRequestDate[i] = DateUtility.getStringDateAndDay((Date)dto.getRequestStartDate()) + this.mospParams.getName("Wave") + DateUtility.getStringDateAndDay((Date)dto.getRequestEndDate());
            aryLblHolidayType1[i] = this.timeReference().holiday().getHolidayType1NameForHolidayRequest(dto.getHolidayType1(), dto.getHolidayType2());
            aryLblHolidayType2[i] = this.getHolidayType2Abbr(dto.getHolidayType1(), dto.getHolidayType2(), dto.getRequestStartDate());
            aryLblHolidayRange[i] = this.getHolidayRange(dto);
            aryHolidayType1[i] = String.valueOf(dto.getHolidayType1());
            aryHolidayType2[i] = dto.getHolidayType2();
            aryHolidayRange[i] = String.valueOf(dto.getHolidayRange());
            aryStartTime[i] = DateUtility.getStringTime((Date)dto.getStartTime(), (Date)dto.getRequestStartDate());
            aryLblRequestReason[i] = dto.getRequestReason();
            aryLblWorkflowStatus[i] = this.getStatusStageValueView(dto.getState(), dto.getStage());
            aryStatusStyle[i] = this.getStatusColor(dto.getState());
            aryLblApproverName[i] = dto.getApproverName();
            aryLblWorkflow[i] = String.valueOf(dto.getWorkflow());
            aryLblOnOff[i] = this.getButtonOnOff(dto.getState(), dto.getStage());
            aryWorkflowStatus[i] = dto.getState();
            aryWorkflow[i] = dto.getWorkflow();
        }
        vo.setAryCkbHolidayRequestListId(aryCkbRecordId);
        vo.setAryLblDate(aryLblRequestDate);
        vo.setAryLblHolidayType1(aryLblHolidayType1);
        vo.setAryLblHolidayType2(aryLblHolidayType2);
        vo.setAryLblHolidayType3(aryLblHolidayRange);
        vo.setAryLblRequestReason(aryLblRequestReason);
        vo.setAryLblState(aryLblWorkflowStatus);
        vo.setAryStateStyle(aryStatusStyle);
        vo.setAryLblApprover(aryLblApproverName);
        vo.setAryLblWorkflow(aryLblWorkflow);
        vo.setAryHolidayType1(aryHolidayType1);
        vo.setAryHolidayType2(aryHolidayType2);
        vo.setAryHolidayType3(aryHolidayRange);
        vo.setAryStartTime(aryStartTime);
        vo.setAryLblOnOff(aryLblOnOff);
        vo.setAryWorkflowStatus(aryWorkflowStatus);
        vo.setAryWorkflow(aryWorkflow);
    }

    protected String getHolidayRange(HolidayRequestListDtoInterface dto) {
        int holidayRange = dto.getHolidayRange();
        if (holidayRange == 1) {
            return this.mospParams.getName("AllTime");
        }
        if (holidayRange == 2) {
            return this.mospParams.getName("FrontTime");
        }
        if (holidayRange == 3) {
            return this.mospParams.getName("BackTime");
        }
        if (holidayRange == 4) {
            return this.getTimeWaveFormat(dto.getStartTime(), dto.getEndTime(), dto.getRequestStartDate());
        }
        return "";
    }

    protected Date getEditStartDate() {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        return this.getDate(vo.getPltEditStartYear(), vo.getPltEditStartMonth(), vo.getPltEditStartDay());
    }

    protected Date getEditEndDate() {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        return this.getDate(vo.getPltEditEndYear(), vo.getPltEditEndMonth(), vo.getPltEditEndDay());
    }

    protected Date getEditStartTime() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        return DateUtility.addMinute((Date)DateUtility.addHour((Date)this.getEditStartDate(), (int)Integer.parseInt(vo.getPltEditStartHour())), (int)Integer.parseInt(vo.getPltEditStartMinute()));
    }

    protected void setDtoFields(HolidayRequestDtoInterface dto, Date startDate, Date endDate, Date startTime, Date endTime, Date acquisitionDate, double useDay, int useHour) throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        dto.setTmdHolidayRequestId(vo.getRecordId());
        dto.setPersonalId(vo.getPersonalId());
        dto.setRequestStartDate(startDate);
        dto.setRequestEndDate(endDate);
        dto.setHolidayType1(Integer.parseInt(vo.getPltEditHolidayType1()));
        if (vo.getPltEditHolidayType1().equals(String.valueOf(1))) {
            dto.setHolidayType2(vo.getPltEditStatusWithPay());
        } else if (vo.getPltEditHolidayType1().equals(String.valueOf(2))) {
            dto.setHolidayType2(vo.getPltEditStatusSpecial());
        } else if (vo.getPltEditHolidayType1().equals(String.valueOf(3))) {
            dto.setHolidayType2(vo.getPltEditSpecialOther());
        } else {
            dto.setHolidayType2(vo.getPltEditSpecialAbsence());
        }
        if (1 == this.getInt(vo.getPltEditHolidayType1()) && 1 == this.getInt(vo.getPltEditStatusWithPay())) {
            dto.setHolidayRange(Integer.parseInt(vo.getPltEditHolidayRangePaidHoliday()));
        } else {
            dto.setHolidayRange(Integer.parseInt(vo.getPltEditHolidayRange()));
        }
        dto.setStartTime(startTime);
        dto.setEndTime(endTime);
        dto.setHolidayAcquisitionDate(acquisitionDate);
        dto.setUseDay(useDay);
        dto.setUseHour(useHour);
        dto.setRequestReason(vo.getTxtEditRequestReason());
    }

    protected void setDtoFields(HolidayRequestDtoInterface dto, Date acquisitionDate) {
        dto.setHolidayAcquisitionDate(acquisitionDate);
    }

    protected void setVoFields(HolidayRequestDtoInterface dto) throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        vo.setRecordId(dto.getTmdHolidayRequestId());
        vo.setPltEditStartYear(DateUtility.getStringYear((Date)dto.getRequestStartDate()));
        vo.setPltEditStartMonth(DateUtility.getStringMonthM((Date)dto.getRequestStartDate()));
        vo.setPltEditStartDay(DateUtility.getStringDayD((Date)dto.getRequestStartDate()));
        vo.setPltEditEndYear(DateUtility.getStringYear((Date)dto.getRequestEndDate()));
        vo.setPltEditEndMonth(DateUtility.getStringMonthM((Date)dto.getRequestEndDate()));
        vo.setPltEditEndDay(DateUtility.getStringDayD((Date)dto.getRequestEndDate()));
        vo.setPltEditHolidayType1(String.valueOf(dto.getHolidayType1()));
        if (dto.getHolidayType1() == 1) {
            vo.setPltEditStatusWithPay(dto.getHolidayType2());
        } else if (dto.getHolidayType1() == 2) {
            vo.setPltEditStatusSpecial(dto.getHolidayType2());
        } else if (dto.getHolidayType1() == 3) {
            vo.setPltEditSpecialOther(dto.getHolidayType2());
        } else {
            vo.setPltEditSpecialAbsence(dto.getHolidayType2());
        }
        if (dto.getHolidayType1() == 1 && 1 == this.getInt(dto.getHolidayType2())) {
            vo.setPltEditHolidayRangePaidHoliday(String.valueOf(dto.getHolidayRange()));
        } else {
            vo.setPltEditHolidayRange(String.valueOf(dto.getHolidayRange()));
        }
        vo.setPltEditStartHour(String.valueOf(DateUtility.getHour((Date)dto.getStartTime(), (Date)dto.getRequestStartDate())));
        vo.setPltEditStartMinute(DateUtility.getStringMinuteM((Date)dto.getStartTime()));
        vo.setPltEditEndTime(String.valueOf(dto.getUseHour()));
        vo.setTxtEditRequestReason(dto.getRequestReason());
        vo.setModeCardEdit(this.getApplicationMode(dto.getWorkflow()));
    }

    protected boolean chkActivationDateValidate() throws MospException {
        if (this.getEditStartDate().after(this.getEditEndDate())) {
            this.mospParams.addErrorMessage("TMW0251", new String[0]);
            return true;
        }
        return false;
    }

    protected double getHolidayDays(HolidayDtoInterface holidayDto, HolidayDataDtoInterface holidayDataDto) throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        Date startDate = this.getEditStartDate();
        Date endDate = this.getEditEndDate();
        double count = this.getHolidayCount(startDate, endDate);
        double holidayDays = 0.0;
        if (1 == this.getInt(vo.getPltEditHolidayRange())) {
            holidayDays = count;
        } else if (2 == this.getInt(vo.getPltEditHolidayRange()) || 3 == this.getInt(vo.getPltEditHolidayRange())) {
            holidayDays = count * 0.5;
        } else {
            this.mospParams.addErrorMessage("TMW0305", new String[0]);
            return 0.0;
        }
        if (holidayDto.getContinuousAcquisition() == 0) {
            if (holidayDays <= holidayDataDto.getGivingDay() - holidayDataDto.getCancelDay()) {
                return holidayDataDto.getGivingDay() - holidayDataDto.getCancelDay();
            }
            this.addHolidayNumDaysExcessErrorMessage(holidayDto.getHolidayName());
            return 0.0;
        }
        if (holidayDto.getContinuousAcquisition() == 1) {
            if (holidayDays <= holidayDataDto.getGivingDay() - holidayDataDto.getCancelDay()) {
                return holidayDays;
            }
            this.addHolidayNumDaysExcessErrorMessage(holidayDto.getHolidayName());
            return 0.0;
        }
        if (holidayDto.getContinuousAcquisition() == 2) {
            if (holidayDto.getNoLimit() == 1) {
                return holidayDays;
            }
            if (holidayDays <= holidayDataDto.getGivingDay() - holidayDataDto.getCancelDay()) {
                return holidayDays;
            }
            this.addHolidayNumDaysExcessErrorMessage(holidayDto.getHolidayName());
            return 0.0;
        }
        return 0.0;
    }

    protected double getHolidayDays(double days, HolidayDtoInterface holidayDto, HolidayDataDtoInterface holidayDataDto) {
        if (holidayDto.getContinuousAcquisition() == 0) {
            if (days <= holidayDataDto.getGivingDay() - holidayDataDto.getCancelDay()) {
                return holidayDataDto.getGivingDay() - holidayDataDto.getCancelDay();
            }
            this.addHolidayNumDaysExcessErrorMessage(holidayDto.getHolidayName());
            return 0.0;
        }
        if (holidayDto.getContinuousAcquisition() == 1) {
            if (days <= holidayDataDto.getGivingDay() - holidayDataDto.getCancelDay()) {
                return days;
            }
            this.addHolidayNumDaysExcessErrorMessage(holidayDto.getHolidayName());
            return 0.0;
        }
        if (holidayDto.getContinuousAcquisition() == 2) {
            if (holidayDto.getNoLimit() == 1) {
                return days;
            }
            if (days <= holidayDataDto.getGivingDay() - holidayDataDto.getCancelDay()) {
                return days;
            }
            this.addHolidayNumDaysExcessErrorMessage(holidayDto.getHolidayName());
            return 0.0;
        }
        return 0.0;
    }

    protected boolean isPaidLeaveHoliday(String personalId, Date startDate) throws MospException {
        List paidList = this.timeReference().paidHolidayInfo().getPaidHolidayPossibleRequestForRequestList(personalId, startDate);
        for (PaidHolidayDataDtoInterface paidHolidayDataDto : paidList) {
            if (!(paidHolidayDataDto.getHoldDay() > 0.0) && paidHolidayDataDto.getHoldHour() <= 0) continue;
            return true;
        }
        return false;
    }

    protected boolean isStockLeaveHoliday(String personalId, Date startDate) throws MospException {
        List stockList = this.timeReference().stockHolidayInfo().getStockHolidayPossibleRequestForRequest(personalId, startDate);
        for (StockHolidayDataDtoInterface stockHolidayDataDto : stockList) {
            if (!(stockHolidayDataDto.getHoldDay() + stockHolidayDataDto.getGivingDay() - stockHolidayDataDto.getCancelDay() - stockHolidayDataDto.getUseDay() > 0.0)) continue;
            return true;
        }
        return false;
    }

    protected Date getStockHolidayAcquisitionDate(Date targetDate) throws MospException {
        block6: {
            List list;
            HolidayRequestVo vo;
            block5: {
                vo = (HolidayRequestVo)this.mospParams.getVo();
                if (!Integer.toString(1).equals(vo.getPltEditHolidayType1())) {
                    return null;
                }
                if (!Integer.toString(2).equals(vo.getPltEditStatusWithPay())) {
                    return null;
                }
                list = this.timeReference().stockHolidayInfo().getStockHolidayPossibleRequestForRequest(vo.getPersonalId(), targetDate);
                if (list == null || list.isEmpty()) {
                    return null;
                }
                if (!Integer.toString(1).equals(vo.getPltEditHolidayRange())) break block5;
                for (StockHolidayDataDtoInterface stockHolidayDataDto : list) {
                    if (!(stockHolidayDataDto.getHoldDay() + stockHolidayDataDto.getGivingDay() - stockHolidayDataDto.getCancelDay() - stockHolidayDataDto.getUseDay() >= 1.0)) continue;
                    return stockHolidayDataDto.getAcquisitionDate();
                }
                break block6;
            }
            if (!Integer.toString(2).equals(vo.getPltEditHolidayRange()) && !Integer.toString(3).equals(vo.getPltEditHolidayRange())) break block6;
            for (StockHolidayDataDtoInterface stockHolidayDataDto : list) {
                if (!(stockHolidayDataDto.getHoldDay() + stockHolidayDataDto.getGivingDay() - stockHolidayDataDto.getCancelDay() - stockHolidayDataDto.getUseDay() >= 0.5)) continue;
                return stockHolidayDataDto.getAcquisitionDate();
            }
        }
        return null;
    }

    protected String[][] getAryPltEditHolidayType2Paid(boolean paidLeave, boolean stockLeave) {
        String[][] array = this.mospParams.getProperties().getCodeArray("HolidayType2WithPay", false);
        int minus = 0;
        if (!paidLeave) {
            ++minus;
        }
        if (!stockLeave) {
            ++minus;
        }
        if (minus == 0) {
            return array;
        }
        String[][] paidArray = new String[array.length - minus][2];
        int i = 0;
        for (String[] holiday : array) {
            if (!paidLeave && Integer.toString(1).equals(holiday[0]) || !stockLeave && Integer.toString(2).equals(holiday[0])) continue;
            paidArray[i][0] = holiday[0];
            paidArray[i][1] = holiday[1];
            ++i;
        }
        return paidArray;
    }

    protected Date getAcquisitionDate(List<PaidHolidayDataDtoInterface> list, Float holdDay, Date targetDate) {
        for (PaidHolidayDataDtoInterface paidHolidayDataDto : list) {
            if (!(paidHolidayDataDto.getHoldDay() >= (double)holdDay.floatValue())) continue;
            return paidHolidayDataDto.getAcquisitionDate();
        }
        this.addHolidayNumUnitExcessErrorMessage(this.mospParams.getName("Day"));
        return null;
    }

    protected Double getHolidayCount(Date startDate, Date endDate) throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        Double count = 0.0;
        List dateList = TimeUtility.getDateList((Date)startDate, (Date)endDate);
        HolidayRequestRegistBeanInterface regist = this.time().holidayRequestRegist();
        for (Date targetDate : dateList) {
            String workTypeCode = regist.getScheduledWorkTypeCode(vo.getPersonalId(), targetDate);
            regist.checkWorkType(startDate, endDate, targetDate, workTypeCode);
            if (this.mospParams.hasErrorMessage()) {
                return 0.0;
            }
            if (TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) continue;
            Double d = count;
            Double d2 = count = Double.valueOf(count + 1.0);
        }
        return count;
    }

    protected void addHolidayNumUnitExcessErrorMessage(String unit) {
        this.mospParams.addErrorMessage("TMW0254", new String[]{this.mospParams.getName("Salaried", new String[]{"Vacation"}), unit});
    }

    protected void addHolidayNumDaysExcessErrorMessage(String name) {
        this.mospParams.addErrorMessage("TMW0254", new String[]{name, this.mospParams.getName("Day")});
    }

    protected void addHolidayNotGiveErrorMessage(String holidayName) {
        this.mospParams.addErrorMessage("TMW0259", new String[]{holidayName});
    }

    protected void addPaidLeaveForPreviousFiscalYearErrorMessage() {
        this.mospParams.addErrorMessage("TMW0317", new String[0]);
    }
}

