/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.input.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.AttendanceCorrectionReferenceBeanInterface;
import jp.mosp.time.bean.DifferenceRequestReferenceBeanInterface;
import jp.mosp.time.bean.TotalTimeCorrectionReferenceBeanInterface;
import jp.mosp.time.dto.settings.AttendanceCorrectionDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeCorrectionDtoInterface;
import jp.mosp.time.dto.settings.impl.AttendanceListDto;
import jp.mosp.time.input.vo.AttendanceHistoryVo;

public class AttendanceHistoryAction
extends TimeAction {
    public static final String CMD_SELECT_SHOW = "TM1911";
    public static final String CMD_RE_SHOW = "TM1912";
    public static final String CMD_TRANSFER = "TM1916";
    public static final String CMD_SELECT_SHOW_TOTAL = "TM1921";

    public AttendanceHistoryAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new AttendanceHistoryVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW_TOTAL)) {
            this.prepareVo(false, false);
            this.selectTotal();
        }
    }

    protected void select() throws MospException {
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getTargetDate();
        this.setEmployeeInfo(personalId, targetDate);
        this.search();
    }

    protected void selectTotal() throws MospException {
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getTargetDate();
        this.setEmployeeInfo(personalId, targetDate);
        this.getAttendanceTotal();
    }

    protected void search() throws MospException {
        this.setDefaultValues();
        this.getAttendanceInfo();
        this.getAttendanceHistory();
    }

    protected void setDefaultValues() {
        AttendanceHistoryVo vo = (AttendanceHistoryVo)this.mospParams.getVo();
        vo.setLblAttendanceDate("");
        vo.setAttendanceDate("");
        vo.setLblAttendanceWorkType("");
        vo.setLblAttendanceStartDate("");
        vo.setLblAttendanceEndDate("");
        vo.setLblAttendanceWorkTime("");
        vo.setLblAttendanceRestTime("");
        vo.setLblAttendancePrivateTime("");
        vo.setLblAttendanceLateTime("");
        vo.setLblAttendanceLeaveEarly("");
        vo.setLblAttendanceLateLeaveEarly("");
        vo.setLblAttendanceOverTimeIn("");
        vo.setLblAttendanceOverTimeOut("");
        vo.setLblAttendanceWorkOnHoliday("");
        vo.setLblAttendanceLateNight("");
        vo.setLblAttendanceState("");
        vo.setLblAttendanceCorrection("");
        vo.setWorkflow(0L);
        vo.setLblAttendanceRemark("");
    }

    protected void getAttendanceInfo() throws MospException {
        AttendanceHistoryVo vo = (AttendanceHistoryVo)this.mospParams.getVo();
        Date targetDate = vo.getTargetDate();
        String personalId = vo.getPersonalId();
        AttendanceListDto dto = this.timeReference().attendanceList().getAttendanceListDto(personalId, targetDate);
        if (dto == null) {
            this.addAttendanceNotExistErrorMessage();
            return;
        }
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        if (workflowDto == null) {
            this.addAttendanceNotExistErrorMessage();
            return;
        }
        vo.setLblAttendanceDate(DateUtility.getStringDateAndDay((Date)dto.getWorkDate()));
        vo.setAttendanceDate(DateUtility.getStringDate((Date)dto.getWorkDate()));
        vo.setLblAttendanceWorkType(dto.getWorkTypeAbbr());
        vo.setLblAttendanceStartDate(dto.getStartTimeString());
        vo.setLblAttendanceEndDate(dto.getEndTimeString());
        vo.setLblAttendanceWorkTime(dto.getWorkTimeString());
        vo.setLblAttendanceRestTime(dto.getRestTimeString());
        vo.setLblAttendancePrivateTime(dto.getPrivateTimeString());
        vo.setLblAttendanceLateTime(dto.getLateTimeString());
        vo.setLblAttendanceLeaveEarly(dto.getLeaveEarlyTimeString());
        vo.setLblAttendanceLateLeaveEarly(dto.getLateLeaveEarlyTimeString());
        vo.setLblAttendanceOverTimeIn(dto.getOvertimeInString());
        vo.setLblAttendanceOverTimeOut(dto.getOvertimeOutString());
        vo.setLblAttendanceWorkOnHoliday(dto.getHolidayWorkTimeString());
        vo.setLblAttendanceLateNight(dto.getLateNightTimeString());
        vo.setLblAttendanceState(this.getStatusStageValueView(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage()));
        vo.setLblAttendanceCorrection(dto.getCorrectionInfo());
        vo.setWorkflow(dto.getWorkflow());
        vo.setLblAttendanceRemark(MospUtility.concat((String[])new String[]{dto.getRemark(), dto.getTimeComment()}));
    }

    public void getAttendanceHistory() throws MospException {
        AttendanceHistoryVo vo = (AttendanceHistoryVo)this.mospParams.getVo();
        Date targetDate = vo.getTargetDate();
        String personalId = vo.getPersonalId();
        AttendanceCorrectionReferenceBeanInterface correction = this.timeReference().attendanceCorrection();
        List list = correction.getAttendanceCorrectionHistory(personalId, targetDate, 1);
        String[] aryLblNumber = new String[list.size()];
        String[] aryLblDate = new String[list.size()];
        String[] aryLblEmployee = new String[list.size()];
        String[] aryLblType = new String[list.size()];
        String[] aryLblBefore = new String[list.size()];
        String[] aryLblAfter = new String[list.size()];
        String[] aryLblComment = new String[list.size()];
        int i = 0;
        for (AttendanceCorrectionDtoInterface dto : list) {
            aryLblNumber[i] = String.valueOf(i + 1);
            aryLblDate[i] = DateUtility.getStringDateAndDayAndTime((Date)dto.getCorrectionDate());
            aryLblEmployee[i] = this.getCorrector(dto);
            aryLblType[i] = correction.getHistoryAttendanceMoreName(dto.getCorrectionType());
            aryLblBefore[i] = correction.getCorrectionValue(dto.getCorrectionType(), dto.getCorrectionBefore(), targetDate);
            aryLblAfter[i] = correction.getCorrectionValue(dto.getCorrectionType(), dto.getCorrectionAfter(), targetDate);
            aryLblComment[i] = dto.getCorrectionReason();
            ++i;
        }
        vo.setAryLblCorrectionNumber(aryLblNumber);
        vo.setAryLblCorrectionDate(aryLblDate);
        vo.setAryLblCorrectionEmployee(aryLblEmployee);
        vo.setAryLblCorrectionType(aryLblType);
        vo.setAryLblCorrectionBefore(aryLblBefore);
        vo.setAryLblCorrectionAfter(aryLblAfter);
        vo.setAryLblCorrectionComment(aryLblComment);
    }

    public void getAttendanceTotal() throws MospException {
        AttendanceHistoryVo vo = (AttendanceHistoryVo)this.mospParams.getVo();
        TotalTimeCorrectionReferenceBeanInterface totalTime = this.timeReference().totalTimeCorrection();
        AttendanceCorrectionReferenceBeanInterface attendance = this.timeReference().attendanceCorrection();
        Date targetDate = vo.getTargetDate();
        String personalId = vo.getPersonalId();
        List list = this.timeReference().totalTimeCorrection().getTotalTimeCorrectionHistory(personalId, DateUtility.getYear((Date)targetDate), DateUtility.getMonth((Date)targetDate));
        String[] aryLblNumber = new String[list.size()];
        String[] aryLblDate = new String[list.size()];
        String[] aryLblEmployee = new String[list.size()];
        String[] aryLblType = new String[list.size()];
        String[] aryLblBefore = new String[list.size()];
        String[] aryLblAfter = new String[list.size()];
        String[] aryLblComment = new String[list.size()];
        int i = 0;
        for (TotalTimeCorrectionDtoInterface dto : list) {
            aryLblNumber[i] = String.valueOf(i + 1);
            aryLblDate[i] = DateUtility.getStringDateAndDayAndTime((Date)dto.getCorrectionDate());
            aryLblEmployee[i] = this.getCorrector(dto);
            aryLblType[i] = attendance.getHistoryAttendanceAggregateName(dto);
            aryLblBefore[i] = totalTime.getCorrectionValue(dto.getCorrectionType(), dto.getCorrectionBefore());
            aryLblAfter[i] = totalTime.getCorrectionValue(dto.getCorrectionType(), dto.getCorrectionAfter());
            aryLblComment[i] = dto.getCorrectionReason();
            ++i;
        }
        vo.setAryLblCorrectionNumber(aryLblNumber);
        vo.setAryLblCorrectionDate(aryLblDate);
        vo.setAryLblCorrectionEmployee(aryLblEmployee);
        vo.setAryLblCorrectionType(aryLblType);
        vo.setAryLblCorrectionBefore(aryLblBefore);
        vo.setAryLblCorrectionAfter(aryLblAfter);
        vo.setAryLblCorrectionComment(aryLblComment);
    }

    protected String getWorkTypeAbbr(AttendanceDtoInterface dto) throws MospException {
        WorkflowDtoInterface workflowDto;
        DifferenceRequestReferenceBeanInterface differenceRequestReference = this.timeReference().differenceRequest();
        DifferenceRequestDtoInterface differenceRequestDto = differenceRequestReference.findForKeyOnWorkflow(dto.getPersonalId(), dto.getWorkDate());
        if (differenceRequestDto != null && (workflowDto = this.reference().workflow().getLatestWorkflowInfo(differenceRequestDto.getWorkflow())) != null && "9".equals(workflowDto.getWorkflowStatus())) {
            return differenceRequestReference.getDifferenceAbbr(differenceRequestDto.getDifferenceType());
        }
        return this.timeReference().workType().getWorkTypeAbbr(dto.getWorkTypeCode(), dto.getWorkDate());
    }

    protected String getCorrector(AttendanceCorrectionDtoInterface dto) throws MospException {
        if (dto == null) {
            return this.mospParams.getName("Hyphen");
        }
        return this.getCorrector(dto.getPersonalId(), dto.getCorrectionPersonalId(), dto.getCorrectionDate());
    }

    protected String getCorrector(TotalTimeCorrectionDtoInterface dto) throws MospException {
        if (dto == null) {
            return this.mospParams.getName("Hyphen");
        }
        return this.getCorrector(dto.getPersonalId(), dto.getCorrectionPersonalId(), dto.getCorrectionDate());
    }

    private String getCorrector(String personalId, String correctionPersonalId, Date correctionDate) throws MospException {
        if (personalId.equals(correctionPersonalId)) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("FrontWithCornerParentheses"));
            sb.append(this.mospParams.getName("Myself"));
            sb.append(this.mospParams.getName("BackWithCornerParentheses"));
            return sb.toString();
        }
        HumanDtoInterface humanDto = this.reference().human().getHumanInfo(correctionPersonalId, correctionDate);
        if (humanDto == null) {
            return this.mospParams.getName("Hyphen");
        }
        return this.getLastFirstName(humanDto.getLastName(), humanDto.getFirstName());
    }

    protected void transfer() {
        AttendanceHistoryVo vo = (AttendanceHistoryVo)this.mospParams.getVo();
        this.setTargetWorkflow(vo.getWorkflow());
        this.mospParams.setNextCommand("TM1811");
    }

    protected void addAttendanceNotExistErrorMessage() {
        String rep = this.mospParams.getName("WorkManage", new String[]{"Data"});
        this.mospParams.addErrorMessage("PFW0201", new String[]{rep});
    }
}

