/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.file.action;

import java.util.Date;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.file.base.ExportListAction;
import jp.mosp.platform.file.base.ExportListVo;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.base.TimeReferenceBeanHandlerInterface;
import jp.mosp.time.bean.CutoffReferenceBeanInterface;
import jp.mosp.time.file.vo.TimeExportListVo;
import jp.mosp.time.utils.TimeMessageUtility;

public class TimeExportListAction
extends ExportListAction {
    public static final String CMD_SHOW = "TM3310";
    public static final String CMD_SEARCH = "TM3312";
    public static final String CMD_RE_SHOW = "TM3313";
    public static final String CMD_SORT = "TM3318";
    public static final String CMD_PAGE = "TM3319";
    public static final String CMD_SET_EXPORT = "TM3380";
    public static final String CMD_SET_ACTIVATION_DATE = "TM3381";

    public TimeExportListAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected void setViewPath(String className) {
        super.setViewPath(className);
        this.mospParams.addJsFile("/pub/time/base/js/time.js");
    }

    protected BaseVo getSpecificVo() {
        return new TimeExportListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_SET_EXPORT)) {
            this.prepareVo();
            this.setExport();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        }
    }

    protected void setExportListInfo() {
        ExportListVo vo = (ExportListVo)this.mospParams.getVo();
        vo.setTableTypeCodeKey("TimeExportTableType");
        vo.setReShowCommand(CMD_RE_SHOW);
        vo.setSearchCommand(CMD_SEARCH);
        vo.setSortCommand(CMD_SORT);
        vo.setSetExportCommand(CMD_SET_EXPORT);
        this.setPageInfo(CMD_PAGE, this.getListLength());
    }

    protected void show() throws MospException {
        this.setExportListInfo();
        this.initExportListVoFields();
        this.initOutputCondition();
    }

    protected void setActivationDate() throws MospException {
        TimeExportListVo vo = (TimeExportListVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            if (!this.isActivationDateValid()) {
                return;
            }
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
    }

    protected void setPulldown() throws MospException {
        TimeExportListVo vo = (TimeExportListVo)this.mospParams.getVo();
        vo.setAryPltWorkPlace(this.getInputActivateDatePulldown());
        vo.setAryPltEmployment(this.getInputActivateDatePulldown());
        vo.setAryPltSection(this.getInputActivateDatePulldown());
        vo.setAryPltPosition(this.getInputActivateDatePulldown());
        vo.setAryPltCutoff(this.getInputActivateDatePulldown());
        if (vo.getModeActivateDate().equals("chaning")) {
            return;
        }
        Date targetDate = this.getPulldownTargetDate();
        TimeReferenceBeanHandlerInterface timeReference = (TimeReferenceBeanHandlerInterface)this.createHandler(TimeReferenceBeanHandlerInterface.class);
        CutoffReferenceBeanInterface cutoffReference = timeReference.cutoff();
        String[][] aryPltCutoff = cutoffReference.getSelectCodeArray(targetDate);
        if (aryPltCutoff[0][0].isEmpty()) {
            vo.setModeActivateDate("chaning");
            this.addNoCutoffMessage();
            return;
        }
        String[][] aryPltWorkPlace = this.reference().workPlace().getCodedAbbrSelectArray(targetDate, true, null);
        String[][] aryPltEmployment = this.reference().employmentContract().getCodedAbbrSelectArray(targetDate, true, null);
        String[][] aryPltSection = this.reference().section().getCodedSelectArray(targetDate, true, null);
        String[][] aryPltPosition = this.reference().position().getCodedSelectArray(targetDate, true, null);
        vo.setAryPltWorkPlace(aryPltWorkPlace);
        vo.setAryPltEmployment(aryPltEmployment);
        vo.setAryPltSection(aryPltSection);
        vo.setAryPltPosition(aryPltPosition);
        vo.setAryPltCutoff(aryPltCutoff);
    }

    protected Date getPulldownTargetDate() throws MospException {
        TimeExportListVo vo = (TimeExportListVo)this.mospParams.getVo();
        return MonthUtility.getYearMonthTargetDate((int)this.getInt(vo.getTxtStartYear()), (int)this.getInt(vo.getTxtStartMonth()), (MospParams)this.mospParams);
    }

    protected void initOutputCondition() throws MospException {
        TimeExportListVo vo = (TimeExportListVo)this.mospParams.getVo();
        Date yearMonthTargetDate = MonthUtility.getTargetYearMonth((Date)this.getSystemDate(), (MospParams)this.mospParams);
        vo.setTxtStartYear(this.getStringYear(yearMonthTargetDate));
        vo.setTxtStartMonth(this.getStringMonth(yearMonthTargetDate));
        vo.setTxtEndYear(this.getStringYear(yearMonthTargetDate));
        vo.setTxtEndMonth(this.getStringMonth(yearMonthTargetDate));
        vo.setModeActivateDate("chaning");
        this.setPulldown();
    }

    protected void addNoCutoffMessage() {
        this.mospParams.addErrorMessage("PFW0201", new String[]{this.mospParams.getName("CutoffDate")});
    }

    protected Date getEditStartDate() throws MospException {
        TimeExportListVo vo = (TimeExportListVo)this.mospParams.getVo();
        return MonthUtility.getYearMonthTermFirstDate((int)this.getInt(vo.getTxtStartYear()), (int)this.getInt(vo.getTxtStartMonth()), (MospParams)this.mospParams);
    }

    protected Date getEditEndDate() throws MospException {
        TimeExportListVo vo = (TimeExportListVo)this.mospParams.getVo();
        return MonthUtility.getYearMonthTermLastDate((int)this.getInt(vo.getTxtEndYear()), (int)this.getInt(vo.getTxtEndMonth()), (MospParams)this.mospParams);
    }

    protected boolean isActivationDateValid() throws MospException {
        if (this.getEditStartDate().after(this.getEditEndDate())) {
            TimeMessageUtility.addErrorActivateDateEndBeforeStart((MospParams)this.mospParams);
            return false;
        }
        return true;
    }
}

