/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.entity;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import jp.mosp.time.dto.settings.LimitStandardDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.entity.TimeSettingEntityInterface;
import jp.mosp.time.utils.TimeUtility;

public class TimeSettingEntity
implements TimeSettingEntityInterface {
    protected TimeSettingDtoInterface dto;
    protected Map<String, LimitStandardDtoInterface> limits = new HashMap();

    public TimeSettingDtoInterface getTimeSettingDto() {
        return this.dto;
    }

    public LimitStandardDtoInterface getLimitStandardDto(String term) {
        return (LimitStandardDtoInterface)this.limits.get(term);
    }

    public void setTimeSettingDto(TimeSettingDtoInterface dto) {
        this.dto = dto;
    }

    public void setLimitStandardDtos(Map<String, LimitStandardDtoInterface> limits) {
        this.limits = limits;
    }

    public String getWorkSettingCode() {
        if (!this.isExist()) {
            return "";
        }
        return this.dto.getWorkSettingCode();
    }

    public Date getActivateDate() {
        if (!this.isExist()) {
            return null;
        }
        return this.dto.getActivateDate();
    }

    public boolean isExist() {
        return this.dto != null;
    }

    public boolean isLimitStandardExist(String term) {
        return this.getLimitStandardDto(term) != null;
    }

    public int getStartWeek() {
        if (!this.isExist()) {
            return 0;
        }
        return this.dto.getStartWeek();
    }

    public int getStartMonthOfYear() {
        if (!this.isExist()) {
            return 1;
        }
        int startMonth = this.dto.getStartYear();
        if (startMonth == 0) {
            return 1;
        }
        return startMonth;
    }

    public int roundDailyLeaveEarly(int leaveEarly) {
        return 0;
    }

    public boolean isOneWeekExist() {
        return this.isLimitStandardExist("week1");
    }

    public boolean isOneMonthExist() {
        return this.isLimitStandardExist("month1");
    }

    public int getOneWeekLimit() {
        return this.getLimit("week1");
    }

    public int getOneMonthLimit() {
        return this.getLimit("month1");
    }

    public int getOneMonthAttention() {
        return this.getAttention("month1");
    }

    public int getOneMonthWarning() {
        return this.getWarning("month1");
    }

    public String getOneWeekLimitHours() {
        return this.getLimitHours("week1");
    }

    public String getOneWeekLimitMinutes() {
        return this.getLimitMinutes("week1");
    }

    public String getOneMonthLimitHours() {
        return this.getLimitHours("month1");
    }

    public String getOneMonthLimitMinutes() {
        return this.getLimitMinutes("month1");
    }

    public String getOneMonthAttentionHours() {
        return this.getAttentionHours("month1");
    }

    public String getOneMonthAttentionMinutes() {
        return this.getAttentionMinutes("month1");
    }

    public String getOneMonthWarningHours() {
        return this.getWarningHours("month1");
    }

    public String getOneMonthWarningMinutes() {
        return this.getWarningMinutes("month1");
    }

    public int getLimit(String term) {
        LimitStandardDtoInterface dto = this.getLimitStandardDto(term);
        if (dto == null) {
            return 0;
        }
        return dto.getLimitTime();
    }

    public String getLimitHours(String term) {
        return this.getHours(this.getLimit(term));
    }

    public String getLimitMinutes(String term) {
        return this.getMinutes(this.getLimit(term));
    }

    public int getAttention(String term) {
        LimitStandardDtoInterface dto = this.getLimitStandardDto(term);
        if (dto == null) {
            return 0;
        }
        return dto.getAttentionTime();
    }

    public String getAttentionHours(String term) {
        return this.getHours(this.getAttention(term));
    }

    public String getAttentionMinutes(String term) {
        return this.getMinutes(this.getAttention(term));
    }

    public int getWarning(String term) {
        LimitStandardDtoInterface dto = this.getLimitStandardDto(term);
        if (dto == null) {
            return 0;
        }
        return dto.getWarningTime();
    }

    public String getWarningHours(String term) {
        return this.getHours(this.getWarning(term));
    }

    public String getWarningMinutes(String term) {
        return this.getMinutes(this.getWarning(term));
    }

    public int getOverLimit(String term, int value) {
        int limit = this.getLimit(term);
        if (limit == 0) {
            return 0;
        }
        int overLimit = value - limit;
        return overLimit < 0 ? 0 : overLimit;
    }

    public boolean isOverLimit(String term, int value) {
        return this.getOverLimit(term, value) > 0;
    }

    public int getOverAttention(String term, int value) {
        int attention = this.getAttention(term);
        if (attention == 0) {
            return 0;
        }
        int overAttention = value - attention;
        return overAttention < 0 ? 0 : overAttention;
    }

    public boolean isOverAttention(String term, int value) {
        return this.getOverAttention(term, value) > 0;
    }

    public int getOverWarning(String term, int value) {
        int warning = this.getWarning(term);
        if (warning == 0) {
            return 0;
        }
        int overWarning = value - warning;
        return overWarning < 0 ? 0 : overWarning;
    }

    public boolean isOverWarning(String term, int value) {
        return this.getOverWarning(term, value) > 0;
    }

    public String getStyle(String term, int value) {
        if (!this.isLimitStandardExist(term)) {
            return "\u3000";
        }
        if (this.isOverWarning(term, value)) {
            return this.getWarningStyle();
        }
        if (this.isOverAttention(term, value)) {
            return this.getAttentionStyle();
        }
        return "\u3000";
    }

    public String getOneMonthStyle(int value) {
        return this.getStyle("month1", value);
    }

    protected String getHours(int time) {
        if (time == 0) {
            return "";
        }
        return String.valueOf(TimeUtility.getHours((int)time));
    }

    protected String getMinutes(int time) {
        if (time == 0) {
            return "";
        }
        return String.valueOf(TimeUtility.getMinutes((int)time));
    }

    protected String getAttentionStyle() {
        return "style=\"color: darkorange\"";
    }

    protected String getWarningStyle() {
        return "style=\"color: red\"";
    }
}

