/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.CapsuleUtility;
import jp.mosp.platform.dto.base.RequestDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.dto.base.HolidayRangeDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.entity.RequestEntityInterface;
import jp.mosp.time.utils.TimeUtility;

public class RequestEntity
implements RequestEntityInterface {
    protected String personalId;
    protected Date targetDate;
    protected List<HolidayRequestDtoInterface> holidayRequestList;
    protected List<OvertimeRequestDtoInterface> overtimeRequestList;
    protected List<SubstituteDtoInterface> substituteList;
    protected List<SubHolidayRequestDtoInterface> subHolidayRequestList;
    protected WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto;
    protected DifferenceRequestDtoInterface differenceRequestDto;
    protected WorkTypeChangeRequestDtoInterface workTypeChangeRequestDto;
    protected AttendanceDtoInterface attendanceDto;
    protected Map<Long, WorkflowDtoInterface> workflowMap;
    protected String scheduledWorkTypeCode;
    protected String substitutedWorkTypeCode;

    public void setPersonalId(String personalId) {
        this.personalId = personalId;
    }

    public void setTargetDate(Date targetDate) {
        this.targetDate = CapsuleUtility.getDateClone((Date)targetDate);
    }

    public boolean hasAttendance() {
        return this.attendanceDto != null;
    }

    public boolean isAttendanceApplied() {
        if (!this.hasAttendance()) {
            return false;
        }
        return WorkflowUtility.isApplied((WorkflowDtoInterface)((WorkflowDtoInterface)this.workflowMap.get(this.attendanceDto.getWorkflow())));
    }

    public boolean isAttendanceDirectStart() {
        if (!this.hasAttendance()) {
            return false;
        }
        return this.isChecked(this.attendanceDto.getDirectStart());
    }

    public boolean isAttendanceDirectEnd() {
        if (!this.hasAttendance()) {
            return false;
        }
        return this.isChecked(this.attendanceDto.getDirectEnd());
    }

    public String getWorkType(boolean isAttendanceConsidered) {
        if (this.attendanceDto != null && isAttendanceConsidered) {
            return this.attendanceDto.getWorkTypeCode();
        }
        boolean isCompleted = false;
        if (this.isAllHoliday(isCompleted)) {
            return this.getSubstituteType(isCompleted);
        }
        if (this.getWorkTypeChangeRequestDto(isCompleted) != null) {
            return this.getChangeWorkType(isCompleted);
        }
        if (this.getWorkOnHolidayRequestDto(isCompleted) != null) {
            return this.getWorkOnHolidayWorkType(isCompleted);
        }
        return this.scheduledWorkTypeCode;
    }

    public String getWorkType() {
        return this.getWorkType(true);
    }

    public boolean isWorkDay() {
        boolean isCompleted = false;
        if (this.isAllHoliday(isCompleted)) {
            return false;
        }
        if (this.getWorkOnHolidayRequestDto(true) != null) {
            return true;
        }
        return !TimeUtility.isHoliday((String)this.scheduledWorkTypeCode);
    }

    public String getWorkOnHolidayWorkType(boolean isCompleted) {
        WorkOnHolidayRequestDtoInterface dto = this.getWorkOnHolidayRequestDto(isCompleted);
        if (dto == null) {
            return "";
        }
        return this.substitutedWorkTypeCode;
    }

    public Date getWorkOnHolidayStartTime(boolean isCompleted) {
        WorkOnHolidayRequestDtoInterface dto = this.getWorkOnHolidayRequestDto(isCompleted);
        if (dto == null) {
            return null;
        }
        if (dto.getSubstitute() != 2) {
            return null;
        }
        return dto.getStartTime();
    }

    public Date getWorkOnHolidayEndTime(boolean isCompleted) {
        WorkOnHolidayRequestDtoInterface dto = this.getWorkOnHolidayRequestDto(isCompleted);
        if (dto == null) {
            return null;
        }
        if (dto.getSubstitute() != 2) {
            return null;
        }
        return dto.getEndTime();
    }

    public int getOvertimeMinutesBeforeWork(boolean isCompleted) {
        List list = this.getOvertimeRequestList(isCompleted);
        for (OvertimeRequestDtoInterface dto : list) {
            if (dto.getOvertimeType() != 1) continue;
            return dto.getRequestTime();
        }
        return 0;
    }

    public int getOvertimeMinutesAfterWork(boolean isCompleted) {
        List list = this.getOvertimeRequestList(isCompleted);
        for (OvertimeRequestDtoInterface dto : list) {
            if (dto.getOvertimeType() != 2) continue;
            return dto.getRequestTime();
        }
        return 0;
    }

    public boolean isAllHoliday(boolean isCompleted) {
        boolean hasAllHoliday = this.hasAllHoliday(isCompleted);
        boolean hasAmHoliday = this.hasAmHoliday(isCompleted);
        boolean hasPmHoliday = this.hasPmHoliday(isCompleted);
        return hasAllHoliday || hasAmHoliday && hasPmHoliday;
    }

    public boolean isAmHoliday(boolean isCompleted) {
        if (this.hasAllHoliday(isCompleted)) {
            return false;
        }
        if (this.hasPmHoliday(isCompleted)) {
            return false;
        }
        return this.hasAmHoliday(isCompleted);
    }

    public boolean isPmHoliday(boolean isCompleted) {
        if (this.hasAllHoliday(isCompleted)) {
            return false;
        }
        if (this.hasAmHoliday(isCompleted)) {
            return false;
        }
        return this.hasPmHoliday(isCompleted);
    }

    protected boolean hasAllHoliday(boolean isCompleted) {
        if (this.hasAllHoliday(this.getHolidayRequestList(isCompleted))) {
            return true;
        }
        if (this.hasAllHoliday(this.getSubHolidayRequestList(isCompleted))) {
            return true;
        }
        return this.hasAllHoliday(this.getSubstituteList(isCompleted)) && !this.hasWorkOnHoliday(isCompleted);
    }

    protected boolean hasAmHoliday(boolean isCompleted) {
        if (this.hasAmHoliday(this.getHolidayRequestList(isCompleted))) {
            return true;
        }
        if (this.hasAmHoliday(this.getSubHolidayRequestList(isCompleted))) {
            return true;
        }
        if (this.hasAmHoliday(this.getSubstituteList(isCompleted)) && !this.hasAmWorkOnHoliday(isCompleted)) {
            return true;
        }
        return this.hasPmWorkOnHoliday(isCompleted) && !this.hasPmHoliday(this.getSubstituteList(isCompleted));
    }

    protected boolean hasPmHoliday(boolean isCompleted) {
        if (this.hasPmHoliday(this.getHolidayRequestList(isCompleted))) {
            return true;
        }
        if (this.hasPmHoliday(this.getSubHolidayRequestList(isCompleted))) {
            return true;
        }
        if (this.hasPmHoliday(this.getSubstituteList(isCompleted)) && !this.hasPmWorkOnHoliday(isCompleted)) {
            return true;
        }
        return this.hasAmWorkOnHoliday(isCompleted) && !this.hasAmHoliday(this.getSubstituteList(isCompleted));
    }

    protected boolean hasAmWorkOnHoliday(boolean isCompleted) {
        if (!this.hasWorkOnHoliday(isCompleted)) {
            return false;
        }
        WorkOnHolidayRequestDtoInterface dto = this.getWorkOnHolidayRequestDto(isCompleted);
        return dto.getSubstitute() == 3;
    }

    protected boolean hasPmWorkOnHoliday(boolean isCompleted) {
        if (!this.hasWorkOnHoliday(isCompleted)) {
            return false;
        }
        WorkOnHolidayRequestDtoInterface dto = this.getWorkOnHolidayRequestDto(isCompleted);
        return dto.getSubstitute() == 4;
    }

    protected boolean hasWorkOnHoliday(boolean isCompleted) {
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.getWorkOnHolidayRequestDto(isCompleted);
        return workOnHolidayRequestDto != null;
    }

    public boolean isWorkOnLegal(boolean isCompleted) {
        if (!this.isWorkOnHolidayNotSubstitute(isCompleted)) {
            return false;
        }
        WorkOnHolidayRequestDtoInterface dto = this.getWorkOnHolidayRequestDto(isCompleted);
        return dto.getWorkOnHolidayType().equals("legal_holiday");
    }

    public boolean isWorkOnPrescribed(boolean isCompleted) {
        if (!this.isWorkOnHolidayNotSubstitute(isCompleted)) {
            return false;
        }
        WorkOnHolidayRequestDtoInterface dto = this.getWorkOnHolidayRequestDto(isCompleted);
        return dto.getWorkOnHolidayType().equals("prescribed_holiday");
    }

    public boolean isWorkOnHolidaySubstitute(boolean isCompleted) {
        if (!this.hasWorkOnHoliday(isCompleted)) {
            return false;
        }
        return !this.isWorkOnHolidayNotSubstitute(isCompleted);
    }

    public boolean isWorkOnHolidayNotSubstitute(boolean isCompleted) {
        if (!this.hasWorkOnHoliday(isCompleted)) {
            return false;
        }
        WorkOnHolidayRequestDtoInterface dto = this.getWorkOnHolidayRequestDto(isCompleted);
        return dto.getSubstitute() == 2;
    }

    public List<Date> getHourlyHolidayFirstSequenceTimes() {
        boolean isCompleted = false;
        ArrayList<Date> hourlyHolidayFirstSequenceTimes = new ArrayList<Date>();
        Map map = this.getHourlyHolidayMap(isCompleted);
        if (map.isEmpty()) {
            return hourlyHolidayFirstSequenceTimes;
        }
        ArrayList startTimeList = new ArrayList(map.keySet());
        Collections.sort(startTimeList);
        hourlyHolidayFirstSequenceTimes.add(new Date(((Date)startTimeList.get(0)).getTime()));
        Date endTime = null;
        for (Date startTime : startTimeList) {
            if (endTime != null && startTime.compareTo(endTime) != 0) break;
            HolidayRequestDtoInterface dto = (HolidayRequestDtoInterface)map.get(startTime);
            endTime = dto.getEndTime();
        }
        hourlyHolidayFirstSequenceTimes.add(new Date(endTime.getTime()));
        return hourlyHolidayFirstSequenceTimes;
    }

    public List<Integer> getHourlyHolidayFirstSequenceMinutes() throws MospException {
        List holidayTimeList = this.getHourlyHolidayFirstSequenceTimes();
        return this.getHourlyHolidaySequenceMinutes(holidayTimeList);
    }

    public List<Date> getHourlyHolidayLastSequenceTimes() {
        boolean isCompleted = false;
        ArrayList<Date> hourlyHolidayFirstSequenceTimes = new ArrayList<Date>();
        Map map = this.getHourlyHolidayMap(isCompleted);
        if (map.isEmpty()) {
            return hourlyHolidayFirstSequenceTimes;
        }
        ArrayList startTimeList = new ArrayList(map.keySet());
        Collections.sort(startTimeList);
        Collections.reverse(startTimeList);
        hourlyHolidayFirstSequenceTimes.add(new Date(((HolidayRequestDtoInterface)map.get(startTimeList.get(0))).getEndTime().getTime()));
        Date sequenceStartTime = null;
        for (Date startTime : startTimeList) {
            HolidayRequestDtoInterface dto = (HolidayRequestDtoInterface)map.get(startTime);
            if (sequenceStartTime != null && dto.getEndTime().compareTo(sequenceStartTime) != 0) break;
            sequenceStartTime = startTime;
        }
        hourlyHolidayFirstSequenceTimes.add(0, new Date(sequenceStartTime.getTime()));
        return hourlyHolidayFirstSequenceTimes;
    }

    public List<Integer> getHourlyHolidayLastSequenceMinutes() throws MospException {
        List holidayTimeList = this.getHourlyHolidayLastSequenceTimes();
        return this.getHourlyHolidaySequenceMinutes(holidayTimeList);
    }

    public List<Integer> getHourlyHolidaySequenceMinutes(List<Date> holidayTimeList) throws MospException {
        ArrayList<Integer> holidayMinuteList = new ArrayList<Integer>();
        if (holidayTimeList.isEmpty()) {
            return holidayMinuteList;
        }
        holidayMinuteList.add(TimeUtility.getMinutes((Date)holidayTimeList.get(0), (Date)this.targetDate));
        holidayMinuteList.add(TimeUtility.getMinutes((Date)holidayTimeList.get(1), (Date)this.targetDate));
        return holidayMinuteList;
    }

    protected Map<Date, HolidayRequestDtoInterface> getHourlyHolidayMap(boolean isCompleted) {
        HashMap<Date, HolidayRequestDtoInterface> map = new HashMap<Date, HolidayRequestDtoInterface>();
        List list = this.getHolidayRequestList(isCompleted);
        for (HolidayRequestDtoInterface dto : list) {
            if (!this.isHourlyHoliday(dto)) continue;
            map.put(dto.getStartTime(), dto);
        }
        return map;
    }

    protected boolean isHourlyHoliday(HolidayRequestDtoInterface dto) {
        if (dto == null) {
            return false;
        }
        return dto.getHolidayRange() == 4;
    }

    protected String getSubstituteType(boolean isCompleted) {
        List list = this.getSubstituteList(isCompleted);
        for (SubstituteDtoInterface dto : list) {
            if (!this.isTheHolidayRange((HolidayRangeDtoInterface)dto, 1)) continue;
            return dto.getSubstituteType();
        }
        if (this.hasAmHoliday(list) && this.hasPmHoliday(list)) {
            return "prescribed_holiday";
        }
        return "";
    }

    protected String getChangeWorkType(boolean isCompleted) {
        WorkTypeChangeRequestDtoInterface dto = this.getWorkTypeChangeRequestDto(isCompleted);
        if (dto == null) {
            return "";
        }
        return dto.getWorkTypeCode();
    }

    public boolean isAmPmHalfSubstitute(boolean isCompleted) {
        List list = this.getSubstituteList(isCompleted);
        return this.hasAmHoliday(list) && this.hasPmHoliday(list);
    }

    public boolean isHalfPostpone(boolean isCompleted) {
        if (!this.hasAmWorkOnHoliday(isCompleted) && !this.hasPmWorkOnHoliday(isCompleted)) {
            return false;
        }
        List list = this.getSubstituteList(isCompleted);
        return this.hasAmHoliday(list) || this.hasPmHoliday(list);
    }

    public boolean isAttendanceAppliable() {
        if (!this.isWorkDay()) {
            return false;
        }
        if (this.isAttendanceApplied()) {
            return false;
        }
        if (this.isOvertimeApplied(false)) {
            return false;
        }
        if (this.isHolidayApplied(false)) {
            return false;
        }
        if (this.isSubHolidayApplied(false)) {
            return false;
        }
        if (this.isWorkOnHolidayHolidayApplied(false)) {
            return false;
        }
        if (this.isSubstituteApplied(false)) {
            return false;
        }
        if (this.isDifferenceApplied(false)) {
            return false;
        }
        return !this.isWorkTypeChangeApplied(false);
    }

    public boolean isOvertimeApplied(boolean isContainCompleted) {
        for (OvertimeRequestDtoInterface dto : this.overtimeRequestList) {
            WorkflowDtoInterface workflowDto = (WorkflowDtoInterface)this.workflowMap.get(dto.getWorkflow());
            if (WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto) && isContainCompleted) {
                return true;
            }
            if (WorkflowUtility.isCancelApply((WorkflowDtoInterface)workflowDto)) {
                return true;
            }
            if (WorkflowUtility.isCancelWithDrawnApply((WorkflowDtoInterface)workflowDto)) {
                return true;
            }
            if (!WorkflowUtility.isApprovable((WorkflowDtoInterface)workflowDto)) continue;
            return true;
        }
        return false;
    }

    public boolean isHolidayApplied(boolean isContainCompleted) {
        for (HolidayRequestDtoInterface dto : this.holidayRequestList) {
            WorkflowDtoInterface workflowDto = (WorkflowDtoInterface)this.workflowMap.get(dto.getWorkflow());
            if (WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto) && isContainCompleted) {
                return true;
            }
            if (WorkflowUtility.isCancelApply((WorkflowDtoInterface)workflowDto)) {
                return true;
            }
            if (WorkflowUtility.isCancelWithDrawnApply((WorkflowDtoInterface)workflowDto)) {
                return true;
            }
            if (!WorkflowUtility.isApprovable((WorkflowDtoInterface)workflowDto)) continue;
            return true;
        }
        return false;
    }

    public boolean isSubHolidayApplied(boolean isContainCompleted) {
        for (SubHolidayRequestDtoInterface dto : this.subHolidayRequestList) {
            WorkflowDtoInterface workflowDto = (WorkflowDtoInterface)this.workflowMap.get(dto.getWorkflow());
            if (WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto) && isContainCompleted) {
                return true;
            }
            if (WorkflowUtility.isCancelApply((WorkflowDtoInterface)workflowDto)) {
                return true;
            }
            if (WorkflowUtility.isCancelWithDrawnApply((WorkflowDtoInterface)workflowDto)) {
                return true;
            }
            if (!WorkflowUtility.isApprovable((WorkflowDtoInterface)workflowDto)) continue;
            return true;
        }
        return false;
    }

    public boolean isWorkOnHolidayHolidayApplied(boolean isContainCompleted) {
        if (this.workOnHolidayRequestDto == null) {
            return false;
        }
        WorkflowDtoInterface workflowDto = (WorkflowDtoInterface)this.workflowMap.get(this.workOnHolidayRequestDto.getWorkflow());
        if (WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto) && isContainCompleted) {
            return true;
        }
        if (WorkflowUtility.isCancelApply((WorkflowDtoInterface)workflowDto)) {
            return true;
        }
        if (WorkflowUtility.isCancelWithDrawnApply((WorkflowDtoInterface)workflowDto)) {
            return true;
        }
        return WorkflowUtility.isApprovable((WorkflowDtoInterface)workflowDto);
    }

    public boolean isSubstituteApplied(boolean isContainCompleted) {
        for (SubstituteDtoInterface dto : this.substituteList) {
            WorkflowDtoInterface workflowDto = (WorkflowDtoInterface)this.workflowMap.get(dto.getWorkflow());
            if (WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto) && isContainCompleted) {
                return true;
            }
            if (WorkflowUtility.isCancelApply((WorkflowDtoInterface)workflowDto)) {
                return true;
            }
            if (WorkflowUtility.isCancelWithDrawnApply((WorkflowDtoInterface)workflowDto)) {
                return true;
            }
            if (!WorkflowUtility.isApprovable((WorkflowDtoInterface)workflowDto)) continue;
            return true;
        }
        return false;
    }

    public boolean isDifferenceApplied(boolean isContainCompleted) {
        if (this.differenceRequestDto == null) {
            return false;
        }
        WorkflowDtoInterface workflowDto = (WorkflowDtoInterface)this.workflowMap.get(this.differenceRequestDto.getWorkflow());
        if (WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto) && isContainCompleted) {
            return true;
        }
        if (WorkflowUtility.isCancelApply((WorkflowDtoInterface)workflowDto)) {
            return true;
        }
        if (WorkflowUtility.isCancelWithDrawnApply((WorkflowDtoInterface)workflowDto)) {
            return true;
        }
        return WorkflowUtility.isApprovable((WorkflowDtoInterface)workflowDto);
    }

    public boolean isWorkTypeChangeApplied(boolean isContainCompleted) {
        if (this.workTypeChangeRequestDto == null) {
            return false;
        }
        WorkflowDtoInterface workflowDto = (WorkflowDtoInterface)this.workflowMap.get(this.workTypeChangeRequestDto.getWorkflow());
        if (WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto) && isContainCompleted) {
            return true;
        }
        if (WorkflowUtility.isCancelApply((WorkflowDtoInterface)workflowDto)) {
            return true;
        }
        return WorkflowUtility.isApprovable((WorkflowDtoInterface)workflowDto);
    }

    protected List<HolidayRequestDtoInterface> getHolidayRequestList(boolean isCompleted) {
        return this.castHolidayRequest(this.getRequestList(this.holidayRequestList, isCompleted));
    }

    protected List<SubHolidayRequestDtoInterface> getSubHolidayRequestList(boolean isCompleted) {
        return this.castSubHolidayRequest(this.getRequestList(this.subHolidayRequestList, isCompleted));
    }

    protected List<SubstituteDtoInterface> getSubstituteList(boolean isCompleted) {
        return this.castSubstitute(this.getRequestList(this.substituteList, isCompleted));
    }

    protected WorkOnHolidayRequestDtoInterface getWorkOnHolidayRequestDto(boolean isCompleted) {
        return (WorkOnHolidayRequestDtoInterface)this.getRequestDto((RequestDtoInterface)this.workOnHolidayRequestDto, isCompleted);
    }

    public List<OvertimeRequestDtoInterface> getOvertimeRequestList(boolean isCompleted) {
        return this.castOvertimeRequest(this.getRequestList(this.overtimeRequestList, isCompleted));
    }

    protected WorkTypeChangeRequestDtoInterface getWorkTypeChangeRequestDto(boolean isCompleted) {
        return (WorkTypeChangeRequestDtoInterface)this.getRequestDto((RequestDtoInterface)this.workTypeChangeRequestDto, isCompleted);
    }

    protected List<HolidayRequestDtoInterface> castHolidayRequest(List<? extends RequestDtoInterface> list) {
        ArrayList<HolidayRequestDtoInterface> castedList = new ArrayList<HolidayRequestDtoInterface>();
        for (RequestDtoInterface requestDtoInterface : list) {
            castedList.add((HolidayRequestDtoInterface)requestDtoInterface);
        }
        return castedList;
    }

    protected List<SubHolidayRequestDtoInterface> castSubHolidayRequest(List<? extends RequestDtoInterface> list) {
        ArrayList<SubHolidayRequestDtoInterface> castedList = new ArrayList<SubHolidayRequestDtoInterface>();
        for (RequestDtoInterface requestDtoInterface : list) {
            castedList.add((SubHolidayRequestDtoInterface)requestDtoInterface);
        }
        return castedList;
    }

    protected List<SubstituteDtoInterface> castSubstitute(List<? extends RequestDtoInterface> list) {
        ArrayList<SubstituteDtoInterface> castedList = new ArrayList<SubstituteDtoInterface>();
        for (RequestDtoInterface requestDtoInterface : list) {
            castedList.add((SubstituteDtoInterface)requestDtoInterface);
        }
        return castedList;
    }

    protected List<OvertimeRequestDtoInterface> castOvertimeRequest(List<? extends RequestDtoInterface> list) {
        ArrayList<OvertimeRequestDtoInterface> castedList = new ArrayList<OvertimeRequestDtoInterface>();
        for (RequestDtoInterface requestDtoInterface : list) {
            castedList.add((OvertimeRequestDtoInterface)requestDtoInterface);
        }
        return castedList;
    }

    protected List<? extends RequestDtoInterface> getRequestList(List<? extends RequestDtoInterface> list, boolean isCompleted) {
        ArrayList<RequestDtoInterface> appliedList = new ArrayList<RequestDtoInterface>();
        for (RequestDtoInterface requestDtoInterface : list) {
            RequestDtoInterface requestDtoInterface2 = this.getRequestDto(requestDtoInterface, isCompleted);
            if (requestDtoInterface2 == null) continue;
            appliedList.add(requestDtoInterface2);
        }
        return appliedList;
    }

    protected RequestDtoInterface getRequestDto(RequestDtoInterface dto, boolean isCompleted) {
        if (dto == null) {
            return null;
        }
        if (isCompleted ? WorkflowUtility.isCompleted((WorkflowDtoInterface)((WorkflowDtoInterface)this.workflowMap.get(dto.getWorkflow()))) : WorkflowUtility.isApplied((WorkflowDtoInterface)((WorkflowDtoInterface)this.workflowMap.get(dto.getWorkflow())))) {
            return dto;
        }
        return null;
    }

    protected boolean hasAllHoliday(List<? extends HolidayRangeDtoInterface> list) {
        return this.hasTheHolidayRange(list, 1);
    }

    protected boolean hasAmHoliday(List<? extends HolidayRangeDtoInterface> list) {
        return this.hasTheHolidayRange(list, 2);
    }

    protected boolean hasPmHoliday(List<? extends HolidayRangeDtoInterface> list) {
        return this.hasTheHolidayRange(list, 3);
    }

    protected boolean hasTheHolidayRange(List<? extends HolidayRangeDtoInterface> list, int theHolidayRange) {
        for (HolidayRangeDtoInterface holidayRangeDtoInterface : list) {
            if (!this.isTheHolidayRange(holidayRangeDtoInterface, theHolidayRange)) continue;
            return true;
        }
        return false;
    }

    protected boolean isTheHolidayRange(HolidayRangeDtoInterface dto, int theHolidayRange) {
        if (dto == null) {
            return false;
        }
        return dto.getHolidayRange() == theHolidayRange;
    }

    protected boolean isChecked(int value) {
        return value == Integer.parseInt("1");
    }

    public String getPersonalId() {
        return this.personalId;
    }

    public Date getTargetDate() {
        return CapsuleUtility.getDateClone((Date)this.targetDate);
    }

    public void setHolidayRequestList(List<HolidayRequestDtoInterface> holidayRequestList) {
        this.holidayRequestList = holidayRequestList;
    }

    public void setOverTimeRequestList(List<OvertimeRequestDtoInterface> overtimeRequestList) {
        this.overtimeRequestList = overtimeRequestList;
    }

    public void setSubstituteList(List<SubstituteDtoInterface> substituteList) {
        this.substituteList = substituteList;
    }

    public void setSubHolidayRequestList(List<SubHolidayRequestDtoInterface> subHolidayRequestList) {
        this.subHolidayRequestList = subHolidayRequestList;
    }

    public void setWorkOnHolidayRequestDto(WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto) {
        this.workOnHolidayRequestDto = workOnHolidayRequestDto;
    }

    public DifferenceRequestDtoInterface getDifferenceRequestDto(boolean isCompleted) {
        return (DifferenceRequestDtoInterface)this.getRequestDto((RequestDtoInterface)this.differenceRequestDto, isCompleted);
    }

    public void setDifferenceRequestDto(DifferenceRequestDtoInterface differenceRequestDto) {
        this.differenceRequestDto = differenceRequestDto;
    }

    public void setWorkTypeChangeRequestDto(WorkTypeChangeRequestDtoInterface workTypeChangeRequestDto) {
        this.workTypeChangeRequestDto = workTypeChangeRequestDto;
    }

    public AttendanceDtoInterface getAttendanceDto() {
        return this.attendanceDto;
    }

    public void setAttendanceDto(AttendanceDtoInterface attendanceDto) {
        this.attendanceDto = attendanceDto;
    }

    public void setWorkflowMap(Map<Long, WorkflowDtoInterface> workflowMap) {
        this.workflowMap = workflowMap;
    }

    public void setScheduledWorkTypeCode(String scheduledWorkTypeCode) {
        this.scheduledWorkTypeCode = scheduledWorkTypeCode;
    }

    public void setSubstitutedWorkTypeCode(String substitutedWorkTypeCode) {
        this.substitutedWorkTypeCode = substitutedWorkTypeCode;
    }
}

