/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.entity;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.entity.HolidayRequestEntityInterface;
import jp.mosp.time.utils.TimeUtility;

public class HolidayRequestEntity
implements HolidayRequestEntityInterface {
    protected Map<Long, HolidayRequestDtoInterface> holidays = new LinkedHashMap();
    protected Map<Long, WorkflowDtoInterface> workflows = new TreeMap();

    public int countHourlyPaidHolidays(boolean isCompleted) {
        return this.countHourlyPaidHolidays(isCompleted, 0L);
    }

    public int countHourlyPaidHolidays(boolean isCompleted, long excludeId) {
        int count = 0;
        for (HolidayRequestDtoInterface dto : this.holidays.values()) {
            if (!this.isHourlyPaidHoliday(dto, isCompleted, excludeId)) continue;
            ++count;
        }
        return count;
    }

    protected boolean isHourlyPaidHoliday(HolidayRequestDtoInterface dto, boolean isCompleted, long excludeId) {
        if (!this.isMatch(dto, isCompleted, excludeId)) {
            return false;
        }
        if (!TimeUtility.isPaidHolidayRequest((HolidayRequestDtoInterface)dto)) {
            return false;
        }
        return TimeUtility.isHourlyHoliday((HolidayRequestDtoInterface)dto);
    }

    protected boolean isMatch(HolidayRequestDtoInterface dto, boolean isCompleted, long excludeId) {
        if (dto == null) {
            return false;
        }
        if (dto.getRecordId() == excludeId) {
            return false;
        }
        return WorkflowUtility.isStatusMatch((WorkflowDtoInterface)((WorkflowDtoInterface)this.workflows.get(dto.getWorkflow())), (boolean)isCompleted);
    }

    public void setHolidays(List<HolidayRequestDtoInterface> holidayList) {
        this.holidays = PlatformUtility.getRecordDtoMap(holidayList);
    }

    public void setWorkflows(Map<Long, WorkflowDtoInterface> workflows) {
        this.workflows = workflows;
    }
}

