/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.entity;

import java.util.Date;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;

public class ApplicationEntity {
    public static final int CODE_TIME_BUTTON_NONE = 9;
    public static final int CODE_REST_BUTTON_NONE = 2;
    public static final int CODE_ROUND_TYPE_NONE = 0;
    public static final int CODE_ROUND_TYPE_DOWN = 1;
    public static final int CODE_ROUND_TYPE_UP = 2;
    protected ApplicationDtoInterface applicationDto;
    protected TimeSettingDtoInterface timeSettingDto;
    protected CutoffDtoInterface cutoffDto;
    protected PaidHolidayDtoInterface paidHolidayDto;

    public ApplicationEntity(ApplicationDtoInterface applicationDto) {
        this.applicationDto = applicationDto;
    }

    public boolean isValid() {
        if (this.applicationDto == null) {
            return false;
        }
        if (this.timeSettingDto == null) {
            return false;
        }
        if (this.cutoffDto == null) {
            return false;
        }
        return this.paidHolidayDto != null;
    }

    public String getWorkSettingCode() {
        if (this.applicationDto == null || MospUtility.isEmpty((String[])new String[]{this.applicationDto.getWorkSettingCode()})) {
            return "";
        }
        return this.applicationDto.getWorkSettingCode();
    }

    public String getScheduleCode() {
        if (this.applicationDto == null || MospUtility.isEmpty((String[])new String[]{this.applicationDto.getScheduleCode()})) {
            return "";
        }
        return this.applicationDto.getScheduleCode();
    }

    public String getPaidHolidayCode() {
        if (this.applicationDto == null || MospUtility.isEmpty((String[])new String[]{this.applicationDto.getPaidHolidayCode()})) {
            return "";
        }
        return this.applicationDto.getPaidHolidayCode();
    }

    public String getCutoffCode() {
        if (this.timeSettingDto == null || this.timeSettingDto.getCutoffCode() == null) {
            return "";
        }
        return this.timeSettingDto.getCutoffCode();
    }

    public int getCutoffDate() {
        if (this.cutoffDto == null) {
            return 0;
        }
        return this.cutoffDto.getCutoffDate();
    }

    public boolean isTimeManaged() {
        if (this.timeSettingDto == null) {
            return false;
        }
        return PlatformUtility.isActivate((int)this.timeSettingDto.getTimeManagementFlag());
    }

    public int getStartDayOfWeek() {
        if (this.timeSettingDto == null) {
            return 1;
        }
        return this.timeSettingDto.getStartWeek();
    }

    public int getNoApproval() {
        if (this.cutoffDto == null) {
            return 0;
        }
        return this.cutoffDto.getNoApproval();
    }

    public boolean useScheduledTime() {
        if (this.timeSettingDto == null) {
            return false;
        }
        return this.timeSettingDto.getUseScheduledTime() == 0;
    }

    public boolean isSelfTightening() {
        if (this.cutoffDto == null) {
            return false;
        }
        return this.cutoffDto.getSelfTightening() == 0;
    }

    public int getPortalTimeButtons() {
        if (this.timeSettingDto == null) {
            return 9;
        }
        return this.timeSettingDto.getPortalTimeButtons();
    }

    public int getPortalRestButtons() {
        if (this.timeSettingDto == null) {
            return 9;
        }
        return this.timeSettingDto.getPortalRestButtons();
    }

    public Date getRoundedStartTime(Date targetTime) {
        if (this.timeSettingDto == null) {
            return this.getRoundedTime(targetTime, 1, 1);
        }
        return this.getRoundedTime(targetTime, this.timeSettingDto.getRoundDailyStartUnit(), this.timeSettingDto.getRoundDailyStart());
    }

    public Date getRoundedActualStartTime(Date targetTime) {
        if (this.timeSettingDto == null) {
            return this.getRoundedTime(targetTime, 1, 1);
        }
        if (this.timeSettingDto.getRoundDailyStartUnit() == 1 && this.timeSettingDto.getRoundDailyStart() == 2) {
            return this.getRoundedTime(targetTime, this.timeSettingDto.getRoundDailyStartUnit(), this.timeSettingDto.getRoundDailyStart());
        }
        return this.getRoundedTime(targetTime, 1, 1);
    }

    public Date getRoundedEndTime(Date targetTime) {
        if (this.timeSettingDto == null) {
            return this.getRoundedTime(targetTime, 1, 1);
        }
        return this.getRoundedTime(targetTime, this.timeSettingDto.getRoundDailyEndUnit(), this.timeSettingDto.getRoundDailyEnd());
    }

    public Date getRoundedActualEndTime(Date targetTime) {
        if (this.timeSettingDto == null) {
            return this.getRoundedTime(targetTime, 1, 1);
        }
        if (this.timeSettingDto.getRoundDailyEndUnit() == 1 && this.timeSettingDto.getRoundDailyEnd() == 2) {
            return this.getRoundedTime(targetTime, this.timeSettingDto.getRoundDailyEndUnit(), this.timeSettingDto.getRoundDailyEnd());
        }
        return this.getRoundedTime(targetTime, 1, 1);
    }

    public Date getRoundedRestStartTime(Date targetTime) {
        if (this.timeSettingDto == null) {
            return this.getRoundedTime(targetTime, 1, 1);
        }
        if (this.timeSettingDto.getRoundDailyRestStartUnit() == 1 && this.timeSettingDto.getRoundDailyRestStart() == 2) {
            return this.getRoundedTime(targetTime, this.timeSettingDto.getRoundDailyRestStartUnit(), this.timeSettingDto.getRoundDailyRestStart());
        }
        return this.getRoundedTime(targetTime, 1, 1);
    }

    public Date getRoundedRestEndTime(Date targetTime) {
        if (this.timeSettingDto == null) {
            return this.getRoundedTime(targetTime, 1, 1);
        }
        if (this.timeSettingDto.getRoundDailyRestEndUnit() == 1 && this.timeSettingDto.getRoundDailyRestEnd() == 2) {
            return this.getRoundedTime(targetTime, this.timeSettingDto.getRoundDailyRestEndUnit(), this.timeSettingDto.getRoundDailyRestEnd());
        }
        return this.getRoundedTime(targetTime, 1, 1);
    }

    protected Date getRoundedTime(Date targetTime, int roundUnit, int roundType) {
        if (targetTime == null) {
            return null;
        }
        long milliseconds = targetTime.getTime();
        if (milliseconds <= 0L) {
            return targetTime;
        }
        int oneMinute = 60000;
        long fraction = milliseconds % (long)oneMinute;
        milliseconds -= fraction;
        if (fraction > 0L && roundType == 2 && roundUnit == 1) {
            milliseconds += (long)oneMinute;
        }
        if (roundType == 0 || roundUnit <= 0) {
            return new Date(milliseconds);
        }
        int millisecondsUnit = roundUnit * 60 * 1000;
        long rounded = milliseconds - milliseconds % (long)millisecondsUnit;
        if (roundType == 2 && milliseconds % (long)millisecondsUnit > 0L) {
            rounded += (long)millisecondsUnit;
        }
        return new Date(rounded);
    }

    public String getProspectsMonths() {
        if (this.timeSettingDto == null) {
            return "0";
        }
        return this.timeSettingDto.getProspectsMonths();
    }

    public TimeSettingDtoInterface getTimeSettingDto() {
        return this.timeSettingDto;
    }

    public void setTimeSettingDto(TimeSettingDtoInterface timeSettingDto) {
        this.timeSettingDto = timeSettingDto;
    }

    public CutoffDtoInterface getCutoffDto() {
        return this.cutoffDto;
    }

    public void setCutoffDto(CutoffDtoInterface cutoffDto) {
        this.cutoffDto = cutoffDto;
    }

    public PaidHolidayDtoInterface getPaidHolidayDto() {
        return this.paidHolidayDto;
    }

    public void setPaidHolidayDto(PaidHolidayDtoInterface paidHolidayDto) {
        this.paidHolidayDto = paidHolidayDto;
    }
}

