/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.dao.settings.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.time.dao.settings.ScheduleDaoInterface;
import jp.mosp.time.dto.settings.ScheduleDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmScheduleDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class TmmScheduleDao
extends PlatformDao
implements ScheduleDaoInterface {
    public static final String TABLE = "tmm_schedule";
    public static final String COL_TMM_SCHEDULE_ID = "tmm_schedule_id";
    public static final String COL_SCHEDULE_CODE = "schedule_code";
    public static final String COL_ACTIVATE_DATE = "activate_date";
    public static final String COL_SCHEDULE_NAME = "schedule_name";
    public static final String COL_SCHEDULE_ABBR = "schedule_abbr";
    public static final String COL_FISCAL_YEAR = "fiscal_year";
    public static final String COL_PATTERN_CODE = "pattern_code";
    public static final String COL_WORK_TYPE_CHANGE_FLAG = "work_type_change_flag";
    public static final String COL_INACTIVATE_FLAG = "inactivate_flag";
    public static final String KEY_1 = "tmm_schedule_id";

    public void initDao() {
    }

    public BaseDto mapping() throws MospException {
        TmmScheduleDto dto = new TmmScheduleDto();
        dto.setTmmScheduleId(this.getLong("tmm_schedule_id"));
        dto.setScheduleCode(this.getString("schedule_code"));
        dto.setActivateDate(this.getDate("activate_date"));
        dto.setScheduleName(this.getString("schedule_name"));
        dto.setScheduleAbbr(this.getString("schedule_abbr"));
        dto.setFiscalYear(this.getInt("fiscal_year"));
        dto.setPatternCode(this.getString("pattern_code"));
        dto.setWorkTypeChangeFlag(this.getInt("work_type_change_flag"));
        dto.setInactivateFlag(this.getInt("inactivate_flag"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<ScheduleDtoInterface> mappingAll() throws MospException {
        ArrayList<ScheduleDtoInterface> all = new ArrayList<ScheduleDtoInterface>();
        while (this.next()) {
            all.add((ScheduleDtoInterface)this.mapping());
        }
        return all;
    }

    public List<ScheduleDtoInterface> findForActivateDate(Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmScheduleDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmScheduleDao.and());
            sb.append("inactivate_flag");
            sb.append(" = ");
            sb.append(0);
            sb.append(" ");
            sb.append(TmmScheduleDao.and());
            sb.append(this.getQueryForMaxActivateDate());
            sb.append(TmmScheduleDao.getOrderByColumn((String)"schedule_code"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<ScheduleDtoInterface> findForHistory(String scheduleCode) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmScheduleDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmScheduleDao.and());
            sb.append(TmmScheduleDao.equal((String)"schedule_code"));
            sb.append(TmmScheduleDao.getOrderByColumn((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, scheduleCode);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public ScheduleDtoInterface findForKey(String scheduleCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmScheduleDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmScheduleDao.and());
            sb.append(TmmScheduleDao.equal((String)"schedule_code"));
            sb.append(TmmScheduleDao.and());
            sb.append(TmmScheduleDao.equal((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, scheduleCode);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            ScheduleDtoInterface dto = null;
            if (this.next()) {
                dto = (ScheduleDtoInterface)this.mapping();
            }
            ScheduleDtoInterface scheduleDtoInterface = dto;
            return scheduleDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public ScheduleDtoInterface findForInfo(String scheduleCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmScheduleDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmScheduleDao.and());
            sb.append(TmmScheduleDao.equal((String)"schedule_code"));
            sb.append(TmmScheduleDao.and());
            sb.append("activate_date");
            sb.append(" <= ? ");
            sb.append(TmmScheduleDao.getOrderByColumnDescLimit1((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, scheduleCode);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            ScheduleDtoInterface dto = null;
            if (this.next()) {
                dto = (ScheduleDtoInterface)this.mapping();
            }
            ScheduleDtoInterface scheduleDtoInterface = dto;
            return scheduleDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<ScheduleDtoInterface> findForSearch(Map<String, Object> param) throws MospException {
        try {
            Date activateDate = (Date)param.get("activateDate");
            String scheduleCode = String.valueOf(param.get("scheduleCode"));
            String scheduleName = String.valueOf(param.get("scheduleName"));
            String scheduleAbbr = String.valueOf(param.get("scheduleAbbr"));
            String fiscalYear = String.valueOf(param.get("fiscalYear"));
            String inactivateFlag = String.valueOf(param.get("inactivateFlag"));
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmScheduleDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmScheduleDao.and());
            sb.append(TmmScheduleDao.like((String)"schedule_code"));
            sb.append(TmmScheduleDao.and());
            sb.append(TmmScheduleDao.like((String)"schedule_name"));
            sb.append(TmmScheduleDao.and());
            sb.append(TmmScheduleDao.like((String)"schedule_abbr"));
            if (activateDate != null) {
                sb.append(TmmScheduleDao.and());
                sb.append(this.getQueryForMaxActivateDate());
            }
            if (!fiscalYear.isEmpty()) {
                sb.append(TmmScheduleDao.and());
                sb.append(TmmScheduleDao.equal((String)"fiscal_year"));
            }
            if (!inactivateFlag.isEmpty()) {
                sb.append(TmmScheduleDao.and());
                sb.append(TmmScheduleDao.equal((String)"inactivate_flag"));
            }
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, TmmScheduleDao.startWithParam((String)scheduleCode));
            this.setParam(this.index++, TmmScheduleDao.containsParam((String)scheduleName));
            this.setParam(this.index++, TmmScheduleDao.containsParam((String)scheduleAbbr));
            if (activateDate != null) {
                this.setParam(this.index++, activateDate);
            }
            if (!fiscalYear.isEmpty()) {
                this.setParam(this.index++, Integer.parseInt(fiscalYear));
            }
            if (!inactivateFlag.isEmpty()) {
                this.setParam(this.index++, Integer.parseInt(inactivateFlag));
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            ScheduleDtoInterface dto = (ScheduleDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmmScheduleId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            ScheduleDtoInterface dto = (ScheduleDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmmScheduleId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        ScheduleDtoInterface dto = (ScheduleDtoInterface)baseDto;
        this.setParam(this.index++, dto.getTmmScheduleId());
        this.setParam(this.index++, dto.getScheduleCode());
        this.setParam(this.index++, dto.getActivateDate());
        this.setParam(this.index++, dto.getScheduleName());
        this.setParam(this.index++, dto.getScheduleAbbr());
        this.setParam(this.index++, dto.getFiscalYear());
        this.setParam(this.index++, dto.getPatternCode());
        this.setParam(this.index++, dto.getWorkTypeChangeFlag());
        this.setParam(this.index++, dto.getInactivateFlag());
        this.setCommonParams(baseDto, isInsert);
    }

    public Map<String, Object> getParamsMap() {
        return new HashMap<String, Object>();
    }

    public StringBuffer getQueryForMaxActivateDate() {
        StringBuffer sb = new StringBuffer();
        sb.append("activate_date");
        sb.append(" IN (SELECT ");
        sb.append("MAX(activate_date)");
        sb.append(TmmScheduleDao.from((String)"tmm_schedule") + " AS A ");
        sb.append(TmmScheduleDao.where());
        sb.append("tmm_schedule.schedule_code");
        sb.append(" = A.schedule_code");
        sb.append(TmmScheduleDao.and());
        sb.append(this.deleteFlagOff());
        sb.append(TmmScheduleDao.and());
        sb.append("activate_date");
        sb.append(" <= ?");
        sb.append(")");
        return sb;
    }
}

