/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.calculation.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.comparator.base.EmployeeCodeComparator;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.base.TotalTimeBaseAction;
import jp.mosp.time.bean.SubordinateSearchBeanInterface;
import jp.mosp.time.bean.TotalTimeCalcBeanInterface;
import jp.mosp.time.bean.TotalTimeSearchBeanInterface;
import jp.mosp.time.calculation.action.TotalTimeCardAction;
import jp.mosp.time.calculation.vo.TotalTimeListVo;
import jp.mosp.time.dto.settings.SubordinateListDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDtoInterface;
import jp.mosp.time.input.action.AttendanceHistoryAction;

public class TotalTimeListAction
extends TotalTimeBaseAction {
    public static final String CMD_SELECT_SHOW = "TM3121";
    public static final String CMD_SEARCH = "TM3122";
    public static final String CMD_RE_SHOW = "TM3123";
    public static final String CMD_TEMPORARY_TIGHTENING = "TM3124";
    public static final String CMD_TRANSFER = "TM3125";
    public static final String CMD_CALC = "TM3126";
    public static final String CMD_RELEASE = "TM3127";
    public static final String CMD_SORT = "TM3128";
    public static final String CMD_PAGE = "TM3129";
    public static final String CMD_OUTPUT_FORMS = "TM3176";

    public TotalTimeListAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new TotalTimeListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo();
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.reShow();
        } else if (this.mospParams.getCommand().equals(CMD_TEMPORARY_TIGHTENING)) {
            this.prepareVo();
            this.batchTightening();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_CALC)) {
            this.prepareVo();
            this.calc();
        } else if (this.mospParams.getCommand().equals(CMD_RELEASE)) {
            this.prepareVo();
            this.batchRelease();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_OUTPUT_FORMS)) {
            this.prepareVo();
            this.outputAttendanceBooks();
        }
    }

    protected void show() throws MospException {
        TotalTimeListVo vo = (TotalTimeListVo)this.mospParams.getVo();
        this.setDefaultValues();
        this.getTransferredCutoffParams();
        this.setCutoffInfo();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.setPulldown();
        vo.setComparatorName(EmployeeCodeComparator.class.getName());
    }

    protected void reShow() throws MospException {
        this.setCutoffInfo();
        this.search();
    }

    protected void search() throws MospException {
        TotalTimeListVo vo = (TotalTimeListVo)this.mospParams.getVo();
        TotalTimeSearchBeanInterface search = this.timeReference().totalTimeSearch();
        this.checkSearchCondition(new String[]{vo.getTxtEditFromEmployeeCode(), vo.getTxtEditToEmployeeCode(), vo.getTxtEditEmployeeName(), vo.getPltEditWorkPlace(), vo.getPltEditEmployment(), vo.getPltEditSection(), vo.getPltEditPosition(), vo.getPltEditApproval(), vo.getPltEditCalc()});
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        search.setTargetYear(vo.getTargetYear());
        search.setTargetMonth(vo.getTargetMonth());
        search.setFromEmployeeCode(vo.getTxtEditFromEmployeeCode());
        search.setToEmployeeCode(vo.getTxtEditToEmployeeCode());
        search.setEmployeeName(vo.getTxtEditEmployeeName());
        search.setWorkPlaceCode(vo.getPltEditWorkPlace());
        search.setEmploymentContractCode(vo.getPltEditEmployment());
        search.setSectionCode(vo.getPltEditSection());
        search.setPositionCode(vo.getPltEditPosition());
        search.setApproval(vo.getPltEditApproval());
        search.setApprovalBeforeDay(vo.getCkbYesterday());
        search.setCalc(vo.getPltEditCalc());
        search.setCutoffCode(vo.getCutoffCode());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(EmployeeCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty()) {
            this.addNoSearchResultMessage();
        }
        this.setCheckOff();
        TotalTimeDtoInterface totalTimeDto = this.timeReference().totalTimeTransaction().findForKey(vo.getTargetYear(), vo.getTargetMonth(), vo.getCutoffCode());
        if (totalTimeDto == null) {
            return;
        }
        vo.setJsCutoffState(Integer.toString(totalTimeDto.getCutoffState()));
    }

    protected void transfer() throws MospException {
        TotalTimeListVo vo = (TotalTimeListVo)this.mospParams.getVo();
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(this.getSelectedPersonalId(this.getTransferredIndex()));
        if (actionName.equals(AttendanceHistoryAction.class.getName())) {
            this.setTargetDate(MonthUtility.getYearMonthDate((int)vo.getTargetYear(), (int)vo.getTargetMonth()));
            this.mospParams.setNextCommand("TM1921");
        } else if (actionName.equals(TotalTimeCardAction.class.getName())) {
            this.setTargetCutoffCode(vo.getCutoffCode());
            this.setTargetYear(vo.getTargetYear());
            this.setTargetMonth(vo.getTargetMonth());
            this.mospParams.setNextCommand("TM3131");
        }
    }

    protected void batchTightening() throws MospException {
        TotalTimeListVo vo = (TotalTimeListVo)this.mospParams.getVo();
        int targetYear = vo.getTargetYear();
        int targetMonth = vo.getTargetMonth();
        String[] aryPersonalId = this.getSelectedPersonalIds(vo.getCkbSelect());
        String cutoffCode = vo.getCutoffCode();
        TotalTimeCalcBeanInterface calc = this.time().totalTimeCalc();
        List list = calc.tightening(aryPersonalId, targetYear, targetMonth, cutoffCode);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        if (!list.isEmpty()) {
            this.mospParams.addGeneralParam("TotalTimeError", (Object)list);
            this.mospParams.addGeneralParam("transferredGenericCode", (Object)cutoffCode);
            this.mospParams.addGeneralParam("transferredYear", (Object)targetYear);
            this.mospParams.addGeneralParam("transferredMonth", (Object)targetMonth);
            this.mospParams.setNextCommand("TM3140");
            return;
        }
        this.commit();
        this.addTighteningMessage();
        this.setCheckOff();
        this.search();
    }

    protected void calc() throws MospException {
        TotalTimeListVo vo = (TotalTimeListVo)this.mospParams.getVo();
        SubordinateSearchBeanInterface search = this.timeReference().subordinateSearch();
        TotalTimeCalcBeanInterface total = this.time().totalTimeCalc();
        List list = this.getSelectedListDto();
        for (SubordinateListDtoInterface dto : list) {
            String personalId = dto.getPersonalId();
            int targetYear = dto.getTargetYear();
            int targetMonth = dto.getTargetMonth();
            TotalTimeDataDtoInterface totalTimeDataDto = total.calc(personalId, targetYear, targetMonth, true);
            search.setTotalTimeData(dto, totalTimeDataDto);
        }
        vo.setList(list);
        vo.setComparatorName(EmployeeCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        this.setCheckOff();
        if (list.isEmpty()) {
            this.addNoSearchResultMessage();
        }
    }

    protected void batchRelease() throws MospException {
        TotalTimeListVo vo = (TotalTimeListVo)this.mospParams.getVo();
        String[] aryPersonalId = this.getSelectedPersonalIds(vo.getCkbSelect());
        int targetYear = vo.getTargetYear();
        int targetMonth = vo.getTargetMonth();
        String cutoffCode = vo.getCutoffCode();
        ArrayList<String> targetPersonalIdList = new ArrayList<String>();
        for (String personalId : aryPersonalId) {
            Integer state = this.timeReference().totalTimeEmployeeTransaction().getCutoffState(personalId, targetYear, targetMonth);
            if (state == null || state != 1) continue;
            targetPersonalIdList.add(personalId);
        }
        if (targetPersonalIdList.isEmpty()) {
            return;
        }
        this.time().totalLeaveRegist().delete(targetPersonalIdList, targetYear, targetMonth);
        this.time().totalOtherVacationRegist().delete(targetPersonalIdList, targetYear, targetMonth);
        this.time().totalAbsenceRegist().delete(targetPersonalIdList, targetYear, targetMonth);
        this.time().totalTimeRegist().delete(targetPersonalIdList, targetYear, targetMonth);
        this.time().totalTimeCorrectionRegist().delete(targetPersonalIdList, targetYear, targetMonth);
        this.time().totalTimeEmployeeTransactionRegist().draftRelease(targetPersonalIdList, targetYear, targetMonth, cutoffCode);
        TotalTimeDtoInterface totalTimeDto = this.timeReference().totalTimeTransaction().findForKey(targetYear, targetMonth, cutoffCode);
        if (totalTimeDto != null) {
            int cutoffState = totalTimeDto.getCutoffState();
            if (cutoffState == 1) {
                totalTimeDto.setCutoffState(0);
                this.time().totalTimeTransactionRegist().draftRelease(totalTimeDto);
            } else if (cutoffState == 2) {
                return;
            }
        }
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addReleaseMessage();
        this.setCheckOff();
        this.search();
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    public void setDefaultValues() {
        TotalTimeListVo vo = (TotalTimeListVo)this.mospParams.getVo();
        vo.setTxtEditFromEmployeeCode("");
        vo.setTxtEditToEmployeeCode("");
        vo.setTxtEditEmployeeName("");
        vo.setJsCutoffState("");
        vo.setCkbYesterday("0");
        vo.setJsSearchConditionRequired(this.isSearchConditionRequired());
    }

    private void setPulldown() throws MospException {
        TotalTimeListVo vo = (TotalTimeListVo)this.mospParams.getVo();
        Date targetDate = MonthUtility.getYearMonthTargetDate((int)vo.getTargetYear(), (int)vo.getTargetMonth(), (MospParams)this.mospParams);
        String[][] aryWorkPlace = this.reference().workPlace().getNameSelectArray(targetDate, true, null);
        String[][] aryEmployment = this.reference().employmentContract().getNameSelectArray(targetDate, true, null);
        String[][] arySection = this.reference().section().getCodedSelectArray(targetDate, true, null);
        String[][] aryPosition = this.reference().position().getCodedSelectArray(targetDate, true, null);
        vo.setAryPltEditWorkPlace(aryWorkPlace);
        vo.setAryPltEditEmployment(aryEmployment);
        vo.setAryPltEditSection(arySection);
        vo.setAryPltEditPosition(aryPosition);
        vo.setAryPltEditApproval(this.getCodeArray("NotApproved", true));
        vo.setAryPltEditCalc(this.getCodeArray("CutoffState", true));
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        TotalTimeListVo vo = (TotalTimeListVo)this.mospParams.getVo();
        Date cutoffTargetDate = vo.getCutoffTermTargetDate();
        String[] aryPersonalId = new String[list.size()];
        String[] aryLblEmployeeCode = new String[list.size()];
        String[] aryLblEmployeeName = new String[list.size()];
        String[] aryLblSection = new String[list.size()];
        String[] aryLblWorkDate = new String[list.size()];
        String[] aryLblPaidHoliday = new String[list.size()];
        String[] aryLblAllHoliday = new String[list.size()];
        String[] aryLblAbsence = new String[list.size()];
        String[] aryLblWorkTime = new String[list.size()];
        String[] aryLblRestTime = new String[list.size()];
        String[] aryLblPrivateTime = new String[list.size()];
        String[] aryLblLateTime = new String[list.size()];
        String[] aryLblLeaveEarlyTime = new String[list.size()];
        String[] aryLblLateLeaveEarlyTime = new String[list.size()];
        String[] aryLblOverTimeIn = new String[list.size()];
        String[] aryLblOverTimeOut = new String[list.size()];
        String[] aryLblWorkOnHolidayTime = new String[list.size()];
        String[] aryLblLateNightTime = new String[list.size()];
        String[] aryLblApploval = new String[list.size()];
        String[] aryLblCalc = new String[list.size()];
        String[] aryLblCorrection = new String[list.size()];
        String[] claApploval = new String[list.size()];
        String[] claCalc = new String[list.size()];
        boolean[] aryNeedDetail = new boolean[list.size()];
        SectionReferenceBeanInterface getSection = this.reference().section();
        for (int i = 0; i < list.size(); ++i) {
            SubordinateListDtoInterface dto = (SubordinateListDtoInterface)list.get(i);
            aryPersonalId[i] = dto.getPersonalId();
            aryLblEmployeeCode[i] = dto.getEmployeeCode();
            aryLblEmployeeName[i] = this.getLastFirstName(dto.getLastName(), dto.getFirstName());
            aryLblSection[i] = getSection.getSectionAbbr(dto.getSectionCode(), cutoffTargetDate);
            aryLblWorkDate[i] = this.getNumberString(dto.getWorkDate(), 1);
            aryLblPaidHoliday[i] = this.getNumberString(dto.getPaidHoliday(), 1);
            aryLblAllHoliday[i] = this.getNumberString(dto.getAllHoliday(), 1);
            aryLblAbsence[i] = this.getNumberString(dto.getAbsence(), 1);
            aryLblWorkTime[i] = this.toTimeDotFormatString(dto.getWorkTime());
            aryLblRestTime[i] = this.toTimeDotFormatString(dto.getRestTime());
            aryLblPrivateTime[i] = this.toTimeDotFormatString(dto.getPrivateTime());
            aryLblLateTime[i] = this.toTimeDotFormatString(dto.getLateTime());
            aryLblLeaveEarlyTime[i] = this.toTimeDotFormatString(dto.getLeaveEarlyTime());
            aryLblLateLeaveEarlyTime[i] = this.toTimeDotFormatString(dto.getLateLeaveEarlyTime());
            aryLblOverTimeIn[i] = this.toTimeDotFormatString(dto.getOverTimeIn());
            aryLblOverTimeOut[i] = this.toTimeDotFormatString(dto.getOverTimeOut());
            aryLblWorkOnHolidayTime[i] = this.toTimeDotFormatString(dto.getWorkOnHolidayTime());
            aryLblLateNightTime[i] = this.toTimeDotFormatString(dto.getLateNightTime());
            aryLblApploval[i] = dto.getApproval();
            claApploval[i] = dto.getApprovalStateClass();
            aryLblCalc[i] = dto.getCalc();
            claCalc[i] = dto.getCutoffStateClass();
            aryLblCorrection[i] = dto.getCorrection();
            aryNeedDetail[i] = dto.getCutoffState() != 0;
        }
        vo.setAryPersonalId(aryPersonalId);
        vo.setAryLblEmployeeCode(aryLblEmployeeCode);
        vo.setAryLblEmployeeName(aryLblEmployeeName);
        vo.setAryLblSection(aryLblSection);
        vo.setAryLblWorkDate(aryLblWorkDate);
        vo.setAryLblWorkTime(aryLblWorkTime);
        vo.setAryLblRestTime(aryLblRestTime);
        vo.setAryLblPrivateTime(aryLblPrivateTime);
        vo.setAryLblLateTime(aryLblLateTime);
        vo.setAryLblLeaveEarlyTime(aryLblLeaveEarlyTime);
        vo.setAryLblLateLeaveEarlyTime(aryLblLateLeaveEarlyTime);
        vo.setAryLblOverTimeIn(aryLblOverTimeIn);
        vo.setAryLblOverTimeOut(aryLblOverTimeOut);
        vo.setAryLblWorkOnHolidayTime(aryLblWorkOnHolidayTime);
        vo.setAryLblLateNightTime(aryLblLateNightTime);
        vo.setAryLblPaidHoliday(aryLblPaidHoliday);
        vo.setAryLblAllHoliday(aryLblAllHoliday);
        vo.setAryLblAbsence(aryLblAbsence);
        vo.setAryLblApploval(aryLblApploval);
        vo.setAryLblCalc(aryLblCalc);
        vo.setAryLblCorrection(aryLblCorrection);
        vo.setClaApploval(claApploval);
        vo.setClaCalc(claCalc);
        vo.setAryNeedDetail(aryNeedDetail);
    }

    protected void setDtoFields(TotalTimeDtoInterface dto) throws MospException {
        TotalTimeListVo vo = (TotalTimeListVo)this.mospParams.getVo();
        dto.setCalculationYear(vo.getTargetYear());
        dto.setCalculationMonth(vo.getTargetMonth());
        dto.setCutoffCode(vo.getCutoffCode());
        dto.setCalculationDate(vo.getCalculationDate());
        dto.setCutoffState(0);
    }

    protected void setCheckOff() {
        TotalTimeListVo vo = (TotalTimeListVo)this.mospParams.getVo();
        vo.setCkbSelect(new String[0]);
    }

    protected void outputAttendanceBooks() throws MospException {
        TotalTimeListVo vo = (TotalTimeListVo)this.mospParams.getVo();
        String[] personalIds = this.getSelectedPersonalIds(vo.getCkbSelect());
        this.timeReference().attendanceBook().makeAttendanceBooks(personalIds, vo.getTargetYear(), vo.getTargetMonth());
        if (this.mospParams.hasErrorMessage()) {
            this.addNoSearchResultMessage();
        }
    }

    protected List<SubordinateListDtoInterface> getSelectedListDto() {
        TotalTimeListVo vo = (TotalTimeListVo)this.mospParams.getVo();
        ArrayList<SubordinateListDtoInterface> selectedList = new ArrayList<SubordinateListDtoInterface>();
        for (String idx : vo.getCkbSelect()) {
            selectedList.add((SubordinateListDtoInterface)this.getSelectedListDto(idx));
        }
        return selectedList;
    }
}

