/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.calculation.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.utils.PlatformNamingUtility;
import jp.mosp.time.base.TotalTimeBaseAction;
import jp.mosp.time.bean.TotalTimeCorrectionRegistBeanInterface;
import jp.mosp.time.bean.TotalTimeRegistBeanInterface;
import jp.mosp.time.calculation.vo.TotalTimeCardVo;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.TotalAbsenceDtoInterface;
import jp.mosp.time.dto.settings.TotalLeaveDtoInterface;
import jp.mosp.time.dto.settings.TotalOtherVacationDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeCorrectionDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdTotalAbsenceDto;
import jp.mosp.time.dto.settings.impl.TmdTotalLeaveDto;
import jp.mosp.time.dto.settings.impl.TmdTotalOtherVacationDto;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeUtility;

public class TotalTimeCardAction
extends TotalTimeBaseAction {
    public static final String CMD_SELECT_SHOW = "TM3131";
    public static final String CMD_RE_SHOW = "TM3132";
    public static final String CMD_UPDATE = "TM3133";
    public static final String CMD_INSERT = "TM3135";

    public TotalTimeCardAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new TotalTimeCardVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.reShow();
        } else if (this.mospParams.getCommand().equals(CMD_UPDATE)) {
            this.prepareVo(true, false);
            this.changeMode();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT)) {
            this.prepareVo();
            this.regist();
        }
    }

    protected void show() throws MospException {
        TotalTimeCardVo vo = (TotalTimeCardVo)this.mospParams.getVo();
        String personalId = this.getTargetPersonalId();
        this.getCutoffParams();
        this.setCutoffInfo();
        String cutoffCode = vo.getCutoffCode();
        int targetYear = vo.getTargetYear();
        int targetMonth = vo.getTargetMonth();
        this.setEmployeeInfo(personalId, vo.getCutoffTermTargetDate());
        this.setDefaultValues();
        this.setCorrectionVoFields();
        vo.setModeCardEdit("insert");
        int state = this.timeReference().totalTimeTransaction().getStoredCutoffState(targetYear, targetMonth, cutoffCode);
        vo.setTightened(state == 2);
    }

    protected void reShow() throws MospException {
        this.setCutoffInfo();
        this.setDefaultValues();
        this.setCorrectionVoFields();
        TotalTimeCardVo vo = (TotalTimeCardVo)this.mospParams.getVo();
        vo.setModeCardEdit("insert");
    }

    protected void changeMode() throws MospException {
        TotalTimeCardVo vo = (TotalTimeCardVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            vo.setModeCardEdit("edit");
        } else if (vo.getModeCardEdit().equals("edit")) {
            vo.setModeCardEdit("insert");
            this.setDefaultValues();
        }
    }

    protected void regist() throws MospException {
        boolean isHour;
        boolean isDay;
        List list;
        TmdTotalLeaveDto dto;
        int i;
        TotalTimeCardVo vo = (TotalTimeCardVo)this.mospParams.getVo();
        TotalTimeRegistBeanInterface registTotalTime = this.time().totalTimeRegist();
        TotalTimeCorrectionRegistBeanInterface correctionRegist = this.time().totalTimeCorrectionRegist();
        String personalId = vo.getPersonalId();
        int targetYear = vo.getTargetYear();
        int targetMonth = vo.getTargetMonth();
        TotalTimeDataDtoInterface oldTotalTimeDto = this.timeReference().totalTime().findForKey(personalId, targetYear, targetMonth);
        List oldTotalLeaveList = this.timeReference().totalLeave().getTotalLeaveList(personalId, targetYear, targetMonth);
        List oldTotalOtherVacationList = this.timeReference().totalOtherVacation().getTotalOtherVacationList(personalId, targetYear, targetMonth);
        List oldTotalAbsenceList = this.timeReference().totalAbsence().getTotalAbsenceList(personalId, targetYear, targetMonth);
        TotalTimeDataDtoInterface workTimeDto = registTotalTime.getInitDto();
        this.setDtoWorkTimeFields(workTimeDto);
        for (i = 0; i < vo.getAryTxtTimesSpecialLeave().length; ++i) {
            dto = new TmdTotalLeaveDto();
            dto.setPersonalId(workTimeDto.getPersonalId());
            dto.setCalculationYear(workTimeDto.getCalculationYear());
            dto.setCalculationMonth(workTimeDto.getCalculationMonth());
            this.setDtoSpecial((TotalLeaveDtoInterface)dto, i);
            this.time().totalLeaveRegist().regist((TotalLeaveDtoInterface)dto);
        }
        for (i = 0; i < vo.getAryTxtTimesOtherVacation().length; ++i) {
            dto = new TmdTotalOtherVacationDto();
            dto.setPersonalId(workTimeDto.getPersonalId());
            dto.setCalculationYear(workTimeDto.getCalculationYear());
            dto.setCalculationMonth(workTimeDto.getCalculationMonth());
            this.setDtoOther((TotalOtherVacationDtoInterface)dto, i);
            this.time().totalOtherVacationRegist().regist((TotalOtherVacationDtoInterface)dto);
        }
        for (i = 0; i < vo.getAryTxtDeduction().length; ++i) {
            dto = new TmdTotalAbsenceDto();
            dto.setPersonalId(workTimeDto.getPersonalId());
            dto.setCalculationYear(workTimeDto.getCalculationYear());
            dto.setCalculationMonth(workTimeDto.getCalculationMonth());
            this.setDtoAbsence((TotalAbsenceDtoInterface)dto, i);
            this.time().totalAbsenceRegist().regist((TotalAbsenceDtoInterface)dto);
        }
        registTotalTime.update(workTimeDto);
        TotalTimeCorrectionDtoInterface totalTimeCorrectionDto = correctionRegist.getInitDto();
        this.setTotalTimeCorrectionDtoFields(totalTimeCorrectionDto);
        correctionRegist.insertTotalTime(totalTimeCorrectionDto, oldTotalTimeDto, workTimeDto);
        for (TotalLeaveDtoInterface oldDto : oldTotalLeaveList) {
            list = this.timeReference().totalLeave().getTotalLeaveList(personalId, targetYear, targetMonth);
            for (TotalLeaveDtoInterface newDto : list) {
                isDay = false;
                isHour = false;
                if (!oldDto.getHolidayCode().equals(newDto.getHolidayCode())) continue;
                if (oldDto.getTimes() != newDto.getTimes()) {
                    isDay = true;
                }
                if (oldDto.getHours() != newDto.getHours()) {
                    isHour = true;
                }
                if (!isDay && !isHour) continue;
                correctionRegist.insertLeave(totalTimeCorrectionDto, oldDto, newDto, isDay, isHour);
            }
        }
        for (TotalLeaveDtoInterface oldDto : oldTotalOtherVacationList) {
            list = this.timeReference().totalOtherVacation().getTotalOtherVacationList(personalId, targetYear, targetMonth);
            for (TotalLeaveDtoInterface newDto : list) {
                isDay = false;
                isHour = false;
                if (!oldDto.getHolidayCode().equals(newDto.getHolidayCode())) continue;
                if (oldDto.getTimes() != newDto.getTimes()) {
                    isDay = true;
                }
                if (oldDto.getHours() != newDto.getHours()) {
                    isHour = true;
                }
                if (!isDay && !isHour) continue;
                correctionRegist.insertOtherVacation(totalTimeCorrectionDto, (TotalOtherVacationDtoInterface)oldDto, (TotalOtherVacationDtoInterface)newDto, isDay, isHour);
            }
        }
        for (TotalLeaveDtoInterface oldDto : oldTotalAbsenceList) {
            list = this.timeReference().totalAbsence().getTotalAbsenceList(personalId, targetYear, targetMonth);
            for (TotalLeaveDtoInterface newDto : list) {
                isDay = false;
                isHour = false;
                if (!oldDto.getAbsenceCode().equals(newDto.getAbsenceCode())) continue;
                if (oldDto.getTimes() != newDto.getTimes()) {
                    isDay = true;
                }
                if (oldDto.getHours() != newDto.getHours()) {
                    isHour = true;
                }
                if (!isDay && !isHour) continue;
                correctionRegist.insertAbsence(totalTimeCorrectionDto, (TotalAbsenceDtoInterface)oldDto, (TotalAbsenceDtoInterface)newDto, isDay, isHour);
            }
        }
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertMessage();
        this.setVoWorkTimeFields(workTimeDto);
        this.setLeaveVoFields();
        this.setCorrectionVoFields();
    }

    public void setDefaultValues() throws MospException {
        TotalTimeCardVo vo = (TotalTimeCardVo)this.mospParams.getVo();
        int targetYear = vo.getTargetYear();
        int targetMonth = vo.getTargetMonth();
        vo.setLblMonth(targetYear + this.mospParams.getName("Year") + targetMonth + this.mospParams.getName("Month"));
        vo.setLblCorrectionHistory("");
        vo.setTxtCorrectionReason("");
        TotalTimeDataDtoInterface totalTimeDto = this.timeReference().totalTime().findForKey(vo.getPersonalId(), targetYear, targetMonth);
        if (totalTimeDto != null) {
            this.setVoWorkTimeFields(totalTimeDto);
        }
        this.setLeaveVoFields();
    }

    protected void setDtoWorkTimeFields(TotalTimeDataDtoInterface dto) throws MospException {
        TotalTimeCardVo vo = (TotalTimeCardVo)this.mospParams.getVo();
        dto.setTmdTotalTimeId(vo.getTmdTotalTimeId());
        dto.setPersonalId(vo.getPersonalId());
        dto.setCalculationYear(vo.getTargetYear());
        dto.setCalculationMonth(vo.getTargetMonth());
        dto.setCalculationDate(vo.getCalculationDate());
        dto.setDecreaseTime(this.getTimeValue(vo.getTxtDecreaseTimeHour(), vo.getTxtDecreaseTimeMinute()));
        dto.setDirectStart(this.getInt(vo.getTxtTimesNonstop()));
        dto.setDirectEnd(this.getInt(vo.getTxtTimesNoreturn()));
        dto.setFortyFiveHourOvertime(this.getTimeValue(vo.getTxt45HourOverTimeHour(), vo.getTxt45HourOverTimeMinute()));
        dto.setLateDays(this.getInt(vo.getTxtLateDays()));
        dto.setLateThirtyMinutesOrMore(this.getInt(vo.getTxtLateThirtyMinutesOrMore()));
        dto.setLateLessThanThirtyMinutes(this.getInt(vo.getTxtLateLessThanThirtyMinutes()));
        dto.setLateNight(this.getTimeValue(vo.getTxtLateNightHour(), vo.getTxtLateNightMinute()));
        dto.setLateTime(this.getTimeValue(vo.getTxtLateTimeHour(), vo.getTxtLateTimeMinute()));
        dto.setLateThirtyMinutesOrMoreTime(this.getTimeValue(vo.getTxtLateThirtyMinutesOrMoreTimeHour(), vo.getTxtLateThirtyMinutesOrMoreTimeMinute()));
        dto.setLateLessThanThirtyMinutesTime(this.getTimeValue(vo.getTxtLateLessThanThirtyMinutesTimeHour(), vo.getTxtLateLessThanThirtyMinutesTimeMinute()));
        dto.setLeaveEarlyDays(this.getInt(vo.getTxtLeaveEarlyDays()));
        dto.setLeaveEarlyThirtyMinutesOrMore(this.getInt(vo.getTxtLeaveEarlyThirtyMinutesOrMore()));
        dto.setLeaveEarlyLessThanThirtyMinutes(this.getInt(vo.getTxtLeaveEarlyLessThanThirtyMinutes()));
        dto.setLegalWorkOnHoliday(this.getDouble(vo.getTxtLegalWorkOnHoliday()));
        dto.setPaidHolidayHour(this.getInt(vo.getTxtPaidholidayHour()));
        dto.setPrivateTime(this.getTimeValue(vo.getTxtPrivateHour(), vo.getTxtPrivateMinute()));
        dto.setPublicTime(this.getTimeValue(vo.getTxtPublicHour(), vo.getTxtPublicMinute()));
        dto.setMinutelyHolidayATime(this.getTimeValue(vo.getTxtMinutelyHolidayAHour(), vo.getTxtMinutelyHolidayAMinute()));
        dto.setMinutelyHolidayBTime(this.getTimeValue(vo.getTxtMinutelyHolidayBHour(), vo.getTxtMinutelyHolidayBMinute()));
        dto.setRestTime(this.getTimeValue(vo.getTxtRestTimeHour(), vo.getTxtRestTimeMinute()));
        dto.setRestLateNight(this.getTimeValue(vo.getTxtRestLateNightHour(), vo.getTxtRestLateNightMinute()));
        dto.setRestWorkOnSpecificHoliday(this.getTimeValue(vo.getTxtRestWorkOnSpecificHour(), vo.getTxtRestWorkOnSpecificMinute()));
        dto.setRestWorkOnHoliday(this.getTimeValue(vo.getTxtRestWorkOnLegalHour(), vo.getTxtRestWorkOnLegalMinute()));
        dto.setOvertime(this.getTimeValue(vo.getTxtOverTimeHour(), vo.getTxtOverTimeMinute()));
        dto.setOvertimeIn(this.getTimeValue(vo.getTxtOverTimeInHour(), vo.getTxtOverTimeInMinute()));
        dto.setOvertimeOut(this.getTimeValue(vo.getTxtOverTimeOutHour(), vo.getTxtOverTimeOutMinute()));
        dto.setSixtyHourOvertime(this.getTimeValue(vo.getTxt60HourOverTimeHour(), vo.getTxt60HourOverTimeMinute()));
        dto.setSpecificOvertime(this.getTimeValue(vo.getTxtSpecificOverTimeHour(), vo.getTxtSpecificOverTimeMiunte()));
        dto.setSpecificWorkOnHoliday(this.getDouble(vo.getTxtSpecificWorkOnHoliday()));
        dto.setTimesAlternative(this.getDouble(vo.getTxtTimesAlternative()));
        dto.setTimesCompensation(this.getDouble(vo.getTxtTimesCompensation()));
        dto.setTimesHoliday(this.getInt(vo.getTxtTimesHoliday()));
        dto.setTimesLate(this.getInt(vo.getTxtLateDays()));
        dto.setTimesLateCompensation(this.getDouble(vo.getTxtTimesLateCompensation()));
        dto.setTimesLeaveEarly(this.getInt(vo.getTxtLeaveEarlyDays()));
        dto.setTimesLegalCompensation(this.getDouble(vo.getTxtTimesLegalCompensation()));
        dto.setTimesLegalHoliday(this.getInt(vo.getTxtTimesLegalHoliday()));
        dto.setTimesPaidHoliday(this.getDouble(vo.getTxtTimesPaidHoliday()));
        dto.setTimesSpecificCompensation(this.getDouble(vo.getTxtTimesSpecificCompensation()));
        dto.setTimesSpecificHoliday(this.getInt(vo.getTxtTimesSpecificHoliday()));
        dto.setTimesStockHoliday(this.getDouble(vo.getTxtTimesStockHoliday()));
        dto.setTimesHolidaySubstitute(this.getDouble(vo.getTxtTimesSubstitute()));
        dto.setTimesWork(this.getInt(vo.getTxtTimesWork()));
        dto.setTimesWorkDate(this.getDouble(vo.getTxtTimesWorkDate()));
        dto.setWeekDayOvertime(this.getTimeValue(vo.getTxtWeekDayOverTimeHour(), vo.getTxtWeekDayOverTimeMinute()));
        dto.setWorkOnHoliday(this.getTimeValue(vo.getTxtRestWorkOnLegalHour(), vo.getTxtRestWorkOnLegalMinute()));
        dto.setWorkOnSpecificHoliday(this.getTimeValue(vo.getTxtRestWorkOnSpecificHour(), vo.getTxtRestWorkOnSpecificMinute()));
        dto.setWorkTime(this.getTimeValue(vo.getTxtWorkTimeHour(), vo.getTxtWorkTimeMinute()));
        dto.setTimesTotalWorkDate(this.getInt(vo.getTxtTimesTotalWorkDate()));
        dto.setTimesOvertime(this.getInt(vo.getTxtTimesOvertime()));
        dto.setWorkOnHoliday(this.getTimeValue(vo.getTxtWorkOnHolidayHour(), vo.getTxtWorkOnHolidayMinute()));
        dto.setWorkOnSpecificHoliday(this.getTimeValue(vo.getTxtWorkSpecificOnHolidayHour(), vo.getTxtWorkSpecificOnHolidayMinute()));
        dto.setTimesWorkingHoliday(this.getInt(vo.getTxtTimesWorkingHoliday()));
        dto.setLeaveEarlyTime(this.getTimeValue(vo.getTxtLeaveEarlyTimeHour(), vo.getTxtLeaveEarlyTimeMinute()));
        dto.setLeaveEarlyThirtyMinutesOrMoreTime(this.getTimeValue(vo.getTxtLeaveEarlyThirtyMinutesOrMoreTimeHour(), vo.getTxtLeaveEarlyThirtyMinutesOrMoreTimeMinute()));
        dto.setLeaveEarlyLessThanThirtyMinutesTime(this.getTimeValue(vo.getTxtLeaveEarlyLessThanThirtyMinutesTimeHour(), vo.getTxtLeaveEarlyLessThanThirtyMinutesTimeMinute()));
        dto.setTimesLegalHolidaySubstitute(this.getDouble(vo.getTxtTimesLegalHolidaySubstitute()));
        dto.setTimesSpecificHolidaySubstitute(this.getDouble(vo.getTxtTimesSpecificHolidaySubstitute()));
        dto.setLegalCompensationOccurred(this.getDouble(vo.getTxtLegalCompensationOccurred()));
        dto.setSpecificCompensationOccurred(this.getDouble(vo.getTxtSpecificCompensationOccurred()));
        dto.setLateCompensationOccurred(this.getDouble(vo.getTxtLateCompensationOccurred()));
        dto.setLegalCompensationUnused(this.getDouble(vo.getTxtLegalCompensationUnused()));
        dto.setSpecificCompensationUnused(this.getDouble(vo.getTxtSpecificCompensationUnused()));
        dto.setLateCompensationUnused(this.getDouble(vo.getTxtLateCompensationUnused()));
        dto.setTotalSpecialHoliday(this.getDouble(vo.getTxtTotalSpecialHoliday()));
        dto.setSpecialHolidayHour(this.getInt(vo.getTxtSpecialHolidayHour()));
        dto.setTotalOtherHoliday(this.getDouble(vo.getTxtTotalOtherHoliday()));
        dto.setOtherHolidayHour(this.getInt(vo.getTxtOtherHolidayHour()));
        dto.setTotalAbsence(this.getDouble(vo.getTxtTotalDeduction()));
        dto.setAbsenceHour(this.getInt(vo.getTxtDeductionHour()));
        dto.setTimesAchievement(this.getInt(vo.getTxtTimesAchievement()));
        dto.setSpecificWorkTime(this.getTimeValue(vo.getTxtSpecificWorkTimeHour(), vo.getTxtSpecificWorkTimeMinute()));
        dto.setShortUnpaid(this.getTimeValue(vo.getTxtUnpaidShortTimeHour(), vo.getTxtUnpaidShortTimeMinute()));
    }

    protected void setDtoSpecial(TotalLeaveDtoInterface dto, int i) throws MospException {
        TotalTimeCardVo vo = (TotalTimeCardVo)this.mospParams.getVo();
        dto.setTmdTotalLeaveId(vo.getAryTimesSpecialLeaveId()[i]);
        dto.setHolidayCode(vo.getAryTxtTimesSpecialLeaveCode()[i]);
        dto.setTimes(this.getDouble(vo.getAryTxtTimesSpecialLeave(i)));
        dto.setHours(this.getInt(vo.getAryTxtTimesSpecialHour(i)));
    }

    protected void setDtoOther(TotalOtherVacationDtoInterface dto, int i) throws MospException {
        TotalTimeCardVo vo = (TotalTimeCardVo)this.mospParams.getVo();
        dto.setTmdTotalOtherVacationId(vo.getAryTimesOtherVacationId()[i]);
        dto.setHolidayCode(vo.getAryTxtTimesOtherVacationCode()[i]);
        dto.setTimes(this.getDouble(vo.getAryTxtTimesOtherVacation(i)));
        dto.setHours(this.getInt(vo.getAryTxtTimesOtherVacationHour(i)));
    }

    protected void setDtoAbsence(TotalAbsenceDtoInterface dto, int i) throws MospException {
        TotalTimeCardVo vo = (TotalTimeCardVo)this.mospParams.getVo();
        dto.setTmdTotalAbsenceId(vo.getAryDeductionId()[i]);
        dto.setAbsenceCode(vo.getAryTxtDeductionCode()[i]);
        dto.setTimes(this.getDouble(vo.getAryTxtDeduction(i)));
        dto.setHours(this.getInt(vo.getAryTxtDeductionHour(i)));
    }

    protected void setTotalTimeCorrectionDtoFields(TotalTimeCorrectionDtoInterface dto) throws MospException {
        TotalTimeCardVo vo = (TotalTimeCardVo)this.mospParams.getVo();
        dto.setPersonalId(vo.getPersonalId());
        dto.setCalculationYear(vo.getTargetYear());
        dto.setCalculationMonth(vo.getTargetMonth());
        TotalTimeCorrectionDtoInterface latestDto = this.timeReference().totalTimeCorrection().getLatestTotalTimeCorrectionInfo(vo.getPersonalId(), vo.getTargetYear(), vo.getTargetMonth());
        int correctionTimes = 1;
        if (latestDto != null) {
            correctionTimes += latestDto.getCorrectionTimes();
        }
        dto.setCorrectionTimes(correctionTimes);
        dto.setCorrectionDate(DateUtility.getSystemTimeAndSecond());
        dto.setCorrectionPersonalId(this.mospParams.getUser().getPersonalId());
        dto.setCorrectionReason(vo.getTxtCorrectionReason());
    }

    protected void setVoWorkTimeFields(TotalTimeDataDtoInterface dto) throws MospException {
        TotalTimeCardVo vo = (TotalTimeCardVo)this.mospParams.getVo();
        vo.setLblEmployeeCode(this.getEmployeeCode(dto.getPersonalId()));
        vo.setTmdTotalTimeId(dto.getTmdTotalTimeId());
        vo.setTxtDecreaseTimeHour(String.valueOf(dto.getDecreaseTime() / 60));
        vo.setTxtDecreaseTimeMinute(String.valueOf(dto.getDecreaseTime() % 60));
        vo.setTxt45HourOverTimeHour(String.valueOf(dto.getFortyFiveHourOvertime() / 60));
        vo.setTxt45HourOverTimeMinute(String.valueOf(dto.getFortyFiveHourOvertime() % 60));
        vo.setTxtLateDays(String.valueOf(dto.getLateDays()));
        vo.setTxtLateThirtyMinutesOrMore(String.valueOf(dto.getLateThirtyMinutesOrMore()));
        vo.setTxtLateLessThanThirtyMinutes(String.valueOf(dto.getLateLessThanThirtyMinutes()));
        vo.setTxtLateNightHour(String.valueOf(dto.getLateNight() / 60));
        vo.setTxtLateNightMinute(String.valueOf(dto.getLateNight() % 60));
        vo.setTxtLateTimeHour(String.valueOf(dto.getLateTime() / 60));
        vo.setTxtLateTimeMinute(String.valueOf(dto.getLateTime() % 60));
        vo.setTxtLateThirtyMinutesOrMoreTimeHour(this.getHour(dto.getLateThirtyMinutesOrMoreTime()));
        vo.setTxtLateThirtyMinutesOrMoreTimeMinute(this.getMinute(dto.getLateThirtyMinutesOrMoreTime()));
        vo.setTxtLateLessThanThirtyMinutesTimeHour(this.getHour(dto.getLateLessThanThirtyMinutesTime()));
        vo.setTxtLateLessThanThirtyMinutesTimeMinute(this.getMinute(dto.getLateLessThanThirtyMinutesTime()));
        vo.setTxtLeaveEarlyDays(String.valueOf(dto.getLeaveEarlyDays()));
        vo.setTxtLeaveEarlyThirtyMinutesOrMore(String.valueOf(dto.getLeaveEarlyThirtyMinutesOrMore()));
        vo.setTxtLeaveEarlyLessThanThirtyMinutes(String.valueOf(dto.getLeaveEarlyLessThanThirtyMinutes()));
        vo.setTxtLegalWorkOnHoliday(String.valueOf(dto.getLegalWorkOnHoliday()));
        vo.setTxtPaidholidayHour(String.valueOf(dto.getPaidHolidayHour()));
        vo.setTxtPrivateHour(String.valueOf(dto.getPrivateTime() / 60));
        vo.setTxtPrivateMinute(String.valueOf(dto.getPrivateTime() % 60));
        vo.setTxtPublicHour(String.valueOf(dto.getPublicTime() / 60));
        vo.setTxtPublicMinute(String.valueOf(dto.getPublicTime() % 60));
        vo.setTxtMinutelyHolidayAHour(String.valueOf(dto.getMinutelyHolidayATime() / 60));
        vo.setTxtMinutelyHolidayAMinute(String.valueOf(dto.getMinutelyHolidayATime() % 60));
        vo.setTxtMinutelyHolidayBHour(String.valueOf(dto.getMinutelyHolidayBTime() / 60));
        vo.setTxtMinutelyHolidayBMinute(String.valueOf(dto.getMinutelyHolidayBTime() % 60));
        vo.setTxtRestLateNightHour(String.valueOf(dto.getRestLateNight() / 60));
        vo.setTxtRestLateNightMinute(String.valueOf(dto.getRestLateNight() % 60));
        vo.setTxtRestTimeHour(String.valueOf(dto.getRestTime() / 60));
        vo.setTxtRestTimeMinute(String.valueOf(dto.getRestTime() % 60));
        vo.setTxtRestWorkOnLegalHour(String.valueOf(dto.getRestWorkOnHoliday() / 60));
        vo.setTxtRestWorkOnLegalMinute(String.valueOf(dto.getRestWorkOnHoliday() % 60));
        vo.setTxt60HourOverTimeHour(String.valueOf(dto.getSixtyHourOvertime() / 60));
        vo.setTxt60HourOverTimeMinute(String.valueOf(dto.getSixtyHourOvertime() % 60));
        vo.setTxtSpecificOverTimeHour(String.valueOf(dto.getSpecificOvertime() / 60));
        vo.setTxtSpecificOverTimeMiunte(String.valueOf(dto.getSpecificOvertime() % 60));
        vo.setTxtSpecificWorkOnHoliday(String.valueOf(dto.getSpecificWorkOnHoliday()));
        vo.setTxtSpecificWorkTimeHour(String.valueOf(dto.getSpecificWorkTime() / 60));
        vo.setTxtSpecificWorkTimeMinute(String.valueOf(dto.getSpecificWorkTime() % 60));
        vo.setTxtUnpaidShortTimeHour(String.valueOf(dto.getShortUnpaid() / 60));
        vo.setTxtUnpaidShortTimeMinute(String.valueOf(dto.getShortUnpaid() % 60));
        vo.setTxtTimesAlternative(String.valueOf(dto.getTimesAlternative()));
        vo.setTxtTimesCompensation(String.valueOf(dto.getTimesCompensation()));
        vo.setTxtTimesHoliday(String.valueOf(dto.getTimesHoliday()));
        vo.setTxtTimesLateCompensation(String.valueOf(dto.getTimesLateCompensation()));
        vo.setTxtTimesLegalCompensation(String.valueOf(dto.getTimesLegalCompensation()));
        vo.setTxtTimesLegalHoliday(String.valueOf(dto.getTimesLegalHoliday()));
        vo.setTxtTimesNonstop(String.valueOf(dto.getDirectStart()));
        vo.setTxtTimesNoreturn(String.valueOf(dto.getDirectEnd()));
        vo.setTxtTimesPaidHoliday(String.valueOf(dto.getTimesPaidHoliday()));
        vo.setTxtTimesSpecificCompensation(String.valueOf(dto.getTimesSpecificCompensation()));
        vo.setTxtTimesSpecificHoliday(String.valueOf(dto.getTimesSpecificHoliday()));
        vo.setTxtTimesStockHoliday(String.valueOf(dto.getTimesStockHoliday()));
        vo.setTxtTimesSubstitute(String.valueOf(dto.getTimesHolidaySubstitute()));
        vo.setTxtTimesWork(String.valueOf(dto.getTimesWork()));
        vo.setTxtTimesWorkDate(String.valueOf(dto.getTimesWorkDate()));
        vo.setTxtWeekDayOverTimeHour(String.valueOf(dto.getWeekDayOvertime() / 60));
        vo.setTxtWeekDayOverTimeMinute(String.valueOf(dto.getWeekDayOvertime() % 60));
        vo.setTxtRestWorkOnSpecificHour(String.valueOf(dto.getRestWorkOnSpecificHoliday() / 60));
        vo.setTxtRestWorkOnSpecificMinute(String.valueOf(dto.getRestWorkOnSpecificHoliday() % 60));
        vo.setTxtRestWorkOnLegalHour(String.valueOf(dto.getRestWorkOnHoliday() / 60));
        vo.setTxtRestWorkOnLegalMinute(String.valueOf(dto.getRestWorkOnHoliday() % 60));
        vo.setTxtOverTimeHour(String.valueOf(dto.getOvertime() / 60));
        vo.setTxtOverTimeMinute(String.valueOf(dto.getOvertime() % 60));
        vo.setTxtOverTimeInHour(String.valueOf(dto.getOvertimeIn() / 60));
        vo.setTxtOverTimeInMinute(String.valueOf(dto.getOvertimeIn() % 60));
        vo.setTxtOverTimeOutHour(String.valueOf(dto.getOvertimeOut() / 60));
        vo.setTxtOverTimeOutMinute(String.valueOf(dto.getOvertimeOut() % 60));
        vo.setTxtWorkTimeHour(String.valueOf(dto.getWorkTime() / 60));
        vo.setTxtWorkTimeMinute(String.valueOf(dto.getWorkTime() % 60));
        vo.setTxtTimesAchievement(String.valueOf(dto.getTimesAchievement()));
        vo.setTxtTimesTotalWorkDate(String.valueOf(dto.getTimesTotalWorkDate()));
        vo.setTxtTimesOvertime(String.valueOf(dto.getTimesOvertime()));
        vo.setTxtWorkOnHolidayHour(String.valueOf(dto.getWorkOnHoliday() / 60));
        vo.setTxtWorkOnHolidayMinute(String.valueOf(dto.getWorkOnHoliday() % 60));
        vo.setTxtWorkSpecificOnHolidayHour(String.valueOf(dto.getWorkOnSpecificHoliday() / 60));
        vo.setTxtWorkSpecificOnHolidayMinute(String.valueOf(dto.getWorkOnSpecificHoliday() % 60));
        vo.setTxtTimesWorkingHoliday(String.valueOf(dto.getTimesWorkingHoliday()));
        vo.setTxtLeaveEarlyTimeHour(String.valueOf(dto.getLeaveEarlyTime() / 60));
        vo.setTxtLeaveEarlyTimeMinute(String.valueOf(dto.getLeaveEarlyTime() % 60));
        vo.setTxtLeaveEarlyThirtyMinutesOrMoreTimeHour(String.valueOf(this.getHour(dto.getLeaveEarlyThirtyMinutesOrMoreTime())));
        vo.setTxtLeaveEarlyThirtyMinutesOrMoreTimeMinute(String.valueOf(this.getMinute(dto.getLeaveEarlyThirtyMinutesOrMoreTime())));
        vo.setTxtLeaveEarlyLessThanThirtyMinutesTimeHour(String.valueOf(this.getHour(dto.getLeaveEarlyLessThanThirtyMinutesTime())));
        vo.setTxtLeaveEarlyLessThanThirtyMinutesTimeMinute(String.valueOf(this.getMinute(dto.getLeaveEarlyLessThanThirtyMinutesTime())));
        vo.setTxtTimesLegalHolidaySubstitute(String.valueOf(dto.getTimesLegalHolidaySubstitute()));
        vo.setTxtTimesSpecificHolidaySubstitute(String.valueOf(dto.getTimesSpecificHolidaySubstitute()));
        vo.setTxtTotalSpecialHoliday(String.valueOf(dto.getTotalSpecialHoliday()));
        vo.setTxtSpecialHolidayHour(String.valueOf(dto.getSpecialHolidayHour()));
        vo.setTxtTotalOtherHoliday(String.valueOf(dto.getTotalOtherHoliday()));
        vo.setTxtOtherHolidayHour(String.valueOf(dto.getOtherHolidayHour()));
        vo.setTxtTotalDeduction(String.valueOf(dto.getTotalAbsence()));
        vo.setTxtDeductionHour(String.valueOf(dto.getAbsenceHour()));
        vo.setTxtLegalCompensationOccurred(String.valueOf(dto.getLegalCompensationOccurred()));
        vo.setTxtSpecificCompensationOccurred(String.valueOf(dto.getSpecificCompensationOccurred()));
        vo.setTxtLateCompensationOccurred(String.valueOf(dto.getLateCompensationOccurred()));
        vo.setTxtLegalCompensationUnused(String.valueOf(dto.getLegalCompensationUnused()));
        vo.setTxtSpecificCompensationUnused(String.valueOf(dto.getSpecificCompensationUnused()));
        vo.setTxtLateCompensationUnused(String.valueOf(dto.getLateCompensationUnused()));
    }

    protected void setLeaveVoFields() throws MospException {
        TotalTimeCardVo vo = (TotalTimeCardVo)this.mospParams.getVo();
        List specialList = this.timeReference().holiday().getHolidayList(vo.getTargetDate(), 2);
        int specialListSize = specialList.size();
        String[] aryTxtTimesSpecialLeave = new String[specialListSize];
        String[] aryTxtTimesSpecialHour = new String[specialListSize];
        String[] aryTxtTimesSpecialLeaveTitle = new String[specialListSize];
        String[] aryTxtTimesSpecialLeaveCode = new String[specialListSize];
        long[] aryTimesSpecialLeaveId = new long[specialListSize];
        int i = 0;
        for (HolidayDtoInterface dto : specialList) {
            aryTxtTimesSpecialLeaveTitle[i] = dto.getHolidayAbbr();
            aryTxtTimesSpecialLeaveCode[i] = dto.getHolidayCode();
            aryTxtTimesSpecialLeave[i] = Double.toString(0.0);
            aryTxtTimesSpecialHour[i] = String.valueOf(0);
            TotalLeaveDtoInterface totalLeaveDto = this.timeReference().totalLeave().findForKey(vo.getPersonalId(), vo.getTargetYear(), vo.getTargetMonth(), dto.getHolidayCode());
            if (totalLeaveDto != null) {
                aryTimesSpecialLeaveId[i] = totalLeaveDto.getTmdTotalLeaveId();
                aryTxtTimesSpecialLeave[i] = String.valueOf(totalLeaveDto.getTimes());
                aryTxtTimesSpecialHour[i] = String.valueOf(totalLeaveDto.getHours());
            }
            ++i;
        }
        vo.setAryTxtTimesSpecialLeave(aryTxtTimesSpecialLeave);
        vo.setAryTxtTimesSpecialHour(aryTxtTimesSpecialHour);
        vo.setAryTxtTimesSpecialLeaveTitle(aryTxtTimesSpecialLeaveTitle);
        vo.setAryTxtTimesSpecialLeaveCode(aryTxtTimesSpecialLeaveCode);
        vo.setAryTimesSpecialLeaveId(aryTimesSpecialLeaveId);
        List otherList = this.timeReference().holiday().getHolidayList(vo.getTargetDate(), 3);
        int otherListSize = otherList.size();
        String[] aryTxtTimesOtherVacation = new String[otherListSize];
        String[] aryTxtTimesOtherVacationHour = new String[otherListSize];
        String[] aryTxtTimesOtherVacationTitle = new String[otherListSize];
        String[] aryTxtTimesOtherVacationCode = new String[otherListSize];
        long[] aryTimesOtherVacationId = new long[otherListSize];
        i = 0;
        for (HolidayDtoInterface dto : otherList) {
            aryTxtTimesOtherVacationTitle[i] = dto.getHolidayAbbr();
            aryTxtTimesOtherVacationCode[i] = dto.getHolidayCode();
            aryTxtTimesOtherVacation[i] = Double.toString(0.0);
            aryTxtTimesOtherVacationHour[i] = String.valueOf(0);
            TotalOtherVacationDtoInterface totalOtherVacationDto = this.timeReference().totalOtherVacation().findForKey(vo.getPersonalId(), vo.getTargetYear(), vo.getTargetMonth(), dto.getHolidayCode());
            if (totalOtherVacationDto != null) {
                aryTimesOtherVacationId[i] = totalOtherVacationDto.getTmdTotalOtherVacationId();
                aryTxtTimesOtherVacation[i] = String.valueOf(totalOtherVacationDto.getTimes());
                aryTxtTimesOtherVacationHour[i] = String.valueOf(totalOtherVacationDto.getHours());
            }
            ++i;
        }
        vo.setAryTxtTimesOtherVacation(aryTxtTimesOtherVacation);
        vo.setAryTxtTimesOtherVacationHour(aryTxtTimesOtherVacationHour);
        vo.setAryTxtTimesOtherVacationTitle(aryTxtTimesOtherVacationTitle);
        vo.setAryTxtTimesOtherVacationCode(aryTxtTimesOtherVacationCode);
        vo.setAryTimesOtherVacationId(aryTimesOtherVacationId);
        List deductionList = this.timeReference().holiday().getHolidayList(vo.getTargetDate(), 4);
        int deductionListSize = deductionList.size();
        String[] aryTxtTimesDeduction = new String[deductionListSize];
        String[] aryTxtTimesDeductionHour = new String[deductionListSize];
        String[] aryTxtTimesDeductionTitle = new String[deductionListSize];
        String[] aryTxtTimesDeductionCode = new String[deductionListSize];
        long[] aryDeductionId = new long[deductionListSize];
        i = 0;
        for (HolidayDtoInterface dto : deductionList) {
            aryTxtTimesDeductionTitle[i] = dto.getHolidayAbbr();
            aryTxtTimesDeductionCode[i] = dto.getHolidayCode();
            aryTxtTimesDeduction[i] = Double.toString(0.0);
            aryTxtTimesDeductionHour[i] = String.valueOf(0);
            TotalAbsenceDtoInterface totalAbsenceDto = this.timeReference().totalAbsence().findForKey(vo.getPersonalId(), vo.getTargetYear(), vo.getTargetMonth(), dto.getHolidayCode());
            if (totalAbsenceDto != null) {
                aryDeductionId[i] = totalAbsenceDto.getTmdTotalAbsenceId();
                aryTxtTimesDeduction[i] = String.valueOf(totalAbsenceDto.getTimes());
                aryTxtTimesDeductionHour[i] = String.valueOf(totalAbsenceDto.getHours());
            }
            ++i;
        }
        vo.setAryTxtDeduction(aryTxtTimesDeduction);
        vo.setAryTxtDeductionHour(aryTxtTimesDeductionHour);
        vo.setAryTxtDeductionTitle(aryTxtTimesDeductionTitle);
        vo.setAryTxtDeductionCode(aryTxtTimesDeductionCode);
        vo.setAryDeductionId(aryDeductionId);
    }

    protected void setCorrectionVoFields() throws MospException {
        TotalTimeCardVo vo = (TotalTimeCardVo)this.mospParams.getVo();
        TotalTimeCorrectionDtoInterface dto = this.timeReference().totalTimeCorrection().getLatestTotalTimeCorrectionInfo(vo.getPersonalId(), vo.getTargetYear(), vo.getTargetMonth());
        if (dto == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.mospParams.getName("Finality"));
        sb.append(this.mospParams.getName("Corrector"));
        sb.append(PlatformNamingUtility.colon((MospParams)this.mospParams));
        sb.append(this.reference().human().getHumanName(dto.getCorrectionPersonalId(), dto.getCorrectionDate()));
        sb.append(" ");
        sb.append(TimeNamingUtility.days((MospParams)this.mospParams));
        sb.append(PlatformNamingUtility.colon((MospParams)this.mospParams));
        sb.append(DateUtility.getStringDateAndDayAndTime((Date)dto.getCorrectionDate()));
        vo.setLblCorrectionHistory(sb.toString());
        vo.setTxtCorrectionReason(dto.getCorrectionReason());
    }

    protected String getHour(int time) {
        return String.valueOf(TimeUtility.getHours((int)time));
    }

    protected String getMinute(int time) {
        return String.valueOf(TimeUtility.getMinutes((int)time));
    }
}

