/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.WorkTypeSearchBeanInterface;
import jp.mosp.time.dao.settings.WorkTypeDaoInterface;
import jp.mosp.time.dao.settings.WorkTypeItemDaoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeListDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmWorkTypeListDto;

public class WorkTypeSearchBean
extends PlatformBean
implements WorkTypeSearchBeanInterface {
    private WorkTypeDaoInterface workTypeDao;
    private WorkTypeItemDaoInterface workTypeItemDao;
    private Date activateDate;
    private String workTypeCode;
    private String workTypeName;
    private String workTypeAbbr;
    private String inactivateFlag;

    public WorkTypeSearchBean() {
    }

    public WorkTypeSearchBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.workTypeDao = (WorkTypeDaoInterface)this.createDao(WorkTypeDaoInterface.class);
        this.workTypeItemDao = (WorkTypeItemDaoInterface)this.createDao(WorkTypeItemDaoInterface.class);
    }

    public List<WorkTypeListDtoInterface> getSearchList() throws MospException {
        Map param = this.workTypeDao.getParamsMap();
        param.put("activateDate", this.activateDate);
        param.put("workTypeCode", this.workTypeCode);
        param.put("workTypeName", this.workTypeName);
        param.put("workTypeAbbr", this.workTypeAbbr);
        param.put("inactivateFlag", this.inactivateFlag);
        List list = this.workTypeDao.findForSearch(param);
        ArrayList<WorkTypeListDtoInterface> workTypeList = new ArrayList<WorkTypeListDtoInterface>();
        for (WorkTypeDtoInterface dto : list) {
            String workTypeCode = dto.getWorkTypeCode();
            Date activateDate = dto.getActivateDate();
            TmmWorkTypeListDto workTypeListDto = new TmmWorkTypeListDto();
            workTypeListDto.setTmmWorkTypeId(dto.getTmmWorkTypeId());
            workTypeListDto.setWorkTypeCode(workTypeCode);
            workTypeListDto.setActivateDate(activateDate);
            workTypeListDto.setWorkTypeName(dto.getWorkTypeName());
            workTypeListDto.setWorkTypeAbbr(dto.getWorkTypeAbbr());
            workTypeListDto.setInactivateFlag(dto.getInactivateFlag());
            workTypeListDto.setStartTime(this.workTypeItemDao.findForKey(workTypeCode, activateDate, "WorkStart").getWorkTypeItemValue());
            workTypeListDto.setEndTime(this.workTypeItemDao.findForKey(workTypeCode, activateDate, "WorkEnd").getWorkTypeItemValue());
            workTypeListDto.setWorkTime(this.workTypeItemDao.findForKey(workTypeCode, activateDate, "WorkTime").getWorkTypeItemValue());
            workTypeListDto.setRestTime(this.workTypeItemDao.findForKey(workTypeCode, activateDate, "RestTime").getWorkTypeItemValue());
            workTypeListDto.setFrontTime(this.getTimestamp(this.getMinute(this.workTypeItemDao.findForKey(workTypeCode, activateDate, "FrontStart").getWorkTypeItemValue(), this.workTypeItemDao.findForKey(workTypeCode, activateDate, "FrontEnd").getWorkTypeItemValue())));
            workTypeListDto.setBackTime(this.getTimestamp(this.getMinute(this.workTypeItemDao.findForKey(workTypeCode, activateDate, "BackStart").getWorkTypeItemValue(), this.workTypeItemDao.findForKey(workTypeCode, activateDate, "BackEnd").getWorkTypeItemValue())));
            workTypeList.add((WorkTypeListDtoInterface)workTypeListDto);
        }
        return workTypeList;
    }

    public void setActivateDate(Date activateDate) {
        this.activateDate = this.getDateClone(activateDate);
    }

    public void setWorkTypeCode(String workTypeCode) {
        this.workTypeCode = workTypeCode;
    }

    public void setWorkTypeName(String workTypeName) {
        this.workTypeName = workTypeName;
    }

    public void setWorkTypeAbbr(String workTypeAbbr) {
        this.workTypeAbbr = workTypeAbbr;
    }

    public void setInactivateFlag(String inactivateFlag) {
        this.inactivateFlag = inactivateFlag;
    }

    protected int getMinute(Date startTime, Date endTime) throws MospException {
        Date defaultTime = DateUtility.getDefaultTime();
        return this.getMinute(DateUtility.getHour((Date)startTime, (Date)defaultTime) * 60 + DateUtility.getMinute((Date)startTime), DateUtility.getHour((Date)endTime, (Date)defaultTime) * 60 + DateUtility.getMinute((Date)endTime));
    }

    protected int getMinute(int startMinute, int endMinute) {
        int minute = endMinute - startMinute;
        if (minute >= 0) {
            return minute;
        }
        return 0;
    }

    protected Date getTimestamp(int minute) throws MospException {
        return DateUtility.addMinute((Date)DateUtility.getDefaultTime(), (int)minute);
    }
}

